/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.LESSLanguage;
import org.jetbrains.plugins.less.formatter.LESSMixinBlock;
import org.jetbrains.plugins.less.formatter.LESSRootBlock;
import org.jetbrains.plugins.less.formatter.LESSRulesetBlock;
import org.jetbrains.plugins.less.lexer.LESSTokenTypes;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;
import org.jetbrains.plugins.less.psi.impl.LESSGuardImpl;
import org.jetbrains.plugins.less.psi.impl.LESSMixinName;
import org.jetbrains.plugins.less.psi.impl.LESSVariableImpl;
import org.jetbrains.plugins.less.psi.impl.LessPluginDeclaration;
import org.jetbrains.plugins.less.settings.LessCodeStyleSettings;

public class LessFormattingModelBuilder
extends CssFormattingModelBuilder {
    @NotNull
    protected LessFormattingExtension createExtension(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            LessFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        return new LessFormattingExtension(settings.getCommonSettings((Language)LESSLanguage.INSTANCE), (LessCodeStyleSettings)settings.getCustomSettings(LessCodeStyleSettings.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/less/formatter/LessFormattingModelBuilder", "createExtension"));
    }

    protected static class LessFormattingExtension
    extends CssFormattingModelBuilder.CssFormattingExtension {
        public LessFormattingExtension(CommonCodeStyleSettings commonSettings, LessCodeStyleSettings customSettings) {
            super(commonSettings, (CssCodeStyleSettings)customSettings);
        }

        public boolean isLineComment(IElementType elementType) {
            return LESSTokenTypes.COMMENT == elementType || super.isLineComment(elementType);
        }

        public boolean isComment(IElementType elementType) {
            return LESSElementTypes.LESS_COMMENTS.contains(elementType) || super.isComment(elementType);
        }

        public boolean addSubBlocks(PsiElement element, List<Block> result) {
            PsiElement parent = element.getParent();
            if (element instanceof CssFunction) {
                Indent indent = parent instanceof CssBlock ? Indent.getNormalIndent() : Indent.getNoneIndent();
                result.add((Block)new LESSRulesetBlock(element.getNode(), indent, this, null));
                return true;
            }
            if (element instanceof CssBlock && (parent instanceof CssTermList || parent instanceof LESSMixinInvocation)) {
                result.add((Block)new LESSRulesetBlock(element.getNode(), Indent.getNoneIndent(), this, null));
                return true;
            }
            return super.addSubBlocks(element, result);
        }

        public boolean addSubBlocksOfExtendedLanguage(PsiElement element, Alignment childAlignment, List<Block> result) {
            Indent indent;
            IElementType parentType = element.getParent().getNode().getElementType();
            Indent indent2 = indent = parentType == CssElementTypes.CSS_DECLARATION_BLOCK || parentType == CssElementTypes.CSS_KEYFRAMES_RULE ? Indent.getNormalIndent() : Indent.getNoneIndent();
            if (element instanceof LESSGuardImpl) {
                result.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(element.getNode(), Indent.getNoneIndent(), (CssFormattingModelBuilder.CssFormattingExtension)this));
                return true;
            }
            if (element instanceof LESSVariableDeclaration) {
                if (((LESSVariableDeclaration)element).getValue() instanceof CssBlock) {
                    result.add((Block)new CssFormattingModelBuilder.CssRulesetBlock(element.getNode(), indent, (CssFormattingModelBuilder.CssFormattingExtension)this, null));
                } else {
                    result.add((Block)new CssFormattingModelBuilder.CssPropertyBlock(element.getNode(), indent, (CssFormattingModelBuilder.CssFormattingExtension)this, null, childAlignment));
                }
                return true;
            }
            if (element instanceof LessPluginDeclaration) {
                result.add((Block)new CssFormattingModelBuilder.CssPropertyBlock(element.getNode(), indent, (CssFormattingModelBuilder.CssFormattingExtension)this, null, null));
                return true;
            }
            if (element instanceof LESSVariableImpl) {
                result.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(element.getNode(), Indent.getNoneIndent(), (CssFormattingModelBuilder.CssFormattingExtension)this));
                return true;
            }
            if (element instanceof LESSMixinInvocation) {
                result.add((Block)new CssFormattingModelBuilder.CssPropertyBlock(element.getNode(), indent, (CssFormattingModelBuilder.CssFormattingExtension)this, null, null));
                return true;
            }
            if (element instanceof LESSMixin) {
                result.add((Block)new LESSMixinBlock(element.getNode(), indent, this));
                return true;
            }
            if (element instanceof LESSMixinName || LESSTokenTypes.GUARD_KEYWORDS.contains(element.getNode().getElementType())) {
                result.add((Block)new CssFormattingModelBuilder.LeafBlock(element.getNode(), Indent.getNoneIndent()));
                return true;
            }
            if (element instanceof CssFunction) {
                result.add((Block)new LESSRulesetBlock(element.getNode(), Indent.getNoneIndent(), this, null));
                return true;
            }
            return false;
        }

        public CssFormattingModelBuilder.CssRootBlock createRootBlock(ASTNode _node, CssFormattingModelBuilder.CssFormattingExtension extension) {
            return new LESSRootBlock(_node, extension);
        }

        public CssFormattingModelBuilder.CssRulesetBlock createRulesetBlock(ASTNode _node, Indent indent, CssFormattingModelBuilder.CssFormattingExtension extension, @Nullable Alignment alignment) {
            return new LESSRulesetBlock(_node, indent, extension, alignment);
        }
    }
}

