/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.service.commands;

import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeConfigurationBuilder;
import com.intellij.docker.agent.compose.beans.DockerComposePort;
import com.intellij.docker.agent.compose.beans.DockerComposeServiceBuilder;
import com.intellij.docker.agent.compose.cli.DockerComposeRunCliBuilder;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.util.DockerComposeUtilsKt;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ServiceCmdExecUtils;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.PtyOptions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposeServiceRunCmd
extends AbstractServiceCmd<ComposeServiceRunCmd> {
    private static final Logger LOG = Logger.getInstance(ComposeServiceRunCmd.class);
    private boolean myNoDeps;
    @Nullable
    private PtyOptions myPtyOptions;
    private boolean myRemove;
    @Nullable
    private List<DockerComposePort> myPublishPorts;
    @Nullable
    private String myName;
    private boolean mySaveAllDocuments;

    public ComposeServiceRunCmd(@NotNull RemoteDockerRuntime dockerRuntime) {
        if (dockerRuntime == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(0);
        }
        super(dockerRuntime);
        this.myNoDeps = true;
        this.myRemove = false;
        this.mySaveAllDocuments = true;
    }

    @Override
    @NotNull
    public KillableColoredProcessHandler execute() throws IOException, ExecutionException {
        return this.execute(false);
    }

    @Override
    @NotNull
    public GeneralCommandLine buildCommandLine(@NotNull RemoteDockerRuntime runtime) throws IOException {
        if (runtime == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(1);
        }
        GeneralCommandLine generalCommandLine = DockerComposeCliUtil.buildCommandLineBlocking(ComposeServiceRunCmd.buildRunCommand(this, false), runtime.getAccount());
        if (generalCommandLine == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(2);
        }
        return generalCommandLine;
    }

    @NotNull
    public String execDetached() throws IOException, ExecutionException {
        KillableColoredProcessHandler processHandler = this.execute(true);
        ProcessOutput processOutput = new CapturingProcessRunner((BaseProcessHandler)processHandler).runProcess();
        if (processOutput.checkSuccess(LOG)) {
            String string = processOutput.getStdout().trim();
            if (string == null) {
                ComposeServiceRunCmd.$$$reportNull$$$0(3);
            }
            return string;
        }
        throw new ExecutionException(processOutput.getStderr());
    }

    @Override
    @NotNull
    protected ComposeServiceRunCmd getThis() {
        ComposeServiceRunCmd composeServiceRunCmd = this;
        if (composeServiceRunCmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(4);
        }
        return composeServiceRunCmd;
    }

    public boolean isNoDeps() {
        return this.myNoDeps;
    }

    @NotNull
    public ComposeServiceRunCmd withNoDeps(boolean value) {
        this.myNoDeps = value;
        ComposeServiceRunCmd composeServiceRunCmd = this;
        if (composeServiceRunCmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(5);
        }
        return composeServiceRunCmd;
    }

    @Nullable
    public PtyOptions getPtyOptions() {
        return this.myPtyOptions;
    }

    @NotNull
    public ComposeServiceRunCmd withPtyOptions(@Nullable PtyOptions ptyOptions) {
        this.myPtyOptions = ptyOptions;
        ComposeServiceRunCmd composeServiceRunCmd = this;
        if (composeServiceRunCmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(6);
        }
        return composeServiceRunCmd;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public ComposeServiceRunCmd withNoPty(@Nullable Boolean noPty) {
        ComposeServiceRunCmd composeServiceRunCmd = this.withPtyOptions(DockerComposeCliUtil.defaultPtyOptionsByNoPty(noPty));
        if (composeServiceRunCmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(7);
        }
        return composeServiceRunCmd;
    }

    public boolean isRemove() {
        return this.myRemove;
    }

    @NotNull
    public ComposeServiceRunCmd withRemove(boolean remove) {
        this.myRemove = remove;
        ComposeServiceRunCmd composeServiceRunCmd = this;
        if (composeServiceRunCmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(8);
        }
        return composeServiceRunCmd;
    }

    @Nullable
    public List<DockerComposePort> getPublishPorts() {
        return this.myPublishPorts;
    }

    @NotNull
    public ComposeServiceRunCmd withPublishPorts(@Nullable List<DockerComposePort> ports) {
        this.myPublishPorts = ports;
        ComposeServiceRunCmd composeServiceRunCmd = this;
        if (composeServiceRunCmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(9);
        }
        return composeServiceRunCmd;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @NotNull
    public ComposeServiceRunCmd withName(@Nullable String name) {
        this.myName = name;
        ComposeServiceRunCmd composeServiceRunCmd = this;
        if (composeServiceRunCmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(10);
        }
        return composeServiceRunCmd;
    }

    @NotNull
    private KillableColoredProcessHandler execute(boolean detached) throws IOException, ExecutionException {
        KillableColoredProcessHandler killableColoredProcessHandler = DockerComposeCliUtil.run(ComposeServiceRunCmd.buildRunCommand(this, detached), this.getDockerRuntime(), ProgressManager.getInstance().getProgressIndicator());
        if (killableColoredProcessHandler == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(11);
        }
        return killableColoredProcessHandler;
    }

    public boolean isSaveAllDocuments() {
        return this.mySaveAllDocuments;
    }

    @NotNull
    public ComposeServiceRunCmd withSaveAllDocuments(boolean saveAllDocuments) {
        this.mySaveAllDocuments = saveAllDocuments;
        ComposeServiceRunCmd composeServiceRunCmd = this;
        if (composeServiceRunCmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(12);
        }
        return composeServiceRunCmd;
    }

    @NotNull
    private static DockerComposeRunCliBuilder buildRunCommand(@NotNull ComposeServiceRunCmd cmd, boolean detached) throws IOException {
        if (cmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(13);
        }
        if (ContainerUtil.isEmpty(cmd.getConfigurationPaths())) {
            throw new IllegalArgumentException(DockerBundle.message((String)"ComposeServiceRunCmd.error.path.required", (Object[])new Object[0]));
        }
        if (StringUtil.isEmpty((String)cmd.getServiceName())) {
            throw new IllegalArgumentException(DockerBundle.message((String)"ComposeServiceRunCmd.error.service.required", (Object[])new Object[0]));
        }
        if (cmd.isSaveAllDocuments()) {
            if (Registry.is((String)"docker.compose.use.modality.any.for.saving.documents")) {
                ApplicationManager.getApplication().invokeAndWait(() -> ServiceCmdExecUtils.saveAllDocumentsAsIs(), ModalityState.any());
            } else {
                ApplicationManager.getApplication().invokeAndWait(() -> ServiceCmdExecUtils.saveAllDocumentsAsIs());
            }
        }
        List paths = DockerComposeUtilsKt.findDockerComposeConfigurationFiles(cmd.getConfigurationPaths());
        Set<String> namedVolumes = ServiceCmdExecUtils.collectNamedVolumes(cmd.getVolumesBinding());
        DockerComposeConfigurationBuilder<?, ?, ?> configurationBuilder = ServiceCmdExecUtils.createConfigurationBuilder(paths, namedVolumes, cmd.getDockerRuntime().getAccount());
        if (!ArrayUtil.isEmpty((Object[])cmd.getVolumesFrom())) {
            ServiceCmdExecUtils.assertVolumesFromOptionSupported(configurationBuilder);
        }
        DockerComposeServiceBuilder serviceBuilder = configurationBuilder.addService(cmd.getServiceName());
        String[] entrypoint = cmd.getEntrypoint();
        if (entrypoint != null) {
            serviceBuilder.withEntrypoint(entrypoint);
        } else {
            serviceBuilder.withEntrypointLine("");
        }
        DockerVolumeBinding[] updatedBindings = cmd.getVolumesBinding();
        serviceBuilder.withCommand(DockerComposeUtilsKt.escapeDollarSigns((String[])cmd.getCommand())).withWorkingDir(cmd.getWorkingDir()).withEnvironment(DockerComposeUtilsKt.escapeDollarSigns(cmd.getEnvironment())).withVolumesFrom(cmd.getVolumesFrom()).withBindVolumes(updatedBindings).withPorts(cmd.getPorts()).withUser(cmd.getUser()).withExtraHosts(cmd.getExtraHosts()).withRestartPolicy(cmd.getRestartPolicy());
        ServiceCmdExecUtils.setupSharedVolume(configurationBuilder, serviceBuilder, cmd, paths, updatedBindings);
        DockerComposeConfiguration override = configurationBuilder.build();
        File tempFile = ServiceCmdExecUtils.writeDockerComposeOverrideYml(override);
        List list2 = ContainerUtil.append((List)paths, (Object[])new Path[]{tempFile.toPath()});
        List<Path> configurationPaths = List.of(list2.toArray(new Path[0]));
        DockerComposeRunCliBuilder dockerComposeRunCliBuilder = (DockerComposeRunCliBuilder)((DockerComposeRunCliBuilder)((DockerComposeRunCliBuilder)((DockerComposeRunCliBuilder)DockerComposeCliUtil.buildRunCommand(cmd.getDockerRuntime().getAccount()).withEnvironment(cmd.getEnvs())).withFiles(configurationPaths)).withDetached(detached).withRemove(cmd.isRemove()).withNoDeps(cmd.isNoDeps()).withPtyOptions(DockerComposeCliUtil.toDockerComposePtyOptions(cmd.getPtyOptions())).withContainerName(cmd.getName()).withPublishPorts(cmd.getPublishPorts()).withSubcommandOptions(cmd.getSubcommandOptions())).withService(cmd.getServiceName()).withProjectName(cmd.getProjectName());
        if (dockerComposeRunCliBuilder == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(14);
        }
        return dockerComposeRunCliBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/service/commands/ComposeServiceRunCmd";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/service/commands/ComposeServiceRunCmd";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommandLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execDetached";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThis";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withNoDeps";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withPtyOptions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withNoPty";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withRemove";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withPublishPorts";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "withSaveAllDocuments";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRunCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildCommandLine";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildRunCommand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14 -> new IllegalStateException(string);
        };
    }
}

