/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceScopeEditorTree;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.introspection.IndefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.view.DbNamespaceNode;
import com.intellij.database.view.DbNamespacesTree;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.FilteringTree;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataSourceScopeEditor {
    private static final Key<DataSourceScopeEditor> EDITOR_KEY = Key.create((String)"DataSourceScopeEditor");
    private static final String INTROSPECTOR_SHOULD_VISIT_EVERY_DATABASE = "database.scopeRefresh.listSchemasFromAllDatabases";
    private final Project myProject;
    private final MyTree myTree;
    protected BasicModel myModel;
    protected TreePattern mySelectedScope;
    protected TreePattern myPermStructure;
    protected Couple<String> myFakeCurrentSchema;
    protected final DataSourceSchemaMapping mySchemaMapping;
    private boolean mySkipSpecForRoot;
    private boolean myFakeCurrentSchemaEnabled;
    private final JComponent myPanel;
    protected boolean myRechecking;
    private Pair<Dbms, BasicMetaModel<?>> myMmCache;

    public DataSourceScopeEditor(@NotNull Project project) {
        if (project == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(0);
        }
        this.myModel = null;
        this.mySelectedScope = TreePattern.EMPTY;
        this.myPermStructure = TreePattern.EMPTY;
        this.myFakeCurrentSchema = null;
        this.mySchemaMapping = new DataSourceSchemaMapping();
        this.mySkipSpecForRoot = true;
        this.myFakeCurrentSchemaEnabled = false;
        this.myTree = new MyTree(this, project, new DbNamespaceNode(null, null, null){

            @Override
            public BasicMetaObject<?> getMeta() {
                return DataSourceScopeEditor.this.getMetaModel().root;
            }
        }, () -> this.myFakeCurrentSchema, this.mySchemaMapping);
        this.myProject = project;
        ClientProperty.put((JComponent)((Object)this.getTree()), EDITOR_KEY, (Object)this);
        this.myTree.getSearchModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeNodesInserted(TreeModelEvent e) {
                if (DataSourceScopeEditor.this.mySkipSpecForRoot) {
                    for (Object o : e.getChildren()) {
                        CheckedTreeNode node = (CheckedTreeNode)ObjectUtils.tryCast((Object)o, CheckedTreeNode.class);
                        DbNamespaceNode userNode = (DbNamespaceNode)DataSourceScopeEditor.this.myTree.getSearchModel().getUserObject((DefaultMutableTreeNode)node);
                        if (userNode == null || !DbImplUtilCore.isDatabase((ObjectKind)userNode.getKind())) continue;
                        DbImplUtil.invokeLater(() -> DataSourceScopeEditor.this.myTree.getTree().expandPath(new TreePath(node.getPath())));
                    }
                }
            }

            public void treeNodesChanged(TreeModelEvent event) {
                DataSourceScopeEditor.this.beforeStateChanged();
                DataSourceScopeEditor.this.onStateChanged();
            }
        });
        JComponent northPanel = this.createNorthPanel();
        northPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)northPanel, "North");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree.getComponent(), (boolean)true);
        this.myPanel.add((Component)scrollPane, "Center");
    }

    @NotNull
    protected abstract Dbms getDbms();

    protected BasicMetaModel<?> getMetaModel() {
        return this.myModel == null ? DataSourceScopeEditor.getMetaModelFromDbms(this.getDbms()) : this.myModel.getMetaModel();
    }

    @NotNull
    private static BasicMetaModel<?> getMetaModelFromDbms(Dbms dbms) {
        BasicMetaModel basicMetaModel = DbImplUtilCore.getMetaModel((Dbms)dbms);
        if (basicMetaModel == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(1);
        }
        return basicMetaModel;
    }

    @NotNull
    protected JComponent createNorthPanel() {
        JPanel northPanel = new JPanel(new BorderLayout());
        ActionToolbar actionsToolbar = ActionManager.getInstance().createActionToolbar("DbSourceScopeEditor", (ActionGroup)this.createTreeActions(), true);
        actionsToolbar.setTargetComponent((JComponent)((Object)this.getTree()));
        northPanel.add((Component)actionsToolbar.getComponent(), "East");
        this.myTree.installSimple();
        JPanel jPanel = northPanel;
        if (jPanel == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Nullable
    public Couple<String> getFakeCurrentSchema() {
        return this.myFakeCurrentSchema;
    }

    public void setFakeCurrentSchema(@Nullable Couple<String> fakeSchema) {
        this.myFakeCurrentSchema = fakeSchema;
        TreeUtil.invalidateCacheAndRepaint((TreeUI)this.getTree().getUI());
    }

    public boolean isSubstituted(@NotNull BasicNamespace e) {
        if (e == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(3);
        }
        return DataSourceSnapshotManager.getInstance().map((BasicElement)e, this.mySchemaMapping, false) != null;
    }

    public void setSubstituted(@NotNull BasicNamespace e, boolean substituted) {
        if (e == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(4);
        }
        ObjectPath path = BasicPaths.of((BasicElement)e);
        TreePattern pattern = DataSourceSchemaMapping.asPattern((ObjectPath)path);
        if (substituted) {
            ObjectPath tgt = DataSourceSnapshotManager.getInstance().getBasePath(e, true);
            if (tgt != null) {
                this.mySchemaMapping.put(pattern, "minicat", tgt);
            }
        } else {
            this.mySchemaMapping.prune(pattern);
        }
        this.myTree.getTree().getSearchModel().updateStructure();
    }

    public void setSchemaMapping(@NotNull DataSourceSchemaMapping mapping) {
        if (mapping == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(5);
        }
        this.mySchemaMapping.assign(mapping);
    }

    @NotNull
    public abstract DataSourceSchemaMapping getSchemaMapping();

    protected void beforeStateChanged() {
    }

    protected void onStateChanged() {
    }

    protected FilteringTree<CheckedTreeNode, DbNamespaceNode> getFilteringTree() {
        return this.myTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScopes(@Nullable TreePattern selection, @Nullable TreePattern structure) {
        boolean structChanged;
        boolean permStructChanged;
        boolean selChanged;
        if (selection == null && structure == null) {
            return;
        }
        boolean bl = selChanged = selection != null && !selection.equals((Object)this.mySelectedScope);
        if (selChanged) {
            this.mySelectedScope = selection;
        }
        boolean bl2 = permStructChanged = structure != null && !structure.equals((Object)this.myPermStructure);
        if (permStructChanged) {
            this.myPermStructure = structure;
        }
        boolean bl3 = structChanged = permStructChanged || selChanged;
        if (structChanged) {
            TreePattern tempStructure = TreePatternUtils.union((TreePattern[])new TreePattern[]{this.myPermStructure, this.mySelectedScope});
            if (permStructChanged || tempStructure != this.myPermStructure) {
                MyTree.createShadowStructure((DbNamespaceNode)this.myTree.getSearchModel().getRootObject(), tempStructure);
                this.myTree.getSearchModel().updateStructure();
            }
        }
        try {
            this.myRechecking = true;
            this.myTree.recheck(this.mySelectedScope);
        }
        finally {
            this.myRechecking = false;
        }
        this.onSetScopeReady();
    }

    protected void onSetScopeReady() {
    }

    @NotNull
    protected TreePattern getEditorState() {
        TreePattern treePattern = this.getEditorState(false);
        if (treePattern == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(6);
        }
        return treePattern;
    }

    @NotNull
    protected TreePattern getEditorState(boolean perm) {
        DbNamespaceNode root = (DbNamespaceNode)this.myTree.getSearchModel().getRootObject();
        TreePattern treePattern = DbNamespacesTree.buildPattern(root, perm);
        if (treePattern == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(7);
        }
        return treePattern;
    }

    public boolean hasSpeedSearchActive() {
        return SpeedSearchSupply.getSupply((JComponent)((Object)this.getTree())) != null;
    }

    public void select(@Nullable BasicElement selection) {
        if (selection == null) {
            return;
        }
        TreePath path = new TreePath(ArrayUtil.reverseArray((Object[])JBIterable.generate((Object)selection, o -> o.getParent()).toList().toArray()));
        TreeUtil.visit((JTree)((Object)this.myTree.getTree()), (TreeVisitor)new TreeVisitor.ByTreePath(path, o -> {
            Object userObject = TreeUtil.getUserObject((Object)o);
            Object result = userObject instanceof DbNamespaceNode ? ((DbNamespaceNode)userObject).getObject() : userObject;
            return result == null ? this.myModel.getRoot() : result;
        }), o -> {
            this.myTree.getTree().expandPath((TreePath)o);
            TreeUtil.selectPath((JTree)((Object)this.myTree.getTree()), (TreePath)o);
        });
    }

    public void setInitialModel(@Nullable LocalDataSource dataSource, @Nullable BasicModel tempModel) {
        this.myModel = tempModel;
        this.mySkipSpecForRoot = dataSource != null && DataSourceScopeEditor.isSingleRoot(dataSource);
        this.myTree.setSkipSpecForRoot(this.mySkipSpecForRoot);
        this.myFakeCurrentSchema = dataSource == null ? null : dataSource.getFakeCurrentSchema();
        this.myFakeCurrentSchemaEnabled = this.isFakeCurrentSchemaEnabled(tempModel, this.myFakeCurrentSchema);
        this.myTree.update();
    }

    public boolean isFakeCurrentSchemaEnabled(@Nullable BasicModel tempModel, Couple<String> fakeCurrentSchema) {
        if (fakeCurrentSchema != null) {
            return true;
        }
        if (tempModel == null) {
            return false;
        }
        if (tempModel.getMetaModel().dbms != Dbms.UNKNOWN) {
            return false;
        }
        JBIterable namespaces = JBIterable.from((Iterable)tempModel.getRoot().getNamespaces());
        if (namespaces.isEmpty()) {
            return false;
        }
        BasicDatabase curDb = tempModel.getRoot().getCurrentDatabase();
        if (curDb == null) {
            return true;
        }
        namespaces = JBIterable.from((Iterable)curDb.getNamespaces());
        if (namespaces.isEmpty()) {
            return false;
        }
        BasicMateNamespace curSc = (BasicMateNamespace)namespaces.filter(BasicMateNamespace.class).filter(BasicNamespace::isCurrent).first();
        return curSc == null;
    }

    protected DbNamespaceNode getRoot() {
        return (DbNamespaceNode)this.myTree.getSearchModel().getRootObject();
    }

    @Nullable
    protected LocalDataSource getDataSource(boolean withCredentials) {
        return null;
    }

    public void introspectIfEmpty() {
        if (this.myModel != null && !DataSourceScopeEditor.getNamespaces((BasicElement)this.myModel.getRoot()).isEmpty()) {
            return;
        }
        this.introspectIfCan();
    }

    public void introspectIfCan() {
        LocalDataSource dataSource = this.getDataSource(false);
        if (dataSource == null || !DbImplUtilCore.canConnectTo((LocalDataSource)dataSource)) {
            return;
        }
        this.reintrospect(null);
    }

    private static JBIterable<BasicNamespace> getNamespaces(@NotNull BasicElement el) {
        if (el == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(8);
        }
        return el.getChildren().filter(BasicNamespace.class);
    }

    private boolean canReintrospect() {
        LocalDataSource dataSource = this.getDataSource(false);
        return dataSource != null && DataSourceSyncManager.getInstance().isAbleToPerform(this.myProject, (RawDataSource)dataSource);
    }

    public void reintrospect(@Nullable List<BasicNamespace> namespaces) {
        LocalDataSource dataSource = this.getDataSource(true);
        if (dataSource == null) {
            return;
        }
        IndefiniteIntrospectionTask task = IntrospectionTasks.prepareBriefTask((String)dataSource.getUniqueId(), (boolean)Registry.is((String)INTROSPECTOR_SHOULD_VISIT_EVERY_DATABASE));
        LoaderContext context = LoaderContext.selectTask((Project)this.myProject, (LocalDataSource)dataSource, (IntrospectionTask)task);
        context.withCredentials(this.getCredentials());
        AsyncTask.Frame frame = AsyncTask.Frame.create((String)DatabaseBundle.message((String)"progress.title.update.namespaces", (Object[])new Object[0]));
        AsyncTask.withIndicator((AsyncTask.Frame)frame, (ProgressIndicator)new EmptyProgressIndicator());
        frame.computeAsync(null, () -> this.reintrospectImpl(context));
    }

    private AsyncTask<SyncQueue.SyncResult> reintrospectImpl(@NotNull LoaderContext context) {
        if (context == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(9);
        }
        LocalDataSource dataSource = context.getDataSource();
        AsyncTask<SyncQueue.SyncResult> promise = DataSourceSyncManager.getInstance().tryPerformAsync(context, true, false);
        if (promise == null) {
            return null;
        }
        return promise.whenComplete(AsyncUtil.getEdtExecutor(), (res2, e) -> {
            BasicModel model;
            AsyncUtil.addUnhandledError((ErrorHandler)context.getErrorHandler(), (Throwable)e, (LocalDataSource)context.getDataSource());
            if (res2 != null && (model = (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class)) != null && !DataSourceScopeEditor.getNamespaces((BasicElement)model.getRoot()).isEmpty()) {
                this.myModel = model;
                this.mySkipSpecForRoot = DataSourceScopeEditor.isSingleRoot(dataSource);
                this.myTree.setSkipSpecForRoot(this.mySkipSpecForRoot);
                this.myFakeCurrentSchemaEnabled = this.isFakeCurrentSchemaEnabled(model, (Couple<String>)dataSource.getFakeCurrentSchema());
                this.onIntrospectionFinished(dataSource);
            }
            this.handleIntrospectionError(StringUtil.nullize((String)context.getErrorHandler().getSummary()));
        });
    }

    protected void onIntrospectionFinished(LocalDataSource dataSource) {
        this.myTree.update();
        this.onStateChanged();
    }

    @NotNull
    protected DatabaseCredentials getCredentials() {
        DatabaseCredentials databaseCredentials = DatabaseCredentials.getInstance();
        if (databaseCredentials == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(10);
        }
        return databaseCredentials;
    }

    protected void handleIntrospectionError(@Nls @Nullable String msg) {
    }

    private static boolean isSingleRoot(@NotNull LocalDataSource dataSource) {
        Dbms dbms;
        if (dataSource == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(11);
        }
        return (dbms = dataSource.getDbms()).isH2() || dbms.isHsqldb();
    }

    @NotNull
    public DataSourceScopeEditorTree getTree() {
        DataSourceScopeEditorTree dataSourceScopeEditorTree = this.myTree.getTree();
        if (dataSourceScopeEditorTree == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(12);
        }
        return dataSourceScopeEditorTree;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(13);
        }
        return jComponent;
    }

    @NotNull
    protected DefaultActionGroup createTreeActions() {
        return new DefaultActionGroup(new AnAction[]{new RefreshAction(), this.createExpandActon(), this.createCollapseAction(), new MarkAsCurrentAction(), new SubstituteAction(), new DropFilterAction()});
    }

    @NotNull
    private AnAction createCollapseAction() {
        CollapseAllAction action = new CollapseAllAction((JTree)((Object)this.getTree()));
        action.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CollapseAll"), (JComponent)((Object)this.getTree()));
        CollapseAllAction collapseAllAction = action;
        if (collapseAllAction == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(14);
        }
        return collapseAllAction;
    }

    @NotNull
    private AnAction createExpandActon() {
        ExpandAllAction action = new ExpandAllAction((JTree)((Object)this.getTree()));
        action.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ExpandAll"), (JComponent)((Object)this.getTree()));
        ExpandAllAction expandAllAction = action;
        if (expandAllAction == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(15);
        }
        return expandAllAction;
    }

    @Nullable
    private static DataSourceScopeEditor getEditor(@NotNull AnActionEvent e) {
        DataSourceScopeEditorTree component;
        if (e == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(16);
        }
        return (component = DataSourceScopeEditorTree.getTree(e.getDataContext())) == null ? null : (DataSourceScopeEditor)ComponentUtil.getClientProperty((JComponent)((Object)component), EDITOR_KEY);
    }

    @NotNull
    private static JBIterable<DbNamespaceNode> getNamespaceNodes(@Nullable DataSourceScopeEditor editor2) {
        JBIterable jBIterable = DataSourceScopeEditor.getSelectedNodes(editor2).filter(n -> n.getObject() instanceof BasicNamespace);
        if (jBIterable == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(17);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DbNamespaceNode> getSelectedNodes(@Nullable DataSourceScopeEditor editor2) {
        if (editor2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DataSourceScopeEditor.$$$reportNull$$$0(18);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object[])((CheckedTreeNode[])editor2.getTree().getSelectedNodes(CheckedTreeNode.class, null))).filterMap(n -> (DbNamespaceNode)editor2.myTree.getUserObject((TreeNode)n));
        if (jBIterable == null) {
            DataSourceScopeEditor.$$$reportNull$$$0(19);
        }
        return jBIterable;
    }

    public static void addPattern(DataSourceScopeEditor editor2, DbNamespaceNode target, BasicMetaObject<?> meta) {
        TreePatternNode.PatternWrapper pattern = TreePatternNode.PatternWrapper.create((String)"abc.*");
        DbNamespaceNode filter = new DbNamespaceNode(pattern.toString(), meta, pattern);
        target.setFilterChildren(ContainerUtil.append(target.getFilterChildren(), (Object[])new DbNamespaceNode[]{filter}));
        filter.setHasAllAndCur(filter.getWildcardMetas().isNotEmpty());
        editor2.getFilteringTree().getSearchModel().refilter();
        filter.setChecked(true);
        DbUIUtil.invokeLater(() -> {
            CheckedTreeNode node = (CheckedTreeNode)editor2.getFilteringTree().getSearchModel().getCachedNode((Object)filter);
            if (node != null) {
                editor2.getTree().setNodeState(node, true);
                editor2.getTree().startEditingAtPath(TreeUtil.getPathFromRoot((TreeNode)node));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6, 7, 10, 12, 13, 14, 15, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditor";
                break;
            }
            case 3: 
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModelFromDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNorthPanel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentials";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollapseAction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpandActon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceNodes";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSubstituted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSubstituted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSchemaMapping";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaces";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reintrospectImpl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSingleRoot";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6, 7, 10, 12, 13, 14, 15, 17, 18, 19 -> new IllegalStateException(string);
        };
    }

    private final class MyTree
    extends FilteringTree<CheckedTreeNode, DbNamespaceNode> {
        private final DbNamespacesTree myNamespacesTree;
        final /* synthetic */ DataSourceScopeEditor this$0;

        MyTree(@NotNull DataSourceScopeEditor dataSourceScopeEditor, Project project, DbNamespaceNode root, Supplier<Couple<String>> fakeCurrent, DataSourceSchemaMapping mapping) {
            if (project == null) {
                MyTree.$$$reportNull$$$0(0);
            }
            this(dataSourceScopeEditor, project, DataSourceScopeEditorTree.createNode(root), fakeCurrent, mapping);
        }

        private MyTree(final @NotNull DataSourceScopeEditor dataSourceScopeEditor, Project project, CheckedTreeNode root, Supplier<Couple<String>> fakeCurrent, DataSourceSchemaMapping mapping) {
            if (project == null) {
                MyTree.$$$reportNull$$$0(1);
            }
            this.this$0 = dataSourceScopeEditor;
            super((Tree)new DataSourceScopeEditorTree(project, root, fakeCurrent, mapping), (DefaultMutableTreeNode)root);
            this.myNamespacesTree = new DbNamespacesTree();
            SwingUtilities.invokeLater(() -> this.rebuildTree());
            this.getTree().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DataSourceScopeEditorTree.HoverHelper helper = DataSourceScopeEditorTree.HoverHelper.get((JTree)((Object)MyTree.this.getTree()));
                    if (helper == null) {
                        return;
                    }
                    helper.updateHover(e);
                    if ("add_pattern".equals(helper.hoveredTag)) {
                        BasicMetaObject<?> meta;
                        DbNamespaceNode node = (DbNamespaceNode)MyTree.this.getSearchModel().getUserObject(helper.hoveredPath == null ? null : (CheckedTreeNode)ObjectUtils.tryCast((Object)helper.hoveredPath.getLastPathComponent(), CheckedTreeNode.class));
                        DbNamespaceNode parent = node == null ? null : (DbNamespaceNode)node.getParent();
                        BasicMetaObject<?> basicMetaObject = meta = node == null ? null : node.getMeta();
                        if (parent != null && meta != null) {
                            DataSourceScopeEditor.addPattern(MyTree.this.this$0, parent, meta);
                        }
                        e.consume();
                    }
                }
            });
        }

        protected Class<? extends CheckedTreeNode> getNodeClass() {
            return CheckedTreeNode.class;
        }

        @NotNull
        protected CheckedTreeNode createNode(@Nullable DbNamespaceNode obj) {
            CheckedTreeNode checkedTreeNode = DataSourceScopeEditorTree.createNode(obj);
            if (checkedTreeNode == null) {
                MyTree.$$$reportNull$$$0(2);
            }
            return checkedTreeNode;
        }

        @NotNull
        protected Iterable<DbNamespaceNode> getChildren(@NotNull DbNamespaceNode obj) {
            if (obj == null) {
                MyTree.$$$reportNull$$$0(3);
            }
            JBIterable jBIterable = obj.getChildNodes();
            if (jBIterable == null) {
                MyTree.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @Nullable
        protected String getText(@Nullable DbNamespaceNode object) {
            return object == null || object.getObject() == "*" ? null : object.getName();
        }

        @NotNull
        public DataSourceScopeEditorTree getTree() {
            DataSourceScopeEditorTree dataSourceScopeEditorTree = (DataSourceScopeEditorTree)super.getTree();
            if (dataSourceScopeEditorTree == null) {
                MyTree.$$$reportNull$$$0(5);
            }
            return dataSourceScopeEditorTree;
        }

        private void rebuildTree() {
            DbNamespaceNode root = (DbNamespaceNode)this.getSearchModel().getRootObject();
            this.myNamespacesTree.addNodes(root, (BasicElement)(this.this$0.myModel == null ? null : this.this$0.myModel.getRoot()));
            MyTree.createShadowStructure(root, TreePatternUtils.union((TreePattern[])new TreePattern[]{this.this$0.myPermStructure, this.this$0.mySelectedScope, this.this$0.getEditorState(true)}));
            this.getSearchModel().updateStructure();
        }

        public void update() {
            this.rebuildTree();
            this.getTree().revalidate();
            this.getTree().repaint();
        }

        private static void createShadowStructure(@NotNull DbNamespaceNode root, @NotNull TreePattern scope2) {
            if (root == null) {
                MyTree.$$$reportNull$$$0(6);
            }
            if (scope2 == null) {
                MyTree.$$$reportNull$$$0(7);
            }
            DbNamespacesTree.fillShadowChildren(scope2.root.groups, root);
        }

        private void recheck(@NotNull TreePattern scope2) {
            if (scope2 == null) {
                MyTree.$$$reportNull$$$0(8);
            }
            FilteringTree.SearchTreeModel model = this.this$0.myTree.getSearchModel();
            DbNamespaceNode root = (DbNamespaceNode)model.getRootObject();
            root.setChecked(true);
            this.myNamespacesTree.recheck(root, Collections.singleton(scope2.root));
            this.getTree().updateFromNodes();
        }

        private void setSkipSpecForRoot(boolean skipSpecForRoot) {
            this.myNamespacesTree.setSkipSpecForRoot(skipSpecForRoot);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditor$MyTree";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createShadowStructure";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "recheck";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class RefreshAction
    extends DumbAwareAction {
        RefreshAction() {
            super(DatabaseBundle.message((String)"DataSourceScopeEditor.RefreshAction.text", (Object[])new Object[0]), DatabaseBundle.message((String)"DataSourceScopeEditor.RefreshAction.description", (Object[])new Object[0]), AllIcons.Actions.Refresh);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                RefreshAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            DataSourceScopeEditor editor2;
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(1);
            }
            boolean enabled = (editor2 = DataSourceScopeEditor.getEditor(e)) != null && editor2.canReintrospect();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setDescription(DatabaseBundle.message((String)(enabled ? "DataSourceScopeEditor.RefreshAction.description" : "DataSourceScopeEditor.RefreshAction.description.running"), (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataSourceScopeEditor editor2;
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(2);
            }
            if ((editor2 = DataSourceScopeEditor.getEditor(e)) != null) {
                List namespaces = JBIterable.of((Object[])((CheckedTreeNode[])editor2.getTree().getSelectedNodes(CheckedTreeNode.class, null))).transform(n -> {
                    DbNamespaceNode node = (DbNamespaceNode)editor2.myTree.getUserObject((TreeNode)n);
                    return node == null ? null : node.getObject();
                }).filter(BasicNamespace.class).toList();
                editor2.reintrospect(namespaces);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditor$RefreshAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditor$RefreshAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class MarkAsCurrentAction
    extends DumbAwareAction {
        public MarkAsCurrentAction() {
            super(DatabaseBundle.message((String)"action.MarkAsCurrentAction.text", (Object[])new Object[0]), DatabaseBundle.message((String)"action.MarkAsCurrentAction.description", (Object[])new Object[0]), AllIcons.Actions.Checked_selected);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MarkAsCurrentAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            DataSourceScopeEditor editor2;
            if (e == null) {
                MarkAsCurrentAction.$$$reportNull$$$0(1);
            }
            boolean visible = (editor2 = DataSourceScopeEditor.getEditor(e)) != null && editor2.myFakeCurrentSchemaEnabled;
            boolean enabled = visible && !this.getNodes(editor2).isEmpty();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(visible);
        }

        @NotNull
        public JBIterable<DbNamespaceNode> getNodes(DataSourceScopeEditor editor2) {
            JBIterable jBIterable = JBIterable.of((Object[])((CheckedTreeNode[])editor2.getTree().getSelectedNodes(CheckedTreeNode.class, null))).filterMap(arg_0 -> ((MyTree)editor2.myTree).getUserObject(arg_0)).filter(n -> !(n instanceof DbNamespaceNode.CurNode) && n.getObject() != "*");
            if (jBIterable == null) {
                MarkAsCurrentAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataSourceScopeEditor editor2;
            DbNamespaceNode node;
            if (e == null) {
                MarkAsCurrentAction.$$$reportNull$$$0(3);
            }
            if ((node = (DbNamespaceNode)this.getNodes(editor2 = DataSourceScopeEditor.getEditor(e)).first()) == null) {
                return;
            }
            String name2 = DbNamespacesTree.getNodeName(node);
            if (DbImplUtilCore.isDatabase((ObjectKind)node.getKind())) {
                this.mark(editor2, name2, null);
            } else {
                this.mark(editor2, DbNamespacesTree.getParentName(node), name2);
            }
        }

        public void mark(DataSourceScopeEditor editor2, String pName, String name2) {
            Couple<String> fsc = editor2.myFakeCurrentSchema;
            boolean isSet = DbNamespacesTree.matches(fsc, pName, name2);
            editor2.setFakeCurrentSchema(isSet ? null : Couple.of((Object)pName, (Object)name2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditor$MarkAsCurrentAction";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditor$MarkAsCurrentAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class SubstituteAction
    extends DumbAwareAction {
        private SubstituteAction() {
            super(AllIcons.Actions.Lightning);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SubstituteAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            DataSourceScopeEditor editor2;
            if (e == null) {
                SubstituteAction.$$$reportNull$$$0(1);
            }
            LocalDataSource dataSource = (editor2 = DataSourceScopeEditor.getEditor(e)) == null ? null : editor2.getDataSource(false);
            boolean visible = editor2 != null && (DataSourceSnapshotManager.IGNORE_AUTO_MINI_CAT || dataSource != null && !dataSource.getSchemaMapping().isUseMiniCat());
            JBIterable<DbNamespaceNode> nodes2 = visible ? DataSourceScopeEditor.getNamespaceNodes(editor2) : JBIterable.empty();
            boolean enabled = visible && nodes2.map(n -> n.getObject()).filter(BasicNamespace.class).filter(o -> DataSourceSnapshotManager.getInstance().canSubstitute(o, false, false)).isNotEmpty();
            DbNamespaceNode first2 = (DbNamespaceNode)nodes2.first();
            BasicNamespace namespace = first2 == null ? null : (BasicNamespace)first2.getObject();
            boolean state = editor2 != null && (first2 == null || editor2.isSubstituted(namespace) && !first2.isChecked());
            e.getPresentation().setText(DatabaseBundle.message((String)(state ? "DataSourceScopeEditor.SubstituteAction.text.disable" : "DataSourceScopeEditor.SubstituteAction.text.enable"), (Object[])new Object[0]));
            e.getPresentation().setDescription(DatabaseBundle.message((String)(state ? "DataSourceScopeEditor.SubstituteAction.description.disable" : "DataSourceScopeEditor.SubstituteAction.description.enable"), (Object[])new Object[0]));
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(visible);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataSourceScopeEditor editor2;
            if (e == null) {
                SubstituteAction.$$$reportNull$$$0(2);
            }
            if ((editor2 = DataSourceScopeEditor.getEditor(e)) == null) {
                return;
            }
            JBIterable<DbNamespaceNode> namespaces = DataSourceScopeEditor.getNamespaceNodes(editor2);
            DbNamespaceNode first2 = (DbNamespaceNode)namespaces.first();
            BasicNamespace namespace = first2 == null ? null : (BasicNamespace)first2.getObject();
            boolean state = first2 == null || editor2.isSubstituted(namespace) && !first2.isChecked();
            namespaces.forEach(n -> {
                if (!state && n.isChecked()) {
                    n.setChecked(false);
                }
                editor2.setSubstituted((BasicNamespace)n.getObject(), !state);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditor$SubstituteAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditor$SubstituteAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class DropFilterAction
    extends DumbAwareAction {
        private DropFilterAction() {
            super(DatabaseBundle.message((String)"action.remove.filter.text", (Object[])new Object[0]), null, AllIcons.Toolbar.RemoveSlot);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                DropFilterAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DropFilterAction.$$$reportNull$$$0(1);
            }
            DataSourceScopeEditor editor2 = DataSourceScopeEditor.getEditor(e);
            DbNamespaceNode target = DropFilterAction.getPatternNode(editor2);
            e.getPresentation().setEnabled(target != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataSourceScopeEditor editor2;
            DbNamespaceNode target;
            if (e == null) {
                DropFilterAction.$$$reportNull$$$0(2);
            }
            DbNamespaceNode dbNamespaceNode = target = (editor2 = DataSourceScopeEditor.getEditor(e)) == null ? null : DropFilterAction.getPatternNode(editor2);
            if (target == null) {
                return;
            }
            DbNamespaceNode parent = (DbNamespaceNode)target.getParent();
            if (parent == null) {
                return;
            }
            DbNamespaceNode toSelect = DropFilterAction.getNodeToSelect(target, parent);
            ArrayList<DbNamespaceNode> filters = new ArrayList<DbNamespaceNode>(parent.getFilterChildren());
            filters.remove(target);
            parent.setFilterChildren(filters);
            editor2.getFilteringTree().getSearchModel().refilter();
            CheckedTreeNode selNode = (CheckedTreeNode)editor2.getFilteringTree().getSearchModel().getCachedNode((Object)toSelect);
            editor2.getTree().setSelectionPath(selNode == null ? null : TreeUtil.getPathFromRoot((TreeNode)selNode));
        }

        private static DbNamespaceNode getNodeToSelect(DbNamespaceNode target, DbNamespaceNode parent) {
            Iterator it = parent.getChildNodes().iterator();
            DbNamespaceNode prev2 = null;
            while (it.hasNext()) {
                DbNamespaceNode cur = (DbNamespaceNode)it.next();
                if (cur == target) {
                    if (!it.hasNext()) break;
                    return (DbNamespaceNode)it.next();
                }
                prev2 = cur;
            }
            return prev2 == null ? parent : prev2;
        }

        @Nullable
        private static DbNamespaceNode getPatternNode(DataSourceScopeEditor editor2) {
            DbNamespaceNode selection = (DbNamespaceNode)DataSourceScopeEditor.getSelectedNodes(editor2).single();
            return selection != null && selection.getObject() instanceof TreePatternNode.PatternWrapper ? selection : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditor$DropFilterAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditor$DropFilterAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

