/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DbConversionPoints;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class SFlakeDomains
extends BaseDomainRegistry {
    private static final int MAX_PRECISION = 38;
    private static final int MAX_FRACTION = 9;
    private static final int MAX_VARCHAR = 0x1000000;
    private static final int MAX_BINARY = 0x800000;

    public SFlakeDomains() {
        this.add((Domain)new Number2Domain("number", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add((Domain)new FloatDomain("float", ConversionPoint.DOUBLE_PRECISION, Double.MIN_VALUE, Double.MAX_VALUE));
        this.add((Domain)new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, Double.MIN_VALUE, Double.MAX_VALUE));
        this.add((Domain)new TextDomain("varchar", ConversionPoint.VARCHAR, 0x1000000L, TextDomain.Length.optional((long)0x1000000L, (boolean)true)));
        this.add(new BinaryDomain("binary", ConversionPoint.BINARY, 0x800000L, TextDomain.Length.optional((long)1L, (boolean)true)).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add(new SimpleDomain("date", ConversionPoint.DATE).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("time", ConversionPoint.TIME, 9, 9, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("timestampntz", ConversionPoint.TIMESTAMP, 9, 9, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("timestampltz", DbConversionPoints.TIMESTAMP_WITH_TIMEZONE, 9, 9, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("timestamptz", DbConversionPoints.TIMESTAMP_WITH_TIMEZONE, 9, 9, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new SimpleDomain("variant", ConversionPoint.JSON){

            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                int suitability;
                if (domain == null) {
                    1.$$$reportNull$$$0(0);
                }
                Compatibility compatibility = (suitability = this.getLogicType().getSuitability(domain.getLogicType())) > 0 ? Compatibility.compatibleLossy((Cardinality)this.cardinality(), (LogicalType)domain.getLogicType(), (LogicalType)this.getLogicType()) : Compatibility.incompatible();
                if (compatibility == null) {
                    1.$$$reportNull$$$0(1);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/snowflake/SFlakeDomains$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/snowflake/SFlakeDomains$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        this.add(new SimpleDomain("object", ConversionPoint.JSON){

            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    2.$$$reportNull$$$0(0);
                }
                Compatibility compatibility = SFlakeDomains.checkCompatibilityAndName(this, domain);
                if (compatibility == null) {
                    2.$$$reportNull$$$0(1);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/snowflake/SFlakeDomains$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/snowflake/SFlakeDomains$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new SimpleDomain("array", ConversionPoint.JSON){

            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    3.$$$reportNull$$$0(0);
                }
                Compatibility compatibility = SFlakeDomains.checkCompatibilityAndName(this, domain);
                if (compatibility == null) {
                    3.$$$reportNull$$$0(1);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/snowflake/SFlakeDomains$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/snowflake/SFlakeDomains$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
    }

    private static Compatibility checkCompatibilityAndName(SimpleDomain domain1, Domain domain2) {
        int suitability = domain1.getLogicType().getSuitability(domain2.getLogicType());
        return suitability >= 100 && StringUtil.equalsIgnoreCase((CharSequence)domain1.simpleName(), (CharSequence)domain2.simpleName()) ? Compatibility.full((Cardinality)domain1.cardinality(), (LogicalType)domain2.getLogicType(), (LogicalType)domain1.getLogicType()) : (suitability > 0 ? Compatibility.compatibleLossy((Cardinality)domain1.cardinality(), (LogicalType)domain2.getLogicType(), (LogicalType)domain1.getLogicType()) : Compatibility.incompatible());
    }
}

