/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.OffsetTime;
import java.time.temporal.Temporal;
import org.assertj.core.api.AbstractTemporalAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.TemporalOffset;
import org.assertj.core.error.ShouldBeAfter;
import org.assertj.core.error.ShouldBeAfterOrEqualTo;
import org.assertj.core.error.ShouldBeBefore;
import org.assertj.core.error.ShouldBeBeforeOrEqualTo;
import org.assertj.core.error.ShouldBeEqualIgnoringNanos;
import org.assertj.core.error.ShouldBeEqualIgnoringSeconds;
import org.assertj.core.error.ShouldBeEqualIgnoringTimezone;
import org.assertj.core.error.ShouldHaveSameHourAs;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;

public abstract class AbstractOffsetTimeAssert<SELF extends AbstractOffsetTimeAssert<SELF>>
extends AbstractTemporalAssert<SELF, OffsetTime> {
    public static final String NULL_OFFSET_TIME_PARAMETER_MESSAGE = "The OffsetTime to compare actual with should not be null";

    protected AbstractOffsetTimeAssert(OffsetTime actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isBefore(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (!((OffsetTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return (SELF)((AbstractOffsetTimeAssert)this.myself);
    }

    public SELF isBefore(String offsetTimeAsString) {
        AbstractOffsetTimeAssert.assertOffsetTimeAsStringParameterIsNotNull(offsetTimeAsString);
        return this.isBefore(this.parse(offsetTimeAsString));
    }

    public SELF isBeforeOrEqualTo(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (((OffsetTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualTo.shouldBeBeforeOrEqualTo(this.actual, other));
        }
        return (SELF)((AbstractOffsetTimeAssert)this.myself);
    }

    public SELF isBeforeOrEqualTo(String offsetTimeAsString) {
        AbstractOffsetTimeAssert.assertOffsetTimeAsStringParameterIsNotNull(offsetTimeAsString);
        return this.isBeforeOrEqualTo(this.parse(offsetTimeAsString));
    }

    public SELF isAfterOrEqualTo(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (((OffsetTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualTo.shouldBeAfterOrEqualTo(this.actual, other));
        }
        return (SELF)((AbstractOffsetTimeAssert)this.myself);
    }

    public SELF isAfterOrEqualTo(String offsetTimeAsString) {
        AbstractOffsetTimeAssert.assertOffsetTimeAsStringParameterIsNotNull(offsetTimeAsString);
        return this.isAfterOrEqualTo(this.parse(offsetTimeAsString));
    }

    public SELF isAfter(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (!((OffsetTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return (SELF)((AbstractOffsetTimeAssert)this.myself);
    }

    public SELF isAfter(String offsetTimeAsString) {
        AbstractOffsetTimeAssert.assertOffsetTimeAsStringParameterIsNotNull(offsetTimeAsString);
        return this.isAfter(this.parse(offsetTimeAsString));
    }

    public SELF isEqualTo(String offsetTimeAsString) {
        AbstractOffsetTimeAssert.assertOffsetTimeAsStringParameterIsNotNull(offsetTimeAsString);
        return (SELF)((AbstractOffsetTimeAssert)this.isEqualTo(this.parse(offsetTimeAsString)));
    }

    public SELF isNotEqualTo(String offsetTimeAsString) {
        AbstractOffsetTimeAssert.assertOffsetTimeAsStringParameterIsNotNull(offsetTimeAsString);
        return (SELF)((AbstractOffsetTimeAssert)this.isNotEqualTo(this.parse(offsetTimeAsString)));
    }

    public SELF isIn(String ... offsetTimesAsString) {
        this.checkIsNotNullAndNotEmpty(offsetTimesAsString);
        return (SELF)((AbstractOffsetTimeAssert)this.isIn(AbstractOffsetTimeAssert.convertToOffsetTimeArray(offsetTimesAsString)));
    }

    public SELF isNotIn(String ... offsetTimesAsString) {
        this.checkIsNotNullAndNotEmpty(offsetTimesAsString);
        return (SELF)((AbstractOffsetTimeAssert)this.isNotIn(AbstractOffsetTimeAssert.convertToOffsetTimeArray(offsetTimesAsString)));
    }

    private static Object[] convertToOffsetTimeArray(String ... offsetTimesAsString) {
        Object[] dates = new OffsetTime[offsetTimesAsString.length];
        for (int i = 0; i < offsetTimesAsString.length; ++i) {
            dates[i] = OffsetTime.parse(offsetTimesAsString[i]);
        }
        return dates;
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        Preconditions.checkArgument(values != null, "The given OffsetTime array should not be null", new Object[0]);
        Preconditions.checkArgument(values.length > 0, "The given OffsetTime array should not be empty", new Object[0]);
    }

    private static void assertOffsetTimeAsStringParameterIsNotNull(String OffsetTimeAsString) {
        Preconditions.checkArgument(OffsetTimeAsString != null, "The String representing the OffsetTime to compare actual with should not be null", new Object[0]);
    }

    private static void assertOffsetTimeParameterIsNotNull(OffsetTime other) {
        Preconditions.checkArgument(other != null, NULL_OFFSET_TIME_PARAMETER_MESSAGE, new Object[0]);
    }

    @Deprecated
    public SELF isEqualToIgnoringNanos(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (!AbstractOffsetTimeAssert.areEqualIgnoringNanos((OffsetTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringNanos.shouldBeEqualIgnoringNanos((OffsetTime)this.actual, other));
        }
        return (SELF)((AbstractOffsetTimeAssert)this.myself);
    }

    @Deprecated
    public SELF isEqualToIgnoringSeconds(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (!AbstractOffsetTimeAssert.areEqualIgnoringSeconds((OffsetTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringSeconds.shouldBeEqualIgnoringSeconds((OffsetTime)this.actual, other));
        }
        return (SELF)((AbstractOffsetTimeAssert)this.myself);
    }

    public SELF isEqualToIgnoringTimezone(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (!AbstractOffsetTimeAssert.areEqualIgnoringTimezone((OffsetTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringTimezone.shouldBeEqualIgnoringTimezone((OffsetTime)this.actual, other));
        }
        return (SELF)((AbstractOffsetTimeAssert)this.myself);
    }

    public SELF hasSameHourAs(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (!AbstractOffsetTimeAssert.haveSameHourField((OffsetTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveSameHourAs.shouldHaveSameHourAs((Temporal)this.actual, other));
        }
        return (SELF)((AbstractOffsetTimeAssert)this.myself);
    }

    public SELF isBetween(OffsetTime startInclusive, OffsetTime endInclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startInclusive, endInclusive, true, true);
        return (SELF)((AbstractOffsetTimeAssert)this.myself);
    }

    public SELF isBetween(String startInclusive, String endInclusive) {
        return this.isBetween(this.parse(startInclusive), this.parse(endInclusive));
    }

    public SELF isStrictlyBetween(OffsetTime startExclusive, OffsetTime endExclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startExclusive, endExclusive, false, false);
        return (SELF)((AbstractOffsetTimeAssert)this.myself);
    }

    public SELF isStrictlyBetween(String startExclusive, String endExclusive) {
        return this.isStrictlyBetween(this.parse(startExclusive), this.parse(endExclusive));
    }

    @Override
    public SELF isCloseTo(OffsetTime other, TemporalOffset<? super OffsetTime> offset) {
        return (SELF)((AbstractOffsetTimeAssert)super.isCloseTo(other, offset));
    }

    @Override
    protected OffsetTime parse(String offsetTimeAsString) {
        return OffsetTime.parse(offsetTimeAsString);
    }

    private static boolean areEqualIgnoringNanos(OffsetTime actual, OffsetTime other) {
        return AbstractOffsetTimeAssert.areEqualIgnoringSeconds(actual, other) && AbstractOffsetTimeAssert.haveSameSecond(actual, other);
    }

    private static boolean areEqualIgnoringSeconds(OffsetTime actual, OffsetTime other) {
        return AbstractOffsetTimeAssert.haveSameHourField(actual, other) && AbstractOffsetTimeAssert.haveSameMinute(actual, other);
    }

    private static boolean areEqualIgnoringTimezone(OffsetTime actual, OffsetTime other) {
        return AbstractOffsetTimeAssert.areEqualIgnoringNanos(actual, other) && AbstractOffsetTimeAssert.haveSameNano(actual, other);
    }

    private static boolean haveSameNano(OffsetTime actual, OffsetTime other) {
        return actual.getNano() == other.getNano();
    }

    private static boolean haveSameSecond(OffsetTime actual, OffsetTime other) {
        return actual.getSecond() == other.getSecond();
    }

    private static boolean haveSameMinute(OffsetTime actual, OffsetTime other) {
        return actual.getMinute() == other.getMinute();
    }

    private static boolean haveSameHourField(OffsetTime actual, OffsetTime other) {
        return actual.getHour() == other.getHour();
    }
}

