/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.renderers;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import javax.swing.JTable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SizeRenderer
extends ColoredTableCellRenderer {
    private final SimpleTextAttributes myBlackTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, UIUtil.getTableForeground(), null, null);
    private final SimpleTextAttributes mySelectionAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, UIUtil.getTableSelectionForeground(), null, null);
    private final long myTotalSize;

    public SizeRenderer(long size) {
        this.myTotalSize = size;
    }

    protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        SimpleTextAttributes attr;
        if (table == null) {
            SizeRenderer.$$$reportNull$$$0(0);
        }
        this.setPaintFocusBorder(false);
        this.setTextAlign(4);
        boolean lineHasFocus = table.hasFocus();
        boolean useSelection = selected && (lineHasFocus || StartupUiUtil.isUnderDarcula());
        SimpleTextAttributes simpleTextAttributes = attr = useSelection ? this.mySelectionAttributes : this.myBlackTextAttributes;
        if (value instanceof Long) {
            this.append(SizeRenderer.formatSize(Long.toString((Long)value)), attr);
            this.append(" ");
            int tens = (int)Math.round(((Long)value).doubleValue() / (double)this.myTotalSize * 1000.0);
            if (tens < 100) {
                this.append(" ");
            }
            String percent = tens / 10 + "." + tens % 10 + "%";
            this.append(percent, useSelection ? this.mySelectionAttributes : SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else {
            @NlsSafe String fragment = value.toString();
            this.append(fragment, attr);
        }
        if (!lineHasFocus && selected) {
            this.setBackground(UIUtil.getTreeUnfocusedSelectionBackground());
        }
    }

    @NotNull
    public static String formatSize(long number) {
        return SizeRenderer.formatSize(String.valueOf(number));
    }

    @NotNull
    @Nls
    public static String formatSize(@Nls String number) {
        String s;
        if (number.length() <= 3) {
            String string = number;
            if (string == null) {
                SizeRenderer.$$$reportNull$$$0(1);
            }
            return string;
        }
        int spaceIdx = number.length() % 3;
        spaceIdx = spaceIdx > 0 ? spaceIdx - 1 : 2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < number.length(); ++i) {
            sb.append(number.charAt(i));
            if (i != spaceIdx || i == number.length() - 1) continue;
            sb.append(' ');
            spaceIdx += 3;
        }
        String string = s = sb.toString();
        if (string == null) {
            SizeRenderer.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected SimpleTextAttributes modifyAttributes(SimpleTextAttributes attributes) {
        return attributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/heap/view/renderers/SizeRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/renderers/SizeRenderer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formatSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

