/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.maven;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.diagram.DiagramColors;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.ui.JBColor;
import com.intellij.uml.maven.MavenDependencyRelationship;
import com.intellij.uml.maven.MavenElement;
import com.intellij.uml.maven.MavenUmlEdge;
import java.awt.Color;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;

@Service(value={Service.Level.APP})
final class MavenUmlColorManager
extends DiagramColorManagerBase {
    public static final Color PROJECT_HEADER_COLOR = new JBColor(new Color(158, 188, 195), new Color(13, 41, 62));
    public static final Color TEST_HEADER_COLOR = new JBColor(new Color(190, 238, 217), new Color(49, 59, 50));

    MavenUmlColorManager() {
    }

    @Nullable
    public ColorKey getEdgeColorKey(@NotNull DiagramBuilder builder, @NotNull DiagramEdge edge) {
        if (builder == null) {
            MavenUmlColorManager.$$$reportNull$$$0(0);
        }
        if (edge == null) {
            MavenUmlColorManager.$$$reportNull$$$0(1);
        }
        if (edge.getRelationship() instanceof MavenDependencyRelationship) {
            return DiagramColors.BAD_EDGE;
        }
        if (edge.getRelationship() == MavenUmlEdge.DUPLICATE) {
            return DiagramColors.BAD_EDGE;
        }
        MavenElement trg = (MavenElement)edge.getTarget().getIdentifyingElement();
        MavenArtifactState state = trg.getState();
        if (state != null) {
            return switch (state) {
                default -> throw new IncompatibleClassChangeError();
                case MavenArtifactState.ADDED, MavenArtifactState.DUPLICATE -> DiagramColors.GENERALIZATION_EDGE;
                case MavenArtifactState.CYCLE -> DiagramColors.BAD_EDGE;
                case MavenArtifactState.EXCLUDED, MavenArtifactState.CONFLICT -> DiagramColors.DEFAULT_EDGE;
            };
        }
        return null;
    }

    @NotNull
    public Color getNodeHeaderBackground(@NotNull DiagramBuilder builder, @NotNull DiagramNode node, Object element) {
        if (builder == null) {
            MavenUmlColorManager.$$$reportNull$$$0(2);
        }
        if (node == null) {
            MavenUmlColorManager.$$$reportNull$$$0(3);
        }
        if (element instanceof MavenElement) {
            if (((MavenElement)element).isProject()) {
                Color color = PROJECT_HEADER_COLOR;
                if (color == null) {
                    MavenUmlColorManager.$$$reportNull$$$0(4);
                }
                return color;
            }
            if (((MavenElement)element).isTestArtifact()) {
                Color color = TEST_HEADER_COLOR;
                if (color == null) {
                    MavenUmlColorManager.$$$reportNull$$$0(5);
                }
                return color;
            }
            if (((MavenElement)element).getScope() == MavenArtifactScope.TEST) {
                Color color = Objects.requireNonNull(builder.getColorScheme().getColor(DiagramColors.REALIZATION_EDGE));
                if (color == null) {
                    MavenUmlColorManager.$$$reportNull$$$0(6);
                }
                return color;
            }
        }
        Color color = Objects.requireNonNull(builder.getColorScheme().getColor(DiagramColors.NODE_HEADER));
        if (color == null) {
            MavenUmlColorManager.$$$reportNull$$$0(7);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/maven/MavenUmlColorManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/maven/MavenUmlColorManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeHeaderBackground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeColorKey";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNodeHeaderBackground";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

