/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.util.BitSet;

final class FluentBitSet {
    private final BitSet bitSet;

    FluentBitSet(BitSet bitSet) {
        this.bitSet = bitSet;
    }

    FluentBitSet(int nbits) {
        this(new BitSet(nbits));
    }

    FluentBitSet andNot(FluentBitSet fBitSet) {
        this.bitSet.andNot(fBitSet.bitSet);
        return this;
    }

    BitSet bitSet() {
        return this.bitSet;
    }

    FluentBitSet clear(int ... bitIndexArray) {
        for (int e : bitIndexArray) {
            this.bitSet.clear(e);
        }
        return this;
    }

    boolean get(int bitIndex) {
        return this.bitSet.get(bitIndex);
    }

    FluentBitSet or(FluentBitSet ... fBitSets) {
        for (FluentBitSet e : fBitSets) {
            this.bitSet.or(e.bitSet);
        }
        return this;
    }

    FluentBitSet or(FluentBitSet fBitSet) {
        this.bitSet.or(fBitSet.bitSet);
        return this;
    }

    FluentBitSet set(int ... bitIndexArray) {
        for (int e : bitIndexArray) {
            this.bitSet.set(e);
        }
        return this;
    }

    FluentBitSet set(int bitIndex) {
        this.bitSet.set(bitIndex);
        return this;
    }

    FluentBitSet setInclusive(int startIncl, int endIncl) {
        this.bitSet.set(startIncl, endIncl + 1);
        return this;
    }
}

