/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.MsBaseJdbcHelper;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MsJdbcHelper
extends MsBaseJdbcHelper {
    public MsJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("MSSQL", version, connection, jdbcClassLoader);
    }

    public MsJdbcHelper(@NotNull String dbmsName, @Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        if (dbmsName == null) {
            MsJdbcHelper.$$$reportNull$$$0(0);
        }
        super(dbmsName, version, connection, jdbcClassLoader);
    }

    private MsJdbcHelper(@NotNull MsJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            MsJdbcHelper.$$$reportNull$$$0(1);
        }
        if (jdbcClassLoader == null) {
            MsJdbcHelper.$$$reportNull$$$0(2);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new MsJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            MsJdbcHelper.$$$reportNull$$$0(3);
        }
        return new MsJdbcHelper(this, jdbcClassLoader);
    }

    public MsJdbcHelper() {
        this(null, null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return MsJdbcHelper.extractVersion(version);
    }

    @NotNull
    static MsJdbcHelper create(@NotNull String dbmsName, @Nullable Connection delegate, @Nullable String productVer, @Nullable ClassLoader jdbcClassLoader) {
        if (dbmsName == null) {
            MsJdbcHelper.$$$reportNull$$$0(4);
        }
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new MsJdbcHelper(dbmsName, MsJdbcHelper.extractVersion(productVer), delegate, jdbcClassLoader);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbmsName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MsJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

