/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.ref;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceWrapper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.python.django.packages.celery.ref.CeleryBeatScheduleNewTaskQuickFix;
import com.intellij.python.django.packages.celery.ref.CeleryBeatScheduleReferenceProvider;
import com.intellij.python.django.packages.restFramework.ref.DrfInsertMissingFunctionViewSetQuickFix;
import com.intellij.python.django.packages.restFramework.ref.DrfViewSetMethodReference;
import com.intellij.python.django.ref.CreateViewQuickFix;
import com.intellij.python.django.ui.CreateTemplateDialog;
import com.intellij.python.django.ui.DjangoTemplateFileFactory;
import com.intellij.python.templateLanguages.ConfigureTemplateDirectoriesAction;
import com.intellij.python.templateLanguages.PyTemplateFileReferenceSet;
import com.jetbrains.django.lang.template.ref.DjangoTemplateFileReferenceSet;
import com.jetbrains.django.ref.ViewParameters;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.DjangoStringUtil;
import com.jetbrains.python.inspections.PyUnresolvedReferenceQuickFixProvider;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DjangoReferenceQuickFixProvider
implements PyUnresolvedReferenceQuickFixProvider {
    public void registerQuickFixes(@NotNull PsiReference reference, @NotNull List<LocalQuickFix> existing) {
        FileReferenceSet fileReferenceSet;
        int count;
        if (reference == null) {
            DjangoReferenceQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (existing == null) {
            DjangoReferenceQuickFixProvider.$$$reportNull$$$0(1);
        }
        PsiElement element = reference.getElement();
        if (reference instanceof DrfViewSetMethodReference) {
            DrfViewSetMethodReference newReference = (DrfViewSetMethodReference)reference;
            existing.add((LocalQuickFix)new DrfInsertMissingFunctionViewSetQuickFix(newReference.getViewSetClass$intellij_python_django(), ((PyStringLiteralExpression)newReference.getElement()).getStringValue()));
        }
        if (reference instanceof CeleryBeatScheduleReferenceProvider.CeleryBeatScheduleReferenceSet.CeleryBeatScheduleReference) {
            existing.add((LocalQuickFix)new CeleryBeatScheduleNewTaskQuickFix());
        }
        FileReference fileReference = null;
        if (reference instanceof FileReference) {
            fileReference = (FileReference)reference;
        } else if (reference instanceof PsiReferenceWrapper && ((PsiReferenceWrapper)reference).isInstance(FileReference.class)) {
            fileReference = (FileReference)((PsiReferenceWrapper)reference).cast(FileReference.class);
        }
        if (fileReference != null && (fileReference.getFileReferenceSet() instanceof DjangoTemplateFileReferenceSet || fileReference.getFileReferenceSet() instanceof PyTemplateFileReferenceSet) && (count = (fileReferenceSet = fileReference.getFileReferenceSet()).getAllReferences().length) != 0 && fileReference.getIndex() == count - 1) {
            existing.add(new CreateTemplateIntentionAction(DjangoStringUtil.getStringValue((PsiElement)element)));
            existing.add((LocalQuickFix)new ConfigureTemplateDirectoriesAction());
        }
    }

    private static void suggestFix(ViewParameters viewMethodReference, @NotNull List<LocalQuickFix> existing) {
        if (existing == null) {
            DjangoReferenceQuickFixProvider.$$$reportNull$$$0(2);
        }
        if (viewMethodReference.getViewsFile() != null) {
            existing.add(new CreateViewQuickFix(viewMethodReference));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/django/ref/DjangoReferenceQuickFixProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerQuickFixes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class CreateTemplateIntentionAction
    implements LocalQuickFix {
        private final String myTemplateName;

        private CreateTemplateIntentionAction(String templateName) {
            this.myTemplateName = templateName;
        }

        @NotNull
        public String getName() {
            String string = DjangoBundle.message((String)"django.create.template.with.name", (Object[])new Object[]{this.myTemplateName});
            if (string == null) {
                CreateTemplateIntentionAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = DjangoBundle.message((String)"django.templates.create.no.capitalization", (Object[])new Object[0]);
            if (string == null) {
                CreateTemplateIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CreateTemplateIntentionAction.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CreateTemplateIntentionAction.$$$reportNull$$$0(3);
            }
            CreateTemplateDialog d = new CreateTemplateDialog(project, descriptor.getPsiElement());
            d.setShowCreateTemplateCheckBox(false);
            d.setTemplateName(this.myTemplateName);
            d.setTemplateNameEditable(false);
            d.show();
            if (d.getExitCode() != 0) {
                return;
            }
            DjangoTemplateFileFactory templateFileFactory = d.getTemplateFileFactory();
            if (d.isCreateTemplate() && !templateFileFactory.isValid(d.getTemplateName())) {
                Messages.showErrorDialog((String)DjangoBundle.message((String)"template-name-error", (Object[])new Object[0]), (String)"");
                return;
            }
            try {
                CreateTemplateIntentionAction.create(project, templateFileFactory, PsiManager.getInstance((Project)project).findDirectory(d.getSelectedTemplateRoot()), d.getTemplateName());
            }
            catch (Exception ex) {
                CreateTemplateIntentionAction.showError(ex.getMessage());
            }
        }

        private static void showError(@NlsSafe String msg) {
            Messages.showErrorDialog((String)msg, (String)"");
        }

        public static void create(Project project, DjangoTemplateFileFactory templateFileFactory, PsiDirectory templateFolder, String templateName) {
            CommandProcessor.getInstance().executeCommand(project, () -> {
                PsiFile file = templateFileFactory.createTemplate(templateFolder, templateName);
                if (file != null) {
                    file.navigate(true);
                }
            }, DjangoBundle.message((String)"django.templates.create.no.capitalization", (Object[])new Object[0]), (Object)templateName, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/python/django/ref/DjangoReferenceQuickFixProvider$CreateTemplateIntentionAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/python/django/ref/DjangoReferenceQuickFixProvider$CreateTemplateIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

