//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgcontext?language=objc)
#[repr(C)]
pub struct CGContext {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CGContext {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"CGContext"> for CGContext {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpathdrawingmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGPathDrawingMode(pub i32);
impl CGPathDrawingMode {
    #[doc(alias = "kCGPathFill")]
    pub const Fill: Self = Self(0);
    #[doc(alias = "kCGPathEOFill")]
    pub const EOFill: Self = Self(1);
    #[doc(alias = "kCGPathStroke")]
    pub const Stroke: Self = Self(2);
    #[doc(alias = "kCGPathFillStroke")]
    pub const FillStroke: Self = Self(3);
    #[doc(alias = "kCGPathEOFillStroke")]
    pub const EOFillStroke: Self = Self(4);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGPathDrawingMode {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGPathDrawingMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgtextdrawingmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGTextDrawingMode(pub i32);
impl CGTextDrawingMode {
    #[doc(alias = "kCGTextFill")]
    pub const Fill: Self = Self(0);
    #[doc(alias = "kCGTextStroke")]
    pub const Stroke: Self = Self(1);
    #[doc(alias = "kCGTextFillStroke")]
    pub const FillStroke: Self = Self(2);
    #[doc(alias = "kCGTextInvisible")]
    pub const Invisible: Self = Self(3);
    #[doc(alias = "kCGTextFillClip")]
    pub const FillClip: Self = Self(4);
    #[doc(alias = "kCGTextStrokeClip")]
    pub const StrokeClip: Self = Self(5);
    #[doc(alias = "kCGTextFillStrokeClip")]
    pub const FillStrokeClip: Self = Self(6);
    #[doc(alias = "kCGTextClip")]
    pub const Clip: Self = Self(7);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGTextDrawingMode {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGTextDrawingMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgtextencoding?language=objc)
// NS_ENUM
#[deprecated = "No longer supported"]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGTextEncoding(pub i32);
impl CGTextEncoding {
    #[doc(alias = "kCGEncodingFontSpecific")]
    #[deprecated = "No longer supported"]
    pub const EncodingFontSpecific: Self = Self(0);
    #[doc(alias = "kCGEncodingMacRoman")]
    #[deprecated = "No longer supported"]
    pub const EncodingMacRoman: Self = Self(1);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGTextEncoding {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGTextEncoding {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cginterpolationquality?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGInterpolationQuality(pub i32);
impl CGInterpolationQuality {
    #[doc(alias = "kCGInterpolationDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "kCGInterpolationNone")]
    pub const None: Self = Self(1);
    #[doc(alias = "kCGInterpolationLow")]
    pub const Low: Self = Self(2);
    #[doc(alias = "kCGInterpolationMedium")]
    pub const Medium: Self = Self(4);
    #[doc(alias = "kCGInterpolationHigh")]
    pub const High: Self = Self(3);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGInterpolationQuality {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGInterpolationQuality {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgblendmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGBlendMode(pub i32);
impl CGBlendMode {
    #[doc(alias = "kCGBlendModeNormal")]
    pub const Normal: Self = Self(0);
    #[doc(alias = "kCGBlendModeMultiply")]
    pub const Multiply: Self = Self(1);
    #[doc(alias = "kCGBlendModeScreen")]
    pub const Screen: Self = Self(2);
    #[doc(alias = "kCGBlendModeOverlay")]
    pub const Overlay: Self = Self(3);
    #[doc(alias = "kCGBlendModeDarken")]
    pub const Darken: Self = Self(4);
    #[doc(alias = "kCGBlendModeLighten")]
    pub const Lighten: Self = Self(5);
    #[doc(alias = "kCGBlendModeColorDodge")]
    pub const ColorDodge: Self = Self(6);
    #[doc(alias = "kCGBlendModeColorBurn")]
    pub const ColorBurn: Self = Self(7);
    #[doc(alias = "kCGBlendModeSoftLight")]
    pub const SoftLight: Self = Self(8);
    #[doc(alias = "kCGBlendModeHardLight")]
    pub const HardLight: Self = Self(9);
    #[doc(alias = "kCGBlendModeDifference")]
    pub const Difference: Self = Self(10);
    #[doc(alias = "kCGBlendModeExclusion")]
    pub const Exclusion: Self = Self(11);
    #[doc(alias = "kCGBlendModeHue")]
    pub const Hue: Self = Self(12);
    #[doc(alias = "kCGBlendModeSaturation")]
    pub const Saturation: Self = Self(13);
    #[doc(alias = "kCGBlendModeColor")]
    pub const Color: Self = Self(14);
    #[doc(alias = "kCGBlendModeLuminosity")]
    pub const Luminosity: Self = Self(15);
    #[doc(alias = "kCGBlendModeClear")]
    pub const Clear: Self = Self(16);
    #[doc(alias = "kCGBlendModeCopy")]
    pub const Copy: Self = Self(17);
    #[doc(alias = "kCGBlendModeSourceIn")]
    pub const SourceIn: Self = Self(18);
    #[doc(alias = "kCGBlendModeSourceOut")]
    pub const SourceOut: Self = Self(19);
    #[doc(alias = "kCGBlendModeSourceAtop")]
    pub const SourceAtop: Self = Self(20);
    #[doc(alias = "kCGBlendModeDestinationOver")]
    pub const DestinationOver: Self = Self(21);
    #[doc(alias = "kCGBlendModeDestinationIn")]
    pub const DestinationIn: Self = Self(22);
    #[doc(alias = "kCGBlendModeDestinationOut")]
    pub const DestinationOut: Self = Self(23);
    #[doc(alias = "kCGBlendModeDestinationAtop")]
    pub const DestinationAtop: Self = Self(24);
    #[doc(alias = "kCGBlendModeXOR")]
    pub const XOR: Self = Self(25);
    #[doc(alias = "kCGBlendModePlusDarker")]
    pub const PlusDarker: Self = Self(26);
    #[doc(alias = "kCGBlendModePlusLighter")]
    pub const PlusLighter: Self = Self(27);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGBlendMode {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGBlendMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl ConcreteType for CGContext {
    #[doc(alias = "CGContextGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGContextGetTypeID() -> CFTypeID;
        }
        unsafe { CGContextGetTypeID() }
    }
}

impl CGContext {
    /// Graphics state functions. *
    #[doc(alias = "CGContextSaveGState")]
    #[inline]
    pub unsafe fn save_g_state(c: Option<&CGContext>) {
        extern "C-unwind" {
            fn CGContextSaveGState(c: Option<&CGContext>);
        }
        unsafe { CGContextSaveGState(c) }
    }

    #[doc(alias = "CGContextRestoreGState")]
    #[inline]
    pub unsafe fn restore_g_state(c: Option<&CGContext>) {
        extern "C-unwind" {
            fn CGContextRestoreGState(c: Option<&CGContext>);
        }
        unsafe { CGContextRestoreGState(c) }
    }

    /// Coordinate space transformations. *
    #[doc(alias = "CGContextScaleCTM")]
    #[inline]
    pub unsafe fn scale_ctm(c: Option<&CGContext>, sx: CGFloat, sy: CGFloat) {
        extern "C-unwind" {
            fn CGContextScaleCTM(c: Option<&CGContext>, sx: CGFloat, sy: CGFloat);
        }
        unsafe { CGContextScaleCTM(c, sx, sy) }
    }

    #[doc(alias = "CGContextTranslateCTM")]
    #[inline]
    pub unsafe fn translate_ctm(c: Option<&CGContext>, tx: CGFloat, ty: CGFloat) {
        extern "C-unwind" {
            fn CGContextTranslateCTM(c: Option<&CGContext>, tx: CGFloat, ty: CGFloat);
        }
        unsafe { CGContextTranslateCTM(c, tx, ty) }
    }

    #[doc(alias = "CGContextRotateCTM")]
    #[inline]
    pub unsafe fn rotate_ctm(c: Option<&CGContext>, angle: CGFloat) {
        extern "C-unwind" {
            fn CGContextRotateCTM(c: Option<&CGContext>, angle: CGFloat);
        }
        unsafe { CGContextRotateCTM(c, angle) }
    }

    #[doc(alias = "CGContextConcatCTM")]
    #[inline]
    pub unsafe fn concat_ctm(c: Option<&CGContext>, transform: CGAffineTransform) {
        extern "C-unwind" {
            fn CGContextConcatCTM(c: Option<&CGContext>, transform: CGAffineTransform);
        }
        unsafe { CGContextConcatCTM(c, transform) }
    }

    #[doc(alias = "CGContextGetCTM")]
    #[inline]
    pub unsafe fn ctm(c: Option<&CGContext>) -> CGAffineTransform {
        extern "C-unwind" {
            fn CGContextGetCTM(c: Option<&CGContext>) -> CGAffineTransform;
        }
        unsafe { CGContextGetCTM(c) }
    }

    /// Drawing attribute functions. *
    #[doc(alias = "CGContextSetLineWidth")]
    #[inline]
    pub unsafe fn set_line_width(c: Option<&CGContext>, width: CGFloat) {
        extern "C-unwind" {
            fn CGContextSetLineWidth(c: Option<&CGContext>, width: CGFloat);
        }
        unsafe { CGContextSetLineWidth(c, width) }
    }

    #[doc(alias = "CGContextSetLineCap")]
    #[cfg(feature = "CGPath")]
    #[inline]
    pub unsafe fn set_line_cap(c: Option<&CGContext>, cap: CGLineCap) {
        extern "C-unwind" {
            fn CGContextSetLineCap(c: Option<&CGContext>, cap: CGLineCap);
        }
        unsafe { CGContextSetLineCap(c, cap) }
    }

    #[doc(alias = "CGContextSetLineJoin")]
    #[cfg(feature = "CGPath")]
    #[inline]
    pub unsafe fn set_line_join(c: Option<&CGContext>, join: CGLineJoin) {
        extern "C-unwind" {
            fn CGContextSetLineJoin(c: Option<&CGContext>, join: CGLineJoin);
        }
        unsafe { CGContextSetLineJoin(c, join) }
    }

    #[doc(alias = "CGContextSetMiterLimit")]
    #[inline]
    pub unsafe fn set_miter_limit(c: Option<&CGContext>, limit: CGFloat) {
        extern "C-unwind" {
            fn CGContextSetMiterLimit(c: Option<&CGContext>, limit: CGFloat);
        }
        unsafe { CGContextSetMiterLimit(c, limit) }
    }

    #[doc(alias = "CGContextSetLineDash")]
    #[inline]
    pub unsafe fn set_line_dash(
        c: Option<&CGContext>,
        phase: CGFloat,
        lengths: *const CGFloat,
        count: usize,
    ) {
        extern "C-unwind" {
            fn CGContextSetLineDash(
                c: Option<&CGContext>,
                phase: CGFloat,
                lengths: *const CGFloat,
                count: usize,
            );
        }
        unsafe { CGContextSetLineDash(c, phase, lengths, count) }
    }

    #[doc(alias = "CGContextSetFlatness")]
    #[inline]
    pub unsafe fn set_flatness(c: Option<&CGContext>, flatness: CGFloat) {
        extern "C-unwind" {
            fn CGContextSetFlatness(c: Option<&CGContext>, flatness: CGFloat);
        }
        unsafe { CGContextSetFlatness(c, flatness) }
    }

    #[doc(alias = "CGContextSetAlpha")]
    #[inline]
    pub unsafe fn set_alpha(c: Option<&CGContext>, alpha: CGFloat) {
        extern "C-unwind" {
            fn CGContextSetAlpha(c: Option<&CGContext>, alpha: CGFloat);
        }
        unsafe { CGContextSetAlpha(c, alpha) }
    }

    #[doc(alias = "CGContextSetBlendMode")]
    #[inline]
    pub unsafe fn set_blend_mode(c: Option<&CGContext>, mode: CGBlendMode) {
        extern "C-unwind" {
            fn CGContextSetBlendMode(c: Option<&CGContext>, mode: CGBlendMode);
        }
        unsafe { CGContextSetBlendMode(c, mode) }
    }

    /// Path construction functions. *
    #[doc(alias = "CGContextBeginPath")]
    #[inline]
    pub unsafe fn begin_path(c: Option<&CGContext>) {
        extern "C-unwind" {
            fn CGContextBeginPath(c: Option<&CGContext>);
        }
        unsafe { CGContextBeginPath(c) }
    }

    #[doc(alias = "CGContextMoveToPoint")]
    #[inline]
    pub unsafe fn move_to_point(c: Option<&CGContext>, x: CGFloat, y: CGFloat) {
        extern "C-unwind" {
            fn CGContextMoveToPoint(c: Option<&CGContext>, x: CGFloat, y: CGFloat);
        }
        unsafe { CGContextMoveToPoint(c, x, y) }
    }

    #[doc(alias = "CGContextAddLineToPoint")]
    #[inline]
    pub unsafe fn add_line_to_point(c: Option<&CGContext>, x: CGFloat, y: CGFloat) {
        extern "C-unwind" {
            fn CGContextAddLineToPoint(c: Option<&CGContext>, x: CGFloat, y: CGFloat);
        }
        unsafe { CGContextAddLineToPoint(c, x, y) }
    }

    #[doc(alias = "CGContextAddCurveToPoint")]
    #[inline]
    pub unsafe fn add_curve_to_point(
        c: Option<&CGContext>,
        cp1x: CGFloat,
        cp1y: CGFloat,
        cp2x: CGFloat,
        cp2y: CGFloat,
        x: CGFloat,
        y: CGFloat,
    ) {
        extern "C-unwind" {
            fn CGContextAddCurveToPoint(
                c: Option<&CGContext>,
                cp1x: CGFloat,
                cp1y: CGFloat,
                cp2x: CGFloat,
                cp2y: CGFloat,
                x: CGFloat,
                y: CGFloat,
            );
        }
        unsafe { CGContextAddCurveToPoint(c, cp1x, cp1y, cp2x, cp2y, x, y) }
    }

    #[doc(alias = "CGContextAddQuadCurveToPoint")]
    #[inline]
    pub unsafe fn add_quad_curve_to_point(
        c: Option<&CGContext>,
        cpx: CGFloat,
        cpy: CGFloat,
        x: CGFloat,
        y: CGFloat,
    ) {
        extern "C-unwind" {
            fn CGContextAddQuadCurveToPoint(
                c: Option<&CGContext>,
                cpx: CGFloat,
                cpy: CGFloat,
                x: CGFloat,
                y: CGFloat,
            );
        }
        unsafe { CGContextAddQuadCurveToPoint(c, cpx, cpy, x, y) }
    }

    #[doc(alias = "CGContextClosePath")]
    #[inline]
    pub unsafe fn close_path(c: Option<&CGContext>) {
        extern "C-unwind" {
            fn CGContextClosePath(c: Option<&CGContext>);
        }
        unsafe { CGContextClosePath(c) }
    }

    /// Path construction convenience functions. *
    #[doc(alias = "CGContextAddRect")]
    #[inline]
    pub unsafe fn add_rect(c: Option<&CGContext>, rect: CGRect) {
        extern "C-unwind" {
            fn CGContextAddRect(c: Option<&CGContext>, rect: CGRect);
        }
        unsafe { CGContextAddRect(c, rect) }
    }

    #[doc(alias = "CGContextAddRects")]
    #[inline]
    pub unsafe fn add_rects(c: Option<&CGContext>, rects: *const CGRect, count: usize) {
        extern "C-unwind" {
            fn CGContextAddRects(c: Option<&CGContext>, rects: *const CGRect, count: usize);
        }
        unsafe { CGContextAddRects(c, rects, count) }
    }

    #[doc(alias = "CGContextAddLines")]
    #[inline]
    pub unsafe fn add_lines(c: Option<&CGContext>, points: *const CGPoint, count: usize) {
        extern "C-unwind" {
            fn CGContextAddLines(c: Option<&CGContext>, points: *const CGPoint, count: usize);
        }
        unsafe { CGContextAddLines(c, points, count) }
    }

    #[doc(alias = "CGContextAddEllipseInRect")]
    #[inline]
    pub unsafe fn add_ellipse_in_rect(c: Option<&CGContext>, rect: CGRect) {
        extern "C-unwind" {
            fn CGContextAddEllipseInRect(c: Option<&CGContext>, rect: CGRect);
        }
        unsafe { CGContextAddEllipseInRect(c, rect) }
    }

    #[doc(alias = "CGContextAddArc")]
    #[inline]
    pub unsafe fn add_arc(
        c: Option<&CGContext>,
        x: CGFloat,
        y: CGFloat,
        radius: CGFloat,
        start_angle: CGFloat,
        end_angle: CGFloat,
        clockwise: c_int,
    ) {
        extern "C-unwind" {
            fn CGContextAddArc(
                c: Option<&CGContext>,
                x: CGFloat,
                y: CGFloat,
                radius: CGFloat,
                start_angle: CGFloat,
                end_angle: CGFloat,
                clockwise: c_int,
            );
        }
        unsafe { CGContextAddArc(c, x, y, radius, start_angle, end_angle, clockwise) }
    }

    #[doc(alias = "CGContextAddArcToPoint")]
    #[inline]
    pub unsafe fn add_arc_to_point(
        c: Option<&CGContext>,
        x1: CGFloat,
        y1: CGFloat,
        x2: CGFloat,
        y2: CGFloat,
        radius: CGFloat,
    ) {
        extern "C-unwind" {
            fn CGContextAddArcToPoint(
                c: Option<&CGContext>,
                x1: CGFloat,
                y1: CGFloat,
                x2: CGFloat,
                y2: CGFloat,
                radius: CGFloat,
            );
        }
        unsafe { CGContextAddArcToPoint(c, x1, y1, x2, y2, radius) }
    }

    #[doc(alias = "CGContextAddPath")]
    #[cfg(feature = "CGPath")]
    #[inline]
    pub unsafe fn add_path(c: Option<&CGContext>, path: Option<&CGPath>) {
        extern "C-unwind" {
            fn CGContextAddPath(c: Option<&CGContext>, path: Option<&CGPath>);
        }
        unsafe { CGContextAddPath(c, path) }
    }

    #[doc(alias = "CGContextReplacePathWithStrokedPath")]
    #[inline]
    pub unsafe fn replace_path_with_stroked_path(c: Option<&CGContext>) {
        extern "C-unwind" {
            fn CGContextReplacePathWithStrokedPath(c: Option<&CGContext>);
        }
        unsafe { CGContextReplacePathWithStrokedPath(c) }
    }

    /// Path information functions. *
    #[doc(alias = "CGContextIsPathEmpty")]
    #[inline]
    pub unsafe fn is_path_empty(c: Option<&CGContext>) -> bool {
        extern "C-unwind" {
            fn CGContextIsPathEmpty(c: Option<&CGContext>) -> bool;
        }
        unsafe { CGContextIsPathEmpty(c) }
    }

    #[doc(alias = "CGContextGetPathCurrentPoint")]
    #[inline]
    pub unsafe fn path_current_point(c: Option<&CGContext>) -> CGPoint {
        extern "C-unwind" {
            fn CGContextGetPathCurrentPoint(c: Option<&CGContext>) -> CGPoint;
        }
        unsafe { CGContextGetPathCurrentPoint(c) }
    }

    #[doc(alias = "CGContextGetPathBoundingBox")]
    #[inline]
    pub unsafe fn path_bounding_box(c: Option<&CGContext>) -> CGRect {
        extern "C-unwind" {
            fn CGContextGetPathBoundingBox(c: Option<&CGContext>) -> CGRect;
        }
        unsafe { CGContextGetPathBoundingBox(c) }
    }

    #[doc(alias = "CGContextCopyPath")]
    #[cfg(feature = "CGPath")]
    #[inline]
    pub unsafe fn path(c: Option<&CGContext>) -> Option<CFRetained<CGPath>> {
        extern "C-unwind" {
            fn CGContextCopyPath(c: Option<&CGContext>) -> Option<NonNull<CGPath>>;
        }
        let ret = unsafe { CGContextCopyPath(c) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGContextPathContainsPoint")]
    #[inline]
    pub unsafe fn path_contains_point(
        c: Option<&CGContext>,
        point: CGPoint,
        mode: CGPathDrawingMode,
    ) -> bool {
        extern "C-unwind" {
            fn CGContextPathContainsPoint(
                c: Option<&CGContext>,
                point: CGPoint,
                mode: CGPathDrawingMode,
            ) -> bool;
        }
        unsafe { CGContextPathContainsPoint(c, point, mode) }
    }

    /// Path drawing functions. *
    #[doc(alias = "CGContextDrawPath")]
    #[inline]
    pub unsafe fn draw_path(c: Option<&CGContext>, mode: CGPathDrawingMode) {
        extern "C-unwind" {
            fn CGContextDrawPath(c: Option<&CGContext>, mode: CGPathDrawingMode);
        }
        unsafe { CGContextDrawPath(c, mode) }
    }

    /// Path drawing convenience functions. *
    #[doc(alias = "CGContextFillPath")]
    #[inline]
    pub unsafe fn fill_path(c: Option<&CGContext>) {
        extern "C-unwind" {
            fn CGContextFillPath(c: Option<&CGContext>);
        }
        unsafe { CGContextFillPath(c) }
    }

    #[doc(alias = "CGContextEOFillPath")]
    #[inline]
    pub unsafe fn eo_fill_path(c: Option<&CGContext>) {
        extern "C-unwind" {
            fn CGContextEOFillPath(c: Option<&CGContext>);
        }
        unsafe { CGContextEOFillPath(c) }
    }

    #[doc(alias = "CGContextStrokePath")]
    #[inline]
    pub unsafe fn stroke_path(c: Option<&CGContext>) {
        extern "C-unwind" {
            fn CGContextStrokePath(c: Option<&CGContext>);
        }
        unsafe { CGContextStrokePath(c) }
    }

    #[doc(alias = "CGContextFillRect")]
    #[inline]
    pub unsafe fn fill_rect(c: Option<&CGContext>, rect: CGRect) {
        extern "C-unwind" {
            fn CGContextFillRect(c: Option<&CGContext>, rect: CGRect);
        }
        unsafe { CGContextFillRect(c, rect) }
    }

    #[doc(alias = "CGContextFillRects")]
    #[inline]
    pub unsafe fn fill_rects(c: Option<&CGContext>, rects: *const CGRect, count: usize) {
        extern "C-unwind" {
            fn CGContextFillRects(c: Option<&CGContext>, rects: *const CGRect, count: usize);
        }
        unsafe { CGContextFillRects(c, rects, count) }
    }

    #[doc(alias = "CGContextStrokeRect")]
    #[inline]
    pub unsafe fn stroke_rect(c: Option<&CGContext>, rect: CGRect) {
        extern "C-unwind" {
            fn CGContextStrokeRect(c: Option<&CGContext>, rect: CGRect);
        }
        unsafe { CGContextStrokeRect(c, rect) }
    }

    #[doc(alias = "CGContextStrokeRectWithWidth")]
    #[inline]
    pub unsafe fn stroke_rect_with_width(c: Option<&CGContext>, rect: CGRect, width: CGFloat) {
        extern "C-unwind" {
            fn CGContextStrokeRectWithWidth(c: Option<&CGContext>, rect: CGRect, width: CGFloat);
        }
        unsafe { CGContextStrokeRectWithWidth(c, rect, width) }
    }

    #[doc(alias = "CGContextClearRect")]
    #[inline]
    pub unsafe fn clear_rect(c: Option<&CGContext>, rect: CGRect) {
        extern "C-unwind" {
            fn CGContextClearRect(c: Option<&CGContext>, rect: CGRect);
        }
        unsafe { CGContextClearRect(c, rect) }
    }

    #[doc(alias = "CGContextFillEllipseInRect")]
    #[inline]
    pub unsafe fn fill_ellipse_in_rect(c: Option<&CGContext>, rect: CGRect) {
        extern "C-unwind" {
            fn CGContextFillEllipseInRect(c: Option<&CGContext>, rect: CGRect);
        }
        unsafe { CGContextFillEllipseInRect(c, rect) }
    }

    #[doc(alias = "CGContextStrokeEllipseInRect")]
    #[inline]
    pub unsafe fn stroke_ellipse_in_rect(c: Option<&CGContext>, rect: CGRect) {
        extern "C-unwind" {
            fn CGContextStrokeEllipseInRect(c: Option<&CGContext>, rect: CGRect);
        }
        unsafe { CGContextStrokeEllipseInRect(c, rect) }
    }

    #[doc(alias = "CGContextStrokeLineSegments")]
    #[inline]
    pub unsafe fn stroke_line_segments(
        c: Option<&CGContext>,
        points: *const CGPoint,
        count: usize,
    ) {
        extern "C-unwind" {
            fn CGContextStrokeLineSegments(
                c: Option<&CGContext>,
                points: *const CGPoint,
                count: usize,
            );
        }
        unsafe { CGContextStrokeLineSegments(c, points, count) }
    }

    /// Clipping functions. *
    #[doc(alias = "CGContextClip")]
    #[inline]
    pub unsafe fn clip(c: Option<&CGContext>) {
        extern "C-unwind" {
            fn CGContextClip(c: Option<&CGContext>);
        }
        unsafe { CGContextClip(c) }
    }

    #[doc(alias = "CGContextEOClip")]
    #[inline]
    pub unsafe fn eo_clip(c: Option<&CGContext>) {
        extern "C-unwind" {
            fn CGContextEOClip(c: Option<&CGContext>);
        }
        unsafe { CGContextEOClip(c) }
    }

    #[doc(alias = "CGContextResetClip")]
    #[inline]
    pub unsafe fn reset_clip(self: &CGContext) {
        extern "C-unwind" {
            fn CGContextResetClip(c: &CGContext);
        }
        unsafe { CGContextResetClip(self) }
    }

    #[doc(alias = "CGContextClipToMask")]
    #[cfg(feature = "CGImage")]
    #[inline]
    pub unsafe fn clip_to_mask(c: Option<&CGContext>, rect: CGRect, mask: Option<&CGImage>) {
        extern "C-unwind" {
            fn CGContextClipToMask(c: Option<&CGContext>, rect: CGRect, mask: Option<&CGImage>);
        }
        unsafe { CGContextClipToMask(c, rect, mask) }
    }

    #[doc(alias = "CGContextGetClipBoundingBox")]
    #[inline]
    pub unsafe fn clip_bounding_box(c: Option<&CGContext>) -> CGRect {
        extern "C-unwind" {
            fn CGContextGetClipBoundingBox(c: Option<&CGContext>) -> CGRect;
        }
        unsafe { CGContextGetClipBoundingBox(c) }
    }

    /// Clipping convenience functions. *
    #[doc(alias = "CGContextClipToRect")]
    #[inline]
    pub unsafe fn clip_to_rect(c: Option<&CGContext>, rect: CGRect) {
        extern "C-unwind" {
            fn CGContextClipToRect(c: Option<&CGContext>, rect: CGRect);
        }
        unsafe { CGContextClipToRect(c, rect) }
    }

    #[doc(alias = "CGContextClipToRects")]
    #[inline]
    pub unsafe fn clip_to_rects(c: Option<&CGContext>, rects: NonNull<CGRect>, count: usize) {
        extern "C-unwind" {
            fn CGContextClipToRects(c: Option<&CGContext>, rects: NonNull<CGRect>, count: usize);
        }
        unsafe { CGContextClipToRects(c, rects, count) }
    }

    /// Primitive color functions. *
    #[doc(alias = "CGContextSetFillColorWithColor")]
    #[cfg(feature = "CGColor")]
    #[inline]
    pub unsafe fn set_fill_color_with_color(c: Option<&CGContext>, color: Option<&CGColor>) {
        extern "C-unwind" {
            fn CGContextSetFillColorWithColor(c: Option<&CGContext>, color: Option<&CGColor>);
        }
        unsafe { CGContextSetFillColorWithColor(c, color) }
    }

    #[doc(alias = "CGContextSetStrokeColorWithColor")]
    #[cfg(feature = "CGColor")]
    #[inline]
    pub unsafe fn set_stroke_color_with_color(c: Option<&CGContext>, color: Option<&CGColor>) {
        extern "C-unwind" {
            fn CGContextSetStrokeColorWithColor(c: Option<&CGContext>, color: Option<&CGColor>);
        }
        unsafe { CGContextSetStrokeColorWithColor(c, color) }
    }

    /// Color space functions. *
    #[doc(alias = "CGContextSetFillColorSpace")]
    #[cfg(feature = "CGColorSpace")]
    #[inline]
    pub unsafe fn set_fill_color_space(c: Option<&CGContext>, space: Option<&CGColorSpace>) {
        extern "C-unwind" {
            fn CGContextSetFillColorSpace(c: Option<&CGContext>, space: Option<&CGColorSpace>);
        }
        unsafe { CGContextSetFillColorSpace(c, space) }
    }

    #[doc(alias = "CGContextSetStrokeColorSpace")]
    #[cfg(feature = "CGColorSpace")]
    #[inline]
    pub unsafe fn set_stroke_color_space(c: Option<&CGContext>, space: Option<&CGColorSpace>) {
        extern "C-unwind" {
            fn CGContextSetStrokeColorSpace(c: Option<&CGContext>, space: Option<&CGColorSpace>);
        }
        unsafe { CGContextSetStrokeColorSpace(c, space) }
    }

    /// Color functions. *
    #[doc(alias = "CGContextSetFillColor")]
    #[inline]
    pub unsafe fn set_fill_color(c: Option<&CGContext>, components: *const CGFloat) {
        extern "C-unwind" {
            fn CGContextSetFillColor(c: Option<&CGContext>, components: *const CGFloat);
        }
        unsafe { CGContextSetFillColor(c, components) }
    }

    #[doc(alias = "CGContextSetStrokeColor")]
    #[inline]
    pub unsafe fn set_stroke_color(c: Option<&CGContext>, components: *const CGFloat) {
        extern "C-unwind" {
            fn CGContextSetStrokeColor(c: Option<&CGContext>, components: *const CGFloat);
        }
        unsafe { CGContextSetStrokeColor(c, components) }
    }

    /// Pattern functions. *
    #[doc(alias = "CGContextSetFillPattern")]
    #[cfg(feature = "CGPattern")]
    #[inline]
    pub unsafe fn set_fill_pattern(
        c: Option<&CGContext>,
        pattern: Option<&CGPattern>,
        components: *const CGFloat,
    ) {
        extern "C-unwind" {
            fn CGContextSetFillPattern(
                c: Option<&CGContext>,
                pattern: Option<&CGPattern>,
                components: *const CGFloat,
            );
        }
        unsafe { CGContextSetFillPattern(c, pattern, components) }
    }

    #[doc(alias = "CGContextSetStrokePattern")]
    #[cfg(feature = "CGPattern")]
    #[inline]
    pub unsafe fn set_stroke_pattern(
        c: Option<&CGContext>,
        pattern: Option<&CGPattern>,
        components: *const CGFloat,
    ) {
        extern "C-unwind" {
            fn CGContextSetStrokePattern(
                c: Option<&CGContext>,
                pattern: Option<&CGPattern>,
                components: *const CGFloat,
            );
        }
        unsafe { CGContextSetStrokePattern(c, pattern, components) }
    }

    #[doc(alias = "CGContextSetPatternPhase")]
    #[inline]
    pub unsafe fn set_pattern_phase(c: Option<&CGContext>, phase: CGSize) {
        extern "C-unwind" {
            fn CGContextSetPatternPhase(c: Option<&CGContext>, phase: CGSize);
        }
        unsafe { CGContextSetPatternPhase(c, phase) }
    }

    /// Color convenience functions. *
    #[doc(alias = "CGContextSetGrayFillColor")]
    #[inline]
    pub unsafe fn set_gray_fill_color(c: Option<&CGContext>, gray: CGFloat, alpha: CGFloat) {
        extern "C-unwind" {
            fn CGContextSetGrayFillColor(c: Option<&CGContext>, gray: CGFloat, alpha: CGFloat);
        }
        unsafe { CGContextSetGrayFillColor(c, gray, alpha) }
    }

    #[doc(alias = "CGContextSetGrayStrokeColor")]
    #[inline]
    pub unsafe fn set_gray_stroke_color(c: Option<&CGContext>, gray: CGFloat, alpha: CGFloat) {
        extern "C-unwind" {
            fn CGContextSetGrayStrokeColor(c: Option<&CGContext>, gray: CGFloat, alpha: CGFloat);
        }
        unsafe { CGContextSetGrayStrokeColor(c, gray, alpha) }
    }

    #[doc(alias = "CGContextSetRGBFillColor")]
    #[inline]
    pub unsafe fn set_rgb_fill_color(
        c: Option<&CGContext>,
        red: CGFloat,
        green: CGFloat,
        blue: CGFloat,
        alpha: CGFloat,
    ) {
        extern "C-unwind" {
            fn CGContextSetRGBFillColor(
                c: Option<&CGContext>,
                red: CGFloat,
                green: CGFloat,
                blue: CGFloat,
                alpha: CGFloat,
            );
        }
        unsafe { CGContextSetRGBFillColor(c, red, green, blue, alpha) }
    }

    #[doc(alias = "CGContextSetRGBStrokeColor")]
    #[inline]
    pub unsafe fn set_rgb_stroke_color(
        c: Option<&CGContext>,
        red: CGFloat,
        green: CGFloat,
        blue: CGFloat,
        alpha: CGFloat,
    ) {
        extern "C-unwind" {
            fn CGContextSetRGBStrokeColor(
                c: Option<&CGContext>,
                red: CGFloat,
                green: CGFloat,
                blue: CGFloat,
                alpha: CGFloat,
            );
        }
        unsafe { CGContextSetRGBStrokeColor(c, red, green, blue, alpha) }
    }

    #[doc(alias = "CGContextSetCMYKFillColor")]
    #[inline]
    pub unsafe fn set_cmyk_fill_color(
        c: Option<&CGContext>,
        cyan: CGFloat,
        magenta: CGFloat,
        yellow: CGFloat,
        black: CGFloat,
        alpha: CGFloat,
    ) {
        extern "C-unwind" {
            fn CGContextSetCMYKFillColor(
                c: Option<&CGContext>,
                cyan: CGFloat,
                magenta: CGFloat,
                yellow: CGFloat,
                black: CGFloat,
                alpha: CGFloat,
            );
        }
        unsafe { CGContextSetCMYKFillColor(c, cyan, magenta, yellow, black, alpha) }
    }

    #[doc(alias = "CGContextSetCMYKStrokeColor")]
    #[inline]
    pub unsafe fn set_cmyk_stroke_color(
        c: Option<&CGContext>,
        cyan: CGFloat,
        magenta: CGFloat,
        yellow: CGFloat,
        black: CGFloat,
        alpha: CGFloat,
    ) {
        extern "C-unwind" {
            fn CGContextSetCMYKStrokeColor(
                c: Option<&CGContext>,
                cyan: CGFloat,
                magenta: CGFloat,
                yellow: CGFloat,
                black: CGFloat,
                alpha: CGFloat,
            );
        }
        unsafe { CGContextSetCMYKStrokeColor(c, cyan, magenta, yellow, black, alpha) }
    }

    /// Rendering intent. *
    #[doc(alias = "CGContextSetRenderingIntent")]
    #[cfg(feature = "CGColorSpace")]
    #[inline]
    pub unsafe fn set_rendering_intent(c: Option<&CGContext>, intent: CGColorRenderingIntent) {
        extern "C-unwind" {
            fn CGContextSetRenderingIntent(c: Option<&CGContext>, intent: CGColorRenderingIntent);
        }
        unsafe { CGContextSetRenderingIntent(c, intent) }
    }

    #[doc(alias = "CGContextSetEDRTargetHeadroom")]
    #[inline]
    pub unsafe fn set_edr_target_headroom(self: &CGContext, headroom: c_float) -> bool {
        extern "C-unwind" {
            fn CGContextSetEDRTargetHeadroom(c: &CGContext, headroom: c_float) -> bool;
        }
        unsafe { CGContextSetEDRTargetHeadroom(self, headroom) }
    }

    #[doc(alias = "CGContextGetEDRTargetHeadroom")]
    #[inline]
    pub unsafe fn edr_target_headroom(self: &CGContext) -> c_float {
        extern "C-unwind" {
            fn CGContextGetEDRTargetHeadroom(c: &CGContext) -> c_float;
        }
        unsafe { CGContextGetEDRTargetHeadroom(self) }
    }

    /// Image functions. *
    #[doc(alias = "CGContextDrawImage")]
    #[cfg(feature = "CGImage")]
    #[inline]
    pub unsafe fn draw_image(c: Option<&CGContext>, rect: CGRect, image: Option<&CGImage>) {
        extern "C-unwind" {
            fn CGContextDrawImage(c: Option<&CGContext>, rect: CGRect, image: Option<&CGImage>);
        }
        unsafe { CGContextDrawImage(c, rect, image) }
    }

    #[doc(alias = "CGContextDrawTiledImage")]
    #[cfg(feature = "CGImage")]
    #[inline]
    pub unsafe fn draw_tiled_image(c: Option<&CGContext>, rect: CGRect, image: Option<&CGImage>) {
        extern "C-unwind" {
            fn CGContextDrawTiledImage(
                c: Option<&CGContext>,
                rect: CGRect,
                image: Option<&CGImage>,
            );
        }
        unsafe { CGContextDrawTiledImage(c, rect, image) }
    }

    #[doc(alias = "CGContextDrawImageApplyingToneMapping")]
    #[cfg(all(feature = "CGImage", feature = "CGToneMapping"))]
    #[inline]
    pub unsafe fn draw_image_applying_tone_mapping(
        self: &CGContext,
        r: CGRect,
        image: &CGImage,
        method: CGToneMapping,
        options: Option<&CFDictionary>,
    ) -> bool {
        extern "C-unwind" {
            fn CGContextDrawImageApplyingToneMapping(
                c: &CGContext,
                r: CGRect,
                image: &CGImage,
                method: CGToneMapping,
                options: Option<&CFDictionary>,
            ) -> bool;
        }
        unsafe { CGContextDrawImageApplyingToneMapping(self, r, image, method, options) }
    }

    #[doc(alias = "CGContextGetInterpolationQuality")]
    #[inline]
    pub unsafe fn interpolation_quality(c: Option<&CGContext>) -> CGInterpolationQuality {
        extern "C-unwind" {
            fn CGContextGetInterpolationQuality(c: Option<&CGContext>) -> CGInterpolationQuality;
        }
        unsafe { CGContextGetInterpolationQuality(c) }
    }

    #[doc(alias = "CGContextSetInterpolationQuality")]
    #[inline]
    pub unsafe fn set_interpolation_quality(
        c: Option<&CGContext>,
        quality: CGInterpolationQuality,
    ) {
        extern "C-unwind" {
            fn CGContextSetInterpolationQuality(
                c: Option<&CGContext>,
                quality: CGInterpolationQuality,
            );
        }
        unsafe { CGContextSetInterpolationQuality(c, quality) }
    }

    #[doc(alias = "CGContextSetShadowWithColor")]
    #[cfg(feature = "CGColor")]
    #[inline]
    pub unsafe fn set_shadow_with_color(
        c: Option<&CGContext>,
        offset: CGSize,
        blur: CGFloat,
        color: Option<&CGColor>,
    ) {
        extern "C-unwind" {
            fn CGContextSetShadowWithColor(
                c: Option<&CGContext>,
                offset: CGSize,
                blur: CGFloat,
                color: Option<&CGColor>,
            );
        }
        unsafe { CGContextSetShadowWithColor(c, offset, blur, color) }
    }

    #[doc(alias = "CGContextSetShadow")]
    #[inline]
    pub unsafe fn set_shadow(c: Option<&CGContext>, offset: CGSize, blur: CGFloat) {
        extern "C-unwind" {
            fn CGContextSetShadow(c: Option<&CGContext>, offset: CGSize, blur: CGFloat);
        }
        unsafe { CGContextSetShadow(c, offset, blur) }
    }

    #[doc(alias = "CGContextDrawLinearGradient")]
    #[cfg(feature = "CGGradient")]
    #[inline]
    pub unsafe fn draw_linear_gradient(
        c: Option<&CGContext>,
        gradient: Option<&CGGradient>,
        start_point: CGPoint,
        end_point: CGPoint,
        options: CGGradientDrawingOptions,
    ) {
        extern "C-unwind" {
            fn CGContextDrawLinearGradient(
                c: Option<&CGContext>,
                gradient: Option<&CGGradient>,
                start_point: CGPoint,
                end_point: CGPoint,
                options: CGGradientDrawingOptions,
            );
        }
        unsafe { CGContextDrawLinearGradient(c, gradient, start_point, end_point, options) }
    }

    #[doc(alias = "CGContextDrawRadialGradient")]
    #[cfg(feature = "CGGradient")]
    #[inline]
    pub unsafe fn draw_radial_gradient(
        c: Option<&CGContext>,
        gradient: Option<&CGGradient>,
        start_center: CGPoint,
        start_radius: CGFloat,
        end_center: CGPoint,
        end_radius: CGFloat,
        options: CGGradientDrawingOptions,
    ) {
        extern "C-unwind" {
            fn CGContextDrawRadialGradient(
                c: Option<&CGContext>,
                gradient: Option<&CGGradient>,
                start_center: CGPoint,
                start_radius: CGFloat,
                end_center: CGPoint,
                end_radius: CGFloat,
                options: CGGradientDrawingOptions,
            );
        }
        unsafe {
            CGContextDrawRadialGradient(
                c,
                gradient,
                start_center,
                start_radius,
                end_center,
                end_radius,
                options,
            )
        }
    }

    #[doc(alias = "CGContextDrawConicGradient")]
    #[cfg(feature = "CGGradient")]
    #[inline]
    pub unsafe fn draw_conic_gradient(
        self: &CGContext,
        gradient: Option<&CGGradient>,
        center: CGPoint,
        angle: CGFloat,
    ) {
        extern "C-unwind" {
            fn CGContextDrawConicGradient(
                c: &CGContext,
                gradient: Option<&CGGradient>,
                center: CGPoint,
                angle: CGFloat,
            );
        }
        unsafe { CGContextDrawConicGradient(self, gradient, center, angle) }
    }

    #[doc(alias = "CGContextDrawShading")]
    #[cfg(feature = "CGShading")]
    #[inline]
    pub unsafe fn draw_shading(c: Option<&CGContext>, shading: Option<&CGShading>) {
        extern "C-unwind" {
            fn CGContextDrawShading(c: Option<&CGContext>, shading: Option<&CGShading>);
        }
        unsafe { CGContextDrawShading(c, shading) }
    }

    /// Text functions. *
    #[doc(alias = "CGContextSetCharacterSpacing")]
    #[inline]
    pub unsafe fn set_character_spacing(c: Option<&CGContext>, spacing: CGFloat) {
        extern "C-unwind" {
            fn CGContextSetCharacterSpacing(c: Option<&CGContext>, spacing: CGFloat);
        }
        unsafe { CGContextSetCharacterSpacing(c, spacing) }
    }

    #[doc(alias = "CGContextSetTextPosition")]
    #[inline]
    pub unsafe fn set_text_position(c: Option<&CGContext>, x: CGFloat, y: CGFloat) {
        extern "C-unwind" {
            fn CGContextSetTextPosition(c: Option<&CGContext>, x: CGFloat, y: CGFloat);
        }
        unsafe { CGContextSetTextPosition(c, x, y) }
    }

    #[doc(alias = "CGContextGetTextPosition")]
    #[inline]
    pub unsafe fn text_position(c: Option<&CGContext>) -> CGPoint {
        extern "C-unwind" {
            fn CGContextGetTextPosition(c: Option<&CGContext>) -> CGPoint;
        }
        unsafe { CGContextGetTextPosition(c) }
    }

    #[doc(alias = "CGContextSetTextMatrix")]
    #[inline]
    pub unsafe fn set_text_matrix(c: Option<&CGContext>, t: CGAffineTransform) {
        extern "C-unwind" {
            fn CGContextSetTextMatrix(c: Option<&CGContext>, t: CGAffineTransform);
        }
        unsafe { CGContextSetTextMatrix(c, t) }
    }

    #[doc(alias = "CGContextGetTextMatrix")]
    #[inline]
    pub unsafe fn text_matrix(c: Option<&CGContext>) -> CGAffineTransform {
        extern "C-unwind" {
            fn CGContextGetTextMatrix(c: Option<&CGContext>) -> CGAffineTransform;
        }
        unsafe { CGContextGetTextMatrix(c) }
    }

    #[doc(alias = "CGContextSetTextDrawingMode")]
    #[inline]
    pub unsafe fn set_text_drawing_mode(c: Option<&CGContext>, mode: CGTextDrawingMode) {
        extern "C-unwind" {
            fn CGContextSetTextDrawingMode(c: Option<&CGContext>, mode: CGTextDrawingMode);
        }
        unsafe { CGContextSetTextDrawingMode(c, mode) }
    }

    #[doc(alias = "CGContextSetFont")]
    #[cfg(feature = "CGFont")]
    #[inline]
    pub unsafe fn set_font(c: Option<&CGContext>, font: Option<&CGFont>) {
        extern "C-unwind" {
            fn CGContextSetFont(c: Option<&CGContext>, font: Option<&CGFont>);
        }
        unsafe { CGContextSetFont(c, font) }
    }

    #[doc(alias = "CGContextSetFontSize")]
    #[inline]
    pub unsafe fn set_font_size(c: Option<&CGContext>, size: CGFloat) {
        extern "C-unwind" {
            fn CGContextSetFontSize(c: Option<&CGContext>, size: CGFloat);
        }
        unsafe { CGContextSetFontSize(c, size) }
    }

    #[doc(alias = "CGContextShowGlyphsAtPositions")]
    #[cfg(feature = "CGFont")]
    #[inline]
    pub unsafe fn show_glyphs_at_positions(
        c: Option<&CGContext>,
        glyphs: *const CGGlyph,
        lpositions: *const CGPoint,
        count: usize,
    ) {
        extern "C-unwind" {
            fn CGContextShowGlyphsAtPositions(
                c: Option<&CGContext>,
                glyphs: *const CGGlyph,
                lpositions: *const CGPoint,
                count: usize,
            );
        }
        unsafe { CGContextShowGlyphsAtPositions(c, glyphs, lpositions, count) }
    }

    /// PDF functions. *
    #[doc(alias = "CGContextDrawPDFPage")]
    #[cfg(feature = "CGPDFPage")]
    #[inline]
    pub unsafe fn draw_pdf_page(c: Option<&CGContext>, page: Option<&CGPDFPage>) {
        extern "C-unwind" {
            fn CGContextDrawPDFPage(c: Option<&CGContext>, page: Option<&CGPDFPage>);
        }
        unsafe { CGContextDrawPDFPage(c, page) }
    }

    /// Output page functions. *
    #[doc(alias = "CGContextBeginPage")]
    #[inline]
    pub unsafe fn begin_page(c: Option<&CGContext>, media_box: *const CGRect) {
        extern "C-unwind" {
            fn CGContextBeginPage(c: Option<&CGContext>, media_box: *const CGRect);
        }
        unsafe { CGContextBeginPage(c, media_box) }
    }

    #[doc(alias = "CGContextEndPage")]
    #[inline]
    pub unsafe fn end_page(c: Option<&CGContext>) {
        extern "C-unwind" {
            fn CGContextEndPage(c: Option<&CGContext>);
        }
        unsafe { CGContextEndPage(c) }
    }

    #[doc(alias = "CGContextFlush")]
    #[inline]
    pub unsafe fn flush(c: Option<&CGContext>) {
        extern "C-unwind" {
            fn CGContextFlush(c: Option<&CGContext>);
        }
        unsafe { CGContextFlush(c) }
    }

    #[doc(alias = "CGContextSynchronize")]
    #[inline]
    pub unsafe fn synchronize(c: Option<&CGContext>) {
        extern "C-unwind" {
            fn CGContextSynchronize(c: Option<&CGContext>);
        }
        unsafe { CGContextSynchronize(c) }
    }

    #[doc(alias = "CGContextSetShouldAntialias")]
    #[inline]
    pub unsafe fn set_should_antialias(c: Option<&CGContext>, should_antialias: bool) {
        extern "C-unwind" {
            fn CGContextSetShouldAntialias(c: Option<&CGContext>, should_antialias: bool);
        }
        unsafe { CGContextSetShouldAntialias(c, should_antialias) }
    }

    #[doc(alias = "CGContextSetAllowsAntialiasing")]
    #[inline]
    pub unsafe fn set_allows_antialiasing(c: Option<&CGContext>, allows_antialiasing: bool) {
        extern "C-unwind" {
            fn CGContextSetAllowsAntialiasing(c: Option<&CGContext>, allows_antialiasing: bool);
        }
        unsafe { CGContextSetAllowsAntialiasing(c, allows_antialiasing) }
    }

    #[doc(alias = "CGContextSetShouldSmoothFonts")]
    #[inline]
    pub unsafe fn set_should_smooth_fonts(c: Option<&CGContext>, should_smooth_fonts: bool) {
        extern "C-unwind" {
            fn CGContextSetShouldSmoothFonts(c: Option<&CGContext>, should_smooth_fonts: bool);
        }
        unsafe { CGContextSetShouldSmoothFonts(c, should_smooth_fonts) }
    }

    #[doc(alias = "CGContextSetAllowsFontSmoothing")]
    #[inline]
    pub unsafe fn set_allows_font_smoothing(c: Option<&CGContext>, allows_font_smoothing: bool) {
        extern "C-unwind" {
            fn CGContextSetAllowsFontSmoothing(c: Option<&CGContext>, allows_font_smoothing: bool);
        }
        unsafe { CGContextSetAllowsFontSmoothing(c, allows_font_smoothing) }
    }

    #[doc(alias = "CGContextSetShouldSubpixelPositionFonts")]
    #[inline]
    pub unsafe fn set_should_subpixel_position_fonts(
        c: Option<&CGContext>,
        should_subpixel_position_fonts: bool,
    ) {
        extern "C-unwind" {
            fn CGContextSetShouldSubpixelPositionFonts(
                c: Option<&CGContext>,
                should_subpixel_position_fonts: bool,
            );
        }
        unsafe { CGContextSetShouldSubpixelPositionFonts(c, should_subpixel_position_fonts) }
    }

    #[doc(alias = "CGContextSetAllowsFontSubpixelPositioning")]
    #[inline]
    pub unsafe fn set_allows_font_subpixel_positioning(
        c: Option<&CGContext>,
        allows_font_subpixel_positioning: bool,
    ) {
        extern "C-unwind" {
            fn CGContextSetAllowsFontSubpixelPositioning(
                c: Option<&CGContext>,
                allows_font_subpixel_positioning: bool,
            );
        }
        unsafe { CGContextSetAllowsFontSubpixelPositioning(c, allows_font_subpixel_positioning) }
    }

    #[doc(alias = "CGContextSetShouldSubpixelQuantizeFonts")]
    #[inline]
    pub unsafe fn set_should_subpixel_quantize_fonts(
        c: Option<&CGContext>,
        should_subpixel_quantize_fonts: bool,
    ) {
        extern "C-unwind" {
            fn CGContextSetShouldSubpixelQuantizeFonts(
                c: Option<&CGContext>,
                should_subpixel_quantize_fonts: bool,
            );
        }
        unsafe { CGContextSetShouldSubpixelQuantizeFonts(c, should_subpixel_quantize_fonts) }
    }

    #[doc(alias = "CGContextSetAllowsFontSubpixelQuantization")]
    #[inline]
    pub unsafe fn set_allows_font_subpixel_quantization(
        c: Option<&CGContext>,
        allows_font_subpixel_quantization: bool,
    ) {
        extern "C-unwind" {
            fn CGContextSetAllowsFontSubpixelQuantization(
                c: Option<&CGContext>,
                allows_font_subpixel_quantization: bool,
            );
        }
        unsafe { CGContextSetAllowsFontSubpixelQuantization(c, allows_font_subpixel_quantization) }
    }

    /// Transparency layer support. *
    #[doc(alias = "CGContextBeginTransparencyLayer")]
    #[inline]
    pub unsafe fn begin_transparency_layer(
        c: Option<&CGContext>,
        auxiliary_info: Option<&CFDictionary>,
    ) {
        extern "C-unwind" {
            fn CGContextBeginTransparencyLayer(
                c: Option<&CGContext>,
                auxiliary_info: Option<&CFDictionary>,
            );
        }
        unsafe { CGContextBeginTransparencyLayer(c, auxiliary_info) }
    }

    #[doc(alias = "CGContextBeginTransparencyLayerWithRect")]
    #[inline]
    pub unsafe fn begin_transparency_layer_with_rect(
        c: Option<&CGContext>,
        rect: CGRect,
        aux_info: Option<&CFDictionary>,
    ) {
        extern "C-unwind" {
            fn CGContextBeginTransparencyLayerWithRect(
                c: Option<&CGContext>,
                rect: CGRect,
                aux_info: Option<&CFDictionary>,
            );
        }
        unsafe { CGContextBeginTransparencyLayerWithRect(c, rect, aux_info) }
    }

    #[doc(alias = "CGContextEndTransparencyLayer")]
    #[inline]
    pub unsafe fn end_transparency_layer(c: Option<&CGContext>) {
        extern "C-unwind" {
            fn CGContextEndTransparencyLayer(c: Option<&CGContext>);
        }
        unsafe { CGContextEndTransparencyLayer(c) }
    }

    /// User space to device space tranformations. *
    #[doc(alias = "CGContextGetUserSpaceToDeviceSpaceTransform")]
    #[inline]
    pub unsafe fn user_space_to_device_space_transform(c: Option<&CGContext>) -> CGAffineTransform {
        extern "C-unwind" {
            fn CGContextGetUserSpaceToDeviceSpaceTransform(
                c: Option<&CGContext>,
            ) -> CGAffineTransform;
        }
        unsafe { CGContextGetUserSpaceToDeviceSpaceTransform(c) }
    }

    #[doc(alias = "CGContextConvertPointToDeviceSpace")]
    #[inline]
    pub unsafe fn convert_point_to_device_space(c: Option<&CGContext>, point: CGPoint) -> CGPoint {
        extern "C-unwind" {
            fn CGContextConvertPointToDeviceSpace(c: Option<&CGContext>, point: CGPoint)
                -> CGPoint;
        }
        unsafe { CGContextConvertPointToDeviceSpace(c, point) }
    }

    #[doc(alias = "CGContextConvertPointToUserSpace")]
    #[inline]
    pub unsafe fn convert_point_to_user_space(c: Option<&CGContext>, point: CGPoint) -> CGPoint {
        extern "C-unwind" {
            fn CGContextConvertPointToUserSpace(c: Option<&CGContext>, point: CGPoint) -> CGPoint;
        }
        unsafe { CGContextConvertPointToUserSpace(c, point) }
    }

    #[doc(alias = "CGContextConvertSizeToDeviceSpace")]
    #[inline]
    pub unsafe fn convert_size_to_device_space(c: Option<&CGContext>, size: CGSize) -> CGSize {
        extern "C-unwind" {
            fn CGContextConvertSizeToDeviceSpace(c: Option<&CGContext>, size: CGSize) -> CGSize;
        }
        unsafe { CGContextConvertSizeToDeviceSpace(c, size) }
    }

    #[doc(alias = "CGContextConvertSizeToUserSpace")]
    #[inline]
    pub unsafe fn convert_size_to_user_space(c: Option<&CGContext>, size: CGSize) -> CGSize {
        extern "C-unwind" {
            fn CGContextConvertSizeToUserSpace(c: Option<&CGContext>, size: CGSize) -> CGSize;
        }
        unsafe { CGContextConvertSizeToUserSpace(c, size) }
    }

    #[doc(alias = "CGContextConvertRectToDeviceSpace")]
    #[inline]
    pub unsafe fn convert_rect_to_device_space(c: Option<&CGContext>, rect: CGRect) -> CGRect {
        extern "C-unwind" {
            fn CGContextConvertRectToDeviceSpace(c: Option<&CGContext>, rect: CGRect) -> CGRect;
        }
        unsafe { CGContextConvertRectToDeviceSpace(c, rect) }
    }

    #[doc(alias = "CGContextConvertRectToUserSpace")]
    #[inline]
    pub unsafe fn convert_rect_to_user_space(c: Option<&CGContext>, rect: CGRect) -> CGRect {
        extern "C-unwind" {
            fn CGContextConvertRectToUserSpace(c: Option<&CGContext>, rect: CGRect) -> CGRect;
        }
        unsafe { CGContextConvertRectToUserSpace(c, rect) }
    }

    #[doc(alias = "CGContextSelectFont")]
    #[deprecated = "No longer supported"]
    #[inline]
    pub unsafe fn select_font(
        c: Option<&CGContext>,
        name: *const c_char,
        size: CGFloat,
        text_encoding: CGTextEncoding,
    ) {
        extern "C-unwind" {
            fn CGContextSelectFont(
                c: Option<&CGContext>,
                name: *const c_char,
                size: CGFloat,
                text_encoding: CGTextEncoding,
            );
        }
        unsafe { CGContextSelectFont(c, name, size, text_encoding) }
    }

    #[doc(alias = "CGContextShowText")]
    #[deprecated = "No longer supported"]
    #[inline]
    pub unsafe fn show_text(c: Option<&CGContext>, string: *const c_char, length: usize) {
        extern "C-unwind" {
            fn CGContextShowText(c: Option<&CGContext>, string: *const c_char, length: usize);
        }
        unsafe { CGContextShowText(c, string, length) }
    }

    #[doc(alias = "CGContextShowTextAtPoint")]
    #[deprecated = "No longer supported"]
    #[inline]
    pub unsafe fn show_text_at_point(
        c: Option<&CGContext>,
        x: CGFloat,
        y: CGFloat,
        string: *const c_char,
        length: usize,
    ) {
        extern "C-unwind" {
            fn CGContextShowTextAtPoint(
                c: Option<&CGContext>,
                x: CGFloat,
                y: CGFloat,
                string: *const c_char,
                length: usize,
            );
        }
        unsafe { CGContextShowTextAtPoint(c, x, y, string, length) }
    }

    #[doc(alias = "CGContextShowGlyphs")]
    #[cfg(feature = "CGFont")]
    #[deprecated = "No longer supported"]
    #[inline]
    pub unsafe fn show_glyphs(c: Option<&CGContext>, g: *const CGGlyph, count: usize) {
        extern "C-unwind" {
            fn CGContextShowGlyphs(c: Option<&CGContext>, g: *const CGGlyph, count: usize);
        }
        unsafe { CGContextShowGlyphs(c, g, count) }
    }

    #[doc(alias = "CGContextShowGlyphsAtPoint")]
    #[cfg(feature = "CGFont")]
    #[deprecated = "No longer supported"]
    #[inline]
    pub unsafe fn show_glyphs_at_point(
        c: Option<&CGContext>,
        x: CGFloat,
        y: CGFloat,
        glyphs: *const CGGlyph,
        count: usize,
    ) {
        extern "C-unwind" {
            fn CGContextShowGlyphsAtPoint(
                c: Option<&CGContext>,
                x: CGFloat,
                y: CGFloat,
                glyphs: *const CGGlyph,
                count: usize,
            );
        }
        unsafe { CGContextShowGlyphsAtPoint(c, x, y, glyphs, count) }
    }

    #[doc(alias = "CGContextShowGlyphsWithAdvances")]
    #[cfg(feature = "CGFont")]
    #[deprecated = "No longer supported"]
    #[inline]
    pub unsafe fn show_glyphs_with_advances(
        c: Option<&CGContext>,
        glyphs: *const CGGlyph,
        advances: *const CGSize,
        count: usize,
    ) {
        extern "C-unwind" {
            fn CGContextShowGlyphsWithAdvances(
                c: Option<&CGContext>,
                glyphs: *const CGGlyph,
                advances: *const CGSize,
                count: usize,
            );
        }
        unsafe { CGContextShowGlyphsWithAdvances(c, glyphs, advances, count) }
    }

    #[doc(alias = "CGContextDrawPDFDocument")]
    #[cfg(feature = "CGPDFDocument")]
    #[deprecated = "No longer supported"]
    #[inline]
    pub unsafe fn draw_pdf_document(
        c: Option<&CGContext>,
        rect: CGRect,
        document: Option<&CGPDFDocument>,
        page: c_int,
    ) {
        extern "C-unwind" {
            fn CGContextDrawPDFDocument(
                c: Option<&CGContext>,
                rect: CGRect,
                document: Option<&CGPDFDocument>,
                page: c_int,
            );
        }
        unsafe { CGContextDrawPDFDocument(c, rect, document, page) }
    }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::save_g_state`"]
    pub fn CGContextSaveGState(c: Option<&CGContext>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::restore_g_state`"]
    pub fn CGContextRestoreGState(c: Option<&CGContext>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::scale_ctm`"]
    pub fn CGContextScaleCTM(c: Option<&CGContext>, sx: CGFloat, sy: CGFloat);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::translate_ctm`"]
    pub fn CGContextTranslateCTM(c: Option<&CGContext>, tx: CGFloat, ty: CGFloat);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::rotate_ctm`"]
    pub fn CGContextRotateCTM(c: Option<&CGContext>, angle: CGFloat);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::concat_ctm`"]
    pub fn CGContextConcatCTM(c: Option<&CGContext>, transform: CGAffineTransform);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::ctm`"]
    pub fn CGContextGetCTM(c: Option<&CGContext>) -> CGAffineTransform;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_line_width`"]
    pub fn CGContextSetLineWidth(c: Option<&CGContext>, width: CGFloat);
}

extern "C-unwind" {
    #[cfg(feature = "CGPath")]
    #[deprecated = "renamed to `CGContext::set_line_cap`"]
    pub fn CGContextSetLineCap(c: Option<&CGContext>, cap: CGLineCap);
}

extern "C-unwind" {
    #[cfg(feature = "CGPath")]
    #[deprecated = "renamed to `CGContext::set_line_join`"]
    pub fn CGContextSetLineJoin(c: Option<&CGContext>, join: CGLineJoin);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_miter_limit`"]
    pub fn CGContextSetMiterLimit(c: Option<&CGContext>, limit: CGFloat);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_line_dash`"]
    pub fn CGContextSetLineDash(
        c: Option<&CGContext>,
        phase: CGFloat,
        lengths: *const CGFloat,
        count: usize,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_flatness`"]
    pub fn CGContextSetFlatness(c: Option<&CGContext>, flatness: CGFloat);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_alpha`"]
    pub fn CGContextSetAlpha(c: Option<&CGContext>, alpha: CGFloat);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_blend_mode`"]
    pub fn CGContextSetBlendMode(c: Option<&CGContext>, mode: CGBlendMode);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::begin_path`"]
    pub fn CGContextBeginPath(c: Option<&CGContext>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::move_to_point`"]
    pub fn CGContextMoveToPoint(c: Option<&CGContext>, x: CGFloat, y: CGFloat);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::add_line_to_point`"]
    pub fn CGContextAddLineToPoint(c: Option<&CGContext>, x: CGFloat, y: CGFloat);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::add_curve_to_point`"]
    pub fn CGContextAddCurveToPoint(
        c: Option<&CGContext>,
        cp1x: CGFloat,
        cp1y: CGFloat,
        cp2x: CGFloat,
        cp2y: CGFloat,
        x: CGFloat,
        y: CGFloat,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::add_quad_curve_to_point`"]
    pub fn CGContextAddQuadCurveToPoint(
        c: Option<&CGContext>,
        cpx: CGFloat,
        cpy: CGFloat,
        x: CGFloat,
        y: CGFloat,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::close_path`"]
    pub fn CGContextClosePath(c: Option<&CGContext>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::add_rect`"]
    pub fn CGContextAddRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::add_rects`"]
    pub fn CGContextAddRects(c: Option<&CGContext>, rects: *const CGRect, count: usize);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::add_lines`"]
    pub fn CGContextAddLines(c: Option<&CGContext>, points: *const CGPoint, count: usize);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::add_ellipse_in_rect`"]
    pub fn CGContextAddEllipseInRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::add_arc`"]
    pub fn CGContextAddArc(
        c: Option<&CGContext>,
        x: CGFloat,
        y: CGFloat,
        radius: CGFloat,
        start_angle: CGFloat,
        end_angle: CGFloat,
        clockwise: c_int,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::add_arc_to_point`"]
    pub fn CGContextAddArcToPoint(
        c: Option<&CGContext>,
        x1: CGFloat,
        y1: CGFloat,
        x2: CGFloat,
        y2: CGFloat,
        radius: CGFloat,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGPath")]
    #[deprecated = "renamed to `CGContext::add_path`"]
    pub fn CGContextAddPath(c: Option<&CGContext>, path: Option<&CGPath>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::replace_path_with_stroked_path`"]
    pub fn CGContextReplacePathWithStrokedPath(c: Option<&CGContext>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::is_path_empty`"]
    pub fn CGContextIsPathEmpty(c: Option<&CGContext>) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::path_current_point`"]
    pub fn CGContextGetPathCurrentPoint(c: Option<&CGContext>) -> CGPoint;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::path_bounding_box`"]
    pub fn CGContextGetPathBoundingBox(c: Option<&CGContext>) -> CGRect;
}

#[cfg(feature = "CGPath")]
#[deprecated = "renamed to `CGContext::path`"]
#[inline]
pub unsafe extern "C-unwind" fn CGContextCopyPath(
    c: Option<&CGContext>,
) -> Option<CFRetained<CGPath>> {
    extern "C-unwind" {
        fn CGContextCopyPath(c: Option<&CGContext>) -> Option<NonNull<CGPath>>;
    }
    let ret = unsafe { CGContextCopyPath(c) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::path_contains_point`"]
    pub fn CGContextPathContainsPoint(
        c: Option<&CGContext>,
        point: CGPoint,
        mode: CGPathDrawingMode,
    ) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::draw_path`"]
    pub fn CGContextDrawPath(c: Option<&CGContext>, mode: CGPathDrawingMode);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::fill_path`"]
    pub fn CGContextFillPath(c: Option<&CGContext>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::eo_fill_path`"]
    pub fn CGContextEOFillPath(c: Option<&CGContext>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::stroke_path`"]
    pub fn CGContextStrokePath(c: Option<&CGContext>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::fill_rect`"]
    pub fn CGContextFillRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::fill_rects`"]
    pub fn CGContextFillRects(c: Option<&CGContext>, rects: *const CGRect, count: usize);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::stroke_rect`"]
    pub fn CGContextStrokeRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::stroke_rect_with_width`"]
    pub fn CGContextStrokeRectWithWidth(c: Option<&CGContext>, rect: CGRect, width: CGFloat);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::clear_rect`"]
    pub fn CGContextClearRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::fill_ellipse_in_rect`"]
    pub fn CGContextFillEllipseInRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::stroke_ellipse_in_rect`"]
    pub fn CGContextStrokeEllipseInRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::stroke_line_segments`"]
    pub fn CGContextStrokeLineSegments(c: Option<&CGContext>, points: *const CGPoint, count: usize);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::clip`"]
    pub fn CGContextClip(c: Option<&CGContext>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::eo_clip`"]
    pub fn CGContextEOClip(c: Option<&CGContext>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::reset_clip`"]
    pub fn CGContextResetClip(c: &CGContext);
}

extern "C-unwind" {
    #[cfg(feature = "CGImage")]
    #[deprecated = "renamed to `CGContext::clip_to_mask`"]
    pub fn CGContextClipToMask(c: Option<&CGContext>, rect: CGRect, mask: Option<&CGImage>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::clip_bounding_box`"]
    pub fn CGContextGetClipBoundingBox(c: Option<&CGContext>) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::clip_to_rect`"]
    pub fn CGContextClipToRect(c: Option<&CGContext>, rect: CGRect);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::clip_to_rects`"]
    pub fn CGContextClipToRects(c: Option<&CGContext>, rects: NonNull<CGRect>, count: usize);
}

extern "C-unwind" {
    #[cfg(feature = "CGColor")]
    #[deprecated = "renamed to `CGContext::set_fill_color_with_color`"]
    pub fn CGContextSetFillColorWithColor(c: Option<&CGContext>, color: Option<&CGColor>);
}

extern "C-unwind" {
    #[cfg(feature = "CGColor")]
    #[deprecated = "renamed to `CGContext::set_stroke_color_with_color`"]
    pub fn CGContextSetStrokeColorWithColor(c: Option<&CGContext>, color: Option<&CGColor>);
}

extern "C-unwind" {
    #[cfg(feature = "CGColorSpace")]
    #[deprecated = "renamed to `CGContext::set_fill_color_space`"]
    pub fn CGContextSetFillColorSpace(c: Option<&CGContext>, space: Option<&CGColorSpace>);
}

extern "C-unwind" {
    #[cfg(feature = "CGColorSpace")]
    #[deprecated = "renamed to `CGContext::set_stroke_color_space`"]
    pub fn CGContextSetStrokeColorSpace(c: Option<&CGContext>, space: Option<&CGColorSpace>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_fill_color`"]
    pub fn CGContextSetFillColor(c: Option<&CGContext>, components: *const CGFloat);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_stroke_color`"]
    pub fn CGContextSetStrokeColor(c: Option<&CGContext>, components: *const CGFloat);
}

extern "C-unwind" {
    #[cfg(feature = "CGPattern")]
    #[deprecated = "renamed to `CGContext::set_fill_pattern`"]
    pub fn CGContextSetFillPattern(
        c: Option<&CGContext>,
        pattern: Option<&CGPattern>,
        components: *const CGFloat,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGPattern")]
    #[deprecated = "renamed to `CGContext::set_stroke_pattern`"]
    pub fn CGContextSetStrokePattern(
        c: Option<&CGContext>,
        pattern: Option<&CGPattern>,
        components: *const CGFloat,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_pattern_phase`"]
    pub fn CGContextSetPatternPhase(c: Option<&CGContext>, phase: CGSize);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_gray_fill_color`"]
    pub fn CGContextSetGrayFillColor(c: Option<&CGContext>, gray: CGFloat, alpha: CGFloat);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_gray_stroke_color`"]
    pub fn CGContextSetGrayStrokeColor(c: Option<&CGContext>, gray: CGFloat, alpha: CGFloat);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_rgb_fill_color`"]
    pub fn CGContextSetRGBFillColor(
        c: Option<&CGContext>,
        red: CGFloat,
        green: CGFloat,
        blue: CGFloat,
        alpha: CGFloat,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_rgb_stroke_color`"]
    pub fn CGContextSetRGBStrokeColor(
        c: Option<&CGContext>,
        red: CGFloat,
        green: CGFloat,
        blue: CGFloat,
        alpha: CGFloat,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_cmyk_fill_color`"]
    pub fn CGContextSetCMYKFillColor(
        c: Option<&CGContext>,
        cyan: CGFloat,
        magenta: CGFloat,
        yellow: CGFloat,
        black: CGFloat,
        alpha: CGFloat,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_cmyk_stroke_color`"]
    pub fn CGContextSetCMYKStrokeColor(
        c: Option<&CGContext>,
        cyan: CGFloat,
        magenta: CGFloat,
        yellow: CGFloat,
        black: CGFloat,
        alpha: CGFloat,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGColorSpace")]
    #[deprecated = "renamed to `CGContext::set_rendering_intent`"]
    pub fn CGContextSetRenderingIntent(c: Option<&CGContext>, intent: CGColorRenderingIntent);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_edr_target_headroom`"]
    pub fn CGContextSetEDRTargetHeadroom(c: &CGContext, headroom: c_float) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::edr_target_headroom`"]
    pub fn CGContextGetEDRTargetHeadroom(c: &CGContext) -> c_float;
}

extern "C-unwind" {
    #[cfg(feature = "CGImage")]
    #[deprecated = "renamed to `CGContext::draw_image`"]
    pub fn CGContextDrawImage(c: Option<&CGContext>, rect: CGRect, image: Option<&CGImage>);
}

extern "C-unwind" {
    #[cfg(feature = "CGImage")]
    #[deprecated = "renamed to `CGContext::draw_tiled_image`"]
    pub fn CGContextDrawTiledImage(c: Option<&CGContext>, rect: CGRect, image: Option<&CGImage>);
}

extern "C-unwind" {
    #[cfg(all(feature = "CGImage", feature = "CGToneMapping"))]
    #[deprecated = "renamed to `CGContext::draw_image_applying_tone_mapping`"]
    pub fn CGContextDrawImageApplyingToneMapping(
        c: &CGContext,
        r: CGRect,
        image: &CGImage,
        method: CGToneMapping,
        options: Option<&CFDictionary>,
    ) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::interpolation_quality`"]
    pub fn CGContextGetInterpolationQuality(c: Option<&CGContext>) -> CGInterpolationQuality;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_interpolation_quality`"]
    pub fn CGContextSetInterpolationQuality(c: Option<&CGContext>, quality: CGInterpolationQuality);
}

extern "C-unwind" {
    #[cfg(feature = "CGColor")]
    #[deprecated = "renamed to `CGContext::set_shadow_with_color`"]
    pub fn CGContextSetShadowWithColor(
        c: Option<&CGContext>,
        offset: CGSize,
        blur: CGFloat,
        color: Option<&CGColor>,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_shadow`"]
    pub fn CGContextSetShadow(c: Option<&CGContext>, offset: CGSize, blur: CGFloat);
}

extern "C-unwind" {
    #[cfg(feature = "CGGradient")]
    #[deprecated = "renamed to `CGContext::draw_linear_gradient`"]
    pub fn CGContextDrawLinearGradient(
        c: Option<&CGContext>,
        gradient: Option<&CGGradient>,
        start_point: CGPoint,
        end_point: CGPoint,
        options: CGGradientDrawingOptions,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGGradient")]
    #[deprecated = "renamed to `CGContext::draw_radial_gradient`"]
    pub fn CGContextDrawRadialGradient(
        c: Option<&CGContext>,
        gradient: Option<&CGGradient>,
        start_center: CGPoint,
        start_radius: CGFloat,
        end_center: CGPoint,
        end_radius: CGFloat,
        options: CGGradientDrawingOptions,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGGradient")]
    #[deprecated = "renamed to `CGContext::draw_conic_gradient`"]
    pub fn CGContextDrawConicGradient(
        c: &CGContext,
        gradient: Option<&CGGradient>,
        center: CGPoint,
        angle: CGFloat,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGShading")]
    #[deprecated = "renamed to `CGContext::draw_shading`"]
    pub fn CGContextDrawShading(c: Option<&CGContext>, shading: Option<&CGShading>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_character_spacing`"]
    pub fn CGContextSetCharacterSpacing(c: Option<&CGContext>, spacing: CGFloat);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_text_position`"]
    pub fn CGContextSetTextPosition(c: Option<&CGContext>, x: CGFloat, y: CGFloat);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::text_position`"]
    pub fn CGContextGetTextPosition(c: Option<&CGContext>) -> CGPoint;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_text_matrix`"]
    pub fn CGContextSetTextMatrix(c: Option<&CGContext>, t: CGAffineTransform);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::text_matrix`"]
    pub fn CGContextGetTextMatrix(c: Option<&CGContext>) -> CGAffineTransform;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_text_drawing_mode`"]
    pub fn CGContextSetTextDrawingMode(c: Option<&CGContext>, mode: CGTextDrawingMode);
}

extern "C-unwind" {
    #[cfg(feature = "CGFont")]
    #[deprecated = "renamed to `CGContext::set_font`"]
    pub fn CGContextSetFont(c: Option<&CGContext>, font: Option<&CGFont>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_font_size`"]
    pub fn CGContextSetFontSize(c: Option<&CGContext>, size: CGFloat);
}

extern "C-unwind" {
    #[cfg(feature = "CGFont")]
    #[deprecated = "renamed to `CGContext::show_glyphs_at_positions`"]
    pub fn CGContextShowGlyphsAtPositions(
        c: Option<&CGContext>,
        glyphs: *const CGGlyph,
        lpositions: *const CGPoint,
        count: usize,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFPage")]
    #[deprecated = "renamed to `CGContext::draw_pdf_page`"]
    pub fn CGContextDrawPDFPage(c: Option<&CGContext>, page: Option<&CGPDFPage>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::begin_page`"]
    pub fn CGContextBeginPage(c: Option<&CGContext>, media_box: *const CGRect);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::end_page`"]
    pub fn CGContextEndPage(c: Option<&CGContext>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::flush`"]
    pub fn CGContextFlush(c: Option<&CGContext>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::synchronize`"]
    pub fn CGContextSynchronize(c: Option<&CGContext>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_should_antialias`"]
    pub fn CGContextSetShouldAntialias(c: Option<&CGContext>, should_antialias: bool);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_allows_antialiasing`"]
    pub fn CGContextSetAllowsAntialiasing(c: Option<&CGContext>, allows_antialiasing: bool);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_should_smooth_fonts`"]
    pub fn CGContextSetShouldSmoothFonts(c: Option<&CGContext>, should_smooth_fonts: bool);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_allows_font_smoothing`"]
    pub fn CGContextSetAllowsFontSmoothing(c: Option<&CGContext>, allows_font_smoothing: bool);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_should_subpixel_position_fonts`"]
    pub fn CGContextSetShouldSubpixelPositionFonts(
        c: Option<&CGContext>,
        should_subpixel_position_fonts: bool,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_allows_font_subpixel_positioning`"]
    pub fn CGContextSetAllowsFontSubpixelPositioning(
        c: Option<&CGContext>,
        allows_font_subpixel_positioning: bool,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_should_subpixel_quantize_fonts`"]
    pub fn CGContextSetShouldSubpixelQuantizeFonts(
        c: Option<&CGContext>,
        should_subpixel_quantize_fonts: bool,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::set_allows_font_subpixel_quantization`"]
    pub fn CGContextSetAllowsFontSubpixelQuantization(
        c: Option<&CGContext>,
        allows_font_subpixel_quantization: bool,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::begin_transparency_layer`"]
    pub fn CGContextBeginTransparencyLayer(
        c: Option<&CGContext>,
        auxiliary_info: Option<&CFDictionary>,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::begin_transparency_layer_with_rect`"]
    pub fn CGContextBeginTransparencyLayerWithRect(
        c: Option<&CGContext>,
        rect: CGRect,
        aux_info: Option<&CFDictionary>,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::end_transparency_layer`"]
    pub fn CGContextEndTransparencyLayer(c: Option<&CGContext>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::user_space_to_device_space_transform`"]
    pub fn CGContextGetUserSpaceToDeviceSpaceTransform(c: Option<&CGContext>) -> CGAffineTransform;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::convert_point_to_device_space`"]
    pub fn CGContextConvertPointToDeviceSpace(c: Option<&CGContext>, point: CGPoint) -> CGPoint;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::convert_point_to_user_space`"]
    pub fn CGContextConvertPointToUserSpace(c: Option<&CGContext>, point: CGPoint) -> CGPoint;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::convert_size_to_device_space`"]
    pub fn CGContextConvertSizeToDeviceSpace(c: Option<&CGContext>, size: CGSize) -> CGSize;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::convert_size_to_user_space`"]
    pub fn CGContextConvertSizeToUserSpace(c: Option<&CGContext>, size: CGSize) -> CGSize;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::convert_rect_to_device_space`"]
    pub fn CGContextConvertRectToDeviceSpace(c: Option<&CGContext>, rect: CGRect) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::convert_rect_to_user_space`"]
    pub fn CGContextConvertRectToUserSpace(c: Option<&CGContext>, rect: CGRect) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::select_font`"]
    pub fn CGContextSelectFont(
        c: Option<&CGContext>,
        name: *const c_char,
        size: CGFloat,
        text_encoding: CGTextEncoding,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::show_text`"]
    pub fn CGContextShowText(c: Option<&CGContext>, string: *const c_char, length: usize);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGContext::show_text_at_point`"]
    pub fn CGContextShowTextAtPoint(
        c: Option<&CGContext>,
        x: CGFloat,
        y: CGFloat,
        string: *const c_char,
        length: usize,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGFont")]
    #[deprecated = "renamed to `CGContext::show_glyphs`"]
    pub fn CGContextShowGlyphs(c: Option<&CGContext>, g: *const CGGlyph, count: usize);
}

extern "C-unwind" {
    #[cfg(feature = "CGFont")]
    #[deprecated = "renamed to `CGContext::show_glyphs_at_point`"]
    pub fn CGContextShowGlyphsAtPoint(
        c: Option<&CGContext>,
        x: CGFloat,
        y: CGFloat,
        glyphs: *const CGGlyph,
        count: usize,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGFont")]
    #[deprecated = "renamed to `CGContext::show_glyphs_with_advances`"]
    pub fn CGContextShowGlyphsWithAdvances(
        c: Option<&CGContext>,
        glyphs: *const CGGlyph,
        advances: *const CGSize,
        count: usize,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFDocument")]
    #[deprecated = "renamed to `CGContext::draw_pdf_document`"]
    pub fn CGContextDrawPDFDocument(
        c: Option<&CGContext>,
        rect: CGRect,
        document: Option<&CGPDFDocument>,
        page: c_int,
    );
}
