/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.activities.Persistence;
import org.eclipse.ui.internal.activities.ws.AbstractTriggerPoint;

public class RegistryTriggerPoint
extends AbstractTriggerPoint {
    private final String id;
    private final IConfigurationElement element;
    private Map<String, String> hints;

    public RegistryTriggerPoint(String id, IConfigurationElement element) {
        this.id = id;
        this.element = element;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getStringHint(String key) {
        return this.getHints().get(key);
    }

    @Override
    public boolean getBooleanHint(String key) {
        return Boolean.parseBoolean(this.getStringHint(key));
    }

    private Map<String, String> getHints() {
        if (this.hints == null) {
            IConfigurationElement[] hintElements;
            this.hints = new HashMap<String, String>();
            IConfigurationElement[] iConfigurationElementArray = hintElements = this.element.getChildren("hint");
            int n = hintElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement hintElement = iConfigurationElementArray[n2];
                String id = hintElement.getAttribute("id");
                String value = hintElement.getAttribute("value");
                if (id == null || value == null) {
                    Persistence.log(this.element, "Invalid trigger point hint", "hint must contain ID and value");
                } else {
                    this.hints.put(id, value);
                }
                ++n2;
            }
        }
        return this.hints;
    }
}

