/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.account;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBAccountInfoService;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0007J\b\u0010\u000e\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/httpClient/account/JbaLicenseService;", "", "<init>", "()V", "requiresLicense", "", "isJetBrainsUser", "isLicensedUser", "productCode", "", "requestLicense", "", "completed", "Lkotlin/Function0;", "showLicenseDialog", "Companion", "intellij.restClient"})
public final class JbaLicenseService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean requiresLicense() {
        String string = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        String productCode = string;
        if (Intrinsics.areEqual((Object)productCode, (Object)"AI") || Registry.Companion.is("http.client.always.require.jba")) {
            return !this.isJetBrainsUser();
        }
        if ((Intrinsics.areEqual((Object)productCode, (Object)PluginAdvertiserService.Companion.getPyCharmProfessional().getProductCode()) || Intrinsics.areEqual((Object)productCode, (Object)PluginAdvertiserService.Companion.getIdeaUltimate().getProductCode())) && PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID)) {
            return !this.isLicensedUser(productCode);
        }
        return false;
    }

    private final boolean isJetBrainsUser() {
        JBAccountInfoService jBAccountInfoService = JBAccountInfoService.getInstance();
        return (jBAccountInfoService != null ? jBAccountInfoService.getUserData() : null) != null;
    }

    private final boolean isLicensedUser(String productCode) {
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        return (licensingFacade != null ? (LicensingFacade.ProductLicenseData)licensingFacade.productLicenses.get(productCode) : null) != null;
    }

    @RequiresEdt
    public final void requestLicense(@NotNull Function0<Unit> completed) {
        block1: {
            CompletableFuture completableFuture;
            JBAccountInfoService.LoginSession loginSession;
            block0: {
                Intrinsics.checkNotNullParameter(completed, (String)"completed");
                if (!ApplicationInfoEx.getInstanceEx().isVendorJetBrains()) break block0;
                this.showLicenseDialog();
                completed.invoke();
                break block1;
            }
            JBAccountInfoService jBAccountInfoService = JBAccountInfoService.getInstance();
            if (jBAccountInfoService == null || (loginSession = jBAccountInfoService.startLoginSession(JBAccountInfoService.LoginMode.AUTO, MapsKt.mapOf((Pair)TuplesKt.to((Object)"campaign", (Object)"HTTP_CLIENT_ANDROID_STUDIO")))) == null || (completableFuture = loginSession.onCompleted()) == null) break block1;
            completableFuture.thenApply(arg_0 -> JbaLicenseService.requestLicense$lambda$1(arg_0 -> JbaLicenseService.requestLicense$lambda$0(completed, arg_0), arg_0));
        }
    }

    private final void showLicenseDialog() {
        block0: {
            AnAction action = ActionManager.getInstance().getAction("Register");
            DataContext dataContext = JbaLicenseService::showLicenseDialog$lambda$2;
            AnAction anAction = action;
            if (anAction == null) break block0;
            anAction.actionPerformed(AnActionEvent.createEvent((DataContext)dataContext, (Presentation)new Presentation(), (String)"", (ActionUiKind)ActionUiKind.NONE, null));
        }
    }

    private static final Unit requestLicense$lambda$0(Function0 $completed, JBAccountInfoService.LoginResult it) {
        $completed.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit requestLicense$lambda$1(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Object showLicenseDialog$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return null;
    }

    @JvmStatic
    @NotNull
    public static final JbaLicenseService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/httpClient/account/JbaLicenseService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/httpClient/account/JbaLicenseService;", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nJbaLicenseService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbaLicenseService.kt\ncom/intellij/httpClient/account/JbaLicenseService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,69:1\n40#2,3:70\n*S KotlinDebug\n*F\n+ 1 JbaLicenseService.kt\ncom/intellij/httpClient/account/JbaLicenseService$Companion\n*L\n23#1:70,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JbaLicenseService getInstance() {
            boolean $i$f$service = false;
            Class<JbaLicenseService> serviceClass$iv = JbaLicenseService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (JbaLicenseService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

