/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters.curl.parser;

import com.intellij.httpClient.converters.curl.parser.QuotesOutside;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class HttpRequestCurlTokenizer {
    @NotNull
    public static List<String> splitInCurlTokens(@NotNull String curlString) {
        if (curlString == null) {
            HttpRequestCurlTokenizer.$$$reportNull$$$0(0);
        }
        ArrayList<String> tokensList = new ArrayList<String>();
        QuotesOutside quotesOutside = QuotesOutside.NONE;
        StringBuilder curToken = new StringBuilder();
        block11: for (int i = 0; i < curlString.length(); ++i) {
            char c = curlString.charAt(i);
            switch (c) {
                case '\"': {
                    if (quotesOutside == QuotesOutside.SINGLE) {
                        curToken.append(c);
                        continue block11;
                    }
                    if (quotesOutside == QuotesOutside.DOUBLE && curToken.isEmpty()) {
                        tokensList.add("");
                        continue block11;
                    }
                    HttpRequestCurlTokenizer.addTokenToList(tokensList, curToken);
                    quotesOutside = HttpRequestCurlTokenizer.updateQuotesState(quotesOutside, Character.valueOf('\"'));
                    continue block11;
                }
                case '$': {
                    if (quotesOutside == QuotesOutside.NONE && HttpRequestCurlTokenizer.checkNextSymbol(curlString, i, '\'')) continue block11;
                    curToken.append(c);
                    continue block11;
                }
                case '\'': {
                    if (quotesOutside == QuotesOutside.DOUBLE) {
                        curToken.append(c);
                        continue block11;
                    }
                    if (quotesOutside == QuotesOutside.SINGLE && curToken.isEmpty()) {
                        tokensList.add("");
                        continue block11;
                    }
                    HttpRequestCurlTokenizer.addTokenToList(tokensList, curToken);
                    quotesOutside = HttpRequestCurlTokenizer.updateQuotesState(quotesOutside, Character.valueOf('\''));
                    continue block11;
                }
                case '\\': {
                    switch (quotesOutside) {
                        case SINGLE: {
                            curToken.append(c);
                            break;
                        }
                        case DOUBLE: {
                            if (HttpRequestCurlTokenizer.checkNextSymbol(curlString, i, '\\', '$', '\"', '`')) {
                                curToken.append(curlString.charAt(i + 1));
                                ++i;
                                break;
                            }
                            curToken.append(c);
                            break;
                        }
                        case NONE: {
                            if (!HttpRequestCurlTokenizer.checkNextSymbol(curlString, i, '\\', '\"', '\'')) break;
                            curToken.append(curlString.charAt(i + 1));
                            ++i;
                        }
                    }
                    continue block11;
                }
                default: {
                    if (quotesOutside != QuotesOutside.NONE) {
                        curToken.append(c);
                        continue block11;
                    }
                    if (Character.isWhitespace(c)) {
                        HttpRequestCurlTokenizer.addTokenToList(tokensList, curToken);
                        continue block11;
                    }
                    curToken.append(c);
                }
            }
        }
        HttpRequestCurlTokenizer.addTokenToList(tokensList, curToken);
        ArrayList<String> arrayList = tokensList;
        if (arrayList == null) {
            HttpRequestCurlTokenizer.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static boolean checkNextSymbol(@NotNull String curlString, int currentSymbolIndex, char ... symbolsToCheck) {
        if (curlString == null) {
            HttpRequestCurlTokenizer.$$$reportNull$$$0(2);
        }
        if (curlString.length() > currentSymbolIndex + 1) {
            char nextSymbol = curlString.charAt(currentSymbolIndex + 1);
            for (char symbolToCheck : symbolsToCheck) {
                if (symbolToCheck != nextSymbol) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static QuotesOutside updateQuotesState(@NotNull QuotesOutside curQuotesState, @NotNull Character curCharacter) {
        if (curQuotesState == null) {
            HttpRequestCurlTokenizer.$$$reportNull$$$0(3);
        }
        if (curCharacter == null) {
            HttpRequestCurlTokenizer.$$$reportNull$$$0(4);
        }
        if (curQuotesState == QuotesOutside.NONE) {
            if (curCharacter.charValue() == '\"') {
                QuotesOutside quotesOutside = QuotesOutside.DOUBLE;
                if (quotesOutside == null) {
                    HttpRequestCurlTokenizer.$$$reportNull$$$0(5);
                }
                return quotesOutside;
            }
            if (curCharacter.charValue() == '\'') {
                QuotesOutside quotesOutside = QuotesOutside.SINGLE;
                if (quotesOutside == null) {
                    HttpRequestCurlTokenizer.$$$reportNull$$$0(6);
                }
                return quotesOutside;
            }
        }
        QuotesOutside quotesOutside = QuotesOutside.NONE;
        if (quotesOutside == null) {
            HttpRequestCurlTokenizer.$$$reportNull$$$0(7);
        }
        return quotesOutside;
    }

    private static void addTokenToList(@NotNull List<String> tokensList, @NotNull StringBuilder token) {
        if (tokensList == null) {
            HttpRequestCurlTokenizer.$$$reportNull$$$0(8);
        }
        if (token == null) {
            HttpRequestCurlTokenizer.$$$reportNull$$$0(9);
        }
        if (!token.isEmpty()) {
            tokensList.add(token.toString());
            token.setLength(0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curlString";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/converters/curl/parser/HttpRequestCurlTokenizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curQuotesState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curCharacter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokensList";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/converters/curl/parser/HttpRequestCurlTokenizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "splitInCurlTokens";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "updateQuotesState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "splitInCurlTokens";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkNextSymbol";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateQuotesState";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addTokenToList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

