/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.preScript;

import com.intellij.httpClient.http.request.HttpRequestPsiConvertersKt;
import com.intellij.httpClient.http.request.HttpRequestUrlAccessor;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.converter.utils.HttpRequestPsiConverterUtilsKt;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.psi.HttpHeaderField;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.substitution.HttpEnvironmentContextProvider;
import com.intellij.httpClient.http.request.substitution.HttpRequestVariableCommonSubstitutorImpl;
import com.intellij.httpClient.http.request.substitutor.HttpRequestVariableSessionSubstitutor;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00013B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010)\u001a\u00020\bJ\u0010\u0010*\u001a\u0004\u0018\u00010\u00012\u0006\u0010)\u001a\u00020\bJ\r\u0010+\u001a\u0004\u0018\u00010,\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u0004\u0018\u00010\u00012\u0006\u0010/\u001a\u00020,J\u0012\u00100\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u000201H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u000201H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0019\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0019\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u0019\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001eR\u0019\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001eR\u001b\u0010%\u001a\f\u0012\b\u0012\u00060&R\u00020\u00000\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001e\u00a8\u00064"}, d2={"Lcom/intellij/httpClient/http/request/run/preScript/HttpClientRequestElementsProvider;", "", "request", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "substitutor", "Lcom/intellij/httpClient/http/request/substitutor/HttpRequestVariableSessionSubstitutor;", "method", "", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/httpClient/http/request/substitutor/HttpRequestVariableSessionSubstitutor;Ljava/lang/String;)V", "getSubstitutor", "()Lcom/intellij/httpClient/http/request/substitutor/HttpRequestVariableSessionSubstitutor;", "getMethod", "()Ljava/lang/String;", "substitutorImpl", "Lcom/intellij/httpClient/http/request/substitution/HttpRequestVariableCommonSubstitutorImpl;", "environment", "Lcom/intellij/httpClient/http/request/environment/HttpRequestEnvironment;", "getEnvironment", "()Lcom/intellij/httpClient/http/request/environment/HttpRequestEnvironment;", "sessionVariables", "Lkotlin/Function1;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "rawBody", "Lkotlin/Lazy;", "getRawBody", "()Lkotlin/Lazy;", "substitutedBody", "getSubstitutedBody", "rawUrl", "getRawUrl", "substitutedUrl", "getSubstitutedUrl", "headers", "Lcom/intellij/httpClient/http/request/run/preScript/HttpClientRequestElementsProvider$Headers;", "getHeaders", "getEnvironmentVariable", "name", "getSessionVariable", "iteration", "", "()Ljava/lang/Integer;", "templateValue", "number", "calculateBody", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;", "calculateUrl", "Headers", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nHttpClientRequestElementsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientRequestElementsProvider.kt\ncom/intellij/httpClient/http/request/run/preScript/HttpClientRequestElementsProvider\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n19#2:100\n1#3:101\n*S KotlinDebug\n*F\n+ 1 HttpClientRequestElementsProvider.kt\ncom/intellij/httpClient/http/request/run/preScript/HttpClientRequestElementsProvider\n*L\n22#1:100\n*E\n"})
public final class HttpClientRequestElementsProvider {
    @NotNull
    private final SmartPsiElementPointer<HttpRequest> request;
    @NotNull
    private final HttpRequestVariableSessionSubstitutor substitutor;
    @NotNull
    private final String method;
    @Nullable
    private final HttpRequestVariableCommonSubstitutorImpl substitutorImpl;
    @NotNull
    private final HttpRequestEnvironment environment;
    @NotNull
    private final Function1<String, Object> sessionVariables;
    @NotNull
    private final Lazy<String> rawBody;
    @NotNull
    private final Lazy<String> substitutedBody;
    @NotNull
    private final Lazy<String> rawUrl;
    @NotNull
    private final Lazy<String> substitutedUrl;
    @NotNull
    private final Lazy<Headers> headers;

    public HttpClientRequestElementsProvider(@NotNull SmartPsiElementPointer<HttpRequest> request, @NotNull HttpRequestVariableSessionSubstitutor substitutor2, @NotNull String method) {
        Object object;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.request = request;
        this.substitutor = substitutor2;
        this.method = method;
        HttpRequestVariableSessionSubstitutor $this$asSafely$iv = this.substitutor;
        boolean $i$f$asSafely = false;
        HttpRequestVariableSessionSubstitutor httpRequestVariableSessionSubstitutor = $this$asSafely$iv;
        if (!(httpRequestVariableSessionSubstitutor instanceof HttpRequestVariableCommonSubstitutorImpl)) {
            httpRequestVariableSessionSubstitutor = null;
        }
        if ((object = (this.substitutorImpl = (HttpRequestVariableCommonSubstitutorImpl)((Object)httpRequestVariableSessionSubstitutor))) == null || (object = ((HttpRequestVariableCommonSubstitutorImpl)object).getContext()) == null || (object = ((HttpEnvironmentContextProvider)object).getEnvironment()) == null) {
            HttpRequestEnvironment httpRequestEnvironment = HttpRequestEnvironment.empty();
            object = httpRequestEnvironment;
            Intrinsics.checkNotNullExpressionValue((Object)httpRequestEnvironment, (String)"empty(...)");
        }
        this.environment = object;
        this.sessionVariables = this.substitutor.getSessionProvider();
        this.rawBody = LazyKt.lazy(() -> HttpClientRequestElementsProvider.rawBody$lambda$0(this));
        this.substitutedBody = LazyKt.lazy(() -> HttpClientRequestElementsProvider.substitutedBody$lambda$1(this));
        this.rawUrl = LazyKt.lazy(() -> HttpClientRequestElementsProvider.rawUrl$lambda$2(this));
        this.substitutedUrl = LazyKt.lazy(() -> HttpClientRequestElementsProvider.substitutedUrl$lambda$3(this));
        this.headers = LazyKt.lazy(() -> HttpClientRequestElementsProvider.headers$lambda$4(this));
    }

    @NotNull
    public final HttpRequestVariableSessionSubstitutor getSubstitutor() {
        return this.substitutor;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public final HttpRequestEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.request.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    @NotNull
    public final Lazy<String> getRawBody() {
        return this.rawBody;
    }

    @NotNull
    public final Lazy<String> getSubstitutedBody() {
        return this.substitutedBody;
    }

    @NotNull
    public final Lazy<String> getRawUrl() {
        return this.rawUrl;
    }

    @NotNull
    public final Lazy<String> getSubstitutedUrl() {
        return this.substitutedUrl;
    }

    @NotNull
    public final Lazy<Headers> getHeaders() {
        return this.headers;
    }

    @Nullable
    public final String getEnvironmentVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (String)ActionsKt.runReadAction(() -> HttpClientRequestElementsProvider.getEnvironmentVariable$lambda$5(this, name));
    }

    @Nullable
    public final Object getSessionVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Function1<String, Object> function1 = this.sessionVariables;
        return function1 != null ? function1.invoke((Object)name) : null;
    }

    @Nullable
    public final Integer iteration() {
        return this.substitutor.iteration();
    }

    @Nullable
    public final Object templateValue(int number) {
        return this.substitutor.templateValue(number);
    }

    private final String calculateBody(HttpRequestVariableSubstitutor substitutor2) {
        return (String)ActionsKt.runReadAction(() -> HttpClientRequestElementsProvider.calculateBody$lambda$7(this, substitutor2));
    }

    private final String calculateUrl(HttpRequestVariableSubstitutor substitutor2) {
        return (String)ActionsKt.runReadAction(() -> HttpClientRequestElementsProvider.calculateUrl$lambda$8(this, substitutor2));
    }

    private static final String rawBody$lambda$0(HttpClientRequestElementsProvider this$0) {
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = HttpRequestVariableSubstitutor.withoutAnySubstitution();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequestVariableSubstitutor, (String)"withoutAnySubstitution(...)");
        return this$0.calculateBody(httpRequestVariableSubstitutor);
    }

    private static final String substitutedBody$lambda$1(HttpClientRequestElementsProvider this$0) {
        return this$0.calculateBody(this$0.substitutor);
    }

    private static final String rawUrl$lambda$2(HttpClientRequestElementsProvider this$0) {
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = HttpRequestVariableSubstitutor.withoutAnySubstitution();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequestVariableSubstitutor, (String)"withoutAnySubstitution(...)");
        return this$0.calculateUrl(httpRequestVariableSubstitutor);
    }

    private static final String substitutedUrl$lambda$3(HttpClientRequestElementsProvider this$0) {
        return this$0.calculateUrl(this$0.substitutor);
    }

    private static final Headers headers$lambda$4(HttpClientRequestElementsProvider this$0) {
        return this$0.new Headers();
    }

    private static final String getEnvironmentVariable$lambda$5(HttpClientRequestElementsProvider this$0, String $name) {
        return this$0.environment.getVariableValue($name);
    }

    private static final String calculateBody$lambda$7(HttpClientRequestElementsProvider this$0, HttpRequestVariableSubstitutor $substitutor) {
        String string;
        HttpRequest httpRequest = (HttpRequest)this$0.request.getElement();
        if (httpRequest != null) {
            HttpRequest it = httpRequest;
            boolean bl = false;
            string = HttpRequestPsiConverterUtilsKt.getBody(it, $substitutor);
        } else {
            string = null;
        }
        return string;
    }

    private static final String calculateUrl$lambda$8(HttpClientRequestElementsProvider this$0, HttpRequestVariableSubstitutor $substitutor) {
        Object object = (HttpRequest)this$0.request.getElement();
        return object != null && (object = HttpRequestPsiConvertersKt.getFullUrl((HttpRequest)object, $substitutor)) != null ? HttpRequestUrlAccessor.toUrlString$default((HttpRequestUrlAccessor)object, false, 1, null) : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u0010\u0012\f\u0012\n0\u0002R\u00060\u0000R\u00020\u00030\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u0010\u0012\f\u0012\n0\u0002R\u00060\u0000R\u00020\u00030\tH\u0096\u0002J\u001a\u0010\n\u001a\f\u0018\u00010\u0002R\u00060\u0000R\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n0\u0002R\u00060\u0000R\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/httpClient/http/request/run/preScript/HttpClientRequestElementsProvider$Headers;", "", "Lcom/intellij/httpClient/http/request/run/preScript/HttpClientRequestElementsProvider$Headers$Header;", "Lcom/intellij/httpClient/http/request/run/preScript/HttpClientRequestElementsProvider;", "<init>", "(Lcom/intellij/httpClient/http/request/run/preScript/HttpClientRequestElementsProvider;)V", "headers", "", "iterator", "", "getHeader", "name", "", "Header", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nHttpClientRequestElementsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientRequestElementsProvider.kt\ncom/intellij/httpClient/http/request/run/preScript/HttpClientRequestElementsProvider$Headers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1#2:100\n295#3,2:101\n*S KotlinDebug\n*F\n+ 1 HttpClientRequestElementsProvider.kt\ncom/intellij/httpClient/http/request/run/preScript/HttpClientRequestElementsProvider$Headers\n*L\n87#1:101,2\n*E\n"})
    public final class Headers
    implements Iterable<Header>,
    KMappedMarker {
        @NotNull
        private final List<Header> headers;

        /*
         * WARNING - void declaration
         */
        public Headers() {
            void $this$headers_u24lambda_u241;
            List list2;
            HttpClientRequestElementsProvider httpClientRequestElementsProvider = HttpClientRequestElementsProvider.this;
            List list3 = list2 = CollectionsKt.createListBuilder();
            Headers headers2 = this;
            boolean bl = false;
            ActionsKt.runReadAction(() -> Headers.headers$lambda$1$lambda$0(httpClientRequestElementsProvider, (List)$this$headers_u24lambda_u241, this));
            headers2.headers = CollectionsKt.build((List)list2);
        }

        @Override
        @NotNull
        public Iterator<Header> iterator() {
            return this.headers.iterator();
        }

        @Nullable
        public final Header getHeader(@Nullable String name) {
            Header header;
            String string = name;
            if (string != null) {
                Object v5;
                block5: {
                    String it = string;
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = this.headers;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String string2;
                        Header it2 = (Header)element$iv;
                        boolean bl2 = false;
                        String string3 = it2.getName();
                        if (string3 != null) {
                            String string4 = string3.toLowerCase(Locale.ROOT);
                            string2 = string4;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                        } else {
                            string2 = null;
                        }
                        String string5 = name.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                        if (!Intrinsics.areEqual((Object)string2, (Object)string5)) continue;
                        v5 = element$iv;
                        break block5;
                    }
                    v5 = null;
                }
                header = v5;
            } else {
                header = null;
            }
            return header;
        }

        private static final Unit headers$lambda$1$lambda$0(HttpClientRequestElementsProvider this$0, List $this_buildList, Headers this$1) {
            HttpRequest httpRequest = (HttpRequest)this$0.request.getElement();
            List list2 = httpRequest != null ? httpRequest.getHeaderFieldList() : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            for (HttpHeaderField headerField : list2) {
                $this_buildList.add(this$1.new Header(headerField.getName(), (Function1<? super HttpRequestVariableSubstitutor, String>)((Function1)new Function1<HttpRequestVariableSubstitutor, String>((Object)headerField){

                    public final String invoke(HttpRequestVariableSubstitutor p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((HttpHeaderField)this.receiver).getValue(p0);
                    }
                })));
            }
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/intellij/httpClient/http/request/run/preScript/HttpClientRequestElementsProvider$Headers$Header;", "", "name", "", "valueProvider", "Lkotlin/Function1;", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;", "<init>", "(Lcom/intellij/httpClient/http/request/run/preScript/HttpClientRequestElementsProvider$Headers;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getName", "()Ljava/lang/String;", "rawValue", "Lkotlin/Lazy;", "getRawValue", "()Lkotlin/Lazy;", "substitutedValue", "getSubstitutedValue", "intellij.httpClient.executor"})
        public final class Header {
            @Nullable
            private final String name;
            @NotNull
            private final Lazy<String> rawValue;
            @NotNull
            private final Lazy<String> substitutedValue;

            public Header(@NotNull String name, Function1<? super HttpRequestVariableSubstitutor, String> valueProvider) {
                Intrinsics.checkNotNullParameter(valueProvider, (String)"valueProvider");
                this.name = name;
                this.rawValue = LazyKt.lazy(() -> Header.rawValue$lambda$1(valueProvider));
                this.substitutedValue = LazyKt.lazy(() -> Header.substitutedValue$lambda$3(valueProvider, HttpClientRequestElementsProvider.this));
            }

            @Nullable
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final Lazy<String> getRawValue() {
                return this.rawValue;
            }

            @NotNull
            public final Lazy<String> getSubstitutedValue() {
                return this.substitutedValue;
            }

            private static final String rawValue$lambda$1$lambda$0(Function1 $valueProvider) {
                HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = HttpRequestVariableSubstitutor.withoutAnySubstitution();
                Intrinsics.checkNotNullExpressionValue((Object)httpRequestVariableSubstitutor, (String)"withoutAnySubstitution(...)");
                return (String)$valueProvider.invoke((Object)httpRequestVariableSubstitutor);
            }

            private static final String rawValue$lambda$1(Function1 $valueProvider) {
                return (String)ActionsKt.runReadAction(() -> Header.rawValue$lambda$1$lambda$0($valueProvider));
            }

            private static final String substitutedValue$lambda$3$lambda$2(Function1 $valueProvider, HttpClientRequestElementsProvider this$0) {
                return (String)$valueProvider.invoke((Object)this$0.getSubstitutor());
            }

            private static final String substitutedValue$lambda$3(Function1 $valueProvider, HttpClientRequestElementsProvider this$0) {
                return (String)ActionsKt.runReadAction(() -> Header.substitutedValue$lambda$3$lambda$2($valueProvider, this$0));
            }
        }
    }
}

