/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.sampling.method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.GeometryKt;
import org.jetbrains.letsPlot.core.commons.geometry.PolylineSimplifier;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.builder.data.GroupUtil;
import org.jetbrains.letsPlot.core.plot.builder.sampling.method.GroupSamplingBase;
import org.jetbrains.letsPlot.core.plot.builder.sampling.method.SamplingUtil;
import org.jetbrains.letsPlot.core.plot.builder.sampling.method.VertexSampling;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rH\u0016J,\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J$\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rH\u0002J)\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rH\u0000\u00a2\u0006\u0002\b\u0012J5\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00140\u00142\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00140\u00142\u0006\u0010\u0017\u001a\u00020\u0003H \u00a2\u0006\u0002\b\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling;", "Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/GroupSamplingBase;", "sampleSize", "", "polygon", "", "(IZ)V", "getPolygon", "()Z", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "population", "groupMapper", "Lkotlin/Function1;", "isApplicable", "groupCount", "resamplePath", "resamplePolygon", "resamplePolygon$plot_builder", "simplifyInternal", "", "points", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "limit", "simplifyInternal$plot_builder", "VertexDpSampling", "VertexVwSampling", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nVertexSampling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VertexSampling.kt\norg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n453#2:131\n403#2:132\n453#2:137\n403#2:138\n453#2:145\n403#2:146\n1238#3,4:133\n1238#3,2:139\n766#3:141\n857#3,2:142\n1241#3:144\n1238#3,4:147\n1549#3:151\n1620#3,3:152\n1549#3:155\n1620#3,2:156\n1549#3:158\n1620#3,3:159\n1208#3,2:163\n1238#3,4:165\n1549#3:169\n1620#3,2:170\n1549#3:172\n1620#3,3:173\n1622#3:176\n1549#3:177\n1620#3,3:178\n1549#3:181\n1620#3,3:182\n1549#3:185\n1620#3,2:186\n766#3:188\n857#3,2:189\n1622#3:191\n1549#3:192\n1620#3,2:193\n1549#3:195\n1620#3,3:196\n1360#3:199\n1446#3,5:200\n1549#3:205\n1620#3,3:206\n1#4:162\n*S KotlinDebug\n*F\n+ 1 VertexSampling.kt\norg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling\n*L\n40#1:131\n40#1:132\n41#1:137\n41#1:138\n47#1:145\n47#1:146\n40#1:133,4\n41#1:139,2\n43#1:141\n43#1:142,2\n41#1:144\n47#1:147,4\n52#1:151\n52#1:152,3\n58#1:155\n58#1:156,2\n58#1:158\n58#1:159,3\n61#1:163,2\n61#1:165,4\n67#1:169\n67#1:170,2\n72#1:172\n72#1:173,3\n67#1:176\n76#1:177\n76#1:178,3\n85#1:181\n85#1:182,3\n86#1:185\n86#1:186,2\n88#1:188\n88#1:189,2\n86#1:191\n92#1:192\n92#1:193,2\n92#1:195\n92#1:196,3\n97#1:199\n97#1:200,5\n98#1:205\n98#1:206,3\n*E\n"})
public abstract class VertexSampling
extends GroupSamplingBase {
    private final boolean polygon;

    public VertexSampling(int sampleSize, boolean polygon2) {
        super(sampleSize);
        this.polygon = polygon2;
    }

    protected final boolean getPolygon() {
        return this.polygon;
    }

    @Override
    public boolean isApplicable(@NotNull DataFrame population, @NotNull Function1<? super Integer, Integer> groupMapper2, int groupCount2) {
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        return population.rowCount() > this.getSampleSize();
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame population, @NotNull Function1<? super Integer, Integer> groupMapper2) {
        DataFrame dataFrame;
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        if (!this.isApplicable(population)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        boolean bl = this.polygon;
        if (bl) {
            dataFrame = this.resamplePolygon$plot_builder(population, groupMapper2);
        } else if (!bl) {
            dataFrame = this.resamplePath(population, groupMapper2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dataFrame;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataFrame resamplePolygon$plot_builder(@NotNull DataFrame population, @NotNull Function1<? super Integer, Integer> groupMapper2) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Iterable $this$associateByTo$iv$iv;
        void $this$mapTo$iv$iv22;
        Iterable groupRings;
        Iterator $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map groupedPoints;
        void $this$mapValuesTo$iv$iv2;
        void $this$mapValues$iv2;
        List list2;
        Object object;
        Object object2;
        Map.Entry it$iv$iv;
        Map.Entry entry;
        Object object3;
        void $this$mapValuesTo$iv$iv22;
        Map $this$mapValues$iv22;
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        List<IndexedValue<DoubleVector>> points2 = SamplingUtil.INSTANCE.readPoints$plot_builder(population);
        List<Integer> groups2 = SamplingUtil.INSTANCE.distinctGroups(groupMapper2, population.rowCount());
        Map<Integer, List<Integer>> map2 = GroupUtil.INSTANCE.indicesByGroup(population.rowCount(), groupMapper2);
        boolean $i$f$mapValues = false;
        void var8_8 = $this$mapValues$iv22;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv22.size()));
        boolean bl = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv22.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object3 = destination$iv$iv;
            boolean bl2 = false;
            entry = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv.getKey();
            object = object3;
            boolean bl22 = false;
            List groupIndices = (List)entry.getValue();
            list2 = CollectionsKt.slice(points2, (Iterable)groupIndices);
            object.put(object2, list2);
        }
        $this$mapValues$iv22 = destination$iv$iv;
        boolean $i$f$mapValues42 = false;
        $this$mapValuesTo$iv$iv22 = $this$mapValues$iv2;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean bl3 = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$filterTo$iv$iv;
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            object3 = destination$iv$iv;
            boolean map32 = false;
            entry = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv.getKey();
            object = object3;
            boolean bl32 = false;
            List groupPoints = (List)entry.getValue();
            Iterable $this$filter$iv = groupPoints;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IndexedValue indexedValue = (IndexedValue)element$iv$iv;
                boolean bl4 = false;
                DoubleVector p = (DoubleVector)indexedValue.component2();
                if (!(p != null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv2;
            object.put(object2, list2);
        }
        Map $i$f$mapValues42 = groupedPoints = destination$iv$iv;
        boolean $i$f$mapValues3 = false;
        destination$iv$iv = $this$mapValues$iv;
        Map map3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo2 = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo222 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void it$iv$iv2;
            object3 = (Map.Entry)element$iv$iv$iv;
            Map map32 = map3;
            boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = false;
            Map.Entry bl32 = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv2.getKey();
            object = map32;
            boolean bl5 = false;
            List groupPoints = (List)bl32.getValue();
            list2 = GeometryKt.splitRings(groupPoints, resamplePolygon.groupedRings.1.1.INSTANCE);
            object.put(object2, list2);
        }
        Map groupedRings2 = map3;
        List flattenedRingsIndex = new ArrayList();
        int base = 0;
        for (Map.Entry entry3 : groupedRings2.entrySet()) {
            Collection<Integer> collection;
            Iterator $this$mapTo$iv$iv3;
            void $this$map$iv2;
            Object element$iv$iv$iv;
            int group2 = ((Number)entry3.getKey()).intValue();
            groupRings = (List)entry3.getValue();
            Iterable $i$f$associateByTo222 = (Iterable)CollectionsKt.getIndices((Collection)((Collection)groupRings));
            int n = group2;
            object = flattenedRingsIndex;
            boolean $i$f$map = false;
            element$iv$iv$iv = $this$map$iv2;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            Iterator $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = $this$mapTo$iv$iv3.iterator();
            while ($i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2.hasNext()) {
                void it;
                int item$iv$iv;
                int bl5 = item$iv$iv = ((IntIterator)$i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2).nextInt();
                collection = destination$iv$iv4;
                boolean bl6 = false;
                collection.add((int)(it + base));
            }
            collection = (List)destination$iv$iv4;
            List list3 = collection;
            int n2 = n;
            object.add(new IndexedValue(n2, (Object)list3));
            base += groupRings.size();
        }
        Iterable iterable = CollectionsKt.flatten((Iterable)groupedRings2.values());
        boolean $i$f$map = false;
        groupRings = iterable;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo232 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv22) {
            void $this$mapTo$iv$iv4;
            void ring;
            List $i$f$mapTo = (List)item$iv$iv;
            object = destination$iv$iv5;
            boolean bl7 = false;
            Iterable $this$map$iv3 = (Iterable)ring;
            boolean $i$f$map2 = false;
            Iterable bl6 = $this$map$iv3;
            Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                Object element$iv$iv;
                IndexedValue indexedValue = (IndexedValue)item$iv$iv2;
                element$iv$iv = destination$iv$iv6;
                boolean bl8 = false;
                DoubleVector p = (DoubleVector)indexedValue.component2();
                element$iv$iv.add((DoubleVector)p);
            }
            object.add((List)destination$iv$iv6);
        }
        List rings = (List)destination$iv$iv5;
        boolean bl9 = false;
        List<List<Integer>> flattenSimplificationIndex = this.simplifyInternal$plot_builder(rings, this.getSampleSize());
        Iterable $this$associateBy$iv = flattenedRingsIndex;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable $i$f$mapTo232 = $this$associateBy$iv;
        Map destination$iv$iv7 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo3 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            IndexedValue $this$map$iv3 = (IndexedValue)element$iv$iv;
            object = destination$iv$iv7;
            boolean bl10 = false;
            int group3 = $this$map$iv3.component1();
            $this$map$iv3 = (IndexedValue)element$iv$iv;
            object2 = group3;
            boolean bl11 = false;
            List groupRingsIndices = (List)$this$map$iv3.component2();
            list2 = CollectionsKt.slice(flattenSimplificationIndex, (Iterable)groupRingsIndices);
            object.put(object2, list2);
        }
        Map map4 = destination$iv$iv7;
        Iterable $this$map$iv4 = groups2;
        boolean $i$f$map3 = false;
        $this$associateByTo$iv$iv = $this$map$iv4;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void $this$mapTo$iv$iv5;
            void $this$map$iv5;
            void group4;
            int $this$map$iv3 = ((Number)item$iv$iv).intValue();
            object = destination$iv$iv2;
            boolean bl12 = false;
            Object v = map4.get((int)group4);
            Intrinsics.checkNotNull(v);
            List ringsSimplification = (List)v;
            Object v2 = groupedRings2.get((int)group4);
            Intrinsics.checkNotNull(v2);
            List rings2 = (List)v2;
            Iterable $i$f$mapTo3 = CollectionsKt.zip((Iterable)rings2, (Iterable)ringsSimplification);
            boolean $i$f$map4 = false;
            void item$iv$iv2 = $this$map$iv5;
            Collection destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv5) {
                Pair pair2 = (Pair)item$iv$iv3;
                Collection collection = destination$iv$iv8;
                boolean bl13 = false;
                List ring = (List)pair2.component1();
                List indices2 = (List)pair2.component2();
                collection.add(CollectionsKt.slice((List)ring, (Iterable)indices2));
            }
            object.add((List)destination$iv$iv8);
        }
        List simplifiedRings = (List)destination$iv$iv2;
        Iterable $this$map$iv6 = CollectionsKt.flatten((Iterable)CollectionsKt.flatten((Iterable)simplifiedRings));
        boolean $i$f$map5 = false;
        destination$iv$iv2 = $this$map$iv6;
        Collection destination$iv$iv9 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
        boolean $i$f$mapTo5 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IndexedValue bl12 = (IndexedValue)item$iv$iv;
            object = destination$iv$iv9;
            boolean bl14 = false;
            object.add(it.getIndex());
        }
        List dataIndices = (List)destination$iv$iv9;
        return population.selectIndices(dataIndices);
    }

    /*
     * WARNING - void declaration
     */
    private final DataFrame resamplePath(DataFrame population, Function1<? super Integer, Integer> groupMapper2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Iterable destination$iv$iv;
        List indices2;
        Collection collection;
        Iterable $this$mapTo$iv$iv3;
        Iterable $this$map$iv3;
        List<IndexedValue<DoubleVector>> points2 = SamplingUtil.INSTANCE.readPoints$plot_builder(population);
        Iterable iterable = GroupUtil.INSTANCE.indicesByGroup(population.rowCount(), groupMapper2).values();
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            Iterator iterator2 = (List)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(CollectionsKt.slice(points2, (Iterable)indices2));
        }
        $this$map$iv3 = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv3 = $this$map$iv3;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void $this$filterTo$iv$iv;
            void groupPoints;
            indices2 = (List)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Iterable $this$filter$iv = (Iterable)groupPoints;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IndexedValue indexedValue = (IndexedValue)element$iv$iv;
                boolean bl2 = false;
                DoubleVector p = (DoubleVector)indexedValue.component2();
                if (!(p != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection.add((List)destination$iv$iv);
        }
        List groupedPaths = (List)destination$iv$iv2;
        Iterable $i$f$map2 = groupedPaths;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void $this$mapTo$iv$iv4;
            void path2;
            List bl = (List)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl3 = false;
            Iterable $this$map$iv4 = (Iterable)path2;
            boolean $i$f$map4 = false;
            destination$iv$iv = $this$map$iv4;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                IndexedValue indexedValue = (IndexedValue)item$iv$iv2;
                Collection collection2 = destination$iv$iv4;
                boolean bl4 = false;
                DoubleVector p = (DoubleVector)indexedValue.component2();
                collection2.add(p);
            }
            collection.add((List)destination$iv$iv4);
        }
        Iterable paths = (List)destination$iv$iv3;
        boolean bl = false;
        List<List<Integer>> simplificationIndex = this.simplifyInternal$plot_builder((List<? extends List<DoubleVector>>)paths, this.getSampleSize());
        paths = CollectionsKt.zip((Iterable)groupedPaths, (Iterable)simplificationIndex);
        boolean $i$f$flatMap = false;
        destination$iv$iv3 = $this$flatMap$iv;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Pair bl3 = (Pair)element$iv$iv;
            boolean bl5 = false;
            List path3 = (List)bl3.component1();
            List indices3 = (List)bl3.component2();
            Iterable list$iv$iv = CollectionsKt.slice((List)path3, (Iterable)indices3);
            CollectionsKt.addAll((Collection)destination$iv$iv5, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv5;
        boolean $i$f$map5 = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IndexedValue list$iv$iv = (IndexedValue)item$iv$iv;
            collection = destination$iv$iv5;
            boolean bl6 = false;
            collection.add(it.getIndex());
        }
        List dataIndices = (List)destination$iv$iv5;
        return population.selectIndices(dataIndices);
    }

    @NotNull
    public abstract List<List<Integer>> simplifyInternal$plot_builder(@NotNull List<? extends List<DoubleVector>> var1, int var2);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J5\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\f2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\f0\f2\u0006\u0010\u000f\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u0010R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling$VertexDpSampling;", "Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling;", "sampleSize", "", "polygon", "", "(IZ)V", "expressionText", "", "getExpressionText", "()Ljava/lang/String;", "simplifyInternal", "", "points", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "limit", "simplifyInternal$plot_builder", "Companion", "plot-builder"})
    public static final class VertexDpSampling
    extends VertexSampling {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String ALIAS = "vertex_dp";

        public VertexDpSampling(int sampleSize, boolean polygon2) {
            super(sampleSize, polygon2);
        }

        @Override
        @NotNull
        public String getExpressionText() {
            return "sampling_vertex_dp(n=" + this.getSampleSize() + ", polygon=" + this.getPolygon() + ')';
        }

        @Override
        @NotNull
        public List<List<Integer>> simplifyInternal$plot_builder(@NotNull List<? extends List<DoubleVector>> points2, int limit) {
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            return PolylineSimplifier.Companion.douglasPeuckerMultipath(points2).setCountLimit(limit).getIndices();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling$VertexDpSampling$Companion;", "", "()V", "ALIAS", "", "plot-builder"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J5\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\f2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\f0\f2\u0006\u0010\u000f\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u0010R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling$VertexVwSampling;", "Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling;", "sampleSize", "", "polygon", "", "(IZ)V", "expressionText", "", "getExpressionText", "()Ljava/lang/String;", "simplifyInternal", "", "points", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "limit", "simplifyInternal$plot_builder", "Companion", "plot-builder"})
    public static final class VertexVwSampling
    extends VertexSampling {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String ALIAS = "vertex_vw";

        public VertexVwSampling(int sampleSize, boolean polygon2) {
            super(sampleSize, polygon2);
        }

        @Override
        @NotNull
        public String getExpressionText() {
            return "sampling_vertex_vw(n=" + this.getSampleSize() + ", polygon=" + this.getPolygon() + ')';
        }

        @Override
        @NotNull
        public List<List<Integer>> simplifyInternal$plot_builder(@NotNull List<? extends List<DoubleVector>> points2, int limit) {
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            return PolylineSimplifier.Companion.visvalingamWhyattMultipath(points2).setCountLimit(limit).getIndices();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling$VertexVwSampling$Companion;", "", "()V", "ALIAS", "", "plot-builder"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

