/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.io;

import com.intellij.util.io.DataOutputStream;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapProcessor;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SequentialRawWriter<T>
implements Closeable {
    private final RawSerializer<? super T> mySerializer;
    private OutputStream myStream;
    private final DataOutputStream myDataOutputStream;

    public SequentialRawWriter(File file, RawSerializer<? super T> serializer) throws FileNotFoundException {
        this(file, serializer, false);
    }

    public SequentialRawWriter(File file, RawSerializer<? super T> serializer, boolean append) throws FileNotFoundException {
        this.mySerializer = serializer;
        this.myStream = new BufferedOutputStream(new FileOutputStream(file));
        this.myDataOutputStream = new DataOutputStream(this.myStream);
    }

    @Override
    public void close() {
        if (this.myStream != null) {
            try {
                this.myStream.close();
            }
            catch (IOException e) {
                V8HeapProcessor.LOG.info((Throwable)e);
            }
            this.myStream = null;
        }
    }

    public int write(T t) throws IOException {
        int was = this.myDataOutputStream.getWrittenBytesCount();
        this.mySerializer.write((DataOutput)this.myDataOutputStream, t);
        int is = this.myDataOutputStream.getWrittenBytesCount();
        return is - was;
    }
}

