/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.jetbrains.plugins.webDeployment.WDBundle;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.CancellableFileSelector;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.PropertyKey;

public class CancellableAllFileSelector
extends AllFileSelector
implements CancellableFileSelector {
    private final Logger LOG = Logger.getInstance(CancellableAllFileSelector.class);
    private final ProgressIndicator myProgressIndicator;
    private final String myMessageKey;
    private final boolean myCancellable;

    public CancellableAllFileSelector(ProgressIndicator progressIndicator, @PropertyKey(resourceBundle="messages.WDBundle") @PropertyKey(resourceBundle="messages.WDBundle") String messageKey, boolean isCancellable) {
        this.myProgressIndicator = progressIndicator;
        this.myMessageKey = messageKey;
        this.myCancellable = isCancellable;
    }

    public boolean includeFile(FileSelectInfo fileInfo) {
        if (this.myCancellable) {
            this.myProgressIndicator.checkCanceled();
        }
        return super.includeFile(fileInfo);
    }

    public boolean traverseDescendents(FileSelectInfo fileInfo) {
        if (this.myCancellable) {
            this.myProgressIndicator.checkCanceled();
        }
        try {
            if (fileInfo.getFile().isSymbolicLink()) {
                return false;
            }
        }
        catch (FileSystemException e) {
            this.LOG.warn((Throwable)e);
            return false;
        }
        this.myProgressIndicator.setText(WDBundle.message(this.myMessageKey, fileInfo.getFile().getName().getBaseName()));
        return super.traverseDescendents(fileInfo);
    }

    public boolean isCancelled() {
        this.myProgressIndicator.checkCanceled();
        return false;
    }
}

