/*
 * Decompiled with CFR 0.152.
 */
package ini4idea.lang;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import ini4idea.lang.IniTokenType;
import ini4idea.lang.parser.IniPropertyStubElementType;
import ini4idea.lang.psi.impl.IniArrayIndexImpl;
import ini4idea.lang.psi.impl.IniArrayIndexListImpl;
import ini4idea.lang.psi.impl.IniKeyImpl;
import ini4idea.lang.psi.impl.IniKeyNameImpl;
import ini4idea.lang.psi.impl.IniPropertyImpl;
import ini4idea.lang.psi.impl.IniSectionImpl;
import ini4idea.lang.psi.impl.IniSectionNameImpl;
import ini4idea.lang.psi.impl.IniValueImpl;

public interface IniElementTypes {
    public static final IElementType INI_ARRAY_INDEX = new IniTokenType("INI_ARRAY_INDEX");
    public static final IElementType INI_ARRAY_INDEX_LIST = new IniTokenType("INI_ARRAY_INDEX_LIST");
    public static final IElementType INI_KEY = new IniTokenType("INI_KEY");
    public static final IElementType INI_KEY_NAME = new IniTokenType("INI_KEY_NAME");
    public static final IElementType INI_PROPERTY = new IniPropertyStubElementType("INI_PROPERTY");
    public static final IElementType INI_SECTION = new IniTokenType("INI_SECTION");
    public static final IElementType INI_SECTION_NAME = new IniTokenType("INI_SECTION_NAME");
    public static final IElementType INI_VALUE = new IniTokenType("INI_VALUE");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == INI_ARRAY_INDEX) {
                return new IniArrayIndexImpl(node);
            }
            if (type == INI_ARRAY_INDEX_LIST) {
                return new IniArrayIndexListImpl(node);
            }
            if (type == INI_KEY) {
                return new IniKeyImpl(node);
            }
            if (type == INI_KEY_NAME) {
                return new IniKeyNameImpl(node);
            }
            if (type == INI_PROPERTY) {
                return new IniPropertyImpl(node);
            }
            if (type == INI_SECTION) {
                return new IniSectionImpl(node);
            }
            if (type == INI_SECTION_NAME) {
                return new IniSectionNameImpl(node);
            }
            if (type == INI_VALUE) {
                return new IniValueImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + String.valueOf(type)));
        }
    }
}

