/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageListNode
extends AbstractTreeNode<Object> {
    protected final CoverageSuitesBundle myBundle;
    private final FileStatusManager myFileStatusManager;
    private final VirtualFile myFile;
    @Deprecated
    protected final CoverageViewManager.StateBean myStateBean;
    private List<AbstractTreeNode<?>> myCachedChildren;

    @Deprecated
    public CoverageListNode(Project project, @NotNull PsiNamedElement element, CoverageSuitesBundle bundle, CoverageViewManager.StateBean stateBean, boolean unused) {
        if (element == null) {
            CoverageListNode.$$$reportNull$$$0(0);
        }
        this(project, element, bundle);
    }

    @Deprecated
    public CoverageListNode(Project project, @NotNull PsiNamedElement element, CoverageSuitesBundle bundle, CoverageViewManager.StateBean stateBean) {
        if (element == null) {
            CoverageListNode.$$$reportNull$$$0(1);
        }
        this(project, element, bundle);
    }

    public CoverageListNode(Project project, @NotNull PsiNamedElement element, CoverageSuitesBundle bundle) {
        if (element == null) {
            CoverageListNode.$$$reportNull$$$0(2);
        }
        super(project, (Object)element);
        this.myName = (String)ReadAction.compute(() -> element.getName());
        this.myBundle = bundle;
        this.myStateBean = CoverageViewManager.getInstance(project).getStateBean();
        this.myFileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        this.myFile = (VirtualFile)ReadAction.compute(() -> {
            VirtualFile canonical;
            VirtualFile file;
            VirtualFile virtualFile = file = element.isValid() ? PsiUtilCore.getVirtualFile((PsiElement)element) : null;
            if (file != null && (canonical = file.getCanonicalFile()) != null) {
                return canonical;
            }
            return file;
        });
    }

    @NotNull
    public synchronized List<? extends AbstractTreeNode<?>> getChildren() {
        if (this.myCachedChildren != null) {
            List<AbstractTreeNode<?>> list = this.myCachedChildren;
            if (list == null) {
                CoverageListNode.$$$reportNull$$$0(3);
            }
            return list;
        }
        this.myCachedChildren = this.myBundle.getCoverageEngine().createCoverageViewExtension(this.myProject, this.myBundle).getChildrenNodes(this);
        if (this.myCachedChildren == null) {
            CoverageListNode.$$$reportNull$$$0(4);
        }
        return this.myCachedChildren;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            CoverageListNode.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.getValue();
            if (object instanceof PsiNamedElement) {
                PsiNamedElement value = (PsiNamedElement)object;
                CoverageViewManager.StateBean stateBean = CoverageViewManager.getInstance(this.myProject).getStateBean();
                if (value instanceof PsiQualifiedNamedElement && (stateBean.isFlattenPackages() && value.getContainingFile() == null || this.getParent() instanceof CoverageListRootNode)) {
                    presentation.setPresentableText(((PsiQualifiedNamedElement)value).getQualifiedName());
                } else {
                    presentation.setPresentableText(value.getName());
                }
                presentation.setIcon(value.getIcon(0));
                presentation.setForcedTextForeground(this.getFileStatus().getColor());
            }
        });
    }

    VirtualFile getFile() {
        return this.myFile;
    }

    public FileStatus getFileStatus() {
        VirtualFile virtualFile = this.myFile;
        return virtualFile != null ? this.myFileStatusManager.getStatus(virtualFile) : super.getFileStatus();
    }

    @Nullable
    protected Color computeBackgroundColor() {
        return null;
    }

    protected boolean shouldPostprocess() {
        return false;
    }

    public boolean canNavigate() {
        PsiElement element;
        Object value = this.getValue();
        return value instanceof PsiElement && (element = (PsiElement)value).isValid() && element.getContainingFile() != null;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public void navigate(boolean requestFocus) {
        if (this.canNavigate()) {
            PsiNamedElement value = (PsiNamedElement)this.getValue();
            if (requestFocus && value != null) {
                NavigationUtil.activateFileWithPsiElement((PsiElement)value, (boolean)true);
            } else if (value instanceof NavigationItem) {
                NavigationItem navigationItem = (NavigationItem)value;
                navigationItem.navigate(false);
            }
        }
    }

    public int getWeight() {
        return (Integer)ReadAction.compute(() -> {
            PsiElement element;
            Object value = this.getValue();
            if (value instanceof PsiElement && (element = (PsiElement)value).getContainingFile() != null) {
                return 40;
            }
            return 30;
        });
    }

    boolean contains(VirtualFile file) {
        PsiElement element;
        boolean equalContainingFile;
        Object value = this.getValue();
        if (value instanceof PsiElement && (equalContainingFile = Comparing.equal((Object)PsiUtilCore.getVirtualFile((PsiElement)(element = (PsiElement)value)), (Object)file))) {
            return true;
        }
        if (value instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)value;
            return this.contains(file, directory);
        }
        if (value instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories;
            PsiDirectoryContainer container = (PsiDirectoryContainer)value;
            for (PsiDirectory directory : directories = container.getDirectories()) {
                if (!this.contains(file, directory)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean contains(VirtualFile file, PsiDirectory value) {
        CoverageViewManager.StateBean stateBean = CoverageViewManager.getInstance(this.myProject).getStateBean();
        if (stateBean.isFlattenPackages()) {
            return Comparing.equal((Object)value.getVirtualFile(), (Object)file.getParent());
        }
        return VfsUtilCore.isAncestor((VirtualFile)value.getVirtualFile(), (VirtualFile)file, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/view/CoverageListNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/view/CoverageListNode";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

