/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinDefaultArgsBranchFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinLateinitFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinOpenMemberWithDefaultArgsFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinUnsafeCastFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinWhenMappingExceptionFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinWhenStringFilter;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.ClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.KotlinClassMarkerFilter;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.KotlinValueClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.classes.ClassSignatureFilter;
import com.intellij.rt.coverage.instrumentation.filters.classes.KotlinFunctionOrPropertyReferenceFilter;
import com.intellij.rt.coverage.instrumentation.filters.classes.KotlinSerializerFilter;
import com.intellij.rt.coverage.instrumentation.filters.compose.ComposeUtils;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.KotlinCoroutinesFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.KotlinDefaultArgsLineFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.KotlinDeprecatedMethodFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.KotlinImplementerDefaultInterfaceMemberFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.KotlinTryFinallyLineFilter;
import com.intellij.rt.coverage.instrumentation.filters.methods.KotlinLocalFunctionInsideIgnoredMethodFilter;
import com.intellij.rt.coverage.instrumentation.filters.methods.KotlinSyntheticAccessMethodFilter;
import com.intellij.rt.coverage.instrumentation.filters.methods.KotlinSyntheticConstructorOfSealedClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.methods.MethodFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KotlinUtils {
    public static final String KOTLIN_DEFAULT_CONSTRUCTOR_MARKER = "Lkotlin/jvm/internal/DefaultConstructorMarker;";
    public static final String COMPANION_SUFFIX = "$Companion";
    private static final boolean ourKotlinEnabled = !"false".equals(System.getProperty("coverage.kotlin.enable", "true"));

    public static boolean isKotlinClass(InstrumentationData data) {
        Boolean bl;
        Boolean isKotlin = data.get(Key.IS_KOTLIN);
        return isKotlin != null && bl != false;
    }

    /*
     * WARNING - void declaration
     */
    public static List<MethodFilter> createMethodFilters() {
        void var0;
        if (!ourKotlinEnabled) {
            return Collections.emptyList();
        }
        ArrayList<MethodFilter> result = new ArrayList<MethodFilter>();
        result.add(new KotlinSyntheticConstructorOfSealedClassFilter());
        result.add(new KotlinSyntheticAccessMethodFilter());
        result.add(new KotlinLocalFunctionInsideIgnoredMethodFilter());
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static List<ClassSignatureFilter> createClassSignatureFilters() {
        void var0;
        if (!ourKotlinEnabled) {
            return Collections.emptyList();
        }
        ArrayList<ClassSignatureFilter> result = new ArrayList<ClassSignatureFilter>();
        result.add(new KotlinFunctionOrPropertyReferenceFilter());
        result.add(new KotlinSerializerFilter());
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static List<CoverageFilter> createLineFilters() {
        void var0;
        if (!ourKotlinEnabled) {
            return Collections.emptyList();
        }
        ArrayList<CoverageFilter> result = new ArrayList<CoverageFilter>();
        result.add(new KotlinImplementerDefaultInterfaceMemberFilter());
        result.add(new KotlinCoroutinesFilter());
        result.add(new KotlinDeprecatedMethodFilter());
        result.add(new KotlinDefaultArgsLineFilter());
        result.add(new KotlinTryFinallyLineFilter());
        result.addAll(ComposeUtils.createLineFilters());
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static List<CoverageFilter> createBranchFilters() {
        void var0;
        if (!ourKotlinEnabled) {
            return Collections.emptyList();
        }
        ArrayList<CoverageFilter> result = new ArrayList<CoverageFilter>();
        result.add(new KotlinWhenMappingExceptionFilter());
        result.add(new KotlinDefaultArgsBranchFilter());
        result.add(new KotlinLateinitFilter());
        result.add(new KotlinOpenMemberWithDefaultArgsFilter());
        result.add(new KotlinUnsafeCastFilter());
        result.add(new KotlinWhenStringFilter());
        result.addAll(ComposeUtils.createBranchFilters());
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static List<ClassFilter> createClassFilters() {
        void var0;
        if (!ourKotlinEnabled) {
            return Collections.emptyList();
        }
        ArrayList<ClassFilter> result = new ArrayList<ClassFilter>();
        result.add(new KotlinClassMarkerFilter());
        result.add(new KotlinValueClassFilter());
        return var0;
    }
}

