/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.flat;

import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsModuleEntity;
import com.intellij.microservices.endpoints.EndpointsProjectModel;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.ui.flat.EndpointsCursor;
import com.intellij.microservices.ui.flat.EndpointsSearchQueryParser;
import com.intellij.microservices.ui.flat.FlatEndpointGroup;
import com.intellij.microservices.ui.flat.FlatEndpointItem;
import com.intellij.microservices.ui.flat.FlatEndpointProvider;
import com.intellij.microservices.ui.flat.FlatModuleParameter;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001aN\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u0007\"\b\b\u0000\u0010\b*\u00020\n\"\b\b\u0001\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001aX\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00130\u0012\"\b\b\u0000\u0010\b*\u00020\n\"\b\b\u0001\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u000eH\u0002\u001a>\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00030\u00122\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00132\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0002\u001a.\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0001H\u0003\u001a&\u0010\u001f\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e0\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u001eH\u0002\u001a\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0001\u001a\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a8\u0006#"}, d2={"containsSearchText", "", "item", "Lcom/intellij/microservices/ui/flat/FlatEndpointItem;", "searchText", "", "getProviderModule", "Lcom/intellij/microservices/ui/flat/FlatEndpointProvider;", "G", "E", "", "project", "Lcom/intellij/openapi/project/Project;", "provider", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "module", "Lcom/intellij/microservices/endpoints/EndpointsModuleEntity;", "getProviderEndpointGroups", "", "Lcom/intellij/microservices/ui/flat/FlatEndpointGroup;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getProviderEndpoints", "showFromLibraries", "showFromTests", "findSelectedModules", "Lcom/intellij/microservices/ui/flat/FlatModuleParameter;", "model", "Lcom/intellij/microservices/endpoints/EndpointsProjectModel;", "queryParser", "Lcom/intellij/microservices/ui/flat/EndpointsSearchQueryParser;", "findSelectedProviders", "parser", "getModulesOrdered", "getModuleAttribute", "intellij.microservices.ui"})
@SourceDebugExtension(value={"SMAP\nEndpointsCursor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndpointsCursor.kt\ncom/intellij/microservices/ui/flat/EndpointsCursorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,270:1\n1563#2:271\n1634#2,3:272\n774#2:276\n865#2:277\n1761#2,3:278\n866#2:281\n1563#2:282\n1634#2,3:283\n1563#2:286\n1634#2,3:287\n1056#2:291\n1761#2,3:292\n1761#2,3:295\n14#3:275\n608#4:290\n*S KotlinDebug\n*F\n+ 1 EndpointsCursor.kt\ncom/intellij/microservices/ui/flat/EndpointsCursorKt\n*L\n142#1:271\n142#1:272,3\n229#1:276\n229#1:277\n231#1:278,3\n229#1:281\n239#1:282\n239#1:283,3\n248#1:286\n248#1:287,3\n265#1:291\n243#1:292,3\n251#1:295,3\n148#1:275\n256#1:290\n*E\n"})
public final class EndpointsCursorKt {
    private static final boolean containsSearchText(FlatEndpointItem<?, ?> item, String searchText) {
        String itemText = item.getPresentableText();
        if (StringsKt.contains((CharSequence)itemText, (CharSequence)searchText, (boolean)true)) {
            return true;
        }
        String frameworkText = item.getFrameworkPresentation().getTitle();
        if (StringsKt.contains((CharSequence)frameworkText, (CharSequence)searchText, (boolean)true)) {
            return true;
        }
        String location = item.getLocationString();
        return StringsKt.contains((CharSequence)location, (CharSequence)searchText, (boolean)true);
    }

    private static final <G, E> FlatEndpointProvider<G, E> getProviderModule(Project project, EndpointsProvider<G, E> provider, EndpointsModuleEntity module) {
        return new FlatEndpointProvider<G, E>(module, provider, provider.getModificationTracker(project));
    }

    /*
     * WARNING - void declaration
     */
    private static final <G, E> List<FlatEndpointGroup<?, ?>> getProviderEndpointGroups(Project project, EndpointsModuleEntity module, EndpointsFilter filter, EndpointsProvider<G, E> provider) {
        Iterable iterable;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            iterable = provider.getEndpointGroups(project, filter);
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new FlatEndpointGroup<void, E>(project, module, provider, it));
            }
            iterable = (List)destination$iv$iv;
        }
        catch (Exception ex) {
            if (ex instanceof ControlFlowException) {
                throw ex;
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(EndpointsCursor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)ex);
            iterable = CollectionsKt.emptyList();
        }
        return iterable;
    }

    private static final List<FlatEndpointItem<?, ?>> getProviderEndpoints(Project project, FlatEndpointGroup<?, ?> item, boolean showFromLibraries, boolean showFromTests) {
        Sequence<FlatEndpointItem<?, ?>> endpointsSeq = item.getEndpoints();
        if (item.getModule() == null || showFromLibraries && showFromTests) {
            return SequencesKt.toList(endpointsSeq);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getLibrariesScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getLibrariesScope(...)");
        GlobalSearchScope librariesScope = globalSearchScope;
        return SequencesKt.toList((Sequence)SequencesKt.filter(endpointsSeq, arg_0 -> EndpointsCursorKt.getProviderEndpoints$lambda$1(showFromLibraries, librariesScope, showFromTests, project, arg_0)));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @RequiresBackgroundThread
    private static final List<FlatModuleParameter> findSelectedModules(Project project, EndpointsProjectModel model, EndpointsSearchQueryParser queryParser, boolean showFromTests) {
        ThreadingAssertions.assertBackgroundThread();
        allModuleParams = new ArrayList<E>();
        for (EndpointsModuleEntity module : EndpointsCursorKt.getModulesOrdered(model, project)) {
            if (!showFromTests && model.isTestModule(module)) continue;
            allModuleParams.add(new FlatModuleParameter(module));
        }
        allModuleParams.add(new FlatModuleParameter(null));
        selectedModules = queryParser.getModules();
        if (selectedModules.isEmpty()) {
            return allModuleParams;
        }
        $this$filter$iv = allModuleParams;
        $i$f$filter = false;
        var8_8 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block9: {
                param = (FlatModuleParameter)element$iv$iv;
                $i$a$-filter-EndpointsCursorKt$findSelectedModules$1 = false;
                v0 /* !! */  = param.getModule();
                if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getName()) == null) {
                    v0 /* !! */  = "#external";
                }
                if (selectedModules.contains(moduleName /* !! */  = v0 /* !! */ )) ** GOTO lbl-1000
                $this$any$iv = selectedModules;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        $i$a$-any-EndpointsCursorKt$findSelectedModules$1$1 = false;
                        if (!StringsKt.contains((CharSequence)((CharSequence)moduleName /* !! */ ), (CharSequence)it, (boolean)true)) continue;
                        v1 = true;
                        break block9;
                    }
                    v1 = false;
                }
            }
            if (v1) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List<EndpointsProvider<?, ?>> findSelectedProviders(Project project, EndpointsSearchQueryParser parser2) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        Sequence providersSequence = EndpointsProvider.Companion.getAvailableProviders(project);
        if (!((Collection)parser2.getFrameworks()).isEmpty()) {
            $this$map$iv = parser2.getFrameworks();
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                collection.add(string2);
            }
            List selectedFrameworks = (List)destination$iv$iv;
            providersSequence = SequencesKt.filter((Sequence)providersSequence, arg_0 -> EndpointsCursorKt.findSelectedProviders$lambda$6(selectedFrameworks, arg_0));
        }
        if (!((Collection)parser2.getTypes()).isEmpty()) {
            $this$map$iv = parser2.getTypes();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                collection.add(string);
            }
            List selectedTypes = (List)destination$iv$iv;
            providersSequence = SequencesKt.filter((Sequence)providersSequence, arg_0 -> EndpointsCursorKt.findSelectedProviders$lambda$9(selectedTypes, arg_0));
        }
        Sequence $this$sortedBy$iv = providersSequence;
        boolean $i$f$sortedBy = false;
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                EndpointsProvider it = (EndpointsProvider)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getPresentation().getQueryTag());
                it = (EndpointsProvider)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPresentation().getQueryTag())));
            }
        }));
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public static final List<EndpointsModuleEntity> getModulesOrdered(@NotNull EndpointsProjectModel model, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ThreadingAssertions.assertBackgroundThread();
        Iterable $this$sortedBy$iv = model.getModuleEntities(project);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                EndpointsModuleEntity it = (EndpointsModuleEntity)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (EndpointsModuleEntity)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    @NotNull
    public static final String getModuleAttribute(@NotNull EndpointsProjectModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return model.getModuleQueryTag() + ":";
    }

    private static final boolean getProviderEndpoints$lambda$1(boolean $showFromLibraries, GlobalSearchScope $librariesScope, boolean $showFromTests, Project $project, FlatEndpointItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        VirtualFile file = it.getContainingFile();
        return file == null || ($showFromLibraries || !$librariesScope.contains(file)) && ($showFromTests || !TestSourcesFilter.isTestSources((VirtualFile)file, (Project)$project));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findSelectedProviders$lambda$6(List $selectedFrameworks, EndpointsProvider p) {
        String it;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        String string = p.getPresentation().getQueryTag().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String queryTag = string;
        if ($selectedFrameworks.contains(queryTag)) return true;
        Iterable $this$any$iv = $selectedFrameworks;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.contains((CharSequence)queryTag, (CharSequence)it, (boolean)true));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findSelectedProviders$lambda$9(List $selectedTypes, EndpointsProvider p) {
        String it;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        String string = p.getEndpointType().getQueryTag().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String queryTag = string;
        if ($selectedTypes.contains(queryTag)) return true;
        Iterable $this$any$iv = $selectedTypes;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.contains((CharSequence)queryTag, (CharSequence)it, (boolean)true));
        return true;
    }

    public static final /* synthetic */ List access$findSelectedModules(Project project, EndpointsProjectModel model, EndpointsSearchQueryParser queryParser, boolean showFromTests) {
        return EndpointsCursorKt.findSelectedModules(project, model, queryParser, showFromTests);
    }

    public static final /* synthetic */ List access$findSelectedProviders(Project project, EndpointsSearchQueryParser parser2) {
        return EndpointsCursorKt.findSelectedProviders(project, parser2);
    }

    public static final /* synthetic */ FlatEndpointProvider access$getProviderModule(Project project, EndpointsProvider provider, EndpointsModuleEntity module) {
        return EndpointsCursorKt.getProviderModule(project, provider, module);
    }

    public static final /* synthetic */ List access$getProviderEndpointGroups(Project project, EndpointsModuleEntity module, EndpointsFilter filter, EndpointsProvider provider) {
        return EndpointsCursorKt.getProviderEndpointGroups(project, module, filter, provider);
    }

    public static final /* synthetic */ List access$getProviderEndpoints(Project project, FlatEndpointGroup item, boolean showFromLibraries, boolean showFromTests) {
        return EndpointsCursorKt.getProviderEndpoints(project, item, showFromLibraries, showFromTests);
    }

    public static final /* synthetic */ boolean access$containsSearchText(FlatEndpointItem item, String searchText) {
        return EndpointsCursorKt.containsSearchText(item, searchText);
    }
}

