/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.LafManager;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierBundle;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0003\u001b\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000f\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\nH\u0016J!\u0010\u000b\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\tH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010\u0014\u001a\u00070\t\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u001b\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0006\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/prettierjs/codeStyle/PrettierCodeStyleStatusBarUIContributor;", "Lcom/intellij/psi/codeStyle/modifier/CodeStyleStatusBarUIContributor;", "<init>", "()V", "areActionsAvailable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getActionGroupTitle", "", "Lcom/intellij/openapi/util/NlsContexts$PopupTitle;", "getActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getTooltip", "createDisableAction", "project", "Lcom/intellij/openapi/project/Project;", "getStatusText", "Lcom/intellij/openapi/util/NlsContexts$StatusBarText;", "psiFile", "getIcon", "Ljavax/swing/Icon;", "createNavigationActions", "createDisableCodeStyleModifierAction", "ReEnableAction", "OpenSettingsDialogAction", "OpenConfigurationAction", "intellij.prettierJS"})
@SourceDebugExtension(value={"SMAP\nPrettierCodeStyleStatusBarUIContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierCodeStyleStatusBarUIContributor.kt\ncom/intellij/prettierjs/codeStyle/PrettierCodeStyleStatusBarUIContributor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,131:1\n37#2:132\n36#2,3:133\n*S KotlinDebug\n*F\n+ 1 PrettierCodeStyleStatusBarUIContributor.kt\ncom/intellij/prettierjs/codeStyle/PrettierCodeStyleStatusBarUIContributor\n*L\n66#1:132\n66#1:133,3\n*E\n"})
public final class PrettierCodeStyleStatusBarUIContributor
implements CodeStyleStatusBarUIContributor {
    public boolean areActionsAvailable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    @Nullable
    public String getActionGroupTitle() {
        return PrettierBundle.message("prettier.code.style.status.bar.action.group.title", new Object[0]);
    }

    @Nullable
    public AnAction[] getActions(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.createNavigationActions(file);
    }

    @NotNull
    public String getTooltip() {
        String string = PrettierBundle.message("prettier.code.style.status.bar.tooltip", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public AnAction createDisableAction(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.createDisableCodeStyleModifierAction(project);
    }

    @NotNull
    public String getStatusText(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings((PsiFile)psiFile).getIndentOptions(psiFile.getFileType());
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptions(...)");
        CommonCodeStyleSettings.IndentOptions fileOptions = indentOptions;
        CommonCodeStyleSettings.IndentOptions indentOptions2 = CodeStyle.getSettings((Project)psiFile.getProject()).getIndentOptions(psiFile.getFileType());
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions2, (String)"getIndentOptions(...)");
        CommonCodeStyleSettings.IndentOptions projectOptions = indentOptions2;
        String string = IndentStatusBarUIContributor.getIndentInfo((CommonCodeStyleSettings.IndentOptions)fileOptions);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIndentInfo(...)");
        Object indentInfo = string;
        if (projectOptions.INDENT_SIZE != fileOptions.INDENT_SIZE || projectOptions.USE_TAB_CHARACTER != fileOptions.USE_TAB_CHARACTER) {
            indentInfo = (String)indentInfo + "*";
        }
        return indentInfo;
    }

    @Nullable
    public Icon getIcon() {
        Icon icon;
        Color statusBarFriendlyColor = LafManager.getInstance().getCurrentUIThemeLookAndFeel().isDark() ? JBUI.CurrentTheme.StatusBar.Widget.FOREGROUND : JBUI.CurrentTheme.StatusBar.Widget.FOREGROUND.brighter();
        Icon icon2 = PrettierUtil.ICON;
        if (icon2 != null) {
            Icon it = icon2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)statusBarFriendlyColor);
            icon = IconUtil.colorize$default((Icon)it, (Color)statusBarFriendlyColor, (boolean)false, (boolean)false, (int)12, null);
        } else {
            icon = null;
        }
        return icon;
    }

    private final AnAction[] createNavigationActions(PsiFile file) {
        List list;
        List $this$createNavigationActions_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$createNavigationActions_u24lambda_u241.add(new OpenConfigurationAction(file));
        $this$createNavigationActions_u24lambda_u241.add(new OpenSettingsDialogAction());
        Collection $this$toTypedArray$iv = CollectionsKt.build((List)list);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new AnAction[0]);
    }

    private final AnAction createDisableCodeStyleModifierAction(Project project) {
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)PrettierBundle.message("prettier.action.disable.for.project.label", new Object[0]), arg_0 -> PrettierCodeStyleStatusBarUIContributor.createDisableCodeStyleModifierAction$lambda$4(arg_0 -> PrettierCodeStyleStatusBarUIContributor.createDisableCodeStyleModifierAction$lambda$3(project, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        return (AnAction)dumbAwareAction;
    }

    private static final Unit createDisableCodeStyleModifierAction$lambda$3(Project $project, AnActionEvent e) {
        Notification notification;
        PrettierConfiguration.getInstance((Project)$project).getState().codeStyleSettingsModifierEnabled = false;
        CodeStyleSettingsManager.getInstance((Project)$project).notifyCodeStyleSettingsChanged();
        String string = PrettierBundle.message("prettier.formatter.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = PrettierBundle.message("prettier.notification.content.code.style.settings.modifier.has.been.disabled", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Notification $this$createDisableCodeStyleModifierAction_u24lambda_u243_u24lambda_u242 = notification = JSLinterGuesser.NOTIFICATION_GROUP.createNotification(string, string2, NotificationType.INFORMATION);
        boolean bl = false;
        Object[] objectArray = new DumbAwareAction[]{new ReEnableAction($project, $this$createDisableCodeStyleModifierAction_u24lambda_u243_u24lambda_u242), new OpenSettingsDialogAction()};
        $this$createDisableCodeStyleModifierAction_u24lambda_u243_u24lambda_u242.addActions((Collection)CollectionsKt.listOf((Object[])objectArray));
        $this$createDisableCodeStyleModifierAction_u24lambda_u243_u24lambda_u242.notify($project);
        return Unit.INSTANCE;
    }

    private static final void createDisableCodeStyleModifierAction$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/prettierjs/codeStyle/PrettierCodeStyleStatusBarUIContributor$OpenConfigurationAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/psi/PsiFile;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.prettierJS"})
    private static final class OpenConfigurationAction
    extends DumbAwareAction {
        @NotNull
        private final PsiFile file;

        public OpenConfigurationAction(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(PrettierBundle.message("prettier.action.open.configuration.file.label", new Object[0]));
            this.file = file;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = this.file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            VirtualFile configFile = PrettierUtil.findFileConfig(project2, this.file.getVirtualFile());
            if (configFile != null) {
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
                if (fileEditorManager.isFileOpen(configFile)) {
                    fileEditorManager.closeFile(configFile);
                }
                FileEditor[] fileEditorArray = fileEditorManager.openFile(configFile, true);
                Intrinsics.checkNotNull((Object)fileEditorArray);
            } else {
                String string = PrettierBundle.message("prettier.formatter.notification.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String string2 = PrettierBundle.message("prettier.notification.config.not.found", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                Notification notification = JSLinterGuesser.NOTIFICATION_GROUP.createNotification(string, string2, NotificationType.INFORMATION);
                notification.notify(project2);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/prettierjs/codeStyle/PrettierCodeStyleStatusBarUIContributor$OpenSettingsDialogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.prettierJS"})
    private static final class OpenSettingsDialogAction
    extends DumbAwareAction {
        public OpenSettingsDialogAction() {
            super(PrettierBundle.message("prettier.action.open.settings.label", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ShowSettingsUtilImpl.Companion.showSettingsDialog(e.getProject(), "settings.javascript.prettier", "Prettier");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/prettierjs/codeStyle/PrettierCodeStyleStatusBarUIContributor$ReEnableAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "project", "Lcom/intellij/openapi/project/Project;", "notification", "Lcom/intellij/notification/Notification;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/notification/Notification;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.prettierJS"})
    private static final class ReEnableAction
    extends DumbAwareAction {
        @NotNull
        private final Project project;
        @NotNull
        private final Notification notification;

        public ReEnableAction(@NotNull Project project, @NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            super(PrettierBundle.message("prettier.action.reenable.label", new Object[0]));
            this.project = project;
            this.notification = notification;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PrettierConfiguration.getInstance((Project)this.project).getState().codeStyleSettingsModifierEnabled = true;
            CodeStyleSettingsManager.getInstance((Project)this.project).notifyCodeStyleSettingsChanged();
            this.notification.expire();
        }
    }
}

