/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.ssh.config.unified.SshConfig;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SshConnectionProvider;
import com.jetbrains.plugins.remotesdk.console.NonSpecifiedRemoteConnector;
import com.jetbrains.plugins.remotesdk.console.SshConfigConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteConnectionUtil {
    public static List<RemoteConnector> getUniqueRemoteConnectors(@Nullable Project project) {
        HashMap remoteConnectors = Maps.newHashMap();
        List<RemoteConnector> allRemoteConnectors = RemoteConnectionUtil.getAllRemoteConnectors(project);
        for (RemoteConnector connector : allRemoteConnectors) {
            remoteConnectors.put(connector.getConnectorKey(), connector);
        }
        ArrayList<RemoteConnector> result = new ArrayList<RemoteConnector>();
        result.add(NonSpecifiedRemoteConnector.INSTANCE);
        result.addAll(remoteConnectors.values());
        return result;
    }

    public static List<RemoteConnector> getSortedUniqueRemoteConnectors(@Nullable Project project) {
        return RemoteConnectionUtil.sort(RemoteConnectionUtil.getUniqueRemoteConnectors(project));
    }

    public static List<RemoteConnector> getAllRemoteConnectors(@Nullable Project project) {
        ArrayList<RemoteConnector> result = new ArrayList<RemoteConnector>();
        result.addAll(RemoteConnectionUtil.collectSshConfigs(project));
        result.addAll(RemoteConnectionUtil.collectAdditionalInterpreters());
        return result;
    }

    private static List<RemoteConnector> collectAdditionalInterpreters() {
        ArrayList<RemoteConnector> result = new ArrayList<RemoteConnector>();
        for (SshConnectionProvider provider : (SshConnectionProvider[])SshConnectionProvider.EP_NAME.getExtensions()) {
            result.addAll(provider.collectRemoteConnectors());
        }
        return result;
    }

    private static Collection<? extends RemoteConnector> collectSshConfigs(@Nullable Project project) {
        ArrayList<SshConfigConnector> result = new ArrayList<SshConfigConnector>();
        for (SshConfig config : RemoteSdkUtil.getSshConfigList(project)) {
            result.add(new SshConfigConnector(config));
        }
        return result;
    }

    @NotNull
    private static List<RemoteConnector> sort(@NotNull List<RemoteConnector> connectors) {
        if (connectors == null) {
            RemoteConnectionUtil.$$$reportNull$$$0(0);
        }
        List<RemoteConnector> list = connectors.stream().sorted((c1, c2) -> {
            boolean noneType2;
            boolean noneType1 = c1.getType() == RemoteConnectionType.NONE;
            boolean bl = noneType2 = c2.getType() == RemoteConnectionType.NONE;
            if (noneType1 != noneType2) {
                return noneType1 ? -1 : 1;
            }
            return c1.getName().compareTo(c2.getName());
        }).toList();
        if (list == null) {
            RemoteConnectionUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/console/RemoteConnectionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/console/RemoteConnectionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "sort";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

