/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.columns;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup;
import org.jetbrains.kotlinx.dataframe.columns.ColumnKind;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnResolutionContext;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.FrameColumn;
import org.jetbrains.kotlinx.dataframe.impl.columns.ColumnWithParent;
import org.jetbrains.kotlinx.dataframe.impl.columns.DataColumnInternal;
import org.jetbrains.kotlinx.dataframe.impl.columns.DataColumnInternalKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.ResolvingFrameColumn;
import org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00042\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0005B\u001f\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0017\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0096\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u0096\u0001J\u0011\u0010\u001c\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0003H\u0096\u0001J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0096\u0001J\u0013\u0010\u001e\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"H\u0016J\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010$\u001a\u00020\u001bH\u0096\u0003J)\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030%2\u0006\u0010&\u001a\u00020\u001b2\n\u0010'\u001a\u00020(\"\u00020\u001bH\u0096\u0003J\u0019\u0010#\u001a\n\u0012\u0002\b\u00030)j\u0002`*2\u0006\u0010+\u001a\u00020,H\u0096\u0003J\u001d\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0.H\u0096\u0003J\u001d\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030)2\u0006\u0010/\u001a\u000200H\u0096\u0003J\u001f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u000e\u00101\u001a\n\u0012\u0002\b\u000302j\u0002`3H\u0096\u0003J+\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030)2\b\u00105\u001a\u0004\u0018\u00010 2\n\u00106\u001a\u0006\u0012\u0002\b\u000307H\u0096\u0003J\u001f\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u000e\u00101\u001a\n\u0012\u0002\b\u000302j\u0002`3H\u0096\u0001J!\u00108\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00032\u000e\u00101\u001a\n\u0012\u0002\b\u000302j\u0002`3H\u0096\u0001J\t\u00109\u001a\u00020\u0018H\u0096\u0001J\b\u0010:\u001a\u00020\u001bH\u0016J\u0015\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030<H\u0096\u0003J\t\u0010=\u001a\u00020>H\u0096\u0001J\t\u0010?\u001a\u00020,H\u0096\u0001J\b\u0010@\u001a\u00020AH\u0016J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010C\u001a\u00020,H\u0016J\"\u0010D\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030F0E2\u0006\u0010G\u001a\u00020HH\u0016J\u001e\u0010I\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0003\u0018\u00010F2\u0006\u0010G\u001a\u00020HH\u0016J\t\u0010J\u001a\u00020\u001bH\u0096\u0001J\u0015\u0010K\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030EH\u0096\u0001J\u0015\u0010L\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030MH\u0096\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u0096\u0001J\u0015\u0010N\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030.H\u0096\u0001R\u0018\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006O"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/columns/FrameColumnWithParent;", "T", "Lorg/jetbrains/kotlinx/dataframe/impl/columns/ColumnWithParent;", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/columns/FrameColumn;", "Lorg/jetbrains/kotlinx/dataframe/impl/columns/DataColumnInternal;", "parent", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnGroup;", "source", "(Lorg/jetbrains/kotlinx/dataframe/columns/ColumnGroup;Lorg/jetbrains/kotlinx/dataframe/columns/FrameColumn;)V", "getParent", "()Lorg/jetbrains/kotlinx/dataframe/columns/ColumnGroup;", "schema", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "getSchema", "()Lkotlin/Lazy;", "getSource", "()Lorg/jetbrains/kotlinx/dataframe/columns/FrameColumn;", "addParent", "changeType", "type", "Lkotlin/reflect/KType;", "contains", "", "value", "countDistinct", "", "defaultValue", "distinct", "equals", "other", "", "forceResolve", "Lorg/jetbrains/kotlinx/dataframe/impl/columns/ResolvingFrameColumn;", "get", "index", "Lorg/jetbrains/kotlinx/dataframe/columns/BaseColumn;", "firstIndex", "otherIndices", "", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "columnName", "", "indices", "", "range", "Lkotlin/ranges/IntRange;", "row", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lorg/jetbrains/kotlinx/dataframe/AnyRow;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "getValueOrNull", "hasNulls", "hashCode", "iterator", "", "kind", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "name", "path", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "rename", "newName", "resolve", "", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "context", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnResolutionContext;", "resolveSingle", "size", "toList", "toSet", "", "values", "core"})
public final class FrameColumnWithParent<T>
implements ColumnWithParent<DataFrame<? extends T>>,
FrameColumn<T>,
DataColumnInternal<DataFrame<? extends T>> {
    @NotNull
    private final ColumnGroup<?> parent;
    @NotNull
    private final FrameColumn<T> source;

    public FrameColumnWithParent(@NotNull ColumnGroup<?> parent, @NotNull FrameColumn<? extends T> source) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter(source, (String)"source");
        this.parent = parent;
        this.source = source;
    }

    @NotNull
    public ColumnGroup<?> getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public FrameColumn<T> getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public Lazy<DataFrameSchema> getSchema() {
        return this.source.getSchema();
    }

    @Override
    public boolean contains(@NotNull DataFrame<? extends T> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.source.contains(value);
    }

    @Override
    public int countDistinct() {
        return this.source.countDistinct();
    }

    @Override
    @Nullable
    public DataFrame<T> defaultValue() {
        return (DataFrame)this.source.defaultValue();
    }

    @Override
    @NotNull
    public FrameColumn<T> distinct() {
        return this.source.distinct();
    }

    @Override
    @NotNull
    public DataFrame<T> get(int index) {
        return (DataFrame)this.source.get(index);
    }

    @Override
    @NotNull
    public BaseColumn<DataFrame<T>> get(int firstIndex, int ... otherIndices) {
        Intrinsics.checkNotNullParameter((Object)otherIndices, (String)"otherIndices");
        return this.source.get(firstIndex, otherIndices);
    }

    @Override
    @NotNull
    public DataColumn<?> get(@NotNull String columnName) {
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        return this.source.get(columnName);
    }

    @Override
    @NotNull
    public FrameColumn<T> get(@NotNull Iterable<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        return this.source.get(indices);
    }

    @Override
    @NotNull
    public DataColumn<DataFrame<T>> get(@NotNull IntRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this.source.get(range);
    }

    @Override
    @NotNull
    public DataFrame<T> get(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return (DataFrame)this.source.get(row);
    }

    @Override
    @NotNull
    public DataColumn<DataFrame<T>> getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return this.source.getValue(thisRef, property);
    }

    @Override
    @NotNull
    public DataFrame<T> getValue(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return (DataFrame)this.source.getValue(row);
    }

    @Override
    @Nullable
    public DataFrame<T> getValueOrNull(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return (DataFrame)this.source.getValueOrNull(row);
    }

    @Override
    public boolean hasNulls() {
        return this.source.hasNulls();
    }

    @Override
    @NotNull
    public Iterator<DataFrame<T>> iterator() {
        return this.source.iterator();
    }

    @Override
    @NotNull
    public ColumnKind kind() {
        return this.source.kind();
    }

    @Override
    @NotNull
    public String name() {
        return this.source.name();
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    @NotNull
    public List<DataFrame<T>> toList() {
        return this.source.toList();
    }

    @Override
    @NotNull
    public Set<DataFrame<T>> toSet() {
        return this.source.toSet();
    }

    @Override
    @NotNull
    public KType type() {
        return this.source.type();
    }

    @Override
    @NotNull
    public Iterable<DataFrame<T>> values() {
        return this.source.values();
    }

    public boolean equals(@Nullable Object other) {
        return UtilsKt.checkEquals(this.getSource(), other);
    }

    public int hashCode() {
        return this.getSource().hashCode();
    }

    @Override
    @NotNull
    public ColumnPath path() {
        return ColumnWithParent.DefaultImpls.path(this);
    }

    @Override
    @NotNull
    public List<ColumnWithPath<DataFrame<T>>> resolve(@NotNull ColumnResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ColumnWithParent.DefaultImpls.resolve(this, context);
    }

    @Override
    @Nullable
    public ColumnWithPath<DataFrame<T>> resolveSingle(@NotNull ColumnResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ColumnWithParent.DefaultImpls.resolveSingle(this, context);
    }

    @Override
    @NotNull
    public ResolvingFrameColumn<T> forceResolve() {
        return new ResolvingFrameColumn(this);
    }

    @Override
    @NotNull
    public FrameColumnWithParent<T> changeType(@NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new FrameColumnWithParent((ColumnGroup<?>)this.getParent(), TypeConversionsKt.asFrameColumn(DataColumnInternalKt.internal((DataColumn)this.getSource()).changeType(type)));
    }

    @Override
    @NotNull
    public FrameColumnWithParent<T> addParent(@NotNull ColumnGroup<?> parent) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        return new FrameColumnWithParent<T>(parent, this.getSource());
    }

    @Override
    @NotNull
    public FrameColumnWithParent<T> rename(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return new FrameColumnWithParent((ColumnGroup<?>)this.getParent(), this.getSource().rename(newName));
    }
}

