/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.codeGen.DefaultReadDfMethod;
import org.jetbrains.kotlinx.dataframe.codeGen.DefaultReadTsvMethod;
import org.jetbrains.kotlinx.dataframe.io.SupportedDataFrameFormat;
import org.jetbrains.kotlinx.dataframe.io.SupportedFormatSample;
import org.jetbrains.kotlinx.dataframe.io.TsvKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0016J&\u0010\u0011\u001a\n\u0012\u0002\b\u00030\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0017H\u0016J&\u0010\u0011\u001a\n\u0012\u0002\b\u00030\u0012j\u0002`\u00132\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/TSV;", "Lorg/jetbrains/kotlinx/dataframe/io/SupportedDataFrameFormat;", "()V", "testOrder", "", "getTestOrder", "()I", "acceptsExtension", "", "ext", "", "acceptsSample", "sample", "Lorg/jetbrains/kotlinx/dataframe/io/SupportedFormatSample;", "createDefaultReadMethod", "Lorg/jetbrains/kotlinx/dataframe/codeGen/DefaultReadDfMethod;", "pathRepresentation", "readDataFrame", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "file", "Ljava/io/File;", "header", "", "stream", "Ljava/io/InputStream;", "core"})
public final class TSV
implements SupportedDataFrameFormat {
    private final int testOrder;

    public TSV() {
        this.testOrder = 30000;
    }

    @Override
    @NotNull
    public DataFrame<?> readDataFrame(@NotNull InputStream stream, @NotNull List<String> header) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        return TsvKt.readTSV$default(DataFrame.Companion, stream, header, false, null, 0, null, false, null, null, 508, null);
    }

    @Override
    @NotNull
    public DataFrame<?> readDataFrame(@NotNull File file, @NotNull List<String> header) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        return TsvKt.readTSV$default(DataFrame.Companion, file, header, null, 0, null, false, null, 124, null);
    }

    @Override
    public boolean acceptsExtension(@NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        return Intrinsics.areEqual((Object)ext, (Object)"tsv");
    }

    @Override
    public boolean acceptsSample(@NotNull SupportedFormatSample sample) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        return true;
    }

    @Override
    public int getTestOrder() {
        return this.testOrder;
    }

    @Override
    @NotNull
    public DefaultReadDfMethod createDefaultReadMethod(@Nullable String pathRepresentation) {
        return new DefaultReadTsvMethod(pathRepresentation);
    }
}

