/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.cython.types;

import com.intellij.psi.PsiElement;
import com.intellij.python.pro.cython.types.CythonBuiltinType;
import com.intellij.python.pro.cython.types.CythonStructType;
import com.intellij.python.pro.cython.types.CythonType;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeCheckerExtension;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CythonTypeChecker
implements PyTypeCheckerExtension {
    @NotNull
    public Optional<Boolean> match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context, @NotNull PyTypeChecker.GenericSubstitutions substitutions) {
        if (context == null) {
            CythonTypeChecker.$$$reportNull$$$0(0);
        }
        if (substitutions == null) {
            CythonTypeChecker.$$$reportNull$$$0(1);
        }
        PyType newExpected = CythonTypeChecker.convert(expected, context);
        PyType newActual = CythonTypeChecker.convert(actual, context);
        if (newActual instanceof CythonType && newExpected instanceof CythonType) {
            Optional<Boolean> optional = CythonTypeChecker.matchCythonTypes((CythonType)newExpected, (CythonType)newActual);
            if (optional == null) {
                CythonTypeChecker.$$$reportNull$$$0(2);
            }
            return optional;
        }
        Optional<Boolean> optional = newExpected != expected || newActual != actual ? Optional.of(PyTypeChecker.match((PyType)newExpected, (PyType)newActual, (TypeEvalContext)context, (PyTypeChecker.GenericSubstitutions)substitutions)) : Optional.empty();
        if (optional == null) {
            CythonTypeChecker.$$$reportNull$$$0(3);
        }
        return optional;
    }

    private static Optional<Boolean> matchCythonTypes(@NotNull CythonType expected, @NotNull CythonType actual) {
        if (expected == null) {
            CythonTypeChecker.$$$reportNull$$$0(4);
        }
        if (actual == null) {
            CythonTypeChecker.$$$reportNull$$$0(5);
        }
        return Optional.of(true);
    }

    @Nullable
    static PyType convertType(@NotNull CythonType type, @NotNull TypeEvalContext context) {
        if (type == null) {
            CythonTypeChecker.$$$reportNull$$$0(6);
        }
        if (context == null) {
            CythonTypeChecker.$$$reportNull$$$0(7);
        }
        PyBuiltinCache cache = PyBuiltinCache.getInstance((PsiElement)context.getOrigin());
        if (type instanceof CythonBuiltinType) {
            CythonBuiltinType builtin = (CythonBuiltinType)type;
            String baseName = builtin.getBaseName();
            if ("char".equals(baseName)) {
                if (builtin.isPointer()) {
                    return type;
                }
                return cache.getIntType();
            }
            if ("int".equals(baseName)) {
                return cache.getIntType();
            }
            if ("float".equals(baseName) || "double".equals(baseName)) {
                return cache.getFloatType();
            }
            if ("Py_ssize_t".equals(baseName) || "ssize_t".equals(baseName) || "size_t".equals(baseName)) {
                return cache.getIntType();
            }
        } else if (type instanceof CythonStructType) {
            return type;
        }
        return type;
    }

    @Nullable
    private static PyType convert(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            CythonTypeChecker.$$$reportNull$$$0(8);
        }
        if (type instanceof CythonType) {
            return CythonTypeChecker.convertType((CythonType)type, context);
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutions";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pro/cython/types/CythonTypeChecker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pro/cython/types/CythonTypeChecker";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "match";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matchCythonTypes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

