/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.utils;

import com.intellij.openapi.application.PathManager;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.LocalEelApi;
import com.intellij.sh.ShLanguage;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sh/utils/ExternalServicesUtil;", "", "<init>", "()V", "computeDownloadPath", "Ljava/nio/file/Path;", "eel", "Lcom/intellij/platform/eel/EelApi;", "intellij.sh.core"})
public final class ExternalServicesUtil {
    @NotNull
    public static final ExternalServicesUtil INSTANCE = new ExternalServicesUtil();

    private ExternalServicesUtil() {
    }

    @JvmStatic
    @NotNull
    public static final Path computeDownloadPath(@NotNull EelApi eel) {
        Intrinsics.checkNotNullParameter((Object)eel, (String)"eel");
        Path basePath = Path.of(PathManager.getPluginsPath(), new String[0]).resolve(ShLanguage.INSTANCE.getID());
        if (eel instanceof LocalEelApi) {
            Path path = basePath;
            Intrinsics.checkNotNull((Object)path);
            return path;
        }
        EelPlatform platform = eel.getPlatform();
        if (EelPlatformKt.isMac((EelPlatform)platform)) {
            basePath = basePath.resolve("mac");
        } else if (EelPlatformKt.isLinux((EelPlatform)platform)) {
            basePath = basePath.resolve("linux");
        } else if (EelPlatformKt.isWindows((EelPlatform)platform)) {
            basePath = basePath.resolve("windows");
        } else if (EelPlatformKt.isFreeBSD((EelPlatform)platform)) {
            basePath = basePath.resolve("freebsd");
        }
        if (EelPlatformKt.isX86_64((EelPlatform)platform)) {
            basePath = basePath.resolve("amd64");
        } else if (EelPlatformKt.isX86((EelPlatform)platform)) {
            basePath = basePath.resolve("i386");
        } else if (EelPlatformKt.isArm64((EelPlatform)platform)) {
            basePath = basePath.resolve("arm64");
        }
        Path path = basePath;
        Intrinsics.checkNotNull((Object)path);
        return path;
    }
}

