/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemoteCloseable;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.FileBlob;
import com.intellij.database.remote.jdbc.impl.FileClob;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HiveJdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> typesWithScale = new HashSet<String>(Arrays.asList("decimal", "varchar", "char", "numeric"));

    public HiveJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("HIVE", version, connection, jdbcClassLoader);
    }

    public HiveJdbcHelper() {
        this(null, null, null);
    }

    private HiveJdbcHelper(@NotNull HiveJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            HiveJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcClassLoader == null) {
            HiveJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return HiveJdbcHelper.extractVersion(version);
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper, @Nullable ClassLoader jdbcClassLoader) {
        if (!JdbcNativeUtil.detectString(product, "Hive")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return HiveJdbcHelper.create(delegate, productVer, jdbcClassLoader);
    }

    @NotNull
    private static JdbcHelperImpl create(@Nullable Connection delegate, @Nullable String productVer, @Nullable ClassLoader jdbcClassLoader) {
        JdbcNativeUtil.logInfo("release_version: " + productVer);
        return new HiveJdbcHelper(HiveJdbcHelper.extractVersion(productVer), delegate, jdbcClassLoader);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new HiveJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    public boolean supportsCalendarInPreparedStatement() {
        return false;
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            HiveJdbcHelper.$$$reportNull$$$0(2);
        }
        if (e.typeName != null) {
            e.typeName = e.typeName.toLowerCase(Locale.ENGLISH);
        }
        if (!typesWithScale.contains(e.typeName)) {
            e.scale = -1;
            e.length = -1;
        }
    }

    @Override
    public String fixColumnLabel(String columnLabel) {
        int dotPos = columnLabel.indexOf(46);
        if (dotPos == -1) {
            return columnLabel;
        }
        return columnLabel.substring(dotPos + 1);
    }

    @Override
    protected void setTimestamp(@NotNull RemotePreparedStatement statement, int idx, Timestamp timestamp) throws Exception {
        if (statement == null) {
            HiveJdbcHelper.$$$reportNull$$$0(3);
        }
        statement.setTimestamp(idx, timestamp);
    }

    @Override
    @Nullable
    public RemoteCloseable setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            HiveJdbcHelper.$$$reportNull$$$0(4);
        }
        if (columnInfo == null) {
            HiveJdbcHelper.$$$reportNull$$$0(5);
        }
        int type = columnInfo.getType();
        if (value == null) {
            statement.setNull(idx, type);
        } else if (value instanceof LobInfo.FileBlobInfo) {
            LobInfo.FileBlobInfo info = (LobInfo.FileBlobInfo)value;
            statement.setObject(idx, new FileBlob(info.file));
        } else if (value instanceof LobInfo.FileClobInfo) {
            LobInfo.FileClobInfo info = (LobInfo.FileClobInfo)value;
            statement.setObject(idx, new FileClob(info.file, info.charset));
        } else if (value instanceof LobInfo.BlobInfo) {
            statement.setObject(idx, ((LobInfo.BlobInfo)value).data);
        } else if (value instanceof byte[]) {
            statement.setBinaryStream(idx, new ByteArrayInputStream((byte[])value));
        } else if (type == -5 && value instanceof BigInteger) {
            statement.setObject(idx, value);
        } else {
            return super.setStatementParameter(statement, value, columnInfo, needsEscaping, idx);
        }
        return null;
    }

    @Override
    public int getType(@NotNull ResultSet delegate) {
        if (delegate == null) {
            HiveJdbcHelper.$$$reportNull$$$0(6);
        }
        return 1003;
    }

    @Override
    public char getEscapeChar() {
        return '\\';
    }

    @Override
    @NotNull
    protected String getCharsToEscape() {
        return "%_\\";
    }

    @Override
    public int fixUpdateCount(int update) {
        if (update == 0) {
            return -2;
        }
        return update;
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            HiveJdbcHelper.$$$reportNull$$$0(7);
        }
        return new HiveJdbcHelper(this, jdbcClassLoader);
    }

    @Override
    protected Object fixRowObject(Object object, ResultSetMetaData metaData, int i) throws SQLException {
        if (metaData.getColumnType(i) == 6 && object instanceof Double) {
            return Float.valueOf(((Double)object).floatValue());
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/HiveJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setTimestamp";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setStatementParameter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

