/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.visualEditing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.swagger.core.visualEditing.SwEditorMouseEvent;
import com.intellij.swagger.core.visualEditing.utils.SwIntervalTreeBlockingHolder;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0010\u0018\u0000 $2\u00020\u0001:\u0002$%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u0016\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010#\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR/\u0010\u000f\u001a#\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00130\u00130\u0010\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/swagger/core/visualEditing/SwVisualEditingActionsService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "_mouseEventsFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/swagger/core/visualEditing/SwEditorMouseEvent;", "mouseEvents", "Lkotlinx/coroutines/flow/SharedFlow;", "getMouseEvents", "()Lkotlinx/coroutines/flow/SharedFlow;", "lineRangesTreeStorage", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/swagger/core/visualEditing/SwVisualEditingActionsService$DocumentAndTimestamp;", "kotlin.jvm.PlatformType", "Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTreeBlockingHolder;", "Lorg/jetbrains/annotations/NotNull;", "getOrCreateIntervalTree", "document", "Lcom/intellij/openapi/editor/Document;", "getUpToDateIntervalTreeOrNull", "disposeOutdatedTrees", "", "createTree", "key", "mouseOverEditorLine", "editor", "Lcom/intellij/openapi/editor/Editor;", "line", "", "mouseExitedEditor", "dispose", "Companion", "DocumentAndTimestamp", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwVisualEditingActionsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwVisualEditingActionsService.kt\ncom/intellij/swagger/core/visualEditing/SwVisualEditingActionsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n774#2:70\n865#2,2:71\n1869#2,2:73\n*S KotlinDebug\n*F\n+ 1 SwVisualEditingActionsService.kt\ncom/intellij/swagger/core/visualEditing/SwVisualEditingActionsService\n*L\n43#1:70\n43#1:71,2\n44#1:73,2\n*E\n"})
public class SwVisualEditingActionsService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @JvmField
    @NotNull
    public final CoroutineScope coroutineScope;
    @NotNull
    private final MutableSharedFlow<SwEditorMouseEvent> _mouseEventsFlow;
    @NotNull
    private final SharedFlow<SwEditorMouseEvent> mouseEvents;
    @NotNull
    private final ConcurrentMap<DocumentAndTimestamp, SwIntervalTreeBlockingHolder> lineRangesTreeStorage;

    public SwVisualEditingActionsService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this._mouseEventsFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        this.mouseEvents = FlowKt.asSharedFlow(this._mouseEventsFlow);
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.create(arg_0 -> SwVisualEditingActionsService.lineRangesTreeStorage$lambda$0((Function1)new Function1<DocumentAndTimestamp, SwIntervalTreeBlockingHolder>((Object)this){

            public final SwIntervalTreeBlockingHolder invoke(DocumentAndTimestamp p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SwVisualEditingActionsService.access$createTree((SwVisualEditingActionsService)this.receiver, p0);
            }
        }, arg_0), ConcurrentHashMap::new);
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"create(...)");
        this.lineRangesTreeStorage = concurrentMap;
    }

    @NotNull
    public SharedFlow<SwEditorMouseEvent> getMouseEvents() {
        return this.mouseEvents;
    }

    @NotNull
    public final SwIntervalTreeBlockingHolder getOrCreateIntervalTree(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Object v = this.lineRangesTreeStorage.get(new DocumentAndTimestamp(document, document.getModificationStamp()));
        Intrinsics.checkNotNull(v);
        return (SwIntervalTreeBlockingHolder)v;
    }

    @Nullable
    public final SwIntervalTreeBlockingHolder getUpToDateIntervalTreeOrNull(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        DocumentAndTimestamp key = new DocumentAndTimestamp(document, document.getModificationStamp());
        return this.lineRangesTreeStorage.containsKey(key) ? (SwIntervalTreeBlockingHolder)this.lineRangesTreeStorage.get(key) : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void disposeOutdatedTrees(@NotNull Document document) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Iterable $this$filter$iv = this.lineRangesTreeStorage.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DocumentAndTimestamp maybeOutdatedKey = (DocumentAndTimestamp)element$iv$iv;
            boolean bl = false;
            if (!(document.getModificationStamp() > maybeOutdatedKey.getTimestamp())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        ConcurrentMap<DocumentAndTimestamp, SwIntervalTreeBlockingHolder> concurrentMap = this.lineRangesTreeStorage;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentAndTimestamp p0 = (DocumentAndTimestamp)element$iv;
            boolean bl = false;
            concurrentMap.remove(p0);
        }
    }

    private final SwIntervalTreeBlockingHolder createTree(DocumentAndTimestamp key) {
        return new SwIntervalTreeBlockingHolder(0, key.getDocument().getLineCount() - 1);
    }

    public final void mouseOverEditorLine(@NotNull Editor editor, int line) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this._mouseEventsFlow.tryEmit((Object)new SwEditorMouseEvent.HoverLine(editor, line));
    }

    public final void mouseExitedEditor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this._mouseEventsFlow.tryEmit((Object)new SwEditorMouseEvent.ExitEditorArea(editor));
    }

    public void dispose() {
    }

    private static final SwIntervalTreeBlockingHolder lineRangesTreeStorage$lambda$0(Function1 $tmp0, Object p0) {
        return (SwIntervalTreeBlockingHolder)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ SwIntervalTreeBlockingHolder access$createTree(SwVisualEditingActionsService $this, DocumentAndTimestamp key) {
        return $this.createTree(key);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/swagger/core/visualEditing/SwVisualEditingActionsService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/swagger/core/visualEditing/SwVisualEditingActionsService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.swagger.core"})
    @SourceDebugExtension(value={"SMAP\nSwVisualEditingActionsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwVisualEditingActionsService.kt\ncom/intellij/swagger/core/visualEditing/SwVisualEditingActionsService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,69:1\n30#2,2:70\n*S KotlinDebug\n*F\n+ 1 SwVisualEditingActionsService.kt\ncom/intellij/swagger/core/visualEditing/SwVisualEditingActionsService$Companion\n*L\n26#1:70,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SwVisualEditingActionsService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SwVisualEditingActionsService> serviceClass$iv = SwVisualEditingActionsService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SwVisualEditingActionsService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/swagger/core/visualEditing/SwVisualEditingActionsService$DocumentAndTimestamp;", "", "document", "Lcom/intellij/openapi/editor/Document;", "timestamp", "", "<init>", "(Lcom/intellij/openapi/editor/Document;J)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getTimestamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.swagger.core"})
    private static final class DocumentAndTimestamp {
        @NotNull
        private final Document document;
        private final long timestamp;

        public DocumentAndTimestamp(@NotNull Document document, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            this.document = document;
            this.timestamp = timestamp;
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final Document component1() {
            return this.document;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final DocumentAndTimestamp copy(@NotNull Document document, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            return new DocumentAndTimestamp(document, timestamp);
        }

        public static /* synthetic */ DocumentAndTimestamp copy$default(DocumentAndTimestamp documentAndTimestamp, Document document, long l, int n, Object object) {
            if ((n & 1) != 0) {
                document = documentAndTimestamp.document;
            }
            if ((n & 2) != 0) {
                l = documentAndTimestamp.timestamp;
            }
            return documentAndTimestamp.copy(document, l);
        }

        @NotNull
        public String toString() {
            return "DocumentAndTimestamp(document=" + this.document + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int result2 = this.document.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.timestamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DocumentAndTimestamp)) {
                return false;
            }
            DocumentAndTimestamp documentAndTimestamp = (DocumentAndTimestamp)other;
            if (!Intrinsics.areEqual((Object)this.document, (Object)documentAndTimestamp.document)) {
                return false;
            }
            return this.timestamp == documentAndTimestamp.timestamp;
        }
    }
}

