/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.codeInsight;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Ordering;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.python.documentation.PythonDocumentationLinkProvider;
import com.jetbrains.python.documentation.PythonDocumentationMap;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public final class DjangoDocumentationLinkProvider
implements PythonDocumentationLinkProvider {
    private static final Logger LOG = Logger.getInstance(DjangoDocumentationLinkProvider.class);
    private static final Map<String, String> urlMap = new ImmutableSortedMap.Builder((Comparator)Ordering.from((o1, o2) -> -o1.compareTo((String)o2))).put((Object)"django.apps", (Object)"ref/applications").put((Object)"django.conf.urls", (Object)"ref/urls").put((Object)"django.urls.conf", (Object)"ref/urls").put((Object)"django.conf.urls.i18n", (Object)"topics/i18n/translation").put((Object)"django.views.i18n", (Object)"topics/i18n/translation").put((Object)"django.contrib.admin", (Object)"ref/contrib/admin/index").put((Object)"django.contrib.admindocs", (Object)"ref/contrib/admin/admindocs").put((Object)"django.contrib.auth", (Object)"topics/auth/index").put((Object)"django.contrib.auth.backends", (Object)"ref/contrib/auth").put((Object)"django.contrib.auth.signals", (Object)"ref/contrib/auth").put((Object)"django.contrib.auth.forms", (Object)"topics/auth/default").put((Object)"django.contrib.auth.views", (Object)"topics/auth/default").put((Object)"django.contrib.auth.hashers", (Object)"topics/auth/passwords").put((Object)"django.contrib.auth.password_validation", (Object)"topics/auth/passwords").put((Object)"django.contrib.auth.middleware", (Object)"ref/middleware").put((Object)"django.contrib.messages.middleware", (Object)"ref/middleware").put((Object)"django.contrib.sessions.middleware", (Object)"ref/middleware").put((Object)"django.contrib.sites.middleware", (Object)"ref/middleware").put((Object)"django.middleware", (Object)"ref/middleware").put((Object)"django.middleware.cache", (Object)"ref/middleware").put((Object)"django.middleware.common", (Object)"ref/middleware").put((Object)"django.middleware.gzip", (Object)"ref/middleware").put((Object)"django.middleware.http", (Object)"ref/middleware").put((Object)"django.middleware.locale", (Object)"ref/middleware").put((Object)"django.middleware.security", (Object)"ref/middleware").put((Object)"django.contrib.contenttypes", (Object)"ref/contrib/contenttypes").put((Object)"django.contrib.flatpages", (Object)"ref/contrib/flatpages").put((Object)"django.contrib.gis", (Object)"ref/contrib/gis/index").put((Object)"django.contrib.gis.admin", (Object)"ref/contrib/gis/admin").put((Object)"django.contrib.gis.db.backends", (Object)"ref/contrib/gis/db-api").put((Object)"django.contrib.gis.db.models", (Object)"ref/contrib/gis/model-api").put((Object)"django.contrib.gis.db.models.functions", (Object)"ref/contrib/gis/functions").put((Object)"django.contrib.gis.feeds", (Object)"ref/contrib/gis/feeds").put((Object)"django.contrib.gis.forms", (Object)"ref/contrib/gis/forms-api").put((Object)"django.contrib.gis.gdal", (Object)"ref/contrib/gis/gdal").put((Object)"django.contrib.gis.geoip2", (Object)"ref/contrib/gis/geoip2").put((Object)"django.contrib.gis.geos", (Object)"ref/contrib/gis/geos").put((Object)"django.contrib.gis.measure", (Object)"ref/contrib/gis/measure").put((Object)"django.contrib.gis.serializers.geojson", (Object)"ref/contrib/gis/serializers").put((Object)"django.contrib.gis.utils", (Object)"ref/contrib/gis/utils").put((Object)"django.contrib.gis.utils.layermapping", (Object)"ref/contrib/gis/layermapping").put((Object)"django.contrib.gis.utils.ogrinspect", (Object)"ref/contrib/gis/ogrinspect").put((Object)"django.contrib.humanize", (Object)"ref/contrib/humanize").put((Object)"django.contrib.messages", (Object)"ref/contrib/messages").put((Object)"django.contrib.postgres", (Object)"ref/contrib/postgres/index").put((Object)"django.contrib.postgres.aggregates", (Object)"ref/contrib/postgres/aggregates").put((Object)"django.contrib.postgres.constraints", (Object)"ref/contrib/postgres/constraints").put((Object)"django.contrib.postgres.expressions", (Object)"ref/contrib/postgres/expressions").put((Object)"django.contrib.postgres.indexes", (Object)"ref/contrib/postgres/indexes").put((Object)"django.contrib.postgres.validators", (Object)"ref/contrib/postgres/validators").put((Object)"django.contrib.redirects", (Object)"ref/contrib/redirects").put((Object)"django.contrib.sessions", (Object)"topics/http/sessions").put((Object)"django.contrib.sitemaps", (Object)"ref/contrib/sitemaps").put((Object)"django.contrib.sites", (Object)"ref/contrib/sites").put((Object)"django.contrib.staticfiles", (Object)"ref/contrib/staticfiles").put((Object)"django.contrib.syndication", (Object)"ref/contrib/syndication").put((Object)"django.core.checks", (Object)"topics/checks").put((Object)"django.core.exceptions", (Object)"ref/exceptions").put((Object)"django.core.files", (Object)"ref/files/index").put((Object)"django.core.files.storage", (Object)"ref/files/storage").put((Object)"django.core.files.uploadedfile", (Object)"ref/files/uploads").put((Object)"django.core.files.uploadhandler", (Object)"ref/files/uploads").put((Object)"django.core.mail", (Object)"topics/email").put((Object)"django.core.management", (Object)"howto/custom-management-commands").put((Object)"django.core.paginator", (Object)"ref/paginator").put((Object)"django.core.signals", (Object)"ref/signals").put((Object)"django.db.backends", (Object)"ref/signals").put((Object)"django.db.models.signals", (Object)"ref/signals").put((Object)"django.test.signals", (Object)"ref/signals").put((Object)"django.core.signing", (Object)"topics/signing").put((Object)"django.core.validators", (Object)"ref/validators").put((Object)"django.db", (Object)"topics/db/index").put((Object)"django.db.backends.base.schema", (Object)"ref/schema-editor").put((Object)"django.db.migrations", (Object)"topics/migrations").put((Object)"django.db.migrations.operations", (Object)"ref/migration-operations").put((Object)"django.db.models", (Object)"topics/db/models").put((Object)"django.db.models.constraints", (Object)"ref/models/constraints").put((Object)"django.db.models.fields", (Object)"ref/models/fields").put((Object)"django.db.models.fields.json", (Object)"topics/db/queries").put((Object)"django.db.models.functions", (Object)"ref/models/database-functions").put((Object)"django.db.models.indexes", (Object)"ref/models/indexes").put((Object)"django.db.models.lookups", (Object)"ref/models/lookups").put((Object)"django.db.models.options", (Object)"ref/models/meta").put((Object)"django.db.transaction", (Object)"topics/db/transactions").put((Object)"django.dispatch", (Object)"topics/signals").put((Object)"django.forms", (Object)"ref/forms/api").put((Object)"django.forms.fields", (Object)"ref/forms/fields").put((Object)"django.forms.formsets", (Object)"ref/forms/formsets").put((Object)"django.forms.models", (Object)"ref/forms/models").put((Object)"django.forms.renderers", (Object)"ref/forms/renderers").put((Object)"django.forms.widgets", (Object)"ref/forms/widgets").put((Object)"django.http", (Object)"ref/request-response").put((Object)"django.middleware.clickjacking", (Object)"ref/clickjacking").put((Object)"django.middleware.csrf", (Object)"ref/csrf").put((Object)"django.views.decorators.csrf", (Object)"ref/csrf").put((Object)"django.shortcuts", (Object)"topics/http/shortcuts").put((Object)"django.template", (Object)"topics/templates").put((Object)"django.template.response", (Object)"ref/template-response").put((Object)"django.test", (Object)"topics/testing/overview").put((Object)"django.test.utils", (Object)"topics/testing/advanced").put((Object)"django.urls", (Object)"ref/urlresolvers").put((Object)"django.utils", (Object)"ref/utils").put((Object)"django.utils.log", (Object)"ref/logging").put((Object)"django.views", (Object)"ref/views").put((Object)"django.views.decorators.cache", (Object)"topics/http/decorators").put((Object)"django.views.decorators.common", (Object)"topics/http/decorators").put((Object)"django.views.decorators.gzip", (Object)"topics/http/decorators").put((Object)"django.views.decorators.http", (Object)"topics/http/decorators").put((Object)"django.views.decorators.vary", (Object)"topics/http/decorators").put((Object)"django.views.generic.dates", (Object)"ref/class-based-views/generic-date-based").put((Object)"django.views.generic.base", (Object)"ref/class-based-views/base").put((Object)"django.db.models.base", (Object)"topics/db/managers").put((Object)"django.views.generic.detail", (Object)"ref/class-based-views/mixins-single-object").build();
    public static final String DEFAULT_DOC_VERSION = "dev";
    private static final String DJANGO_BASE_URL = "https://docs.djangoproject.com/en/";

    @Nullable
    public String getExternalDocumentationUrl(PsiElement element, PsiElement originalElement) {
        if (PythonDocumentationMap.getInstance().getEntries().containsKey("django")) {
            return null;
        }
        PsiFile moduleAnchor = ((PsiElement)ObjectUtils.notNull((Object)originalElement, (Object)element)).getContainingFile();
        if (!(moduleAnchor instanceof PyFile)) {
            return null;
        }
        DjangoModelApi modelApi = (DjangoModelApi)DjangoModelApi.create((PyElement)((PyFile)moduleAnchor)).getSuccessOrNull();
        if (modelApi == null) {
            return null;
        }
        if (element instanceof PyTargetExpression && PyUtil.isTopLevel((PsiElement)element) && element.getContainingFile().getVirtualFile().equals(modelApi.getSettingsFile())) {
            @NonNls String name = ((PyTargetExpression)element).getName();
            if (name == null) {
                return null;
            }
            String elementId = "#" + name.toLowerCase().replace('_', '-');
            return DjangoDocumentationLinkProvider.getDjangoSettingsUrl((PyElement)element) + elementId;
        }
        QualifiedName qName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)element.getContainingFile());
        if (qName == null) {
            return null;
        }
        if (PythonDocumentationMap.getInstance().getEntries().containsKey(qName.toString())) {
            return null;
        }
        for (Map.Entry<String, String> entry : urlMap.entrySet()) {
            QualifiedName elementQName;
            if (!qName.matchesPrefix(QualifiedName.fromDottedString((String)entry.getKey()))) continue;
            String version = DjangoDocumentationLinkProvider.getDjangoDocVersion((PyElement)((PyFile)moduleAnchor));
            if (PyUtil.isInitMethod((PsiElement)element)) {
                element = ((PyFunction)element).getContainingClass();
            }
            if ((elementQName = PythonDocumentationProvider.getFullQualifiedName((PsiElement)element)) != null) {
                elementQName = QualifiedName.fromDottedString((String)elementQName.toString().replace("base.ModelBase", "Model"));
            }
            return DJANGO_BASE_URL + version + "/" + entry.getValue() + (String)(elementQName != null ? "#" + String.valueOf(elementQName) : "");
        }
        return null;
    }

    public @NotNull Function<Document, @NlsSafe String> quickDocExtractor(@NotNull PsiNamedElement namedElement) {
        if (namedElement == null) {
            DjangoDocumentationLinkProvider.$$$reportNull$$$0(0);
        }
        Function<Document, String> function = document -> {
            if (namedElement instanceof PyTargetExpression && PyUtil.isTopLevel((PsiElement)namedElement)) {
                PsiFile file = namedElement.getContainingFile();
                DjangoModelApi modelApi = (DjangoModelApi)DjangoModelApi.create((PyElement)((PyFile)file)).getSuccessOrNull();
                if (modelApi == null) {
                    return null;
                }
                if (file.getVirtualFile().equals(modelApi.getSettingsFile())) {
                    @NonNls String elementName = namedElement.getName();
                    if (elementName == null) {
                        return null;
                    }
                    String elementId = elementName.toLowerCase().replace('_', '-');
                    Element element = document.getElementById(elementId);
                    if (element == null) {
                        return null;
                    }
                    Element div = element.parent();
                    div.select("a.headerlink").remove();
                    div.select("h4").forEach(elem -> elem.prependChild((Node)new Element("br")));
                    div.select("a").forEach(elem -> {
                        String restoredLink;
                        String href = elem.attr("href");
                        try {
                            restoredLink = new URI(DjangoDocumentationLinkProvider.getDjangoSettingsUrl((PyElement)namedElement) + href).normalize().toString();
                        }
                        catch (URISyntaxException e) {
                            LOG.warn("Url normalization failed.", (Throwable)e);
                            restoredLink = "";
                        }
                        elem.attr("href", restoredLink);
                    });
                    return div.toString();
                }
            }
            return null;
        };
        if (function == null) {
            DjangoDocumentationLinkProvider.$$$reportNull$$$0(1);
        }
        return function;
    }

    private static String getDjangoSettingsUrl(PyElement element) {
        return DJANGO_BASE_URL + DjangoDocumentationLinkProvider.getDjangoDocVersion(element) + "/ref/settings/";
    }

    private static String getDjangoDocVersion(PyElement pyElement) {
        DjangoModelApi api = (DjangoModelApi)DjangoModelApi.create((PyElement)pyElement).getSuccessOrNull();
        if (api == null) {
            return DEFAULT_DOC_VERSION;
        }
        List parts = api.getDjangoVersionParts();
        if (parts == null || parts.size() < 2) {
            return DEFAULT_DOC_VERSION;
        }
        boolean dev = parts.size() >= 3 && ((String)parts.get(2)).startsWith(DEFAULT_DOC_VERSION);
        return dev ? DEFAULT_DOC_VERSION : String.format("%s.%s", parts.get(0), parts.get(1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/codeInsight/DjangoDocumentationLinkProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/codeInsight/DjangoDocumentationLinkProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "quickDocExtractor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "quickDocExtractor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

