/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc.wrappers;

import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ResultSetWrapper;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.util.Factory;
import com.intellij.util.containers.JBIterator;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClosableIt<T>
extends JBIterator<T>
implements Closeable {
    private static final ClosableIt<Object> EMPTY = new ClosableIt<Object>(){

        @Override
        public void close() {
        }

        protected Object nextImpl() {
            return this.stop();
        }
    };

    public static <T> ClosableIt<T> empty() {
        return EMPTY;
    }

    @NotNull
    public static <T> ClosableIt<T> from(final @NotNull Iterator<? extends T> it) {
        if (it == null) {
            ClosableIt.$$$reportNull$$$0(0);
        }
        if (it instanceof ClosableIt) {
            ClosableIt closableIt = (ClosableIt)((Object)it);
            if (closableIt == null) {
                ClosableIt.$$$reportNull$$$0(1);
            }
            return closableIt;
        }
        return new ClosableIt<T>(){

            @Override
            public void close() {
            }

            protected T nextImpl() {
                return it.hasNext() ? it.next() : this.stop();
            }
        };
    }

    @NotNull
    static <T> ClosableIt<T> generate(final @NotNull Factory<? extends ClosableIt<T>> next) {
        if (next == null) {
            ClosableIt.$$$reportNull$$$0(2);
        }
        return new LazyAppendableClosableIt<T>(null){

            @Override
            @Nullable
            protected ClosableIt<? extends T> nextIt() {
                return (ClosableIt)next.create();
            }
        };
    }

    @NotNull
    public static <T> ClosableIt<T> lazyAppend(@NotNull ClosableIt<? extends T> it1, final @NotNull Factory<? extends ClosableIt<T>> next) {
        if (it1 == null) {
            ClosableIt.$$$reportNull$$$0(3);
        }
        if (next == null) {
            ClosableIt.$$$reportNull$$$0(4);
        }
        return new LazyAppendableClosableIt<T>(it1){
            boolean myFirst;
            {
                super(init);
                this.myFirst = true;
            }

            @Override
            @Nullable
            protected ClosableIt<? extends T> nextIt() {
                if (!this.myFirst) {
                    return null;
                }
                this.myFirst = false;
                return (ClosableIt)next.create();
            }
        };
    }

    @NotNull
    public static <T> ClosableIt<T> lazyAppendIfEmpty(@NotNull ClosableIt<? extends T> it1, @NotNull Factory<? extends ClosableIt<T>> next) {
        if (it1 == null) {
            ClosableIt.$$$reportNull$$$0(5);
        }
        if (next == null) {
            ClosableIt.$$$reportNull$$$0(6);
        }
        boolean[] empty = new boolean[]{true};
        it1.map(cur -> {
            empty[0] = false;
            return cur;
        });
        return ClosableIt.lazyAppend(it1, () -> empty[0] ? (ClosableIt)next.create() : null);
    }

    @Override
    public abstract void close();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/ClosableIt";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it1";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/ClosableIt";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lazyAppend";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lazyAppendIfEmpty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static abstract class GroupingItImpl<Item, SubItem, Delegate>
    extends GroupingIt<Item, SubItem> {
        protected final ClosableIt<Delegate> myDelegate;
        private GroupIt<SubItem> mySubIt;

        protected GroupingItImpl(@NotNull ClosableIt<Delegate> delegate) {
            if (delegate == null) {
                GroupingItImpl.$$$reportNull$$$0(0);
            }
            this.mySubIt = null;
            this.myDelegate = delegate;
        }

        @NotNull
        protected abstract GroupIt<SubItem> createGroupIt(ClosableIt<Delegate> var1);

        protected abstract Item getItem(ClosableIt<Delegate> var1);

        @Override
        public void close() {
            this.myDelegate.close();
        }

        protected Item nextImpl() {
            if (this.mySubIt == null) {
                if (!this.myDelegate.hasNext()) {
                    return (Item)this.stop();
                }
                this.myDelegate.next();
            }
            while (this.mySubIt != null && this.mySubIt.hasNext()) {
                this.mySubIt.next();
            }
            if (!this.myDelegate.hasNext() && this.mySubIt != null && this.mySubIt.isEof()) {
                return (Item)this.stop();
            }
            this.mySubIt = this.createGroupIt(this.myDelegate);
            return this.getItem(this.myDelegate);
        }

        @Override
        @NotNull
        public JBIterator<SubItem> groupIt() {
            GroupIt<SubItem> groupIt = this.mySubIt;
            if (groupIt == null) {
                GroupingItImpl.$$$reportNull$$$0(1);
            }
            return groupIt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/ClosableIt$GroupingItImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/ClosableIt$GroupingItImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "groupIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }

        protected static abstract class GroupIt<T>
        extends JBIterator<T> {
            private final JBIterator<? extends T> myIt;
            private boolean myFirst = true;
            private boolean myEof = false;

            public GroupIt(JBIterator<? extends T> it) {
                this.myIt = it;
            }

            protected T nextImpl() {
                if (this.myFirst) {
                    this.myFirst = false;
                    return (T)this.myIt.current();
                }
                if (!this.myIt.advance()) {
                    this.myEof = true;
                    return (T)this.stop();
                }
                return (T)(this.isInGroup(this.myIt.current()) ? this.myIt.current() : this.stop());
            }

            protected abstract boolean isInGroup(T var1);

            public boolean isEof() {
                return this.myEof;
            }
        }
    }

    public static abstract class GroupingIt<Item, SubItem>
    extends ClosableIt<Item> {
        @NotNull
        public abstract JBIterator<SubItem> groupIt();
    }

    public static abstract class ResultSetDelegateIt<T>
    extends ClosableIt<T> {
        protected final ResultSetWrapper myRs;
        private final AutoCloseable myHook;
        private BiConsumer<@Nullable String, @Nullable Throwable> myErrorSink;
        private Boolean myInitialHasNext;
        private int myCount;
        private Logger myDbLogger;

        public ResultSetDelegateIt(@Nullable RemoteResultSet rs, @Nullable AutoCloseable hook) throws SQLException {
            this(new ResultSetWrapper(rs), hook, null);
        }

        public ResultSetDelegateIt(@NotNull ResultSetWrapper rs, @Nullable AutoCloseable hook, @Nullable Boolean initialHasNext) {
            if (rs == null) {
                ResultSetDelegateIt.$$$reportNull$$$0(0);
            }
            this.myCount = 0;
            this.myRs = rs;
            this.myHook = hook;
            this.myInitialHasNext = initialHasNext;
        }

        public void withDbLogger(Logger dbLogger) {
            this.myDbLogger = dbLogger;
        }

        public void withErrorSink(BiConsumer<@Nullable String, @Nullable Throwable> errorSink) {
            this.myErrorSink = errorSink;
        }

        protected void currentChanged() {
            super.currentChanged();
            ++this.myCount;
        }

        @Override
        public void close() {
            if (this.myDbLogger != null && this.myDbLogger.isLoggable(Level.FINE)) {
                this.myDbLogger.fine(this.myCount + " rows fetched");
            }
            try {
                ResultSetWrapper.close(this.myRs);
            }
            finally {
                block10: {
                    if (this.myHook != null) {
                        try {
                            this.myHook.close();
                        }
                        catch (Exception e) {
                            if (this.myErrorSink == null) break block10;
                            this.myErrorSink.accept(null, e);
                        }
                    }
                }
            }
        }

        protected T nextImpl() {
            try {
                if (this.myInitialHasNext != null) {
                    boolean hasNext = this.myInitialHasNext;
                    this.myInitialHasNext = null;
                    return (T)(hasNext ? this.calcValue() : this.stop());
                }
                if (this.myRs.next()) {
                    return this.calcValue();
                }
            }
            catch (SQLException e) {
                this.onError(null, e);
            }
            return (T)this.stop();
        }

        protected abstract T calcValue() throws SQLException;

        public void onError(T cur, SQLException e) {
            if (this.myErrorSink != null) {
                this.myErrorSink.accept(null, e);
            }
        }

        public void addError(String title, SQLException e) {
            if (this.myErrorSink != null) {
                this.myErrorSink.accept(title, e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/ClosableIt$ResultSetDelegateIt", "<init>"));
        }
    }

    public static class AutoCloseableGuard<T extends AutoCloseable>
    implements AutoCloseable {
        private final com.intellij.openapi.diagnostic.Logger LOG = com.intellij.openapi.diagnostic.Logger.getInstance(AutoCloseableGuard.class);
        private T myStored;

        public static <T extends AutoCloseable> AutoCloseableGuard<T> guarded(@Nullable T ac) {
            return new AutoCloseableGuard<T>(ac);
        }

        AutoCloseableGuard(@Nullable T stored) {
            this.myStored = stored;
        }

        @Override
        public void close() {
            if (this.myStored == null) {
                return;
            }
            try {
                this.myStored.close();
            }
            catch (Exception e) {
                this.LOG.warn((Throwable)e);
            }
        }

        public T get() {
            return this.myStored;
        }

        public T release() {
            T stored = this.myStored;
            this.myStored = null;
            return stored;
        }
    }

    @ApiStatus.Internal
    public static abstract class ResultSetClosableIt<T>
    extends ResultSetDelegateIt<T> {
        private MutableStorage<T> myStorage;

        ResultSetClosableIt(@Nullable RemoteResultSet rs) throws SQLException {
            super(rs, null);
        }

        ResultSetClosableIt(@NotNull ResultSetWrapper rs, @Nullable Boolean initialHasNext) {
            if (rs == null) {
                ResultSetClosableIt.$$$reportNull$$$0(0);
            }
            super(rs, null, initialHasNext);
        }

        private MutableStorage<T> getStorage() {
            if (this.myStorage == null) {
                this.myStorage = new MutableStorage<T>(this.createStorage(), this.createStorage());
            }
            return this.myStorage;
        }

        @NotNull
        protected T getStorageToFill() {
            T t = this.getStorage().current();
            if (t == null) {
                ResultSetClosableIt.$$$reportNull$$$0(1);
            }
            return t;
        }

        @NotNull
        protected abstract T createStorage();

        @Override
        protected void currentChanged() {
            super.currentChanged();
            this.getStorage().flip();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/ClosableIt$ResultSetClosableIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/ClosableIt$ResultSetClosableIt";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStorageToFill";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class DelegateMutableIt<E, T>
    extends DelegateIt<E, T> {
        private MutableStorage<T> myStorage;

        public DelegateMutableIt(Iterator<? extends E> it) {
            super(it);
        }

        private MutableStorage<T> getStorage() {
            if (this.myStorage == null) {
                this.myStorage = new MutableStorage<T>(this.createStorage(), this.createStorage());
            }
            return this.myStorage;
        }

        @NotNull
        protected T getStorageToFill() {
            T t = this.getStorage().current();
            if (t == null) {
                DelegateMutableIt.$$$reportNull$$$0(0);
            }
            return t;
        }

        @NotNull
        protected abstract T createStorage();

        protected void currentChanged() {
            this.getStorage().flip();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/ClosableIt$DelegateMutableIt", "getStorageToFill"));
        }
    }

    @ApiStatus.Internal
    public static abstract class DelegateIt<E, T>
    extends ClosableIt<T> {
        private final Iterator<? extends E> myIt;

        DelegateIt(Iterator<? extends E> it) {
            this.myIt = it;
        }

        @Override
        public void close() {
            if (this.myIt instanceof ClosableIt) {
                ((ClosableIt)((Object)this.myIt)).close();
            }
        }

        protected T nextImpl() {
            if (!this.myIt.hasNext()) {
                return (T)this.stop();
            }
            return this.calcValue(this.myIt.next());
        }

        protected abstract T calcValue(E var1);
    }

    static final class MutableStorage<T> {
        private T myCurStorage;
        private T myBackStorage;

        MutableStorage(T curStorage, T backStorage) {
            this.myCurStorage = curStorage;
            this.myBackStorage = backStorage;
        }

        @NotNull
        private T current() {
            T t = this.myBackStorage;
            if (t == null) {
                MutableStorage.$$$reportNull$$$0(0);
            }
            return t;
        }

        private void flip() {
            T tmp = this.myCurStorage;
            this.myCurStorage = this.myBackStorage;
            this.myBackStorage = tmp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/ClosableIt$MutableStorage", "current"));
        }
    }

    static abstract class LazyAppendableClosableIt<T>
    extends ClosableIt<T> {
        private ClosableIt<? extends T> myIt;

        LazyAppendableClosableIt(@Nullable ClosableIt<? extends T> init) {
            this.myIt = init;
        }

        @Override
        public void close() {
            if (this.myIt != null) {
                this.myIt.close();
            }
        }

        @Nullable
        protected abstract ClosableIt<? extends T> nextIt();

        protected T nextImpl() {
            if (this.myIt != null && this.myIt.hasNext()) {
                return (T)this.myIt.next();
            }
            do {
                if (this.myIt != null) {
                    this.myIt.close();
                    this.myIt = null;
                }
                this.myIt = this.nextIt();
            } while (this.myIt != null && !this.myIt.hasNext());
            return (T)(this.myIt == null ? this.stop() : this.myIt.next());
        }
    }
}

