/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import icons.DatabaseIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u000e\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/redis/model/RedisModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "<init>", "()V", "getCustomName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "kind", "Lcom/intellij/database/model/ObjectKind;", "plural", "", "getIcon", "Ljavax/swing/Icon;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "intellij.database.dialects.redis"})
public final class RedisModelHelper
extends ModelHelper {
    @NotNull
    public static final RedisModelHelper INSTANCE = new RedisModelHelper();

    private RedisModelHelper() {
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull ObjectKind kind, boolean plural) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA)) {
            Object[] objectArray = new Object[]{plural ? 2 : 1};
            string = DatabaseBundle.message("CustomObjectKind.database", objectArray);
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLLECTION)) {
            Object[] objectArray = new Object[]{plural ? 2 : 1};
            string = DatabaseBundle.message("CustomObjectKind.key", objectArray);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public Icon getIcon(@NotNull ObjectKind kind, @NotNull ModelHelper.ObjectKindVariant variant) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        ObjectKind objectKind = kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA) ? this.getIcon(ObjectKind.DATABASE) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLLECTION) ? DatabaseIcons.CollectionKey : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.STRING) ? DatabaseIcons.StringKey : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.LIST) ? DatabaseIcons.ListKey : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SET) ? DatabaseIcons.SetKey : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SORTED_SET) ? DatabaseIcons.SortedSetKey : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.HASH_TABLE) ? DatabaseIcons.HashTableKey : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.STREAM) ? DatabaseIcons.StreamKey : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.JSON_DOCUMENT) ? DatabaseIcons.JsonDocumentKey : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.DATA_STRUCTURE) ? DatabaseIcons.DataStructureKey : super.getIcon(kind, variant))))))))));
    }
}

