/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite.sql;

import com.intellij.database.dialects.sqlite.sql.SqliteDialect;
import com.intellij.database.dialects.sqlite.sql._SqliteLexer;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;

public class SqliteLexer
extends SqlLexer {
    boolean myDotState;
    boolean myDotLookahead;

    public SqliteLexer() {
        super(SqliteDialect.INSTANCE, (FlexLexer)new _SqliteLexer());
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            SqliteLexer.$$$reportNull$$$0(0);
        }
        this.myDotState = initialState < 0;
        this.myDotLookahead = this.myDotState;
        super.start(buffer, startOffset, endOffset, this.myDotState ? -initialState + 1 : initialState);
    }

    public int getState() {
        return this.myDotState ? -super.getState() - 1 : super.getState();
    }

    @Override
    protected void lookAhead(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            SqliteLexer.$$$reportNull$$$0(1);
        }
        if (this.myDotState ? !this.lookInsideDotCommand(baseLexer) : !this.lookAheadDotCommand(baseLexer)) {
            super.lookAhead(baseLexer);
        }
    }

    public void advance() {
        IElementType passed = this.getTokenType();
        if (passed == SqlTokens.SQLITE_DOT_START) {
            this.myDotState = true;
        } else if (passed == SqlTokens.SQLITE_DOT_END) {
            this.myDotState = false;
        }
        super.advance();
    }

    private boolean lookAheadDotCommand(Lexer lexer) {
        int pos = lexer.getTokenStart();
        CharSequence sequence = lexer.getBufferSequence();
        if (!SqliteLexer.isCommandDot(sequence, pos)) {
            return false;
        }
        this.addToken(pos + 1, SqlTokens.SQLITE_DOT_START);
        lexer.start(sequence, pos + 1, this.getBufferEnd());
        this.myDotLookahead = true;
        return true;
    }

    private boolean lookInsideDotCommand(Lexer lexer) {
        IElementType type = lexer.getTokenType();
        CharSequence sequence = lexer.getBufferSequence();
        int start2 = lexer.getTokenStart();
        int end = lexer.getTokenEnd();
        if (SqlTokens.WS_TOKENS.contains(type) || type == SqlTokens.SQL_STRING_TOKEN || type == SqlTokens.SQL_IDENT_DELIMITED || type == SqlTokens.SQL_UNCLOSED_TOKEN) {
            int eol = StringUtil.indexOfAny((CharSequence)sequence, (String)"\n\r", (int)start2, (int)end);
            if (eol == -1) {
                return false;
            }
            if (eol != start2) {
                this.addToken(eol, (IElementType)(SqlTokens.WS_TOKENS.contains(type) ? type : SqlTokens.SQL_IDENT));
                lexer.start(sequence, eol, this.getBufferEnd());
            }
            this.addToken(eol, SqlTokens.SQLITE_DOT_END);
            this.myDotLookahead = false;
            return true;
        }
        if (SqlTokens.COMMENT_TOKENS.contains(type)) {
            if (end - start2 < 2) {
                return false;
            }
            this.addToken(start2 + 2, SqlTokens.SQL_IDENT);
            lexer.start(sequence, start2 + 2, this.getBufferEnd());
            return true;
        }
        if (type == TokenType.BAD_CHARACTER) {
            this.advanceAs(lexer, SqlTokens.SQL_IDENT);
            return true;
        }
        if (!(type != null || end != 0 && SqliteLexer.isCommandDot(sequence, end - 1))) {
            this.advanceAs(lexer, SqlTokens.SQLITE_DOT_END);
            this.myDotLookahead = false;
            return true;
        }
        return false;
    }

    private static boolean isCommandDot(CharSequence sequence, int pos) {
        int pre;
        if (pos >= sequence.length() || sequence.charAt(pos) != '.') {
            return false;
        }
        int n = pre = pos == 0 ? 10 : (int)sequence.charAt(pos - 1);
        return pre == 10 || pre == 13;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLexer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/sqlite/sql/SqliteLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lookAhead";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

