/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolvableMetaProperty;
import com.intellij.database.model.meta.RawMetaReferenceDesc;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Function;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContextMetaObjectFactory {
    private static final ConcurrentMap<Couple<BasicMetaObject<?>>, BasicMetaObject<?>> ourFactory = CollectionFactory.createConcurrentWeakValueMap();

    public static <E extends BasicElement> BasicMetaObject<E> getMetaObjectInContext(@NotNull BasicMetaObject<?> context, BasicMetaObject<E> root) {
        if (context == null) {
            ContextMetaObjectFactory.$$$reportNull$$$0(0);
        }
        return ContextMetaObjectFactory.getMetaObjectInContext(context, root, true);
    }

    private static <E extends BasicElement> BasicMetaObject<E> getMetaObjectInContext(@NotNull BasicMetaObject<?> context, BasicMetaObject<E> root, boolean bindRefs) {
        if (context == null) {
            ContextMetaObjectFactory.$$$reportNull$$$0(1);
        }
        if (root.getParent() == context || ContextMetaObjectFactory.isUnbound(context)) {
            return root;
        }
        return ourFactory.computeIfAbsent(Couple.of(context, root), p2 -> ContextMetaObjectFactory.createContextMetaObject((BasicMetaObject)p2.first, (BasicMetaObject)p2.second, bindRefs));
    }

    @NotNull
    private static <T extends BasicElement> BasicMetaObject<T> createContextMetaObject(@NotNull BasicMetaObject<?> context, @NotNull BasicMetaObject<T> meta, boolean bindRefs) {
        if (context == null) {
            ContextMetaObjectFactory.$$$reportNull$$$0(2);
        }
        if (meta == null) {
            ContextMetaObjectFactory.$$$reportNull$$$0(3);
        }
        BasicMetaObject<T> res = ContextMetaObjectFactory.clone(meta);
        BasicMetaObject.bindVirtualRoot(res, context);
        ContextMetaObjectFactory.bindContent(res, bindRefs);
        BasicMetaObject<T> basicMetaObject = res;
        if (basicMetaObject == null) {
            ContextMetaObjectFactory.$$$reportNull$$$0(4);
        }
        return basicMetaObject;
    }

    private static <T extends BasicElement> void bindContent(@NotNull BasicMetaObject<T> meta, boolean bindRefs) {
        if (meta == null) {
            ContextMetaObjectFactory.$$$reportNull$$$0(5);
        }
        BasicMetaObject<?>[] children2 = meta.children;
        for (int i2 = 0; i2 < children2.length; ++i2) {
            if (ContextMetaObjectFactory.isRoot(children2[i2])) continue;
            children2[i2] = ContextMetaObjectFactory.getOrCreateContextMetaObject(meta, children2[i2]);
        }
        if (bindRefs) {
            ContextMetaObjectFactory.bindReferences(meta);
        }
    }

    private static <T extends BasicElement> void bindReferences(BasicMetaObject<T> meta) {
        if (ContextMetaObjectFactory.isRoot(meta)) {
            return;
        }
        for (BasicMetaProperty reference : meta.references) {
            ContextMetaObjectFactory.bindContextReferenceDesc(meta, reference);
        }
        for (BasicMetaObject<?> child : meta.children) {
            ContextMetaObjectFactory.bindReferences(child);
        }
    }

    @NotNull
    private static <T extends BasicElement> BasicMetaObject<?> getOrCreateContextMetaObject(BasicMetaObject<?> meta, BasicMetaObject<T> child) {
        BasicMetaObject<T> res = child.getParent() == null && child.getParentClass() != null ? ContextMetaObjectFactory.getMetaObjectInContext(meta, child, false) : ContextMetaObjectFactory.createContextMetaObject(meta, child, false);
        assert (res.getParent() == meta);
        BasicMetaObject<T> basicMetaObject = res;
        if (basicMetaObject == null) {
            ContextMetaObjectFactory.$$$reportNull$$$0(6);
        }
        return basicMetaObject;
    }

    @NotNull
    private static <T extends BasicElement> BasicMetaObject<T> clone(@NotNull BasicMetaObject<T> meta) {
        if (meta == null) {
            ContextMetaObjectFactory.$$$reportNull$$$0(7);
        }
        ContextMetaObjectFactory.checkRootModification(meta);
        return new BasicMetaObject(meta.kind, meta.apiClass, meta.dataFactory, meta.dataDeserializer, meta.properties, ContextMetaObjectFactory.mapInplace((BasicMetaProperty[])meta.references.clone(), BasicMetaProperty::copy), (BasicMetaObject[])meta.children.clone());
    }

    private static <T extends BasicElement> void checkRootModification(@NotNull BasicMetaObject<T> meta) {
        if (meta == null) {
            ContextMetaObjectFactory.$$$reportNull$$$0(8);
        }
        if (ContextMetaObjectFactory.isRoot(meta)) {
            throw new AssertionError((Object)"forbidden");
        }
    }

    private static <T extends BasicElement> boolean isRoot(@NotNull BasicMetaObject<T> meta) {
        if (meta == null) {
            ContextMetaObjectFactory.$$$reportNull$$$0(9);
        }
        return meta.kind == ObjectKind.ROOT;
    }

    private static <T> T[] mapInplace(T[] array, Function<T, T> mapper) {
        int length = array.length;
        for (int i2 = 0; i2 < length; ++i2) {
            array[i2] = mapper.fun(array[i2]);
        }
        return array;
    }

    private static <T extends BasicElement> void bindContextReferenceDesc(BasicMetaObject<T> res, BasicMetaProperty<T, ?> reference) {
        ContextMetaObjectFactory.checkRootModification(res);
        if (!(reference instanceof BasicResolvableMetaProperty)) {
            throw new AssertionError((Object)"unexpected");
        }
        ContextMetaObjectFactory.bindContextReferenceDesc(res, (BasicResolvableMetaProperty)reference);
    }

    private static <S extends BasicElement, T extends BasicElement> void bindContextReferenceDesc(BasicMetaObject<S> res, BasicResolvableMetaProperty<S, T, ?> mr) {
        RawMetaReferenceDesc<S, T> rawDesc = mr.getRawReferenceDesc();
        if (rawDesc != null) {
            mr.bind(ContextMetaObjectFactory.createContextRefDesc(res, rawDesc));
        } else {
            mr.bind(ContextMetaObjectFactory.createContextRefDesc(res, mr.getReferenceDesc()));
        }
    }

    public static <S extends BasicElement, T extends BasicElement> BasicMetaReferenceDesc<S, T> createContextRefDesc(BasicMetaObject<S> context, BasicMetaReferenceDesc<S, T> desc) {
        BasicMetaReferenceDesc res;
        BasicMetaReference<S, ?> baseRef = ContextMetaObjectFactory.getBaseRef(context, desc.getBaseRef());
        if (baseRef == null) {
            BasicMetaObject<?> scope = ContextMetaObjectFactory.getScope(context, RawMetaReferenceDesc.RawMetaObject.rawMeta(desc.getScope()));
            res = new BasicMetaReferenceDesc(desc.valueClass, scope, ContextMetaObjectFactory.getTargets(desc, scope), desc.isBackRef());
        } else {
            ContextMetaObjectFactory.bindContextReferenceDesc(context, baseRef);
            res = new BasicMetaReferenceDesc(desc.valueClass, baseRef, ContextMetaObjectFactory.getTargets(desc, baseRef.getReferenceDesc().targets), desc.isBackRef());
        }
        return res;
    }

    public static <S extends BasicElement, T extends BasicElement> BasicMetaReferenceDesc<S, T> createContextRefDesc(BasicMetaObject<S> context, RawMetaReferenceDesc<S, T> desc) {
        BasicMetaReferenceDesc res;
        BasicMetaReference<S, ?> baseRef = ContextMetaObjectFactory.getBaseRef(context, desc.getBaseRef());
        if (baseRef == null) {
            BasicMetaObject<?> scope = ContextMetaObjectFactory.getScope(context, Objects.requireNonNull(desc.getScope()));
            res = new BasicMetaReferenceDesc(desc.valueClass, scope, ContextMetaObjectFactory.getTargets(JBIterable.of((Object[])desc.targets), scope), desc.isBackRef());
        } else {
            ContextMetaObjectFactory.bindContextReferenceDesc(context, baseRef);
            res = new BasicMetaReferenceDesc(desc.valueClass, baseRef, ContextMetaObjectFactory.getTargets(JBIterable.of((Object[])desc.targets), baseRef.getReferenceDesc().targets), desc.isBackRef());
        }
        return res;
    }

    private static <S extends BasicElement, T extends BasicElement> BasicMetaObject<? extends T>[] getTargets(BasicMetaReferenceDesc<S, T> desc, BasicMetaObject<?> ... scopes) {
        return ContextMetaObjectFactory.getTargets(JBIterable.of((Object[])desc.targets).map(t -> RawMetaReferenceDesc.RawMetaObject.rawMeta(t)), scopes);
    }

    private static <S extends BasicElement, T extends BasicElement> BasicMetaObject<? extends T>[] getTargets(RawMetaReferenceDesc<S, T> desc, BasicMetaObject<?> ... scopes) {
        JBIterable rawTargets = JBIterable.of((Object[])desc.targets);
        return ContextMetaObjectFactory.getTargets(rawTargets, scopes);
    }

    private static <S extends BasicElement, T extends BasicElement> BasicMetaObject<? extends T>[] getTargets(JBIterable<RawMetaReferenceDesc.RawMetaObject<? extends T>> rawTargets, BasicMetaObject<?> ... scopes) {
        return BasicMetaObject.toArray(((JBTreeTraverser)BasicMetaUtils.metaTraverser().withRoots((Object[])scopes)).traverse().filterMap(o -> (BasicMetaObject)rawTargets.filterMap(r -> r.matched((BasicMetaObject<?>)o)).first()).toList());
    }

    @NotNull
    private static <S extends BasicElement, T extends BasicElement> BasicMetaObject<?> getScope(BasicMetaObject<S> res, @NotNull RawMetaReferenceDesc.RawMetaObject<?> rawScope) {
        BasicMetaObject<Object> scope;
        if (rawScope == null) {
            ContextMetaObjectFactory.$$$reportNull$$$0(10);
        }
        for (scope = res; scope != null && rawScope.matched(scope) == null && !scope.kindOf(BasicRoot.class); scope = scope.getParent()) {
        }
        if (scope == null) {
            throw new AssertionError((Object)"Unexpected scope");
        }
        BasicMetaObject<S> basicMetaObject = scope;
        if (basicMetaObject == null) {
            ContextMetaObjectFactory.$$$reportNull$$$0(11);
        }
        return basicMetaObject;
    }

    private static boolean isScope(BasicMetaObject<?> scope, Class<?> scopeClass, ObjectKind scopeKind) {
        return scope.kindOf(scopeClass) || scope.kind == scopeKind;
    }

    private static boolean isUnbound(@NotNull BasicMetaObject<?> context) {
        BasicMetaObject<?> parent;
        if (context == null) {
            ContextMetaObjectFactory.$$$reportNull$$$0(12);
        }
        if ((parent = context.getParent()) == null && context.getParentClass() != null) {
            return true;
        }
        return parent != null && ContextMetaObjectFactory.isUnbound(parent);
    }

    public static void assertBound(@NotNull BasicMetaObject<?> context) {
        if (context == null) {
            ContextMetaObjectFactory.$$$reportNull$$$0(13);
        }
        if (ContextMetaObjectFactory.isUnbound(context)) {
            throw new AssertionError((Object)"Unbound meta is not expected here");
        }
    }

    @Nullable
    private static <S extends BasicElement, T extends BasicElement> BasicMetaReference<S, ?> getBaseRef(BasicMetaObject<S> res, BasicMetaReference<S, ?> baseRef) {
        if (baseRef == null) {
            return null;
        }
        if ((baseRef = res.getReference(baseRef.getId())) == null) {
            throw new AssertionError((Object)"unexpected");
        }
        return baseRef;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/basic/ContextMetaObjectFactory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/basic/ContextMetaObjectFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createContextMetaObject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateContextMetaObject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetaObjectInContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createContextMetaObject";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindContent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "clone";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkRootModification";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isUnbound";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "assertBound";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 11 -> new IllegalStateException(string);
        };
    }

    public static class BasicContextMetaObject<E extends BasicElement> {
        private final BasicMetaObject<E> myMeta;

        public BasicContextMetaObject(@NotNull BasicMetaObject<E> meta) {
            if (meta == null) {
                BasicContextMetaObject.$$$reportNull$$$0(0);
            }
            this.myMeta = meta;
        }

        public BasicContextMetaObject(@NotNull Class<? extends BasicElement> parentClass, @NotNull BasicMetaObject<E> meta) {
            if (parentClass == null) {
                BasicContextMetaObject.$$$reportNull$$$0(1);
            }
            if (meta == null) {
                BasicContextMetaObject.$$$reportNull$$$0(2);
            }
            this(meta);
            BasicMetaObject.bindVirtualRoot(meta, parentClass);
        }

        @NotNull
        public BasicMetaObject<E> get(@NotNull BasicMetaObject<?> context) {
            if (context == null) {
                BasicContextMetaObject.$$$reportNull$$$0(3);
            }
            BasicMetaObject<E> basicMetaObject = ContextMetaObjectFactory.getMetaObjectInContext(context, this.myMeta);
            if (basicMetaObject == null) {
                BasicContextMetaObject.$$$reportNull$$$0(4);
            }
            return basicMetaObject;
        }

        public BasicMetaObject<E> bind() {
            BasicMetaObject<E> res = ContextMetaObjectFactory.clone(this.myMeta);
            ContextMetaObjectFactory.bindContent(res, true);
            return res;
        }

        public BasicMetaObject<E> getInner() {
            return this.myMeta;
        }

        @Nullable
        public E tryCast(@Nullable BasicElement e) {
            return this.myMeta.tryCast(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentClass";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/basic/ContextMetaObjectFactory$BasicContextMetaObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/basic/ContextMetaObjectFactory$BasicContextMetaObject";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

