/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasAliasDefinedType;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasBuiltinTypeClass;
import com.intellij.database.types.DasBuiltinTypeClassWithSuffix;
import com.intellij.database.types.DasCollectionType;
import com.intellij.database.types.DasDefinedTypeClassImpl;
import com.intellij.database.types.DasMapType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeFacade;
import com.intellij.database.types.DasTypeReference;
import com.intellij.database.types.DasTypeSystem;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlUserTypeDefinition;
import java.math.BigInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u001b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b*\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u001a\"\u0010\u000b\u001a\u00020\u0007*\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0014\u001a\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016\u001a.\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0018\"\u000e\b\u0000\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00190\u001a*\b\u0012\u0004\u0012\u0002H\u00190\u00182\u0006\u0010\u001b\u001a\u00020\u0001\u001a\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0018*\b\u0012\u0004\u0012\u00020\u001d0\u00182\u0006\u0010\u001e\u001a\u00020\u0001\u001aB\u0010%\u001a\u00020\u0001\"\u000e\b\u0000\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00190\u001a*\b\u0012\u0004\u0012\u0002H\u00190\u001a2\u001d\u0010&\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u001a\u0012\u0004\u0012\u00020\u00010'\u00a2\u0006\u0002\b(H\u0082\b\u001a\u001c\u0010.\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020+2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016\u001a\u0012\u00100\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\t\u001a\u00020+\u001a\u000f\u00108\u001a\u00070\u0001\u00a2\u0006\u0002\b\b*\u00020\u0007\u001a\u0012\u00109\u001a\u0004\u0018\u00010\u00072\b\u0010:\u001a\u0004\u0018\u00010\u0001\u001a\u0018\u0010;\u001a\u0004\u0018\u00010<2\u0006\u00101\u001a\u00020\u00012\u0006\u0010?\u001a\u00020\u0003\u001a\u0018\u0010@\u001a\u0004\u0018\u00010<2\u0006\u00101\u001a\u00020\u00012\u0006\u0010?\u001a\u00020\u0003\u001a\u0012\u0010H\u001a\u00020\r*\u00020\u00072\u0006\u0010B\u001a\u00020C\u001a\u001a\u0010I\u001a\u00020J*\u00020J2\u0006\u0010K\u001a\u00020\u00072\u0006\u0010)\u001a\u00020L\u001a\n\u0010M\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010N\u001a\u00020\u0007*\u00020\u0007\"+\u0010\u001f\u001a\u00020\u0001\"\u000e\b\u0000\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00190\u001a*\b\u0012\u0004\u0012\u0002H\u00190\u001a8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\"\u0015\u0010\"\u001a\u00020\u0001*\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\"\u0015\u0010)\u001a\u00020**\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\"\u0015\u00101\u001a\u00020\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b2\u00103\"\u0017\u00104\u001a\u0004\u0018\u00010\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b5\u00103\"\u0017\u00106\u001a\u0004\u0018\u00010\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b7\u00103\"\u0017\u0010;\u001a\u0004\u0018\u00010<*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\"\u0017\u0010@\u001a\u0004\u0018\u00010<*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bA\u0010>\"\u0017\u0010B\u001a\u0004\u0018\u00010C*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bD\u0010E\"\u0015\u0010F\u001a\u00020C*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bG\u0010E\u00a8\u0006O"}, d2={"renderSize", "", "size", "", "renderScale", "scale", "resolve", "Lcom/intellij/database/types/DasType;", "Lorg/jetbrains/annotations/NotNull;", "context", "Lcom/intellij/database/model/DasObject;", "unwrap", "untilUnknown", "", "typeClassOf", "Lcom/intellij/database/types/DasDefinedTypeClassImpl;", "definition", "Lcom/intellij/database/model/DasUserDefinedType;", "createAliasType", "Lcom/intellij/database/types/DasAliasDefinedType;", "Lcom/intellij/sql/psi/SqlUserTypeDefinition;", "initInnerType", "Lkotlin/Function0;", "withName", "Lcom/intellij/database/types/DasBuiltinType;", "C", "Lcom/intellij/database/types/DasBuiltinTypeClass;", "newName", "withSuffix", "Lcom/intellij/database/types/DasBuiltinTypeClassWithSuffix;", "newSuffix", "debugName", "getDebugName", "(Lcom/intellij/database/types/DasBuiltinTypeClass;)Ljava/lang/String;", "debugSuffix", "getDebugSuffix", "(Lcom/intellij/database/types/DasBuiltinTypeClassWithSuffix;)Ljava/lang/String;", "debugInfo", "getInfo", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "typeSystem", "Lcom/intellij/database/types/DasTypeSystemBase;", "Lcom/intellij/database/model/basic/BasicElement;", "getTypeSystem", "(Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/types/DasTypeSystemBase;", "getCacheableDasType", "computeType", "remapAgainst", "typeName", "getTypeName", "(Lcom/intellij/database/types/DasType;)Ljava/lang/String;", "packageName", "getPackageName", "schemaName", "getSchemaName", "serialize", "deserializeDasType", "text", "minValue", "Ljava/math/BigInteger;", "getMinValue", "(Lcom/intellij/database/types/DasType;)Ljava/math/BigInteger;", "precision", "maxValue", "getMaxValue", "category", "Lcom/intellij/database/types/DasTypeCategory;", "getCategory", "(Lcom/intellij/database/types/DasType;)Lcom/intellij/database/types/DasTypeCategory;", "categoryOrUnknown", "getCategoryOrUnknown", "is", "mapDeepestComponent", "Lcom/intellij/database/types/DasArrayType;", "newDeepestComponentType", "Lcom/intellij/database/types/DasTypeSystem;", "actualizeStoredType", "unwrapCollections", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\ndasTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dasTypeUtils.kt\ncom/intellij/database/types/DasTypeUtilsKt\n*L\n1#1,158:1\n71#1,3:159\n71#1,3:162\n*S KotlinDebug\n*F\n+ 1 dasTypeUtils.kt\ncom/intellij/database/types/DasTypeUtilsKt\n*L\n63#1:159,3\n66#1:162,3\n*E\n"})
public final class DasTypeUtilsKt {
    @Nullable
    public static final String renderSize(int size) {
        return switch (size) {
            case -1 -> null;
            case 0x7FFFFFFE -> "*";
            case Integer.MAX_VALUE -> "max";
            default -> String.valueOf(size);
        };
    }

    @Nullable
    public static final String renderScale(int scale) {
        return scale != 0 ? String.valueOf(scale) : null;
    }

    @NotNull
    public static final DasType resolve(@NotNull DasType $this$resolve, @Nullable DasObject context) {
        Intrinsics.checkNotNullParameter((Object)$this$resolve, (String)"<this>");
        DasType dasType = DasTypeFacade.resolve($this$resolve, context);
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"resolve(...)");
        return dasType;
    }

    public static /* synthetic */ DasType resolve$default(DasType dasType, DasObject dasObject, int n, Object object) {
        if ((n & 1) != 0) {
            dasObject = null;
        }
        return DasTypeUtilsKt.resolve(dasType, dasObject);
    }

    @JvmOverloads
    @NotNull
    public static final DasType unwrap(@NotNull DasType $this$unwrap, boolean untilUnknown, @Nullable DasObject context) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrap, (String)"<this>");
        DasType type = $this$unwrap;
        while (true) {
            DasType dasType;
            DasType dasType2;
            if ((dasType2 = type) instanceof DasAliasDefinedType) {
                dasType = ((DasAliasDefinedType)type).getInnerType();
            } else if (dasType2 instanceof DasTypeReference) {
                DasType dasType3 = ((DasTypeReference)type).resolve(context);
                dasType = dasType3;
                Intrinsics.checkNotNullExpressionValue((Object)dasType3, (String)"resolve(...)");
            } else {
                return type;
            }
            DasType unwrappedType = dasType;
            if (untilUnknown && Intrinsics.areEqual((Object)unwrappedType, DasTypeSystemBase.UNKNOWN)) {
                return type;
            }
            type = unwrappedType;
        }
    }

    public static /* synthetic */ DasType unwrap$default(DasType dasType, boolean bl, DasObject dasObject, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            dasObject = null;
        }
        return DasTypeUtilsKt.unwrap(dasType, bl, dasObject);
    }

    @NotNull
    public static final DasDefinedTypeClassImpl typeClassOf(@NotNull DasUserDefinedType definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        return new DasDefinedTypeClassImpl(definition);
    }

    @NotNull
    public static final DasAliasDefinedType createAliasType(@NotNull SqlUserTypeDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        return new DasAliasDefinedType(definition){

            public DasType getInnerType() {
                DasUserDefinedType dasUserDefinedType = this.getTypeClass().getDefinition();
                Intrinsics.checkNotNull((Object)dasUserDefinedType, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlUserTypeDefinition");
                SqlUserTypeDefinition typeDef = (SqlUserTypeDefinition)dasUserDefinedType;
                Object object = typeDef.getAliasedTypeElement();
                if (object == null || (object = object.getDasType()) == null) {
                    object = DasTypeSystemBase.UNKNOWN;
                }
                return object;
            }
        };
    }

    @NotNull
    public static final DasAliasDefinedType createAliasType(@NotNull SqlUserTypeDefinition definition, @NotNull Function0<? extends DasType> initInnerType) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter(initInnerType, (String)"initInnerType");
        return new DasAliasDefinedType(initInnerType, definition){
            private final Lazy innerType$delegate;
            {
                this.innerType$delegate = LazyKt.lazy($initInnerType);
            }

            public DasType getInnerType() {
                Lazy lazy = this.innerType$delegate;
                return (DasType)lazy.getValue();
            }
        };
    }

    @NotNull
    public static final <C extends DasBuiltinTypeClass<C>> DasBuiltinType<C> withName(@NotNull DasBuiltinType<C> $this$withName, @NotNull String newName) {
        DasBuiltinType<DasBuiltinTypeClass> dasBuiltinType;
        Intrinsics.checkNotNullParameter($this$withName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        if (!Intrinsics.areEqual((Object)$this$withName.getTypeClass().getName(), (Object)newName)) {
            DasBuiltinType<DasBuiltinTypeClass> dasBuiltinType2 = $this$withName.withTypeClass((DasBuiltinTypeClass)$this$withName.getTypeClass().withName(newName));
            dasBuiltinType = dasBuiltinType2;
            Intrinsics.checkNotNullExpressionValue(dasBuiltinType2, (String)"withTypeClass(...)");
        } else {
            dasBuiltinType = $this$withName;
        }
        return dasBuiltinType;
    }

    @NotNull
    public static final DasBuiltinType<DasBuiltinTypeClassWithSuffix> withSuffix(@NotNull DasBuiltinType<DasBuiltinTypeClassWithSuffix> $this$withSuffix, @NotNull String newSuffix) {
        Intrinsics.checkNotNullParameter($this$withSuffix, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newSuffix, (String)"newSuffix");
        DasBuiltinType<DasBuiltinTypeClassWithSuffix> dasBuiltinType = $this$withSuffix.withTypeClass((DasBuiltinTypeClassWithSuffix)((DasBuiltinTypeClass)((DasBuiltinTypeClassWithSuffix)$this$withSuffix.getTypeClass()).withSuffix(newSuffix)));
        Intrinsics.checkNotNullExpressionValue(dasBuiltinType, (String)"withTypeClass(...)");
        return dasBuiltinType;
    }

    @NotNull
    public static final <C extends DasBuiltinTypeClass<C>> String getDebugName(@NotNull DasBuiltinTypeClass<C> $this$debugName) {
        Intrinsics.checkNotNullParameter($this$debugName, (String)"<this>");
        DasBuiltinTypeClass<C> $this$debugInfo$iv = $this$debugName;
        boolean $i$f$debugInfo = false;
        DasBuiltinTypeClass<C> $this$_get_debugName__u24lambda_u240 = $this$debugInfo$iv;
        boolean bl = false;
        String string = $this$_get_debugName__u24lambda_u240.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String info$iv = string;
        DasBuiltinTypeClass<C> dasBuiltinTypeClass = $this$debugInfo$iv.getCanonical();
        Intrinsics.checkNotNullExpressionValue(dasBuiltinTypeClass, (String)"getCanonical(...)");
        DasBuiltinTypeClass<C> $this$_get_debugName__u24lambda_u2402 = dasBuiltinTypeClass;
        $i$a$-debugInfo-DasTypeUtilsKt$debugName$1 = false;
        String string2 = $this$_get_debugName__u24lambda_u2402.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String canonicalInfo$iv = string2;
        return Intrinsics.areEqual((Object)info$iv, (Object)canonicalInfo$iv) ? info$iv : "{" + canonicalInfo$iv + " as " + info$iv + "}";
    }

    @NotNull
    public static final String getDebugSuffix(@NotNull DasBuiltinTypeClassWithSuffix $this$debugSuffix) {
        Intrinsics.checkNotNullParameter((Object)$this$debugSuffix, (String)"<this>");
        DasBuiltinTypeClass $this$debugInfo$iv = $this$debugSuffix;
        boolean $i$f$debugInfo = false;
        DasBuiltinTypeClass $this$_get_debugSuffix__u24lambda_u241 = $this$debugInfo$iv;
        boolean bl = false;
        String info$iv = $this$debugSuffix.getSuffix();
        DasBuiltinTypeClass dasBuiltinTypeClass = $this$debugInfo$iv.getCanonical();
        Intrinsics.checkNotNullExpressionValue(dasBuiltinTypeClass, (String)"getCanonical(...)");
        $this$_get_debugSuffix__u24lambda_u241 = dasBuiltinTypeClass;
        bl = false;
        String canonicalInfo$iv = $this$debugSuffix.getSuffix();
        return Intrinsics.areEqual((Object)info$iv, (Object)canonicalInfo$iv) ? info$iv : "{" + canonicalInfo$iv + " as " + info$iv + "}";
    }

    private static final <C extends DasBuiltinTypeClass<C>> String debugInfo(DasBuiltinTypeClass<C> $this$debugInfo, Function1<? super DasBuiltinTypeClass<C>, String> getInfo) {
        boolean $i$f$debugInfo = false;
        String info = (String)getInfo.invoke($this$debugInfo);
        DasBuiltinTypeClass<C> dasBuiltinTypeClass = $this$debugInfo.getCanonical();
        Intrinsics.checkNotNullExpressionValue(dasBuiltinTypeClass, (String)"getCanonical(...)");
        String canonicalInfo = (String)getInfo.invoke(dasBuiltinTypeClass);
        return Intrinsics.areEqual((Object)info, (Object)canonicalInfo) ? info : "{" + canonicalInfo + " as " + info + "}";
    }

    @NotNull
    public static final DasTypeSystemBase getTypeSystem(@NotNull BasicElement $this$typeSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$typeSystem, (String)"<this>");
        Dbms dbms = DbImplUtilCore.getDbms($this$typeSystem);
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        return DasTypeSystems.getTypeSystem(dbms);
    }

    @NotNull
    public static final DasType getCacheableDasType(@NotNull BasicElement context, @NotNull Function0<? extends DasType> computeType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(computeType, (String)"computeType");
        BasicModel basicModel = context.getModel();
        if (basicModel == null) {
            return (DasType)computeType.invoke();
        }
        BasicModel model = basicModel;
        DasType dasType = model.getCacheableDasType(context, () -> DasTypeUtilsKt.getCacheableDasType$lambda$2(computeType));
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getCacheableDasType(...)");
        return dasType;
    }

    @NotNull
    public static final DasType remapAgainst(@NotNull DasType $this$remapAgainst, @NotNull BasicElement context) {
        Intrinsics.checkNotNullParameter((Object)$this$remapAgainst, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)$this$remapAgainst, DasTypeSystemBase.UNKNOWN)) {
            return $this$remapAgainst;
        }
        DasTypeSystemBase dasTypeSystemBase = DasTypeUtilsKt.getTypeSystem(context);
        DataType dataType = $this$remapAgainst.toDataType();
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
        return dasTypeSystemBase.createDasType(dataType);
    }

    @NotNull
    public static final String getTypeName(@NotNull DasType $this$typeName) {
        Intrinsics.checkNotNullParameter((Object)$this$typeName, (String)"<this>");
        String string = $this$typeName.getTypeClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Nullable
    public static final String getPackageName(@NotNull DasType $this$packageName) {
        Intrinsics.checkNotNullParameter((Object)$this$packageName, (String)"<this>");
        return $this$packageName.getTypeClass().getPackageName();
    }

    @Nullable
    public static final String getSchemaName(@NotNull DasType $this$schemaName) {
        Intrinsics.checkNotNullParameter((Object)$this$schemaName, (String)"<this>");
        return $this$schemaName.getTypeClass().getSchemaName();
    }

    @NotNull
    public static final String serialize(@NotNull DasType $this$serialize) {
        Intrinsics.checkNotNullParameter((Object)$this$serialize, (String)"<this>");
        String string = DataTypeFactory.serialize($this$serialize.toDataType());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize(...)");
        return string;
    }

    @Nullable
    public static final DasType deserializeDasType(@Nullable String text2) {
        DasType dasType;
        CharSequence charSequence = text2;
        if (charSequence == null || charSequence.length() == 0) {
            dasType = null;
        } else {
            DataType dataType = DataTypeFactory.deserialize(text2);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"deserialize(...)");
            dasType = DasUnresolvedTypeReference.Companion.of(dataType);
        }
        return dasType;
    }

    @Nullable
    public static final BigInteger getMinValue(@NotNull DasType $this$minValue) {
        Intrinsics.checkNotNullParameter((Object)$this$minValue, (String)"<this>");
        return DasTypeUtilsKt.minValue(DasTypeUtilsKt.getTypeName($this$minValue), $this$minValue.toDataType().getPrecision());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final BigInteger minValue(@NotNull String typeName, int precision) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        String string = StringUtil.toUpperCase((String)typeName);
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case -1282431251: {
                if (string.equals("NUMERIC")) {
                    n = 1;
                }
                break;
            }
            case 176095624: {
                if (string.equals("SMALLINT")) {
                    n = 2;
                }
                break;
            }
            case -2034720975: {
                if (string.equals("DECIMAL")) {
                    n = 1;
                }
                break;
            }
            case 1959128815: {
                if (string.equals("BIGINT")) {
                    n = 3;
                }
                break;
            }
            case -594415409: {
                if (string.equals("TINYINT")) {
                    n = 4;
                }
                break;
            }
            case 72655: {
                if (string.equals("INT")) {
                    n = 5;
                }
                break;
            }
            case -1618932450: {
                if (string.equals("INTEGER")) {
                    n = 5;
                }
                break;
            }
        }
        switch (n) {
            case 4: {
                BigInteger bigInteger2 = BigInteger.ZERO;
                return bigInteger2;
            }
            case 2: {
                BigInteger bigInteger = BigInteger.valueOf(Short.MIN_VALUE);
                BigInteger bigInteger2 = bigInteger;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
                return bigInteger2;
            }
            case 5: {
                BigInteger bigInteger = BigInteger.valueOf(Integer.MIN_VALUE);
                BigInteger bigInteger2 = bigInteger;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
                return bigInteger2;
            }
            case 3: {
                BigInteger bigInteger = BigInteger.valueOf(Long.MIN_VALUE);
                BigInteger bigInteger2 = bigInteger;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
                return bigInteger2;
            }
            case 1: {
                BigInteger bigInteger2 = new BigInteger("-" + StringsKt.repeat((CharSequence)"9", (int)precision));
                return bigInteger2;
            }
            default: {
                return null;
            }
        }
    }

    @Nullable
    public static final BigInteger getMaxValue(@NotNull DasType $this$maxValue) {
        Intrinsics.checkNotNullParameter((Object)$this$maxValue, (String)"<this>");
        return DasTypeUtilsKt.maxValue(DasTypeUtilsKt.getTypeName($this$maxValue), $this$maxValue.toDataType().getPrecision());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final BigInteger maxValue(@NotNull String typeName, int precision) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        String string = StringUtil.toUpperCase((String)typeName);
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case -1282431251: {
                if (string.equals("NUMERIC")) {
                    n = 1;
                }
                break;
            }
            case 176095624: {
                if (string.equals("SMALLINT")) {
                    n = 2;
                }
                break;
            }
            case -2034720975: {
                if (string.equals("DECIMAL")) {
                    n = 1;
                }
                break;
            }
            case 1959128815: {
                if (string.equals("BIGINT")) {
                    n = 3;
                }
                break;
            }
            case -594415409: {
                if (string.equals("TINYINT")) {
                    n = 4;
                }
                break;
            }
            case 72655: {
                if (string.equals("INT")) {
                    n = 5;
                }
                break;
            }
            case -1618932450: {
                if (string.equals("INTEGER")) {
                    n = 5;
                }
                break;
            }
        }
        switch (n) {
            case 4: {
                BigInteger bigInteger = BigInteger.valueOf(255);
                BigInteger bigInteger2 = bigInteger;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
                return bigInteger2;
            }
            case 2: {
                BigInteger bigInteger = BigInteger.valueOf(Short.MAX_VALUE);
                BigInteger bigInteger2 = bigInteger;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
                return bigInteger2;
            }
            case 5: {
                BigInteger bigInteger = BigInteger.valueOf(Integer.MAX_VALUE);
                BigInteger bigInteger2 = bigInteger;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
                return bigInteger2;
            }
            case 3: {
                BigInteger bigInteger = BigInteger.valueOf(Long.MAX_VALUE);
                BigInteger bigInteger2 = bigInteger;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
                return bigInteger2;
            }
            case 1: {
                BigInteger bigInteger2 = new BigInteger(StringsKt.repeat((CharSequence)"9", (int)precision));
                return bigInteger2;
            }
            default: {
                return null;
            }
        }
    }

    @Nullable
    public static final DasTypeCategory getCategory(@NotNull DasType $this$category) {
        Intrinsics.checkNotNullParameter((Object)$this$category, (String)"<this>");
        Object object = $this$category instanceof DasBuiltinType ? (DasBuiltinType)$this$category : null;
        return object != null && (object = object.getTypeClass()) != null ? object.getCategory() : null;
    }

    @NotNull
    public static final DasTypeCategory getCategoryOrUnknown(@NotNull DasType $this$categoryOrUnknown) {
        Intrinsics.checkNotNullParameter((Object)$this$categoryOrUnknown, (String)"<this>");
        DasTypeCategory dasTypeCategory = DasTypeUtilsKt.getCategory($this$categoryOrUnknown);
        if (dasTypeCategory == null) {
            dasTypeCategory = DasTypeCategory.UNKNOWN;
        }
        return dasTypeCategory;
    }

    public static final boolean is(@NotNull DasType $this$is, @NotNull DasTypeCategory category) {
        Intrinsics.checkNotNullParameter((Object)$this$is, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        return DasTypeUtilsKt.getCategory($this$is) == category;
    }

    @NotNull
    public static final DasArrayType mapDeepestComponent(@NotNull DasArrayType $this$mapDeepestComponent, @NotNull DasType newDeepestComponentType, @NotNull DasTypeSystem typeSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$mapDeepestComponent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newDeepestComponentType, (String)"newDeepestComponentType");
        Intrinsics.checkNotNullParameter((Object)typeSystem, (String)"typeSystem");
        DasType dasType = $this$mapDeepestComponent.getComponentType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getComponentType(...)");
        DasType componentType = dasType;
        DasType newComponentType = componentType instanceof DasArrayType ? (DasType)DasTypeUtilsKt.mapDeepestComponent((DasArrayType)componentType, newDeepestComponentType, typeSystem) : newDeepestComponentType;
        DasArrayType dasArrayType = typeSystem.getArrayType(newComponentType);
        Intrinsics.checkNotNullExpressionValue((Object)dasArrayType, (String)"getArrayType(...)");
        return dasArrayType;
    }

    @NotNull
    public static final DasType actualizeStoredType(@NotNull DasType $this$actualizeStoredType) {
        Intrinsics.checkNotNullParameter((Object)$this$actualizeStoredType, (String)"<this>");
        return $this$actualizeStoredType;
    }

    @NotNull
    public static final DasType unwrapCollections(@NotNull DasType $this$unwrapCollections) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrapCollections, (String)"<this>");
        DasType t = $this$unwrapCollections;
        while (true) {
            DasType dasType;
            DasType dasType2;
            if ((dasType2 = (t = DasTypeUtilsKt.unwrap$default(t, false, null, 3, null))) instanceof DasCollectionType) {
                dasType = ((DasCollectionType)t).getInnerType();
            } else if (dasType2 instanceof DasMapType) {
                dasType = ((DasMapType)t).getValueType();
            } else {
                return t;
            }
            t = dasType;
        }
    }

    @JvmOverloads
    @NotNull
    public static final DasType unwrap(@NotNull DasType $this$unwrap, boolean untilUnknown) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrap, (String)"<this>");
        return DasTypeUtilsKt.unwrap$default($this$unwrap, untilUnknown, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final DasType unwrap(@NotNull DasType $this$unwrap) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrap, (String)"<this>");
        return DasTypeUtilsKt.unwrap$default($this$unwrap, false, null, 3, null);
    }

    private static final DasType getCacheableDasType$lambda$2(Function0 $tmp0) {
        return (DasType)$tmp0.invoke();
    }
}

