/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.symbols.DasSymbol;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDmlInstructionImpl
extends SqlCompositeElementImpl
implements SqlDmlInstruction {
    public SqlDmlInstructionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlDmlInstructionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    public SqlExpression getTargetExpression() {
        SqlDmlInstruction parent = this.getParentInstruction();
        if (parent != null) {
            return parent.getTargetExpression();
        }
        SqlTableColumnsList tableColumnsList = this.findChildByClass(SqlTableColumnsList.class);
        return tableColumnsList != null ? tableColumnsList.getTableExpression() : this.findChildByClass(SqlExpression.class);
    }

    @Override
    @NotNull
    public List<SqlReferenceExpression> getTargetColumnReferences() {
        SqlReferenceList refs;
        SqlTableColumnsList list = this.findChildByClass(SqlTableColumnsList.class);
        SqlReferenceList sqlReferenceList = refs = list == null ? this.findChildByClass(SqlReferenceList.class) : list.getColumnsReferenceList();
        if (refs != null) {
            List<SqlReferenceExpression> list2 = SqlImplUtil.getReferenceList(refs);
            if (list2 == null) {
                SqlDmlInstructionImpl.$$$reportNull$$$0(1);
            }
            return list2;
        }
        SqlDmlInstruction parent = this.getParentInstruction();
        List<SqlReferenceExpression> list3 = parent != null ? parent.getTargetColumnReferences() : Collections.emptyList();
        if (list3 == null) {
            SqlDmlInstructionImpl.$$$reportNull$$$0(2);
        }
        return list3;
    }

    @Nullable
    protected SqlDmlInstruction getParentInstruction() {
        PsiElement parent = this.getParent();
        SqlDmlInstruction instruction = (SqlDmlInstruction)ObjectUtils.tryCast((Object)this.getParent(), SqlDmlInstruction.class);
        if (instruction == null && parent instanceof SqlClause) {
            instruction = (SqlDmlInstruction)ObjectUtils.tryCast((Object)parent.getParent(), SqlDmlInstruction.class);
        }
        if (PsiUtilCore.getElementType((PsiElement)instruction) == SqlCompositeElementTypes.SQL_MERGE_DML_INSTRUCTION) {
            return instruction;
        }
        return null;
    }

    @Override
    public SqlTableType getTargetType() {
        return SqlImplUtil.getTableTypeOfColumnList(this.getTargetColumnReferences(), this.getTargetExpression());
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlDmlInstruction(this);
    }

    private static boolean processTargetExpression(SqlExpression targetExpression, SqlScopeProcessor processor, ResolveState state, PsiElement place) {
        if (targetExpression instanceof SqlReferenceExpression) {
            SqlReferenceExpression expression = (SqlReferenceExpression)targetExpression;
            if (SqlImplUtil.isProcessingOneOf(processor, expression.getReferenceElementType().getTargetKind())) {
                for (ResolveResult result2 : expression.multiResolve(false)) {
                    DasSymbol symbol = DasSymbolUtil.getSymbol(result2);
                    if (symbol == null || processor.execute(symbol, state)) continue;
                    return false;
                }
            }
            if (!SqlImplUtil.processQualifier(expression, processor, state, place)) {
                return false;
            }
        } else {
            if (targetExpression instanceof SqlDefinition && !processor.execute((SqlDefinition)((Object)targetExpression), state)) {
                return false;
            }
            if (!SqlImplUtil.processDeclarationsInType(targetExpression, processor, state, place)) {
                return false;
            }
        }
        if (processor.isResultEmpty() && processor.mayAccept(SqlDbElementType.CONSTRAINT) && targetExpression instanceof SqlAsExpression) {
            return SqlDmlInstructionImpl.processTargetExpression(((SqlAsExpression)targetExpression).getExpression(), processor, state, place);
        }
        return true;
    }

    @Override
    public boolean processImplicitContextDeclarations(SqlScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlQueryExpression query;
        SqlTableColumnsList targetParent;
        SqlExpression targetExpression = this.getTargetExpression();
        if (targetExpression != null && lastParent == ObjectUtils.chooseNotNull((Object)(targetParent = (SqlTableColumnsList)ObjectUtils.tryCast((Object)targetExpression.getParent(), SqlTableColumnsList.class)), (Object)targetExpression)) {
            return true;
        }
        if (!(targetExpression == null || lastParent instanceof SqlQueryExpression || lastParent instanceof SqlFromClause || SqlDmlInstructionImpl.processTargetExpression(targetExpression, processor, state, place))) {
            return false;
        }
        SqlUsingClause[] usingClauses = (SqlUsingClause[])PsiTreeUtil.getChildrenOfType((PsiElement)this, SqlUsingClause.class);
        if (usingClauses != null && !Arrays.asList(usingClauses).contains(lastParent)) {
            for (SqlUsingClause clause : usingClauses) {
                SqlExpression usingExpression = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)clause, SqlExpression.class);
                if (usingExpression == null || SqlImplUtil.processDeclarationsInType(usingExpression, processor, state, place)) continue;
                return false;
            }
        }
        if (lastParent != (query = (SqlQueryExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlQueryExpression.class)) && query != null && !query.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlDmlInstructionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlDmlInstructionImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetColumnReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

