/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import java.util.List;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.simplify.LineSegmentIndex;
import org.locationtech.jts.simplify.TaggedLineSegment;
import org.locationtech.jts.simplify.TaggedLineString;

public class TaggedLineStringSimplifier {
    private LineIntersector li = new RobustLineIntersector();
    private LineSegmentIndex inputIndex = new LineSegmentIndex();
    private LineSegmentIndex outputIndex = new LineSegmentIndex();
    private TaggedLineString line;
    private Coordinate[] linePts;
    private double distanceTolerance = 0.0;

    public TaggedLineStringSimplifier(LineSegmentIndex inputIndex, LineSegmentIndex outputIndex) {
        this.inputIndex = inputIndex;
        this.outputIndex = outputIndex;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        this.distanceTolerance = distanceTolerance;
    }

    void simplify(TaggedLineString line) {
        this.line = line;
        this.linePts = line.getParentCoordinates();
        this.simplifySection(0, this.linePts.length - 1, 0);
    }

    private void simplifySection(int i2, int j, int depth) {
        int worstCaseSize;
        ++depth;
        int[] sectionIndex = new int[2];
        if (i2 + 1 == j) {
            TaggedLineSegment newSeg = this.line.getSegment(i2);
            this.line.addToResult(newSeg);
            return;
        }
        boolean isValidToSimplify = true;
        if (this.line.getResultSize() < this.line.getMinimumSize() && (worstCaseSize = depth + 1) < this.line.getMinimumSize()) {
            isValidToSimplify = false;
        }
        double[] distance = new double[1];
        int furthestPtIndex = this.findFurthestPoint(this.linePts, i2, j, distance);
        if (distance[0] > this.distanceTolerance) {
            isValidToSimplify = false;
        }
        LineSegment candidateSeg = new LineSegment();
        candidateSeg.p0 = this.linePts[i2];
        candidateSeg.p1 = this.linePts[j];
        sectionIndex[0] = i2;
        sectionIndex[1] = j;
        if (this.hasBadIntersection(this.line, sectionIndex, candidateSeg)) {
            isValidToSimplify = false;
        }
        if (isValidToSimplify) {
            LineSegment newSeg = this.flatten(i2, j);
            this.line.addToResult(newSeg);
            return;
        }
        this.simplifySection(i2, furthestPtIndex, depth);
        this.simplifySection(furthestPtIndex, j, depth);
    }

    private int findFurthestPoint(Coordinate[] pts, int i2, int j, double[] maxDistance) {
        LineSegment seg = new LineSegment();
        seg.p0 = pts[i2];
        seg.p1 = pts[j];
        double maxDist = -1.0;
        int maxIndex = i2;
        for (int k = i2 + 1; k < j; ++k) {
            Coordinate midPt = pts[k];
            double distance = seg.distance(midPt);
            if (!(distance > maxDist)) continue;
            maxDist = distance;
            maxIndex = k;
        }
        maxDistance[0] = maxDist;
        return maxIndex;
    }

    private LineSegment flatten(int start2, int end) {
        Coordinate p0 = this.linePts[start2];
        Coordinate p1 = this.linePts[end];
        LineSegment newSeg = new LineSegment(p0, p1);
        this.remove(this.line, start2, end);
        this.outputIndex.add(newSeg);
        return newSeg;
    }

    private boolean hasBadIntersection(TaggedLineString parentLine, int[] sectionIndex, LineSegment candidateSeg) {
        if (this.hasBadOutputIntersection(candidateSeg)) {
            return true;
        }
        return this.hasBadInputIntersection(parentLine, sectionIndex, candidateSeg);
    }

    private boolean hasBadOutputIntersection(LineSegment candidateSeg) {
        List querySegs = this.outputIndex.query(candidateSeg);
        for (LineSegment querySeg : querySegs) {
            if (!this.hasInteriorIntersection(querySeg, candidateSeg)) continue;
            return true;
        }
        return false;
    }

    private boolean hasBadInputIntersection(TaggedLineString parentLine, int[] sectionIndex, LineSegment candidateSeg) {
        List querySegs = this.inputIndex.query(candidateSeg);
        for (TaggedLineSegment querySeg : querySegs) {
            if (!this.hasInteriorIntersection(querySeg, candidateSeg) || TaggedLineStringSimplifier.isInLineSection(parentLine, sectionIndex, querySeg)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInLineSection(TaggedLineString line, int[] sectionIndex, TaggedLineSegment seg) {
        if (seg.getParent() != line.getParent()) {
            return false;
        }
        int segIndex = seg.getIndex();
        return segIndex >= sectionIndex[0] && segIndex < sectionIndex[1];
    }

    private boolean hasInteriorIntersection(LineSegment seg0, LineSegment seg1) {
        this.li.computeIntersection(seg0.p0, seg0.p1, seg1.p0, seg1.p1);
        return this.li.isInteriorIntersection();
    }

    private void remove(TaggedLineString line, int start2, int end) {
        for (int i2 = start2; i2 < end; ++i2) {
            TaggedLineSegment seg = line.getSegment(i2);
            this.inputIndex.remove(seg);
        }
    }
}

