/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import org.locationtech.jts.io.OrdinateFormat;
import org.locationtech.jts.util.Assert;

public class StringUtil {
    public static final String NEWLINE = System.getProperty("line.separator");

    public static String[] split(String s, String separator) {
        int separatorlen = separator.length();
        ArrayList<String> tokenList = new ArrayList<String>();
        String tmpString = "" + s;
        int pos = tmpString.indexOf(separator);
        while (pos >= 0) {
            String token = tmpString.substring(0, pos);
            tokenList.add(token);
            tmpString = tmpString.substring(pos + separatorlen);
            pos = tmpString.indexOf(separator);
        }
        if (tmpString.length() > 0) {
            tokenList.add(tmpString);
        }
        String[] res = new String[tokenList.size()];
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = (String)tokenList.get(i2);
        }
        return res;
    }

    public static String getStackTrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    public static String getStackTrace(Throwable t, int depth) {
        String stackTrace = "";
        StringReader stringReader = new StringReader(StringUtil.getStackTrace(t));
        LineNumberReader lineNumberReader = new LineNumberReader(stringReader);
        for (int i2 = 0; i2 < depth; ++i2) {
            try {
                stackTrace = stackTrace + lineNumberReader.readLine() + NEWLINE;
                continue;
            }
            catch (IOException e) {
                Assert.shouldNeverReachHere();
            }
        }
        return stackTrace;
    }

    public static String toString(double d) {
        return OrdinateFormat.DEFAULT.format(d);
    }

    public static String spaces(int n) {
        return StringUtil.chars(' ', n);
    }

    public static String chars(char c2, int n) {
        char[] ch = new char[n];
        for (int i2 = 0; i2 < n; ++i2) {
            ch[i2] = c2;
        }
        return new String(ch);
    }
}

