/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.injection;

import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.injection.SqlTypeBasedInjection;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlToken;
import com.intellij.sql.psi.SqlTypeCastExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SqlTypeBasedInjector
implements MultiHostInjector {
    private final Project myProject;
    private final AtomicReference<InjectionsCache> myInjections;

    public SqlTypeBasedInjector(@NotNull Project project) {
        if (project == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myInjections = new AtomicReference();
    }

    @NonInjectable
    @TestOnly
    public SqlTypeBasedInjector(@NotNull Project project, @NotNull Map<Language, SqlTypeBasedInjection> injections) {
        if (project == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(1);
        }
        if (injections == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        ArrayList<InjectionsCache.CacheEntry> result = new ArrayList<InjectionsCache.CacheEntry>();
        for (Map.Entry<Language, SqlTypeBasedInjection> entry : injections.entrySet()) {
            SqlTypeBasedInjection inj = entry.getValue();
            inj.setInjectedLanguageId(entry.getKey().getID());
            IElementType fragment = inj.getFragment() == null ? null : Objects.requireNonNull(SqlTokenRegistry.findCompositeType((String)inj.getFragment()));
            result.add(new InjectionsCache.CacheEntry(inj, entry.getKey(), fragment));
        }
        this.myInjections = new AtomicReference<InjectionsCache>(new InjectionsCache(result, -1L));
    }

    @Nullable
    protected Configuration getConfiguration() {
        return Configuration.getProjectInstance((Project)this.myProject);
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        List<InjectionsCache.CacheEntry> injections;
        if (registrar == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(3);
        }
        if (context == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(4);
        }
        if ((injections = this.getFreshCache().forDialect(SqlImplUtil.getSqlDialectSafe((PsiElement)context))).isEmpty()) {
            return;
        }
        LinkedHashMap langs = new LinkedHashMap();
        SqlTypeBasedInjector.process(context, (PairProcessor<PsiElement, String>)((PairProcessor)(element, type) -> {
            if (element instanceof PsiLanguageInjectionHost && type != null) {
                SqlTypeBasedInjector.mergeLang(langs, (PsiLanguageInjectionHost)element, SqlTypeBasedInjector.getLanguageForType(type, injections));
            }
            return true;
        }));
        for (Map.Entry entry : langs.entrySet()) {
            PsiLanguageInjectionHost host;
            InjectionsCache.CacheEntry inj = (InjectionsCache.CacheEntry)entry.getValue();
            Language lang = inj.resolved;
            if (lang == Language.ANY || SqlTypeBasedInjector.isInjectedByComment(host = (PsiLanguageInjectionHost)entry.getKey())) continue;
            TextRange range = ElementManipulators.getValueTextRange((PsiElement)host);
            InjectedLanguageUtilBase.INJECTED_FRAGMENT_TYPE.set((UserDataHolder)host, (Object)inj.fragment);
            InjectorUtils.registerInjection((Language)lang, (PsiFile)host.getContainingFile(), Collections.singletonList(new InjectorUtils.InjectionInfo(host, inj.injected, range)), (MultiHostRegistrar)registrar, it -> SqlTypeBasedInjector.registerSupport(it));
        }
    }

    @NotNull
    public static Set<String> getTypesFor(@NotNull PsiLanguageInjectionHost element) {
        if (element == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(5);
        }
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        SqlTypeBasedInjector.process((PsiElement)element, (PairProcessor<PsiElement, String>)((PairProcessor)(el, type) -> {
            if (el == element && type != null) {
                types.add((String)type);
            }
            return true;
        }));
        LinkedHashSet<String> linkedHashSet = types;
        if (linkedHashSet == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    private static boolean process(@Nullable PsiElement element, @NotNull PairProcessor<PsiElement, String> processor2) {
        if (processor2 == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(7);
        }
        while (element != null && !Holder.ourIsInjectionSearchPoint.value((Object)element)) {
            element = element.getParent();
        }
        if (element instanceof SqlSetAssignment) {
            return SqlTypeBasedInjector.processAssignment((SqlSetAssignment)element, processor2);
        }
        if (element instanceof SqlBinaryExpression) {
            return SqlTypeBasedInjector.processBinaryExpression((SqlBinaryExpression)element, processor2);
        }
        if (element instanceof SqlExpressionList) {
            return SqlTypeBasedInjector.processExpressionList((SqlExpressionList)element, processor2);
        }
        if (element instanceof SqlTypeCastExpression) {
            return SqlTypeBasedInjector.processTypeCast((SqlTypeCastExpression)element, processor2);
        }
        if (element instanceof SqlColumnDefinition) {
            return SqlTypeBasedInjector.processColumnDef((SqlColumnDefinition)element, processor2);
        }
        return true;
    }

    private static boolean processBinaryExpression(@NotNull SqlBinaryExpression expr, @NotNull PairProcessor<PsiElement, String> processor2) {
        if (expr == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(8);
        }
        if (processor2 == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(9);
        }
        SqlExpression left = expr.getLOperand();
        SqlExpression right = expr.getROperand();
        IElementType sign = expr.getOpSign();
        if (right == null) {
            return true;
        }
        if (!SqlCommonTokens.SAME_TYPE_OPERATORS.contains(sign)) {
            return true;
        }
        return right instanceof PsiLanguageInjectionHost ? SqlTypeBasedInjector.processFromExpression(left, (PsiElement)right, processor2) : SqlTypeBasedInjector.processFromExpression(right, (PsiElement)left, processor2);
    }

    private static boolean processAssignment(@NotNull SqlSetAssignment assignment, @NotNull PairProcessor<PsiElement, String> processor2) {
        SqlExpression left;
        if (assignment == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(10);
        }
        if (processor2 == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(11);
        }
        if ((left = (SqlExpression)ObjectUtils.tryCast((Object)assignment.getLValue(), SqlExpression.class)) == null) {
            return true;
        }
        SqlElement right = assignment.getRValue();
        if (!(right instanceof PsiLanguageInjectionHost)) {
            return true;
        }
        return SqlTypeBasedInjector.processFromExpression(left, (PsiElement)right, processor2);
    }

    private static boolean processFromExpression(@NotNull SqlExpression expr, @NotNull PsiElement place, @NotNull PairProcessor<PsiElement, String> processor2) {
        DasType dasType;
        if (expr == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(12);
        }
        if (place == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(13);
        }
        if (processor2 == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(14);
        }
        if ((dasType = expr.getDasType()) == DasTypeSystemBase.UNKNOWN) {
            return true;
        }
        String name2 = dasType.getDescription();
        return processor2.process((Object)place, (Object)name2);
    }

    private static boolean processTypeCast(@Nullable SqlTypeCastExpression castExpression, @NotNull PairProcessor<PsiElement, String> processor2) {
        if (processor2 == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(15);
        }
        if (castExpression == null) {
            return true;
        }
        SqlExpression expression = castExpression.getExpression();
        SqlTypeElement typeElement = castExpression.getTypeElement();
        return typeElement == null || processor2.process((Object)expression, (Object)DasTypeUtilsKt.getTypeName((DasType)typeElement.getDasType()));
    }

    private static boolean processColumnDef(@Nullable SqlColumnDefinition columnDef, @NotNull PairProcessor<PsiElement, String> processor2) {
        if (processor2 == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(16);
        }
        if (columnDef == null) {
            return true;
        }
        DasType dasType = columnDef.getDasType();
        if (dasType == DasTypeSystemBase.UNKNOWN) {
            return true;
        }
        String typeName = DasTypeUtilsKt.getTypeName((DasType)dasType);
        for (SqlConstraintDefinition constraint : columnDef.getConstraints()) {
            PsiLanguageInjectionHost def;
            if (constraint.getConstraintType() != SqlConstraintDefinition.Type.DEFAULT || (def = (PsiLanguageInjectionHost)ObjectUtils.tryCast((Object)PsiTreeUtil.getChildOfType((PsiElement)constraint, SqlExpression.class), PsiLanguageInjectionHost.class)) == null || processor2.process((Object)def, (Object)typeName)) continue;
            return false;
        }
        return true;
    }

    private static boolean processExpressionList(@Nullable SqlExpressionList list, @NotNull PairProcessor<PsiElement, String> processor2) {
        JBIterable toMatch;
        Object[] lists;
        if (processor2 == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(17);
        }
        if ((lists = SqlTypeBasedInjector.getExpressionsList(list)) == null || lists.length == 0) {
            return true;
        }
        if (list.getParent() instanceof SqlFunctionCallExpression) {
            Object matching = null;
            for (Object overload : lists) {
                if (!overload.isMatched()) continue;
                if (matching != null) {
                    matching = null;
                    break;
                }
                matching = overload;
            }
            toMatch = matching != null ? Collections.singleton(matching) : JBIterable.of((Object[])lists);
        } else {
            toMatch = JBIterable.of((Object[])lists).filter(SqlFunctionsUtil.ExpressionList::isMatched);
        }
        if (!toMatch.iterator().hasNext()) {
            toMatch = JBIterable.of((Object[])lists);
        }
        for (SqlFunctionsUtil.ExpressionList elist : toMatch) {
            if (elist.processArgumentTypes((e, name2, type) -> processor2.process((Object)e, (Object)type))) continue;
            return false;
        }
        return true;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    SqlFunctionsUtil.ExpressionList @Nullable [] getExpressionsList(@Nullable SqlExpressionList list) {
        if (list == null) {
            return null;
        }
        if (list.getParent() instanceof SqlFunctionCallExpression) {
            return SqlFunctionsUtil.getOverloads((SqlFunctionCallExpression)((SqlFunctionCallExpression)list.getParent()));
        }
        SqlDmlInstruction instruction = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)list, SqlDmlInstruction.class, (boolean)true, (Class[])new Class[]{SqlQueryExpression.class});
        boolean isPartOfIn = SqlTypeBasedInjector.isPartOfIn(list);
        if (!isPartOfIn && instruction != null) {
            return SqlFunctionsUtil.getInsertVariants((SqlDmlInstruction)instruction, (SqlExpressionList)list);
        }
        return null;
    }

    private static boolean isPartOfIn(@NotNull SqlExpressionList list) {
        SqlToken previousToken;
        if (list == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(18);
        }
        return PsiUtilCore.getElementType((PsiElement)(previousToken = (SqlToken)PsiTreeUtil.getPrevSiblingOfType((PsiElement)list, SqlToken.class))) == SqlCommonKeywords.SQL_IN;
    }

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<? extends PsiElement>> list = Holder.ourSqlInjectionSearchPoints;
        if (list == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(19);
        }
        return list;
    }

    public static boolean isInjectedByComment(@Nullable PsiLanguageInjectionHost element) {
        return element != null && InjectorUtils.findCommentInjection((PsiElement)element, (String)"comment", null) != null;
    }

    private static void registerSupport(MultiHostRegistrar registrar) {
        LanguageInjectionSupport support = InjectorUtils.findInjectionSupport((String)"sql");
        if (support != null) {
            InjectorUtils.registerSupport((MultiHostRegistrar)registrar, (LanguageInjectionSupport)support, (boolean)true);
        }
    }

    @NotNull
    private InjectionsCache getFreshCache() {
        InjectionsCache cache = this.myInjections.get();
        Configuration myConfiguration = this.getConfiguration();
        if (myConfiguration == null) {
            InjectionsCache injectionsCache = Objects.requireNonNull(cache);
            if (injectionsCache == null) {
                SqlTypeBasedInjector.$$$reportNull$$$0(20);
            }
            return injectionsCache;
        }
        long counter = myConfiguration.getModificationCount();
        if (cache != null && cache.modCounter == counter) {
            InjectionsCache injectionsCache = cache;
            if (injectionsCache == null) {
                SqlTypeBasedInjector.$$$reportNull$$$0(21);
            }
            return injectionsCache;
        }
        cache = new InjectionsCache(JBIterable.from((Iterable)myConfiguration.getInjections("sql")).filter(SqlTypeBasedInjection.class).transform(InjectionsCache.CacheEntry::of).filter(Conditions.notNull()).toList(), counter);
        this.myInjections.set(cache);
        InjectionsCache injectionsCache = cache;
        if (injectionsCache == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(22);
        }
        return injectionsCache;
    }

    @NotNull
    private static Set<InjectionsCache.CacheEntry> getLanguageForType(@NotNull String type, @NotNull List<InjectionsCache.CacheEntry> cache) {
        if (type == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(23);
        }
        if (cache == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(24);
        }
        InjectionsCache.CacheEntry first2 = null;
        Set res2 = null;
        CharSequence bombed = null;
        for (InjectionsCache.CacheEntry item : cache) {
            if (!item.injection.isEnabled()) continue;
            if (bombed == null) {
                bombed = StringUtil.newBombedCharSequence((CharSequence)type, (long)100L);
            }
            if (SqlTypeBasedInjector.matchTimed(bombed, item) != Boolean.TRUE || item.resolved == Language.ANY || Comparing.equal(first2, (Object)item)) continue;
            if (first2 == null) {
                first2 = item;
                continue;
            }
            if (res2 == null) {
                res2 = ContainerUtil.newLinkedHashSet((Object[])new InjectionsCache.CacheEntry[]{first2, item});
                continue;
            }
            res2.add(item);
        }
        if (res2 != null) {
            Set set = res2;
            if (set == null) {
                SqlTypeBasedInjector.$$$reportNull$$$0(25);
            }
            return set;
        }
        if (first2 != null) {
            Set<Object> set = Collections.singleton(first2);
            if (set == null) {
                SqlTypeBasedInjector.$$$reportNull$$$0(26);
            }
            return set;
        }
        Set<InjectionsCache.CacheEntry> set = Collections.emptySet();
        if (set == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(27);
        }
        return set;
    }

    @Nullable
    private static Boolean matchTimed(@NotNull CharSequence bombed, @NotNull InjectionsCache.CacheEntry item) {
        if (bombed == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(28);
        }
        if (item == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(29);
        }
        try {
            return item.injection.getPattern().matcher(bombed).matches();
        }
        catch (ProcessCanceledException e) {
            return null;
        }
    }

    private static void mergeLang(@NotNull Map<PsiLanguageInjectionHost, InjectionsCache.CacheEntry> langs, @NotNull PsiLanguageInjectionHost host, @NotNull Set<InjectionsCache.CacheEntry> inj) {
        if (langs == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(30);
        }
        if (host == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(31);
        }
        if (inj == null) {
            SqlTypeBasedInjector.$$$reportNull$$$0(32);
        }
        InjectionsCache.CacheEntry lang = inj.size() != 1 ? InjectionsCache.CacheEntry.BAD : inj.iterator().next();
        InjectionsCache.CacheEntry old2 = langs.get(host);
        if (old2 == InjectionsCache.CacheEntry.BAD || old2 == lang) {
            return;
        }
        langs.put(host, old2 == null ? lang : InjectionsCache.CacheEntry.BAD);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 19, 20, 21, 22, 25, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injections";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/injection/SqlTypeBasedInjector";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bombed";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langs";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/injection/SqlTypeBasedInjector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesFor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFreshCache";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageForType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypesFor";
                break;
            }
            case 6: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processBinaryExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processAssignment";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processFromExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processTypeCast";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processColumnDef";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processExpressionList";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isPartOfIn";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageForType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "matchTimed";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "mergeLang";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 19, 20, 21, 22, 25, 26, 27 -> new IllegalStateException(string);
        };
    }

    private static final class InjectionsCache {
        public final List<CacheEntry> items;
        public final long modCounter;
        private final Map<String, List<CacheEntry>> myByLang;

        private InjectionsCache(@NotNull List<CacheEntry> items, long counter) {
            if (items == null) {
                InjectionsCache.$$$reportNull$$$0(0);
            }
            this.myByLang = ContainerUtil.createConcurrentSoftValueMap();
            this.items = items;
            this.modCounter = counter;
        }

        @NotNull
        public List<CacheEntry> forDialect(@NotNull SqlLanguageDialectEx lang) {
            List<CacheEntry> cached;
            if (lang == null) {
                InjectionsCache.$$$reportNull$$$0(1);
            }
            if ((cached = this.myByLang.get(lang.getID())) != null) {
                List<CacheEntry> list = cached;
                if (list == null) {
                    InjectionsCache.$$$reportNull$$$0(2);
                }
                return list;
            }
            ArrayList<CacheEntry> newCached = new ArrayList<CacheEntry>();
            String id = lang.getID();
            for (CacheEntry item : this.items) {
                List<String> hosts = item.injection.getHostLanguages();
                if (!hosts.isEmpty() && !hosts.contains(id)) continue;
                newCached.add(item);
            }
            newCached.trimToSize();
            this.myByLang.put(lang.getID(), newCached);
            ArrayList<CacheEntry> arrayList = newCached;
            if (arrayList == null) {
                InjectionsCache.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lang";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/injection/SqlTypeBasedInjector$InjectionsCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/injection/SqlTypeBasedInjector$InjectionsCache";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forDialect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "forDialect";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }

        public static class CacheEntry {
            public static final CacheEntry BAD = new CacheEntry(new SqlTypeBasedInjection(), Language.ANY, null);
            public final SqlTypeBasedInjection injection;
            public final Language resolved;
            public final InjectedLanguage injected;
            public final IElementType fragment;

            @Nullable
            public static CacheEntry of(SqlTypeBasedInjection injection) {
                Language language = Language.findLanguageByID((String)injection.getInjectedLanguageId());
                if (language == null) {
                    return null;
                }
                IElementType fragment = null;
                if (injection.getFragment() != null && (fragment = SqlTokenRegistry.findCompositeType((String)injection.getFragment())) == null) {
                    return null;
                }
                return new CacheEntry(injection, language, fragment);
            }

            public CacheEntry(@NotNull SqlTypeBasedInjection injection, @NotNull Language resolved, @Nullable IElementType fragment) {
                if (injection == null) {
                    CacheEntry.$$$reportNull$$$0(0);
                }
                if (resolved == null) {
                    CacheEntry.$$$reportNull$$$0(1);
                }
                this.injection = injection;
                this.resolved = resolved;
                this.fragment = fragment;
                this.injected = InjectedLanguage.create((String)injection.getInjectedLanguageId(), (String)injection.getPrefix(), (String)injection.getSuffix(), (boolean)false);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CacheEntry entry = (CacheEntry)o;
                return this.injected.equals((Object)entry.injected);
            }

            public int hashCode() {
                return this.injected.hashCode();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "injection";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "resolved";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/injection/SqlTypeBasedInjector$InjectionsCache$CacheEntry";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class Holder {
        private static final List<Class<? extends PsiElement>> ourSqlInjectionSearchPoints = List.of(SqlExpressionList.class, SqlColumnDefinition.class, SqlTypeCastExpression.class, SqlSetAssignment.class, SqlBinaryExpression.class);
        private static final Condition<PsiElement> ourIsInjectionSearchPoint = Conditions.instanceOf((Class[])ourSqlInjectionSearchPoints.toArray(ArrayUtil.EMPTY_CLASS_ARRAY));

        private Holder() {
        }
    }
}

