/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.javascript.karma.KarmaConfig;
import com.intellij.javascript.karma.server.CapturedBrowser;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.StreamEventHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.webcore.util.JsonUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaServerState {
    private static final Logger LOG = Logger.getInstance(KarmaServerState.class);
    private static final String BROWSER_CONNECTED_EVENT_TYPE = "browserConnected";
    private static final String BROWSER_DISCONNECTED_EVENT_TYPE = "browserDisconnected";
    private static final Pattern SERVER_PORT_LINE_PATTERN = Pattern.compile("Karma.+server started at http[s]?://[^:]+:(\\d+)/.*$");
    private static final String[][] FAILED_TO_START_BROWSER_PATTERNS = new String[][]{{"ERROR [launcher]: No binary for ", " browser on your platform.\n"}, {"ERROR [launcher]: Cannot start ", "\n"}};
    private final KarmaServer myServer;
    private final List<String> myOverriddenBrowsers;
    private final ConcurrentMap<String, CapturedBrowser> myCapturedBrowsers;
    private final AtomicInteger myBoundServerPort;
    private final AtomicBoolean myBrowsersReady;
    private final List<String> myFailedToStartBrowsers;
    private volatile KarmaConfig myConfig;

    public KarmaServerState(@NotNull KarmaServer server, @NotNull String configurationFilePath, @NotNull String workingDirectory) {
        if (server == null) {
            KarmaServerState.$$$reportNull$$$0(0);
        }
        if (configurationFilePath == null) {
            KarmaServerState.$$$reportNull$$$0(1);
        }
        if (workingDirectory == null) {
            KarmaServerState.$$$reportNull$$$0(2);
        }
        this.myCapturedBrowsers = Maps.newConcurrentMap();
        this.myBoundServerPort = new AtomicInteger(-1);
        this.myBrowsersReady = new AtomicBoolean(false);
        this.myFailedToStartBrowsers = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myServer = server;
        this.myOverriddenBrowsers = KarmaServerState.parseBrowsers(KarmaServerState.findBrowsers(server.getServerSettings().getKarmaOptions()));
        this.myServer.registerStreamEventHandler(new BrowserEventHandler(BROWSER_CONNECTED_EVENT_TYPE));
        this.myServer.registerStreamEventHandler(new BrowserEventHandler(BROWSER_DISCONNECTED_EVENT_TYPE));
        this.myServer.registerStreamEventHandler(new BrowserCapturingFailedEventHandler());
        this.myServer.registerStreamEventHandler(new ConfigHandler(configurationFilePath, workingDirectory));
    }

    @NotNull
    private static String findBrowsers(@NotNull String karmaOptions) {
        if (karmaOptions == null) {
            KarmaServerState.$$$reportNull$$$0(3);
        }
        String singleOptionPrefix = "--browsers=";
        List options = ParametersListUtil.parse((String)karmaOptions);
        Optional<String> singleOption = options.stream().filter(s -> s.startsWith(singleOptionPrefix)).findFirst();
        if (singleOption.isPresent()) {
            String string = singleOption.get().substring(singleOptionPrefix.length());
            if (string == null) {
                KarmaServerState.$$$reportNull$$$0(4);
            }
            return string;
        }
        int ind = options.indexOf("--browsers");
        if (ind >= 0 && ind < options.size() - 1) {
            String string = (String)options.get(ind + 1);
            if (string == null) {
                KarmaServerState.$$$reportNull$$$0(5);
            }
            return string;
        }
        return "";
    }

    @Nullable
    private static List<String> parseBrowsers(@NotNull String browsersStr) {
        if (browsersStr == null) {
            KarmaServerState.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmptyOrSpaces((String)browsersStr)) {
            return null;
        }
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return splitter.splitToList((CharSequence)browsersStr);
    }

    private void handleBrowsersChange(@NotNull String eventType, @NotNull String browserId, @NotNull String browserName, @Nullable Boolean autoCaptured) {
        if (eventType == null) {
            KarmaServerState.$$$reportNull$$$0(7);
        }
        if (browserId == null) {
            KarmaServerState.$$$reportNull$$$0(8);
        }
        if (browserName == null) {
            KarmaServerState.$$$reportNull$$$0(9);
        }
        if (BROWSER_CONNECTED_EVENT_TYPE.equals(eventType)) {
            CapturedBrowser browser = new CapturedBrowser(browserName, browserId, (Boolean)ObjectUtils.notNull((Object)autoCaptured, (Object)true));
            this.myCapturedBrowsers.put(browserId, browser);
        } else {
            this.myCapturedBrowsers.remove(browserId);
        }
        this.updateBrowsersReadyStatus();
    }

    private void updateBrowsersReadyStatus() {
        boolean ready = this.isCapturedBrowsersQuorum();
        if (this.myBrowsersReady.compareAndSet(!ready, ready)) {
            this.myServer.fireOnBrowsersReady(ready);
        }
    }

    private boolean isCapturedBrowsersQuorum() {
        List<String> expectedBrowsers = this.myOverriddenBrowsers;
        if (expectedBrowsers == null) {
            KarmaConfig config = this.myConfig;
            if (config == null) {
                return true;
            }
            expectedBrowsers = config.getBrowsers();
        }
        HashSet<String> expectedBrowserSet = new HashSet<String>(expectedBrowsers);
        this.myFailedToStartBrowsers.forEach(expectedBrowserSet::remove);
        if (ContainerUtil.exists(this.myCapturedBrowsers.values(), o -> !o.isAutoCaptured())) {
            return true;
        }
        long autoCapturedCount = this.myCapturedBrowsers.values().stream().filter(o -> o.isAutoCaptured()).count();
        return autoCapturedCount > 0L && (long)expectedBrowserSet.size() <= autoCapturedCount;
    }

    public boolean areBrowsersReady() {
        return this.myBrowsersReady.get();
    }

    public int getServerPort() {
        return this.myBoundServerPort.get();
    }

    @Nullable
    public KarmaConfig getKarmaConfig() {
        return this.myConfig;
    }

    public void onStandardOutputLineAvailable(@NotNull String line) {
        String failedToStartBrowser;
        int serverPort;
        if (line == null) {
            KarmaServerState.$$$reportNull$$$0(10);
        }
        if ((serverPort = this.myBoundServerPort.get()) == -1 && (serverPort = KarmaServerState.parseServerPort(line)) != -1 && this.myBoundServerPort.compareAndSet(-1, serverPort)) {
            this.myServer.fireOnPortBound();
        }
        if (!this.myBrowsersReady.get() && (failedToStartBrowser = KarmaServerState.parseFailedToStartBrowser(line)) != null) {
            this.onBrowserCapturingFailed(failedToStartBrowser);
        }
    }

    private void onBrowserCapturingFailed(@NotNull String notCapturedBrowser) {
        if (notCapturedBrowser == null) {
            KarmaServerState.$$$reportNull$$$0(11);
        }
        LOG.info("Browser " + notCapturedBrowser + " failed to be captured");
        this.myFailedToStartBrowsers.add(notCapturedBrowser);
        this.updateBrowsersReadyStatus();
    }

    @Nullable
    private static String parseFailedToStartBrowser(@NotNull String line) {
        if (line == null) {
            KarmaServerState.$$$reportNull$$$0(12);
        }
        for (String[] pattern : FAILED_TO_START_BROWSER_PATTERNS) {
            String failedToStartBrowser = KarmaServerState.getInnerSubstring(line, pattern[0], pattern[1]);
            if (failedToStartBrowser == null) continue;
            return failedToStartBrowser;
        }
        return null;
    }

    private static int parseServerPort(@NotNull String text) {
        Matcher m;
        if (text == null) {
            KarmaServerState.$$$reportNull$$$0(13);
        }
        if ((m = SERVER_PORT_LINE_PATTERN.matcher(text)).find()) {
            String portStr = m.group(1);
            try {
                return Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                LOG.warn("Can't parse web server port from '" + text + "'");
            }
        }
        return -1;
    }

    @Nullable
    private static String getInnerSubstring(@NotNull String str, @NotNull String prefix, @NotNull String suffix) {
        if (str == null) {
            KarmaServerState.$$$reportNull$$$0(14);
        }
        if (prefix == null) {
            KarmaServerState.$$$reportNull$$$0(15);
        }
        if (suffix == null) {
            KarmaServerState.$$$reportNull$$$0(16);
        }
        if (str.startsWith(prefix) && str.endsWith(suffix) && prefix.length() + suffix.length() <= str.length()) {
            return str.substring(prefix.length(), str.length() - suffix.length());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFilePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "karmaOptions";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/server/KarmaServerState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browsersStr";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserName";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notCapturedBrowser";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/server/KarmaServerState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findBrowsers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findBrowsers";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseBrowsers";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleBrowsersChange";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onStandardOutputLineAvailable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onBrowserCapturingFailed";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseFailedToStartBrowser";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseServerPort";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getInnerSubstring";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    private final class BrowserEventHandler
    implements StreamEventHandler {
        private final String myEventType;

        private BrowserEventHandler(String eventType) {
            if (eventType == null) {
                BrowserEventHandler.$$$reportNull$$$0(0);
            }
            this.myEventType = eventType;
        }

        @Override
        @NotNull
        public String getEventType() {
            String string = this.myEventType;
            if (string == null) {
                BrowserEventHandler.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void handle(@NotNull JsonElement eventBody) {
            if (eventBody == null) {
                BrowserEventHandler.$$$reportNull$$$0(2);
            }
            if (eventBody.isJsonObject()) {
                JsonObject event = eventBody.getAsJsonObject();
                String id = JsonUtil.getChildAsString((JsonObject)event, (String)"id");
                String name = JsonUtil.getChildAsString((JsonObject)event, (String)"name");
                Boolean autoCaptured = JsonUtil.getChildAsBooleanObj((JsonObject)event, (String)"isAutoCaptured");
                if (id != null && name != null) {
                    KarmaServerState.this.handleBrowsersChange(this.myEventType, id, name, autoCaptured);
                } else {
                    LOG.warn("Illegal browser event. Type: " + this.myEventType + ", body: " + String.valueOf(eventBody));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/karma/server/KarmaServerState$BrowserEventHandler";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventBody";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/karma/server/KarmaServerState$BrowserEventHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEventType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handle";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class BrowserCapturingFailedEventHandler
    implements StreamEventHandler {
        private BrowserCapturingFailedEventHandler() {
        }

        @Override
        @NotNull
        public String getEventType() {
            return "browserCapturingFailed";
        }

        @Override
        public void handle(@NotNull JsonElement eventBody) {
            if (eventBody == null) {
                BrowserCapturingFailedEventHandler.$$$reportNull$$$0(0);
            }
            if (!eventBody.isJsonObject()) {
                LOG.warn("Not an object");
                return;
            }
            String name = JsonUtil.getChildAsString((JsonObject)eventBody.getAsJsonObject(), (String)"browserLauncherName");
            if (name != null) {
                KarmaServerState.this.onBrowserCapturingFailed(name);
            } else {
                LOG.warn("Unspecified name");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventBody", "com/intellij/javascript/karma/server/KarmaServerState$BrowserCapturingFailedEventHandler", "handle"));
        }
    }

    private class ConfigHandler
    implements StreamEventHandler {
        @NotNull
        private final String myConfigurationFileDir;

        ConfigHandler(@NotNull String configurationFilePath, String workingDirectory) {
            Path parent;
            if (configurationFilePath == null) {
                ConfigHandler.$$$reportNull$$$0(0);
            }
            if (workingDirectory == null) {
                ConfigHandler.$$$reportNull$$$0(1);
            }
            Path configFile = NioFiles.toPath((String)configurationFilePath);
            String configFileDir = null;
            if (configFile != null && Files.isRegularFile(configFile, new LinkOption[0]) && (parent = configFile.getParent()) != null) {
                configFileDir = parent.toAbsolutePath().toString();
            }
            this.myConfigurationFileDir = Objects.requireNonNullElse(configFileDir, workingDirectory);
        }

        @Override
        @NotNull
        public String getEventType() {
            return "configFile";
        }

        @Override
        public void handle(@NotNull JsonElement eventBody) {
            if (eventBody == null) {
                ConfigHandler.$$$reportNull$$$0(2);
            }
            KarmaServerState.this.myConfig = KarmaConfig.parseFromJson(eventBody, this.myConfigurationFileDir);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationFilePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workingDirectory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventBody";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/karma/server/KarmaServerState$ConfigHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handle";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

