/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.settings;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.settings.DockerPathMappingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.ui.fragmentedDialog.FragmentedDialog;
import com.intellij.docker.ui.fragmentedDialog.optionBuilders.FragmentedDialogBooleanOptionBuilder;
import com.intellij.docker.ui.fragmentedDialog.optionBuilders.FragmentedDialogCommandlineBuilder;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.docker.utils.InternalUtilsKt;
import com.intellij.execution.Platform;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0003\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\n0\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/docker/settings/DockerVolumeBindingDialog;", "", "volumeBinding", "Lcom/intellij/docker/agent/settings/DockerVolumeBindingImpl;", "config", "Lcom/intellij/docker/DockerCloudConfiguration;", "alreadyUsedVolumes", "", "Lcom/intellij/docker/agent/settings/DockerVolumeBinding;", "okButtonText", "", "<init>", "(Lcom/intellij/docker/agent/settings/DockerVolumeBindingImpl;Lcom/intellij/docker/DockerCloudConfiguration;Ljava/util/List;Ljava/lang/String;)V", "myFileDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "myMountPoints", "", "kotlin.jvm.PlatformType", "myHostPathComponent", "Lcom/intellij/openapi/ui/ComponentWithBrowseButton;", "Lcom/intellij/ui/components/fields/ExtendableTextField;", "getMyHostPathComponent$annotations", "()V", "myDialog", "Lcom/intellij/docker/ui/fragmentedDialog/FragmentedDialog$Commandline;", "showAndGet", "MyBrowseFolderActionListener", "Companion", "intellij.clouds.docker"})
public final class DockerVolumeBindingDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileChooserDescriptor myFileDescriptor;
    @NotNull
    private final Set<String> myMountPoints;
    @NotNull
    private final ComponentWithBrowseButton<ExtendableTextField> myHostPathComponent;
    @NotNull
    private final FragmentedDialog.Commandline<DockerVolumeBindingImpl> myDialog;
    @NotNull
    private static final String HOST_PATH_REGEX = "([a-zA-Z0-9_-]+)+$";

    public DockerVolumeBindingDialog(@NotNull DockerVolumeBindingImpl volumeBinding, @NotNull DockerCloudConfiguration config2, @NotNull List<? extends DockerVolumeBinding> alreadyUsedVolumes, @Nls @Nullable String okButtonText) {
        Intrinsics.checkNotNullParameter((Object)volumeBinding, (String)"volumeBinding");
        Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
        Intrinsics.checkNotNullParameter(alreadyUsedVolumes, (String)"alreadyUsedVolumes");
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(DockerBundle.message((String)"DockerVolumeBindingConfigurable.BrowseFolderAction.title", (Object[])new Object[0])).withDescription(DockerBundle.message((String)"DockerVolumeBindingConfigurable.BrowseFolderAction.description", (Object[])new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withDescription(...)");
        this.myFileDescriptor = fileChooserDescriptor;
        this.myMountPoints = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)alreadyUsedVolumes), DockerVolumeBindingDialog::myMountPoints$lambda$0), arg_0 -> DockerVolumeBindingDialog.myMountPoints$lambda$1(volumeBinding, arg_0)));
        this.myHostPathComponent = (ComponentWithBrowseButton)new TextFieldWithBrowseButton((JTextField)new ExtendableTextField());
        String string = DockerBundle.message((String)"configurable.DockerVolumeBindingConfigurable.display.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        String string3 = DockerBundle.message((String)"DockerVolumeBindingDialog.commandline.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String string4 = string3;
        this.myDialog = new FragmentedDialog.Commandline(null, string2, string4, volumeBinding, null, null, null, okButtonText, null, "reference.docker.deploy.volume-bindings", arg_0 -> DockerVolumeBindingDialog.myDialog$lambda$15(this, config2, arg_0), 368, null);
        List<DockerPathMappingImpl> mappings = config2.getPathMappings();
        if (!SystemInfo.isLinux && !((Collection)mappings).isEmpty()) {
            this.myFileDescriptor.setRoots(SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)mappings), DockerVolumeBindingDialog::_init_$lambda$16), DockerVolumeBindingDialog::_init_$lambda$17)));
        }
        this.myHostPathComponent.addActionListener((ActionListener)((Object)new MyBrowseFolderActionListener(this.myDialog.getMainPanel(), config2, this.myFileDescriptor, this.myHostPathComponent)));
    }

    public /* synthetic */ DockerVolumeBindingDialog(DockerVolumeBindingImpl dockerVolumeBindingImpl, DockerCloudConfiguration dockerCloudConfiguration, List list2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        this(dockerVolumeBindingImpl, dockerCloudConfiguration, list2, string);
    }

    private static /* synthetic */ void getMyHostPathComponent$annotations() {
    }

    @Nullable
    public final DockerVolumeBindingImpl showAndGet() {
        return (DockerVolumeBindingImpl)this.myDialog.showAndGet();
    }

    private static final String myMountPoints$lambda$0(DockerVolumeBinding it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContainerPath();
    }

    private static final boolean myMountPoints$lambda$1(DockerVolumeBindingImpl $volumeBinding, String it) {
        return !Intrinsics.areEqual((Object)it, (Object)$volumeBinding.getContainerPath());
    }

    private static final Unit myDialog$lambda$15$lambda$6$lambda$2(DockerCloudConfiguration $config, ComponentWithBrowseButton c, DockerVolumeBindingImpl s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        ComponentWithBrowseButton componentWithBrowseButton = c;
        s.setHostPath(DockerUtils.convertLocalPathToDockerMachinePath($config, componentWithBrowseButton != null && (componentWithBrowseButton = (ExtendableTextField)componentWithBrowseButton.getChildComponent()) != null ? componentWithBrowseButton.getText() : null));
        return Unit.INSTANCE;
    }

    private static final Unit myDialog$lambda$15$lambda$6$lambda$3(DockerCloudConfiguration $config, ComponentWithBrowseButton c, DockerVolumeBindingImpl s) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        ExtendableTextField extendableTextField = (ExtendableTextField)c.getChildComponent();
        String string = DockerUtils.convertDockerMachinePathToLocalPath($config, s.getHostPath());
        if (string == null) {
            string = "";
        }
        extendableTextField.setText(string);
        return Unit.INSTANCE;
    }

    private static final boolean myDialog$lambda$15$lambda$6$lambda$4(DockerVolumeBindingImpl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence charSequence = it.getHostPath();
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    private static final ValidationInfo myDialog$lambda$15$lambda$6$lambda$5(ComponentWithBrowseButton c, DockerVolumeBindingImpl dockerVolumeBindingImpl) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)dockerVolumeBindingImpl, (String)"<unused var>");
        String path2 = ((ExtendableTextField)c.getChildComponent()).getText();
        Object[] objectArray = (Object[])path2;
        if (!(objectArray == null || StringsKt.isBlank((CharSequence)objectArray) || DockerVolumeBindingDialog.Companion.isAbsolutePath(path2, Platform.current()) || Pattern.matches(HOST_PATH_REGEX, path2) || OSAgnosticPathUtil.isUncPath((String)path2))) {
            objectArray = new Object[]{path2};
            validationInfo = new ValidationInfo(DockerBundle.message((String)"DockerVolumeBindingsEditor.HostPath.validation.invalid.name", (Object[])objectArray)).asWarning();
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final Unit myDialog$lambda$15$lambda$6(DockerCloudConfiguration $config, FragmentedDialogCommandlineBuilder.CmdTextWithBrowseButtonBuilder $this$textWithBrowseButton) {
        Intrinsics.checkNotNullParameter((Object)$this$textWithBrowseButton, (String)"$this$textWithBrowseButton");
        $this$textWithBrowseButton.setEmptyText(DockerBundle.message((String)"DockerVolumeBindingConfigurable.BrowseFolderAction.title", (Object[])new Object[0]));
        $this$textWithBrowseButton.setTooltip(DockerBundle.message((String)"DockerVolumeBindingDialog.host.tooltip", (Object[])new Object[0]));
        $this$textWithBrowseButton.setPopupDescription(DockerBundle.message((String)"DockerVolumeBindingDialog.host.tooltip", (Object[])new Object[0]));
        $this$textWithBrowseButton.setApply((arg_0, arg_1) -> DockerVolumeBindingDialog.myDialog$lambda$15$lambda$6$lambda$2($config, arg_0, arg_1));
        $this$textWithBrowseButton.setInit((arg_0, arg_1) -> DockerVolumeBindingDialog.myDialog$lambda$15$lambda$6$lambda$3($config, arg_0, arg_1));
        $this$textWithBrowseButton.setVisible(DockerVolumeBindingDialog::myDialog$lambda$15$lambda$6$lambda$4);
        $this$textWithBrowseButton.setValidation(DockerVolumeBindingDialog::myDialog$lambda$15$lambda$6$lambda$5);
        return Unit.INSTANCE;
    }

    private static final Unit myDialog$lambda$15$lambda$10$lambda$7(JBTextField c, DockerVolumeBindingImpl s) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        s.setContainerPath(c.getText());
        return Unit.INSTANCE;
    }

    private static final Unit myDialog$lambda$15$lambda$10$lambda$8(JBTextField c, DockerVolumeBindingImpl s) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        c.setText(s.getContainerPath());
        return Unit.INSTANCE;
    }

    private static final ValidationInfo myDialog$lambda$15$lambda$10$lambda$9(DockerVolumeBindingDialog this$0, JBTextField c, DockerVolumeBindingImpl s) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        CharSequence charSequence = s.getContainerPath();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            object = new ValidationInfo(DockerBundle.message((String)"DockerVolumeBindingConfigurable.error.container.path.required", (Object[])new Object[0]));
        } else {
            String string = s.getContainerPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContainerPath(...)");
            object = !com.intellij.docker.settings.DockerVolumeBindingDialog$Companion.isAbsolutePath$default(Companion, string, null, 2, null) ? new ValidationInfo(DockerBundle.message((String)"DockerVolumeBindingDialog.containers.validation", (Object[])new Object[0])) : (this$0.myMountPoints.contains(s.getContainerPath()) ? new ValidationInfo(DockerBundle.message((String)"DockerVolumeBindingsEditor.ContainerPath.validation.mount.point.already.used", (Object[])new Object[0])) : null);
        }
        return object;
    }

    private static final Unit myDialog$lambda$15$lambda$10(DockerVolumeBindingDialog this$0, FragmentedDialogCommandlineBuilder.CmdStaticTextOptionBuilder $this$staticText) {
        Intrinsics.checkNotNullParameter((Object)$this$staticText, (String)"$this$staticText");
        $this$staticText.setEmptyText(DockerBundle.message((String)"DockerVolumeBindingsEditor.ContainerPath.title", (Object[])new Object[0]));
        $this$staticText.setApply(DockerVolumeBindingDialog::myDialog$lambda$15$lambda$10$lambda$7);
        $this$staticText.setInit(DockerVolumeBindingDialog::myDialog$lambda$15$lambda$10$lambda$8);
        $this$staticText.setTooltip(DockerBundle.message((String)"DockerVolumeBindingDialog.containers.tooltip", (Object[])new Object[0]));
        $this$staticText.setValidation((arg_0, arg_1) -> DockerVolumeBindingDialog.myDialog$lambda$15$lambda$10$lambda$9(this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final boolean myDialog$lambda$15$lambda$14$lambda$11(DockerVolumeBindingImpl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isReadOnly();
    }

    private static final Unit myDialog$lambda$15$lambda$14$lambda$12(DockerVolumeBindingImpl s, boolean r) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        s.setReadOnly(r);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo myDialog$lambda$15$lambda$14$lambda$13(FragmentedDialogCommandlineBuilder.CmdLabel cmdLabel2, DockerVolumeBindingImpl s) {
        Intrinsics.checkNotNullParameter((Object)cmdLabel2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        CharSequence charSequence = s.getHostPath();
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? new ValidationInfo(DockerBundle.message((String)"DockerVolumeBindingDialog.ro.validation", (Object[])new Object[0])) : null;
    }

    private static final Unit myDialog$lambda$15$lambda$14(FragmentedDialogBooleanOptionBuilder $this$flag) {
        Intrinsics.checkNotNullParameter((Object)$this$flag, (String)"$this$flag");
        $this$flag.setGetter(DockerVolumeBindingDialog::myDialog$lambda$15$lambda$14$lambda$11);
        $this$flag.setSetter(DockerVolumeBindingDialog::myDialog$lambda$15$lambda$14$lambda$12);
        $this$flag.setValidation(DockerVolumeBindingDialog::myDialog$lambda$15$lambda$14$lambda$13);
        $this$flag.setPopupDescription(DockerBundle.message((String)"DockerVolumeBindingDialog.ro.tooltip", (Object[])new Object[0]));
        $this$flag.setTooltip(DockerBundle.message((String)"DockerVolumeBindingDialog.ro.tooltip", (Object[])new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit myDialog$lambda$15(DockerVolumeBindingDialog this$0, DockerCloudConfiguration $config, FragmentedDialogCommandlineBuilder $this$Commandline) {
        Intrinsics.checkNotNullParameter((Object)$this$Commandline, (String)"$this$Commandline");
        ComponentWithBrowseButton<ExtendableTextField> componentWithBrowseButton = this$0.myHostPathComponent;
        String string = DockerBundle.message((String)"DockerVolumeBindingConfigurable.BrowseFolderAction.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        FragmentedDialogCommandlineBuilder.textWithBrowseButton$default($this$Commandline, componentWithBrowseButton, string, false, arg_0 -> DockerVolumeBindingDialog.myDialog$lambda$15$lambda$6($config, arg_0), 4, null);
        FragmentedDialogCommandlineBuilder.staticText$default($this$Commandline, new JBTextField(), false, arg_0 -> DockerVolumeBindingDialog.myDialog$lambda$15$lambda$10(this$0, arg_0), 2, null);
        String string2 = DockerBundle.message((String)"DockerVolumeBindingConfigurable.read.only.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$Commandline.flag(string2, DockerUiUtilsKt.asNlsSafe("ro"), DockerVolumeBindingDialog::myDialog$lambda$15$lambda$14);
        return Unit.INSTANCE;
    }

    private static final String _init_$lambda$16(DockerPathMappingImpl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getLocalPath();
    }

    private static final VirtualFile _init_$lambda$17(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LocalFileSystem.getInstance().findFileByPath(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u001c\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/settings/DockerVolumeBindingDialog$Companion;", "", "<init>", "()V", "HOST_PATH_REGEX", "", "isUnixAbsolutePath", "", "str", "isAbsolutePath", "path", "platform", "Lcom/intellij/execution/Platform;", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isUnixAbsolutePath(String str) {
            return StringsKt.startsWith$default((String)str, (String)"/", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)str, (CharSequence)":", (boolean)false, (int)2, null);
        }

        private final boolean isAbsolutePath(String path2, Platform platform) {
            Platform platform2 = platform;
            return switch (platform2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[platform2.ordinal()]) {
                case 1 -> InternalUtilsKt.isWindowsPath(path2);
                case 2 -> this.isUnixAbsolutePath(path2);
                case -1 -> {
                    if (InternalUtilsKt.isWindowsPath(path2) || this.isUnixAbsolutePath(path2)) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        static /* synthetic */ boolean isAbsolutePath$default(Companion companion, String string, Platform platform, int n, Object object) {
            if ((n & 2) != 0) {
                platform = null;
            }
            return companion.isAbsolutePath(string, platform);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Platform.values().length];
                try {
                    nArray[Platform.WINDOWS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Platform.UNIX.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/settings/DockerVolumeBindingDialog$MyBrowseFolderActionListener;", "Lcom/intellij/openapi/ui/ComponentWithBrowseButton$BrowseFolderActionListener;", "Lcom/intellij/ui/components/fields/ExtendableTextField;", "mainComponent", "Ljavax/swing/JComponent;", "config", "Lcom/intellij/docker/DockerCloudConfiguration;", "fileDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "textField", "Lcom/intellij/openapi/ui/ComponentWithBrowseButton;", "<init>", "(Ljavax/swing/JComponent;Lcom/intellij/docker/DockerCloudConfiguration;Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;Lcom/intellij/openapi/ui/ComponentWithBrowseButton;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.clouds.docker"})
    private static final class MyBrowseFolderActionListener
    extends ComponentWithBrowseButton.BrowseFolderActionListener<ExtendableTextField> {
        @NotNull
        private final JComponent mainComponent;
        @NotNull
        private final DockerCloudConfiguration config;

        public MyBrowseFolderActionListener(@NotNull JComponent mainComponent, @NotNull DockerCloudConfiguration config2, @NotNull FileChooserDescriptor fileDescriptor, @NotNull ComponentWithBrowseButton<ExtendableTextField> textField) {
            Intrinsics.checkNotNullParameter((Object)mainComponent, (String)"mainComponent");
            Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
            Intrinsics.checkNotNullParameter((Object)fileDescriptor, (String)"fileDescriptor");
            Intrinsics.checkNotNullParameter(textField, (String)"textField");
            super(textField, null, fileDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
            this.mainComponent = mainComponent;
            this.config = config2;
        }

        public void actionPerformed(@Nullable ActionEvent e) {
            if (SystemInfo.isLinux || !((Collection)this.config.getPathMappings()).isEmpty()) {
                super.actionPerformed(e);
            } else {
                Messages.showWarningDialog((Component)this.mainComponent, (String)DockerBundle.message((String)"DockerVolumeBindingConfigurable.mapping.warning.message", (Object[])new Object[0]), (String)DockerBundle.message((String)"DockerVolumeBindingConfigurable.mapping.warning.title", (Object[])new Object[0]));
            }
        }
    }
}

