/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.scripts.ScriptsKt;
import com.intellij.javascript.debugger.scripts.VmScriptFileSystemKt;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\t\u001a\u00020\u0005H\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/debugger/scripts/SourceContentFile;", "Lcom/intellij/testFramework/LightVirtualFile;", "url", "Lcom/intellij/util/Url;", "source", "", "<init>", "(Lcom/intellij/util/Url;Ljava/lang/String;)V", "_path", "getPath", "isLoaded", "", "()Z", "intellij.javascript.debugger"})
public class SourceContentFile
extends LightVirtualFile {
    @NotNull
    private final String _path;

    public SourceContentFile(@NotNull Url url, @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        super(PathUtilRt.getFileName((String)url.getPath()), ScriptsKt.getFileType(url), (CharSequence)source, Charsets.UTF_8, LocalTimeCounter.currentTime());
        this._path = VmScriptFileSystemKt.toVirtualFilePath(url);
        UndoUtil.disableUndoFor((VirtualFile)((VirtualFile)this));
    }

    @NotNull
    public String getPath() {
        return this._path;
    }

    public final boolean isLoaded() {
        CharSequence charSequence = this.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getContent(...)");
        return charSequence.length() > 0;
    }
}

