/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.scripts.ConsumerOnEdt;
import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.javascript.debugger.scripts.FileNode;
import com.intellij.javascript.debugger.scripts.ScriptTreeActionBase;
import com.intellij.javascript.debugger.scripts.ScriptsKt;
import com.intellij.javascript.debugger.scripts.SourcesTreeComponent;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceFileFinder;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapInspectorKt;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.VisualizeSourceMapActionKt;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Url;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0014J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0014J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javascript/debugger/scripts/VisualizeScriptSourcemap;", "Lcom/intellij/javascript/debugger/scripts/ScriptTreeActionBase;", "treeComponent", "Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;", "<init>", "(Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;)V", "invisibleIfDisabled", "", "getInvisibleIfDisabled", "()Z", "isApplicable", "info", "Lcom/intellij/javascript/debugger/scripts/FileInfo;", "chooseScript", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/Script;", "items", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "perform", "", "node", "Lcom/intellij/javascript/debugger/scripts/FileNode;", "context", "visualize", "script", "sourceUrl", "Lcom/intellij/util/Url;", "intellij.javascript.debugger"})
public final class VisualizeScriptSourcemap
extends ScriptTreeActionBase {
    private final boolean invisibleIfDisabled;

    public VisualizeScriptSourcemap(@NotNull SourcesTreeComponent treeComponent) {
        Intrinsics.checkNotNullParameter((Object)treeComponent, (String)"treeComponent");
        super(treeComponent, JSDebuggerBundle.message("js.scripts.visualize.action", new Object[0]));
    }

    @Override
    protected boolean getInvisibleIfDisabled() {
        return this.invisibleIfDisabled;
    }

    @Override
    protected boolean isApplicable(@NotNull FileInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        for (Script script : info.getScripts$intellij_javascript_debugger()) {
            if (script.getSourceMap() == null) continue;
            return true;
        }
        return false;
    }

    private final Promise<Script> chooseScript(List<? extends Script> items, DataContext dataContext) {
        if (items.size() == 1) {
            return Promises.resolvedPromise((Object)CollectionsKt.first(items));
        }
        AsyncPromise result = new AsyncPromise();
        JBPopupFactory.getInstance().createPopupChooserBuilder(items).setTitle(JSDebuggerBundle.message("js.scripts.visualize.popup.choose", new Object[0])).setItemChosenCallback(arg_0 -> VisualizeScriptSourcemap.chooseScript$lambda$1(arg_0 -> VisualizeScriptSourcemap.chooseScript$lambda$0(result, arg_0), arg_0)).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> VisualizeScriptSourcemap.chooseScript$lambda$3(VisualizeScriptSourcemap::chooseScript$lambda$2, arg_0, arg_1, arg_2))).createPopup().showInBestPositionFor(dataContext);
        return (Promise)result;
    }

    @Override
    protected void perform(@NotNull FileNode node, @NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Url sourceUrl = node.getFileInfo().getUrl();
        this.chooseScript(node.getFileInfo().getScripts$intellij_javascript_debugger(), context).onSuccess(arg_0 -> VisualizeScriptSourcemap.perform$lambda$5(arg_0 -> VisualizeScriptSourcemap.perform$lambda$4(this, sourceUrl, arg_0), arg_0));
    }

    private final void visualize(Script script, Url sourceUrl) {
        SourceMap sourceMap = script.getSourceMap();
        if (sourceMap == null) {
            return;
        }
        SourceMap map = sourceMap;
        Project project = this.getProject();
        this.getTreeComponent().getDebugProcess().getDebuggerViewSupport().getFileByUrlOrVmSource(script, true).onSuccess((Consumer)new ConsumerOnEdt<VirtualFile>(map, sourceUrl, script, this, project){
            final /* synthetic */ SourceMap $map;
            final /* synthetic */ Url $sourceUrl;
            final /* synthetic */ Script $script;
            final /* synthetic */ VisualizeScriptSourcemap this$0;
            {
                this.$map = $map;
                this.$sourceUrl = $sourceUrl;
                this.$script = $script;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void consume(Project project, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                VisualizeSourceMapActionKt.visualizeMap(this.$map, file, this.$sourceUrl, project, new SourceFileFinder(this.$map, this.$script, this.this$0){
                    final /* synthetic */ SourceMap $map;
                    final /* synthetic */ Script $script;
                    final /* synthetic */ VisualizeScriptSourcemap this$0;
                    {
                        this.$map = $map;
                        this.$script = $script;
                        this.this$0 = $receiver;
                    }

                    public VirtualFile find(Url source) {
                        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                        VirtualFile virtualFile = SourceMapInspectorKt.createSourceFromProvidedContent(this.$map, source, (UserDataHolder)this.$script);
                        if (virtualFile == null && (virtualFile = SourceMapInspectorKt.getSourceFile(source)) == null) {
                            virtualFile = this.this$0.getTreeComponent().getDebugProcess().findFileOrAny(source);
                        }
                        return virtualFile;
                    }
                });
            }
        });
    }

    private static final Unit chooseScript$lambda$0(AsyncPromise $result, Script value) {
        $result.setResult((Object)value);
        return Unit.INSTANCE;
    }

    private static final void chooseScript$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit chooseScript$lambda$2(JBLabel label, Script value, int n) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        label.setIcon(ScriptsKt.getFileType(value.getUrl()).getIcon());
        label.setText(value.getUrl().toDecodedForm());
        return Unit.INSTANCE;
    }

    private static final void chooseScript$lambda$3(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke((Object)p0, p1, (Object)p2);
    }

    private static final Unit perform$lambda$4(VisualizeScriptSourcemap this$0, Url $sourceUrl, Script script) {
        Intrinsics.checkNotNull((Object)script);
        this$0.visualize(script, $sourceUrl);
        return Unit.INSTANCE;
    }

    private static final void perform$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

