/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.Experimental;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ListenersUtil;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.output.Response;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public interface StreamingChatLanguageModel {
    @Experimental
    default public void chat(ChatRequest chatRequest, final StreamingChatResponseHandler handler) {
        final ChatRequest finalChatRequest = ChatRequest.builder().messages(chatRequest.messages()).parameters(this.defaultRequestParameters().overrideWith(chatRequest.parameters())).build();
        final List<ChatModelListener> listeners = this.listeners();
        final ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        StreamingChatResponseHandler observingHandler = new StreamingChatResponseHandler(){

            @Override
            public void onPartialResponse(String partialResponse) {
                handler.onPartialResponse(partialResponse);
            }

            @Override
            public void onCompleteResponse(ChatResponse completeResponse) {
                ListenersUtil.onResponse(completeResponse, finalChatRequest, attributes, listeners);
                handler.onCompleteResponse(completeResponse);
            }

            @Override
            public void onError(Throwable error) {
                ListenersUtil.onError(error, finalChatRequest, attributes, listeners);
                handler.onError(error);
            }
        };
        ListenersUtil.onRequest(finalChatRequest, attributes, listeners);
        this.doChat(finalChatRequest, observingHandler);
    }

    @Experimental
    default public void chat(String userMessage, StreamingChatResponseHandler handler) {
        ChatRequest chatRequest = ChatRequest.builder().messages(UserMessage.from(userMessage)).build();
        this.chat(chatRequest, handler);
    }

    @Experimental
    default public void chat(List<ChatMessage> messages, StreamingChatResponseHandler handler) {
        ChatRequest chatRequest = ChatRequest.builder().messages(messages).build();
        this.chat(chatRequest, handler);
    }

    default public List<ChatModelListener> listeners() {
        return Collections.emptyList();
    }

    @Experimental
    default public void doChat(ChatRequest chatRequest, final StreamingChatResponseHandler handler) {
        ChatRequestParameters parameters = chatRequest.parameters();
        ChatLanguageModel.validate(parameters);
        ChatLanguageModel.validate(parameters.toolChoice());
        ChatLanguageModel.validate(parameters.responseFormat());
        StreamingResponseHandler<AiMessage> legacyHandler = new StreamingResponseHandler<AiMessage>(){

            @Override
            public void onNext(String token) {
                handler.onPartialResponse(token);
            }

            @Override
            public void onComplete(Response<AiMessage> response) {
                ChatResponse chatResponse = ChatResponse.builder().aiMessage(response.content()).metadata(((ChatResponseMetadata.Builder)((ChatResponseMetadata.Builder)ChatResponseMetadata.builder().tokenUsage(response.tokenUsage())).finishReason(response.finishReason())).build()).build();
                handler.onCompleteResponse(chatResponse);
            }

            @Override
            public void onError(Throwable error) {
                handler.onError(error);
            }
        };
        List<ToolSpecification> toolSpecifications = parameters.toolSpecifications();
        if (Utils.isNullOrEmpty(toolSpecifications)) {
            this.generate(chatRequest.messages(), legacyHandler);
        } else if (parameters.toolChoice() == ToolChoice.REQUIRED) {
            if (toolSpecifications.size() != 1) {
                throw new UnsupportedFeatureException(String.format("%s.%s is currently supported only when there is a single tool", ToolChoice.class.getSimpleName(), ToolChoice.REQUIRED.name()));
            }
            this.generate(chatRequest.messages(), toolSpecifications.get(0), legacyHandler);
        } else {
            this.generate(chatRequest.messages(), toolSpecifications, legacyHandler);
        }
    }

    @Experimental
    default public ChatRequestParameters defaultRequestParameters() {
        return ChatRequestParameters.builder().build();
    }

    @Experimental
    default public Set<Capability> supportedCapabilities() {
        return Set.of();
    }

    @Deprecated(forRemoval=true)
    default public void generate(String userMessage, StreamingResponseHandler<AiMessage> handler) {
        this.generate(Collections.singletonList(UserMessage.from(userMessage)), handler);
    }

    @Deprecated(forRemoval=true)
    default public void generate(UserMessage userMessage, StreamingResponseHandler<AiMessage> handler) {
        this.generate(Collections.singletonList(userMessage), handler);
    }

    @Deprecated(forRemoval=true)
    public void generate(List<ChatMessage> var1, StreamingResponseHandler<AiMessage> var2);

    @Deprecated(forRemoval=true)
    default public void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, StreamingResponseHandler<AiMessage> handler) {
        throw new UnsupportedFeatureException("tools are currently not supported by " + this.getClass().getSimpleName());
    }

    @Deprecated(forRemoval=true)
    default public void generate(List<ChatMessage> messages, ToolSpecification toolSpecification, StreamingResponseHandler<AiMessage> handler) {
        throw new UnsupportedFeatureException("tools and tool choice are currently not supported by " + this.getClass().getSimpleName());
    }
}

