/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.Ed25519PublicBCPGKey;
import org.bouncycastle.bcpg.Ed448PublicBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.StreamUtil;
import org.bouncycastle.bcpg.UnknownBCPGKey;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.bcpg.X25519PublicBCPGKey;
import org.bouncycastle.bcpg.X448PublicBCPGKey;
import org.bouncycastle.util.Pack;

public class PublicKeyPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    public static final int LIBREPGP_5 = 5;
    public static final int VERSION_6 = 6;
    private int version;
    private long time;
    private int validDays;
    private int algorithm;
    private BCPGKey key;

    PublicKeyPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this(bCPGInputStream, false);
    }

    PublicKeyPacket(BCPGInputStream bCPGInputStream, boolean bl) throws IOException {
        this(6, bCPGInputStream, bl);
    }

    PublicKeyPacket(int n, BCPGInputStream bCPGInputStream) throws IOException {
        this(n, bCPGInputStream, false);
    }

    PublicKeyPacket(int n, BCPGInputStream bCPGInputStream, boolean bl) throws IOException {
        super(n, bl);
        this.version = bCPGInputStream.read();
        if (this.version < 2 || this.version > 6) {
            throw new UnsupportedPacketVersionException("Unsupported Public Key Packet version encountered: " + this.version);
        }
        this.time = (long)StreamUtil.read4OctetLength(bCPGInputStream) & 0xFFFFFFFFL;
        if (this.version == 2 || this.version == 3) {
            this.validDays = StreamUtil.read2OctetLength(bCPGInputStream);
        }
        this.algorithm = (byte)bCPGInputStream.read();
        long l = -1L;
        if (this.version == 5 || this.version == 6) {
            l = StreamUtil.read4OctetLength(bCPGInputStream);
        }
        this.parseKey(bCPGInputStream, this.algorithm, l);
    }

    private void parseKey(BCPGInputStream bCPGInputStream, int n, long l) throws IOException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                this.key = new RSAPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 17: {
                this.key = new DSAPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 16: 
            case 20: {
                this.key = new ElGamalPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 18: {
                this.key = new ECDHPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 25: {
                this.key = new X25519PublicBCPGKey(bCPGInputStream);
                break;
            }
            case 26: {
                this.key = new X448PublicBCPGKey(bCPGInputStream);
                break;
            }
            case 19: {
                this.key = new ECDSAPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 22: {
                this.key = new EdDSAPublicBCPGKey(bCPGInputStream);
                break;
            }
            case 27: {
                this.key = new Ed25519PublicBCPGKey(bCPGInputStream);
                break;
            }
            case 28: {
                this.key = new Ed448PublicBCPGKey(bCPGInputStream);
                break;
            }
            default: {
                if (this.version == 6 || this.version == 5) {
                    this.key = new UnknownBCPGKey((int)l, bCPGInputStream);
                    break;
                }
                throw new IOException("unknown PGP public key algorithm encountered: " + this.algorithm);
            }
        }
    }

    @Deprecated
    public PublicKeyPacket(int n, Date date, BCPGKey bCPGKey) {
        this(4, n, date, bCPGKey);
    }

    public PublicKeyPacket(int n, int n2, Date date, BCPGKey bCPGKey) {
        this(6, n, n2, date, bCPGKey);
    }

    PublicKeyPacket(int n, int n2, int n3, Date date, BCPGKey bCPGKey) {
        super(n);
        this.version = n2;
        this.time = date.getTime() / 1000L;
        this.algorithm = n3;
        this.key = bCPGKey;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public int getValidDays() {
        return this.validDays;
    }

    public Date getTime() {
        return new Date(this.time * 1000L);
    }

    public BCPGKey getKey() {
        return this.key;
    }

    public byte[] getEncodedContents() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
        bCPGOutputStream.write(this.version);
        StreamUtil.writeSeconds(bCPGOutputStream, this.time);
        if (this.version <= 3) {
            StreamUtil.write2OctetLength(bCPGOutputStream, this.validDays);
        }
        bCPGOutputStream.write(this.algorithm);
        if (this.version == 6 || this.version == 5) {
            StreamUtil.write4OctetLength(bCPGOutputStream, this.key.getEncoded().length);
        }
        bCPGOutputStream.writeObject((BCPGObject)((Object)this.key));
        bCPGOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(this.hasNewPacketFormat(), this.getPacketTag(), this.getEncodedContents());
    }

    public static long getKeyID(PublicKeyPacket publicKeyPacket, byte[] byArray) {
        if (publicKeyPacket.version <= 3) {
            RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.key;
            return rSAPublicBCPGKey.getModulus().longValue();
        }
        if (publicKeyPacket.version == 4) {
            return Pack.bigEndianToLong(byArray, byArray.length - 8);
        }
        if (publicKeyPacket.version == 5 || publicKeyPacket.version == 6) {
            return Pack.bigEndianToLong(byArray, 0);
        }
        return 0L;
    }
}

