/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.interpreter.InvalidNodeExecutionException;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterRefResolveResult;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.download.NodeDownloadableInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreterType;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreterType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeJsInterpreterRef {
    @NonNls
    static final String PROJECT_LEVEL = "project";
    @NonNls
    private final String myReferenceName;

    private NodeJsInterpreterRef(@NotNull @NonNls String referenceName) {
        if (referenceName == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(0);
        }
        this.myReferenceName = FileUtil.toSystemIndependentName((String)referenceName);
    }

    private NodeJsInterpreterRef(@Nullable NodeJsInterpreter interpreter2) {
        this.myReferenceName = interpreter2 == null ? "" : FileUtil.toSystemIndependentName((String)interpreter2.getReferenceName());
    }

    @NotNull
    @NonNls
    public String getReferenceName() {
        String string = this.myReferenceName;
        if (string == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isProjectRef() {
        return PROJECT_LEVEL.equals(this.myReferenceName);
    }

    public boolean isConstantRef() {
        return !PROJECT_LEVEL.equals(this.myReferenceName) && !NodeJsLocalInterpreterType.isNodeFromPathRef(this);
    }

    @Nullable
    public NodeJsInterpreter resolve(@NotNull Project project) {
        NodeInterpreterRefResolveResult result2;
        if (project == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(2);
        }
        return (result2 = this.resolveResult(project)) != null ? (NodeJsInterpreter)result2.getInterpreter() : null;
    }

    @Nullable
    NodeInterpreterRefResolveResult resolveResult(@NotNull Project project) {
        if (project == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(3);
        }
        NodeJsInterpreterRef ref2 = this.dereferenceIfProject(project);
        return ref2.resolveResultWithoutAliases(project);
    }

    @NotNull
    public NodeJsInterpreterRef dereferenceIfProject(@NotNull Project project) {
        if (project == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(4);
        }
        NodeJsInterpreterRef nodeJsInterpreterRef = this.isProjectRef() ? NodeJsInterpreterManager.getInstance(project).getInterpreterRef() : this;
        if (nodeJsInterpreterRef == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(5);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public NodeJsInterpreter resolveNotNull(@NotNull Project project) throws ExecutionException {
        NodeJsInterpreter interpreter2;
        if (project == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(6);
        }
        if ((interpreter2 = this.resolve(project)) != null) {
            NodeJsInterpreter nodeJsInterpreter = interpreter2;
            if (nodeJsInterpreter == null) {
                NodeJsInterpreterRef.$$$reportNull$$$0(7);
            }
            return nodeJsInterpreter;
        }
        throw new InvalidNodeExecutionException(project);
    }

    @NotNull
    public NodeJsLocalInterpreter resolveAsLocal(@NotNull Project project) throws ExecutionException {
        if (project == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(8);
        }
        NodeJsInterpreter interpreter2 = this.resolve(project);
        NodeJsLocalInterpreter nodeJsLocalInterpreter = NodeJsLocalInterpreter.cast(interpreter2);
        if (nodeJsLocalInterpreter == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(9);
        }
        return nodeJsLocalInterpreter;
    }

    @Nullable
    NodeJsInterpreter resolveWithoutAliases(@NotNull Project project) {
        NodeInterpreterRefResolveResult result2;
        if (project == null) {
            NodeJsInterpreterRef.$$$reportNull$$$0(10);
        }
        return (result2 = this.resolveResultWithoutAliases(project)) != null ? (NodeJsInterpreter)result2.getInterpreter() : null;
    }

    @Nullable
    NodeInterpreterRefResolveResult resolveResultWithoutAliases(@Nullable Project project) {
        if (this.myReferenceName.isEmpty()) {
            return null;
        }
        NodeInterpreterRefResolveResult result2 = null;
        for (NodeJsInterpreterType type2 : NodeJsInterpreterRef.interpreterTypes()) {
            if (!type2.isAvailable()) continue;
            NodeInterpreterRefResolveResult localResult = type2.resolveReference(project, this.myReferenceName);
            if (localResult != null && localResult.getInterpreter() != null) {
                return localResult;
            }
            if (localResult == null) continue;
            result2 = localResult;
        }
        return result2;
    }

    private static NodeJsInterpreterType[] interpreterTypes() {
        return new NodeJsInterpreterType[]{NodeJsRemoteInterpreterType.getInstance(), WslNodeInterpreterType.getInstance(), NodeJsLocalInterpreterType.getInstance(), NodeDownloadableInterpreterType.getInstance()};
    }

    @NotNull
    public static NodeJsInterpreterRef createProjectRef() {
        return new NodeJsInterpreterRef(PROJECT_LEVEL);
    }

    @NotNull
    public static NodeJsInterpreterRef create(@Nullable @NonNls String referenceName) {
        return new NodeJsInterpreterRef(StringUtil.notNullize((String)referenceName, (String)PROJECT_LEVEL));
    }

    @NotNull
    public static NodeJsInterpreterRef create(@Nullable NodeJsInterpreter interpreter2) {
        return new NodeJsInterpreterRef(interpreter2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeJsInterpreterRef ref2 = (NodeJsInterpreterRef)o;
        return this.myReferenceName.equals(ref2.myReferenceName);
    }

    public int hashCode() {
        return this.myReferenceName.hashCode();
    }

    public String toString() {
        return this.myReferenceName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROJECT_LEVEL;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dereferenceIfProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNotNull";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAsLocal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveResult";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "dereferenceIfProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveNotNull";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsLocal";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveWithoutAliases";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 7, 9 -> new IllegalStateException(string);
        };
    }
}

