/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.reference;

import com.google.common.base.Splitter;
import com.intellij.execution.Platform;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.javascript.nodejs.env.DotEnvFileManager;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePathManager {
    public static final String NODE_PATH = "NODE_PATH";
    private static final char NODE_PATH_SEPARATOR = NodePathManager.getNodePathSeparator(Platform.current());
    private final Project myProject;
    private volatile Pair<NodePathData, List<VirtualFile>> myCache;

    public NodePathManager(@NotNull Project project) {
        if (project == null) {
            NodePathManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public List<VirtualFile> getNodePaths(@Nullable VirtualFile contextFile) {
        NodePathData nodePathData = this.findNodePathData(contextFile);
        if (nodePathData == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                NodePathManager.$$$reportNull$$$0(1);
            }
            return list;
        }
        Pair cache = this.myCache;
        if (cache != null && nodePathData.equals(cache.first)) {
            List list = (List)cache.second;
            if (list == null) {
                NodePathManager.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<VirtualFile> paths = NodePathManager.parsePathsFromNodePathEnvVariable(nodePathData);
        this.myCache = cache = Pair.create((Object)nodePathData, paths);
        List<VirtualFile> list = paths;
        if (list == null) {
            NodePathManager.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private NodePathData findNodePathData(@Nullable VirtualFile contextFileOrDir) {
        NodePathData nodePath;
        NodeRunConfigurationNodePathProvider service;
        DotEnvFileManager envFileManager = DotEnvFileManager.getInstance(this.myProject);
        if (contextFileOrDir != null) {
            List<DotEnvFileManager.EnvFileData> envFileDataList = envFileManager.findEnvs(contextFileOrDir);
            for (DotEnvFileManager.EnvFileData envFileData : envFileDataList) {
                String nodePathValue = envFileData.getEnvs().get(NODE_PATH);
                if (nodePathValue == null) continue;
                return new NodePathData(nodePathValue, envFileData.getEnvFile());
            }
        }
        if ((service = NodeRunConfigurationNodePathProvider.getInstance(this.myProject)) != null && (nodePath = service.getNodePathData()) != null) {
            return nodePath;
        }
        String value = EnvironmentUtil.getValue((String)NODE_PATH);
        if (value != null) {
            return new NodePathData(value, null);
        }
        return null;
    }

    @NotNull
    private static List<VirtualFile> parsePathsFromNodePathEnvVariable(@NotNull NodePathData nodePathData) {
        if (nodePathData == null) {
            NodePathManager.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)nodePathData.myNodePathValue)) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                NodePathManager.$$$reportNull$$$0(5);
            }
            return list;
        }
        Iterable res = Splitter.on((char)NODE_PATH_SEPARATOR).split((CharSequence)nodePathData.myNodePathValue);
        VirtualFile contextDir = nodePathData.myContextFileOrDir;
        if (contextDir != null && !contextDir.isDirectory()) {
            contextDir = contextDir.getParent();
        }
        ArrayList<VirtualFile> dirs = new ArrayList<VirtualFile>();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (String dirPath : res) {
            if (!StringUtil.isNotEmpty((String)dirPath)) continue;
            VirtualFile dir = null;
            if (OSAgnosticPathUtil.isAbsolute((String)dirPath)) {
                dir = fileSystem.findFileByPath(dirPath);
            } else if (contextDir != null) {
                dir = contextDir.findFileByRelativePath(dirPath);
            }
            if (dir == null) continue;
            dirs.add(dir);
        }
        ArrayList<VirtualFile> arrayList = dirs;
        if (arrayList == null) {
            NodePathManager.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public static EnvironmentVariablesData prependPath(@NotNull EnvironmentVariablesData envData, @NotNull String extraNodePath) {
        Object value;
        if (envData == null) {
            NodePathManager.$$$reportNull$$$0(7);
        }
        if (extraNodePath == null) {
            NodePathManager.$$$reportNull$$$0(8);
        }
        if ((value = (String)envData.getEnvs().get(NODE_PATH)) == null && envData.isPassParentEnvs()) {
            value = (String)EnvironmentUtil.getEnvironmentMap().get(NODE_PATH);
        }
        value = ((String)(value = StringUtil.notNullize((String)value))).isEmpty() || StringUtil.startsWithChar((CharSequence)value, (char)NODE_PATH_SEPARATOR) ? extraNodePath + (String)value : extraNodePath + NODE_PATH_SEPARATOR + (String)value;
        LinkedHashMap<String, Object> envs = new LinkedHashMap<String, Object>(envData.getEnvs());
        envs.put(NODE_PATH, value);
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create(Map.copyOf(envs), (boolean)envData.isPassParentEnvs());
        if (environmentVariablesData == null) {
            NodePathManager.$$$reportNull$$$0(9);
        }
        return environmentVariablesData;
    }

    public static void prependNodePaths(@NotNull NodeTargetRun targetRun, @NotNull List<String> localNodePathDirs) {
        if (targetRun == null) {
            NodePathManager.$$$reportNull$$$0(10);
        }
        if (localNodePathDirs == null) {
            NodePathManager.$$$reportNull$$$0(11);
        }
        if (localNodePathDirs.isEmpty()) {
            return;
        }
        TargetedCommandLineBuilder commandLine = targetRun.getCommandLineBuilder();
        List resultTargetValues = ContainerUtil.concat((List)ContainerUtil.map(localNodePathDirs, dir -> targetRun.path((String)dir)), (List)ContainerUtil.createMaybeSingletonList((Object)commandLine.getEnvironmentVariable(NODE_PATH)));
        commandLine.addEnvironmentVariable(NODE_PATH, TargetValue.composite((Collection)resultTargetValues, values -> String.join((CharSequence)String.valueOf(NodePathManager.getNodePathSeparator(targetRun.getRequest().getTargetPlatform().getPlatform())), values)));
    }

    private static char getNodePathSeparator(@NotNull Platform platform) {
        if (platform == null) {
            NodePathManager.$$$reportNull$$$0(12);
        }
        return platform == Platform.WINDOWS ? (char)';' : ':';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/reference/NodePathManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePathData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraNodePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localNodePathDirs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/reference/NodePathManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodePaths";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePathsFromNodePathEnvVariable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "prependPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parsePathsFromNodePathEnvVariable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prependPath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prependNodePaths";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNodePathSeparator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6, 9 -> new IllegalStateException(string);
        };
    }

    public static class NodePathData {
        private final String myNodePathValue;
        private final VirtualFile myContextFileOrDir;

        public NodePathData(@NotNull String nodePathValue, @Nullable VirtualFile contextFileOrDir) {
            if (nodePathValue == null) {
                NodePathData.$$$reportNull$$$0(0);
            }
            this.myNodePathValue = nodePathValue;
            this.myContextFileOrDir = contextFileOrDir;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodePathData data2 = (NodePathData)o;
            return this.myNodePathValue.equals(data2.myNodePathValue) && Objects.equals(this.myContextFileOrDir, data2.myContextFileOrDir);
        }

        public int hashCode() {
            return Objects.hash(this.myNodePathValue, this.myContextFileOrDir);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePathValue", "com/intellij/javascript/nodejs/reference/NodePathManager$NodePathData", "<init>"));
        }
    }

    public static interface NodeRunConfigurationNodePathProvider {
        @Nullable
        public NodePathData getNodePathData();

        @Nullable
        public static NodeRunConfigurationNodePathProvider getInstance(@NotNull Project project) {
            if (project == null) {
                NodeRunConfigurationNodePathProvider.$$$reportNull$$$0(0);
            }
            return (NodeRunConfigurationNodePathProvider)project.getService(NodeRunConfigurationNodePathProvider.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/reference/NodePathManager$NodeRunConfigurationNodePathProvider", "getInstance"));
        }
    }
}

