/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.coverage;

import com.google.common.base.Preconditions;
import com.intellij.javascript.testFramework.coverage.LcovCoverageReport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoverageSerializationUtils {
    private static final String SOURCE_FILE_PREFIX = "SF:";
    private static final String LINE_HIT_PREFIX = "DA:";
    private static final String END_OF_RECORD = "end_of_record";

    @Deprecated
    @NotNull
    public static LcovCoverageReport readLCOV(@Nullable File baseDir, @NotNull File lcovFile) throws IOException {
        if (lcovFile == null) {
            CoverageSerializationUtils.$$$reportNull$$$0(0);
        }
        return CoverageSerializationUtils.readLCOV(lcovFile.toPath(), baseDir != null ? baseDir.toPath() : null, Function.identity());
    }

    @NotNull
    public static LcovCoverageReport readLCOV(@Nullable Path baseDir, @NotNull Path lcovFile) throws IOException {
        if (lcovFile == null) {
            CoverageSerializationUtils.$$$reportNull$$$0(1);
        }
        return CoverageSerializationUtils.readLCOV(lcovFile, baseDir, Function.identity());
    }

    @NotNull
    public static LcovCoverageReport readLCOV(@NotNull Path lcovFile, @Nullable Path localBaseDir, @NotNull Function<? super String, String> toLocalPathConvertor) throws IOException {
        String line;
        if (lcovFile == null) {
            CoverageSerializationUtils.$$$reportNull$$$0(2);
        }
        if (toLocalPathConvertor == null) {
            CoverageSerializationUtils.$$$reportNull$$$0(3);
        }
        BufferedReader reader = Files.newBufferedReader(lcovFile, StandardCharsets.UTF_8);
        String currentFileName = null;
        int lineNumber = 1;
        ArrayList<LcovCoverageReport.LineHits> lineDataList = null;
        LcovCoverageReport report = new LcovCoverageReport();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith(SOURCE_FILE_PREFIX)) {
                currentFileName = toLocalPathConvertor.apply(line.substring(SOURCE_FILE_PREFIX.length()));
                lineDataList = new ArrayList<LcovCoverageReport.LineHits>();
            } else if (line.startsWith(LINE_HIT_PREFIX)) {
                if (lineDataList == null) {
                    throw new IllegalStateException("Unexpected line hit description at line " + lineNumber + ": expected source file definition");
                }
                String[] values = line.substring(LINE_HIT_PREFIX.length()).split(",");
                Preconditions.checkState((values.length == 2 ? 1 : 0) != 0, (Object)("Unexpected line hit description at line " + lineNumber + ": expected 2 integers, got " + line));
                try {
                    int lineNum = Integer.parseInt(values[0]);
                    int hitCount = Integer.parseInt(values[1]);
                    LcovCoverageReport.LineHits lineHits = new LcovCoverageReport.LineHits(lineNum, hitCount);
                    lineDataList.add(lineHits);
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Unexpected line hit description at line " + lineNumber + ": expected integers, got " + line, e);
                }
            } else if (END_OF_RECORD.equals(line)) {
                if (lineDataList == null) {
                    throw new IllegalStateException("Unexpected end of record at line " + lineNumber + ": expected source file definition");
                }
                Preconditions.checkNotNull((Object)currentFileName, (Object)("Unexpected end of record at line " + lineNumber + ": no source file definition"));
                report.mergeFileReport(localBaseDir, currentFileName, lineDataList);
                currentFileName = null;
                lineDataList = null;
            }
            ++lineNumber;
        }
        Preconditions.checkState((lineDataList == null ? 1 : 0) != 0, (Object)"Unexpected end of report: expected end_of_record");
        LcovCoverageReport lcovCoverageReport = report;
        LcovCoverageReport lcovCoverageReport2 = lcovCoverageReport;
        if (lcovCoverageReport2 == null) {
            CoverageSerializationUtils.$$$reportNull$$$0(4);
        }
        return lcovCoverageReport2;
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static void writeLCOV(@NotNull LcovCoverageReport report, @NotNull File outputFile) throws IOException {
        if (report == null) {
            CoverageSerializationUtils.$$$reportNull$$$0(5);
        }
        if (outputFile == null) {
            CoverageSerializationUtils.$$$reportNull$$$0(6);
        }
        try (PrintWriter out = new PrintWriter(outputFile, StandardCharsets.UTF_8);){
            for (Map.Entry<String, List<LcovCoverageReport.LineHits>> entry : report.getInfo().entrySet()) {
                out.print(SOURCE_FILE_PREFIX);
                out.println(entry.getKey());
                for (LcovCoverageReport.LineHits lineHits : entry.getValue()) {
                    out.print(LINE_HIT_PREFIX);
                    out.print(lineHits.getLineNumber());
                    out.print(',');
                    out.println(lineHits.getHits());
                }
                out.println(END_OF_RECORD);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lcovFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toLocalPathConvertor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/coverage/CoverageSerializationUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "report";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/coverage/CoverageSerializationUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readLCOV";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readLCOV";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeLCOV";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

