/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jquery;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.library.JSExternalDocumentationProvider;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.JavaXmlDocumentKt;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jetbrains.annotations.Nls;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JQueryExtDocProvider
extends JSExternalDocumentationProvider {
    private static final String FILE_PREFIX = "file://";

    public JQueryExtDocProvider(String docUrl) {
        super(docUrl);
    }

    @Nls
    public String fetchExternalDocumentation(Project project, PsiElement original, List<String> docUrls, boolean onHover) {
        try {
            @Nls StringBuilder result2 = new StringBuilder();
            Document doc = this.parseDocument();
            List<PsiElement> docElements = Collections.singletonList(original);
            for (PsiElement element2 : docElements) {
                if (!(element2 instanceof JSQualifiedNamedElement)) continue;
                Pair selection = (Pair)ReadAction.compute(() -> {
                    JSQualifiedNamedElement qualifiedNamedElement = (JSQualifiedNamedElement)element2;
                    String qualifiedName = qualifiedNamedElement.getQualifiedName();
                    Pair<XPath, NodeList> sel = JQueryExtDocProvider.selectNodes(doc, qualifiedName);
                    if (((NodeList)sel.second).getLength() == 0) {
                        @Nls String simpleName = qualifiedNamedElement.getName();
                        sel = JQueryExtDocProvider.selectNodes(doc, simpleName);
                    }
                    return sel;
                });
                for (int i = 0; i < ((NodeList)selection.second).getLength(); ++i) {
                    if (i > 0) {
                        result2.append("<br><hr>");
                    }
                    JQueryExtDocProvider.generateDoc((XPath)selection.first, ((NodeList)selection.second).item(i), result2);
                }
            }
            String docText = result2.toString();
            return docText.isEmpty() ? JavaScriptBundle.message("jquery.documentation.not.found", new Object[0]) : docText;
        }
        catch (Exception e) {
            return "Document parsing error " + e.getMessage();
        }
    }

    private static Pair<XPath, NodeList> selectNodes(Document doc, String name) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newDefaultInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr = xpath.compile("//entry[@name='" + name + "' and @type='method']");
        Object selectionResult = expr.evaluate(doc, XPathConstants.NODESET);
        return Pair.create((Object)xpath, (Object)((NodeList)selectionResult));
    }

    private Document parseDocument() throws Exception {
        DocumentBuilder db = JavaXmlDocumentKt.createDocumentBuilder();
        String filePath = this.myDocUrl.startsWith(FILE_PREFIX) ? this.myDocUrl.substring(FILE_PREFIX.length()) : this.myDocUrl;
        return db.parse(new File(filePath));
    }

    private static void generateDoc(XPath xpath, Node entryNode, StringBuilder result2) throws XPathExpressionException {
        NodeList signatureList = (NodeList)xpath.evaluate("./signature", entryNode, XPathConstants.NODESET);
        boolean isFirst = true;
        for (int i = 0; i < signatureList.getLength(); ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append("<br><b>OR</b><br>");
            }
            JQueryExtDocProvider.processSignature(xpath, entryNode, signatureList.item(i), result2);
        }
        String shortDesc = (String)xpath.evaluate("./desc/text()", entryNode, XPathConstants.STRING);
        if (shortDesc != null) {
            result2.append(shortDesc);
        }
        result2.append("<h2>Parameters:</h2>");
        isFirst = true;
        for (int i = 0; i < signatureList.getLength(); ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append("<br><b>OR</b><br>");
            }
            JQueryExtDocProvider.processParameters(xpath, signatureList.item(i), result2);
        }
        Node longDesc = (Node)xpath.evaluate("./longdesc", entryNode, XPathConstants.NODE);
        if (longDesc != null) {
            result2.append("<h2>Description:</h2>");
            result2.append("<table width='100%'><tr><td width='20'></td><td>");
            JQueryExtDocProvider.processAsHtml(longDesc, result2);
            result2.append("</td></tr></table>");
        }
    }

    private static void processSignature(XPath xpath, Node entryNode, Node signNode, StringBuilder result2) throws XPathExpressionException {
        Node name;
        NamedNodeMap attrs = entryNode.getAttributes();
        StringBuilder typeAndName = new StringBuilder();
        typeAndName.append("<pre>");
        Node returnType2 = attrs.getNamedItem("return");
        if (returnType2 != null) {
            typeAndName.append("[ ").append(returnType2.getTextContent()).append(" ] ");
        }
        if ((name = attrs.getNamedItem("name")) != null) {
            typeAndName.append("<b>").append(name.getTextContent()).append("</b>");
        }
        typeAndName.append('(');
        String indent = StringUtil.repeat((String)" ", (int)typeAndName.toString().replaceAll("<[a-z/]*>", "").length());
        result2.append((CharSequence)typeAndName);
        NodeList argList = (NodeList)xpath.evaluate(".//argument", signNode, XPathConstants.NODESET);
        boolean isFirst = true;
        for (int i = 0; i < argList.getLength(); ++i) {
            Node argName;
            if (!isFirst) {
                result2.append(",\n").append(indent);
            } else {
                isFirst = false;
            }
            Node argNode = argList.item(i);
            NamedNodeMap argAttrs = argNode.getAttributes();
            Node argType = argAttrs.getNamedItem("type");
            if (argType != null) {
                result2.append("[ ").append(argType.getTextContent()).append(" ] ");
            }
            if ((argName = argAttrs.getNamedItem("name")) == null) continue;
            result2.append(argName.getTextContent());
        }
        result2.append(')');
        result2.append("</pre>");
    }

    private static void processParameters(XPath xpath, Node signNode, StringBuilder result2) throws XPathExpressionException {
        NodeList argList = (NodeList)xpath.evaluate(".//argument", signNode, XPathConstants.NODESET);
        result2.append("<table width='100%'>");
        if (argList.getLength() == 0) {
            JQueryExtDocProvider.addParameter(null, null, null, result2);
        }
        for (int i = 0; i < argList.getLength(); ++i) {
            Node argNode = argList.item(i);
            NamedNodeMap argAttrs = argNode.getAttributes();
            Node argNameAttr = argAttrs.getNamedItem("name");
            String argName = argNameAttr == null ? null : argNameAttr.getTextContent();
            Node argTypeAttr = argAttrs.getNamedItem("type");
            String argType = argTypeAttr == null ? null : argTypeAttr.getTextContent();
            NodeList argDescList = (NodeList)xpath.evaluate(".//desc", argNode, XPathConstants.NODESET);
            String argDesc = argDescList.getLength() > 0 ? argDescList.item(0).getTextContent() : null;
            JQueryExtDocProvider.addParameter(argName, argType, argDesc, result2);
        }
        result2.append("</table>");
    }

    private static void addParameter(String argName, String argType, String argDesc, StringBuilder result2) {
        result2.append("<tr>");
        result2.append("<td width='20' valign='top'></td>");
        result2.append("<td width='20%' valign='top'>");
        result2.append((String)(argName == null ? "<i>none</i>" : "<b>" + argName + "</b>"));
        result2.append("</td>");
        result2.append("<td width='20%' valign='top'>");
        result2.append(argType == null ? "" : argType);
        result2.append("</td>");
        result2.append("<td valign='top'>");
        result2.append(argDesc == null ? "" : argDesc);
        result2.append("</td>");
        result2.append("</tr>");
    }

    private static void processAsHtml(Node rootNode2, StringBuilder result2) {
        NodeList children = rootNode2.getChildNodes();
        block5: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (rootNode2.getNodeType()) {
                case 3: {
                    result2.append(child.getTextContent());
                    continue block5;
                }
                case 4: {
                    result2.append("<![CDATA[").append(child.getTextContent()).append("]]");
                    continue block5;
                }
                case 1: {
                    String nodeName = child.getNodeName();
                    if ("#text".equals(child.getNodeName())) {
                        result2.append(child.getNodeValue().replace("<", "&lt;").replace(">", "&gt;"));
                        continue block5;
                    }
                    if ("img".equals(nodeName)) continue block5;
                    result2.append('<').append(child.getNodeName()).append('>');
                    JQueryExtDocProvider.processAsHtml(child, result2);
                    result2.append("</").append(child.getNodeName()).append('>');
                }
            }
        }
    }
}

